/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.util;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class NSReg {
    public static final int MAGIC_NUMBER = 1986282561;
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 2;
    public static final int HDR_SIZE = 128;
    public static final int REGTYPE_KEY = 1;
    public static final int REGTYPE_DELETED = 128;
    public static final int REGTYPE_ENTRY = 16;
    public static final int REGTYPE_ENTRY_STRING_UTF = 17;
    public static final int REGTYPE_ENTRY_INT32_ARRAY = 18;
    public static final int REGTYPE_ENTRY_BYTES = 19;
    public static final int REGTYPE_ENTRY_FILE = 20;
    private RandomAccessFile file;
    private int root;
    private int avail;

    public final int readShort() throws IOException {
        int n = this.file.read();
        int n2 = this.file.read();
        return (n2 << 8) + (n << 0);
    }

    public final int readInt() throws IOException {
        int n = this.file.read();
        int n2 = this.file.read();
        int n3 = this.file.read();
        int n4 = this.file.read();
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    public void load(String string) throws IOException {
        this.file = new RandomAccessFile(string, "r");
        int n = this.readInt();
        int n2 = this.readShort();
        int n3 = this.readShort();
        if (n != 1986282561 || n2 != 1) {
            throw new IOException("Invalid nsreg file");
        }
        this.avail = this.readInt();
        this.root = this.readInt();
    }

    public Entry root() throws IOException {
        return new Entry(this.root);
    }

    public Entry get(String string) throws IOException {
        String string2;
        Entry entry;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (string.length() == 0) {
            return this.root();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        for (entry = this.root(); stringTokenizer.hasMoreTokens() && entry != null; entry = entry.getKey(string2)) {
            string2 = stringTokenizer.nextToken();
        }
        return entry;
    }

    public void printTree() throws IOException {
        NSReg.printSubTree(this.root(), "");
    }

    public static void printSubTree(Entry entry) throws IOException {
        NSReg.printSubTree(entry, "/");
    }

    private static void printSubTree(Entry entry, String string) throws IOException {
        Object object;
        Object object2;
        if ((string = string + "/" + entry.name()).startsWith("//")) {
            string = string.substring(1);
        }
        Enumeration enumeration = entry.values();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = entry.getValue((String)object2);
            String string2 = ((Entry)object).type == 17 ? ((Entry)object).valueAsString() : "REGTYPE-" + ((Entry)object).type;
            System.out.println(string + ":" + (String)object2 + " = " + string2);
        }
        object2 = entry.subKeys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            NSReg.printSubTree(entry.getKey((String)object), string);
        }
    }

    public static void main(String[] stringArray) {
        try {
            NSReg nSReg = new NSReg();
            String string = stringArray[0];
            nSReg.load(string);
            String string2 = "/";
            if (stringArray.length > 1) {
                string2 = stringArray[1];
            }
            Entry entry = nSReg.get(string2);
            NSReg.printSubTree(entry);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public class Entry {
        public int location;
        public int name;
        public int namelen;
        public int type;
        public int left;
        public int down;
        public int value;
        public int valuelen;
        public int valuebuf;
        public int parent;
        private Vector subKeys;
        private Vector values;

        public Entry(int n) throws IOException {
            this(n, true);
        }

        private Entry(int n, boolean bl) throws IOException {
            NSReg.this.file.seek(n);
            this.location = NSReg.this.readInt();
            this.name = NSReg.this.readInt();
            this.namelen = NSReg.this.readShort();
            this.type = NSReg.this.readShort();
            this.left = NSReg.this.readInt();
            this.down = NSReg.this.readInt();
            this.value = NSReg.this.readInt();
            this.valuelen = NSReg.this.readInt();
            this.valuebuf = NSReg.this.readInt();
            this.parent = NSReg.this.readInt();
            if (bl && this.type == 1) {
                this.scanElements();
            }
        }

        private void scanElements() throws IOException {
            this.subKeys = new Vector();
            for (Entry entry = this.down(false); entry != null; entry = entry.left(false)) {
                this.subKeys.addElement(entry.name());
            }
            this.values = new Vector();
            for (Entry entry = this.value(); entry != null; entry = entry.left(false)) {
                this.values.addElement(entry.name());
            }
        }

        public Enumeration subKeys() {
            return this.subKeys.elements();
        }

        public Enumeration values() {
            return this.values.elements();
        }

        public String name() throws IOException {
            byte[] byArray = new byte[this.namelen - 1];
            NSReg.this.file.seek(this.name);
            NSReg.this.file.readFully(byArray);
            return new String(byArray);
        }

        public String valueAsString() throws IOException {
            if (this.type != 17) {
                throw new IOException("Not a UTF8 value: " + this.name());
            }
            byte[] byArray = new byte[this.valuelen - 1];
            NSReg.this.file.seek(this.value);
            NSReg.this.file.readFully(byArray);
            return new String(byArray, "UTF8");
        }

        public Entry left() throws IOException {
            return this.left(true);
        }

        private Entry left(boolean bl) throws IOException {
            Entry entry = null;
            if (this.left > 0) {
                entry = new Entry(this.left, bl);
            }
            return entry;
        }

        public Entry down() throws IOException {
            return this.down(true);
        }

        public Entry down(boolean bl) throws IOException {
            Entry entry = null;
            if (this.down > 0) {
                entry = new Entry(this.down, bl);
            }
            return entry;
        }

        public Entry value() throws IOException {
            Entry entry = null;
            if (this.value > 0) {
                entry = new Entry(this.value);
            }
            return entry;
        }

        public Entry getKey(String string) throws IOException {
            Entry entry = this.down();
            if (entry != null) {
                entry = entry.getObject(string);
            }
            return entry;
        }

        public Entry getValue(String string) throws IOException {
            Entry entry = this.value();
            if (entry != null) {
                entry = entry.getObject(string);
            }
            return entry;
        }

        public Entry getObject(String string) throws IOException {
            Entry entry = this;
            while (!entry.name().equals(string) && (entry = entry.left()) != null) {
            }
            return entry;
        }
    }
}

