/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.util;

public final class Queue {
    static final int DEFAULT_DEPTH = 64;
    static final int DEFAULT_HIWATER = 32;
    Object[] queue;
    boolean isWaitGet;
    boolean isWaitPut;
    boolean isBlocking;
    int rOffset;
    int wOffset;
    int depth;
    int hiwater;
    int size;
    int depthCP;
    int sizeCP;

    public Queue() {
        this(64, 32);
    }

    public Queue(int n, int n2) {
        this.queue = new Object[n + 1];
        this.isWaitGet = false;
        this.isWaitPut = false;
        this.isBlocking = true;
        this.rOffset = 0;
        this.wOffset = 0;
        this.size = 0;
        this.sizeCP = -1;
        this.depth = n;
        this.hiwater = n2;
    }

    public synchronized void setDepth(int n) {
        this.depth = n;
    }

    public synchronized void putLast(Object object) {
        this.putFlowControl();
        this.queue[this.wOffset++] = object;
        if (this.wOffset == this.depth + 1) {
            this.wOffset = 0;
        }
        if (this.isWaitGet) {
            this.notify();
        }
        ++this.size;
    }

    public synchronized void putFirst(Object object) {
        this.putFlowControl();
        --this.rOffset;
        if (this.rOffset == -1) {
            this.rOffset = this.depth;
        }
        this.queue[this.rOffset] = object;
        if (this.isWaitGet) {
            this.notify();
        }
        ++this.size;
    }

    public synchronized void release() {
        if (this.isWaitGet) {
            this.notify();
        }
    }

    public synchronized void disable() {
        this.depthCP = this.depth;
        this.sizeCP = this.size;
        this.depth = 0;
        this.size = 0;
    }

    public synchronized void enable() {
        if (this.sizeCP >= 0) {
            this.depth = this.depthCP;
            this.size = this.sizeCP;
            this.sizeCP = -1;
            if (!this.isEmpty()) {
                this.release();
            }
            if (this.isWaitPut && this.size <= this.hiwater) {
                this.notifyAll();
                this.isWaitPut = false;
            }
        }
    }

    public synchronized void setBlocking(boolean bl) {
        this.isBlocking = bl;
        this.release();
    }

    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    private final void putFlowControl() {
        while (this.size >= this.depth) {
            this.isWaitPut = true;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized Object getFirst() {
        Object object = null;
        while (this.isEmpty()) {
            if (!this.isBlocking) {
                return null;
            }
            this.isWaitGet = true;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.isWaitGet = false;
        object = this.queue[this.rOffset];
        this.queue[this.rOffset++] = null;
        if (this.rOffset == this.depth + 1) {
            this.rOffset = 0;
        }
        if (this.isWaitPut && this.size <= this.hiwater) {
            this.notifyAll();
            this.isWaitPut = false;
        }
        --this.size;
        return object;
    }
}

