/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.util;

import com.mindbright.jca.security.SecureRandom;

public class SecureRandomAndPad
extends SecureRandom {
    private SecureRandom random;
    private byte[] state;
    private int x;
    private int y;

    private int arcfour_byte() {
        int n = this.x + 1 & 0xFF;
        byte by = this.state[n];
        int n2 = by + this.y & 0xFF;
        byte by2 = this.state[n2];
        this.x = n;
        this.y = n2;
        this.state[n2] = (byte)(by & 0xFF);
        this.state[n] = (byte)(by2 & 0xFF);
        return this.state[by + by2 & 0xFF];
    }

    public SecureRandomAndPad() {
        this(new SecureRandom());
    }

    public SecureRandomAndPad(SecureRandom secureRandom) {
        this.random = secureRandom;
        this.state = new byte[256];
        for (int i = 0; i < 256; ++i) {
            this.state[i] = (byte)i;
        }
    }

    public void setPadSeed(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 256; ++i) {
            byte by = this.state[i];
            n2 = n2 + byArray[n] + by & 0xFF;
            byte by2 = this.state[n2];
            this.state[n2] = (byte)(by & 0xFF);
            this.state[i] = (byte)(by2 & 0xFF);
            if (++n < byArray.length) continue;
            n = 0;
        }
    }

    public void nextPadBytes(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            byArray[i] = (byte)((byArray[i] ^ this.arcfour_byte()) & 0xFF);
        }
    }

    public byte[] generateSeed(int n) {
        return this.random.generateSeed(n);
    }

    public void nextBytes(byte[] byArray) {
        this.random.nextBytes(byArray);
    }

    public void setSeed(byte[] byArray) {
        this.random.setSeed(byArray);
    }
}

