/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.common;

import com.avocent.avworks.nmm.common.EditUserDialogController;
import com.avocent.avworks.nmm.common.InterfaceController;
import com.avocent.avworks.nmm.common.JDialogUserAccessRights;
import com.avocent.avworks.nmm.common.JFrameAmp;
import com.avocent.avworks.nmm.common.Port;
import com.avocent.avworks.nmm.common.User;
import com.avocent.avworks.nmm.common.UsersPanelController;
import com.avocent.avworks.services.BrowserHelper;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.gui.components.ButtonPanel;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Hashtable;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AccessRightsDialogController
implements InterfaceController {
    public static final String CNAME = "AccessRightsDialogController";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.common.Res");
    public static final String TRACE_CONTEXT = "AccessRightsDialogController";
    protected DefaultListModel m_dlmAccessAllowedServerList;
    protected DefaultListModel m_dlmAccessDeniedServerList;
    protected User m_uUser;
    protected boolean m_bIsModified = false;
    protected EditUserDialogController m_amucParentController;
    protected JDialogUserAccessRights m_jduarDialog;

    public AccessRightsDialogController(EditUserDialogController editUserDialogController) throws ExceptionConstructorFailed {
        this.m_amucParentController = editUserDialogController;
        this.m_jduarDialog = (JDialogUserAccessRights)((Object)this.createView());
        this.m_jduarDialog.pack();
        this.m_jduarDialog.requestFocus();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            throw new RuntimeException("Do not call AccessRightsDialogController.setVisible directly.  Call show(user) or hide() instead.");
        }
        this.m_jduarDialog.setVisible(bl);
    }

    public void showUser(User user) throws Exception {
        this.m_bIsModified = false;
        this.m_uUser = user;
        this.m_jduarDialog.getNameLabel().setText(user.m_szName);
        this.m_dlmAccessAllowedServerList.removeAllElements();
        this.m_dlmAccessDeniedServerList.removeAllElements();
        Hashtable<Port, Port> hashtable = new Hashtable<Port, Port>();
        for (int i = 0; i < user.getPortCount(); ++i) {
            Port port = user.getPortAt(i);
            this.m_dlmAccessAllowedServerList.addElement(port);
            hashtable.put(port, port);
        }
        UsersPanelController usersPanelController = this.m_amucParentController.getUsersPanelController();
        for (int i = 0; i < usersPanelController.getPortCount(); ++i) {
            Port port = usersPanelController.getPortAt(i);
            if (hashtable.get(port) != null) continue;
            this.m_dlmAccessDeniedServerList.addElement(port);
        }
        this.m_jduarDialog.getRootPane().setDefaultButton(this.m_jduarDialog.getOkButton());
        this.m_jduarDialog.setVisible(true);
    }

    void okAction() {
        this.m_uUser.clearPortList();
        for (int i = 0; i < this.m_dlmAccessAllowedServerList.getSize(); ++i) {
            this.m_uUser.addPort((Port)this.m_dlmAccessAllowedServerList.get(i));
        }
        if (this.m_amucParentController.isAccessListModified() || this.m_bIsModified) {
            this.m_amucParentController.setIsAccessListModified(true);
        }
        this.setVisible(false);
        this.m_jduarDialog.dispose();
    }

    void cancelAction() {
        this.setVisible(false);
        this.m_jduarDialog.dispose();
    }

    void helpAction() {
        String string = this.m_amucParentController.getAccessRightsDialogHelpUrl();
        if (string != null) {
            JFrameAmp jFrameAmp = this.m_amucParentController.getUsersPanelController().getAmpController().getMainFrame();
            BrowserHelper.showHelpPage((JFrame)jFrameAmp, (String)string);
        }
    }

    void addAction() {
        JList jList = this.m_jduarDialog.getNoAccessList();
        Object[] objectArray = jList.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            this.m_dlmAccessAllowedServerList.addElement(objectArray[i]);
            this.m_dlmAccessDeniedServerList.removeElement(objectArray[i]);
        }
        jList.clearSelection();
        this.m_jduarDialog.getAddButton().setEnabled(false);
        this.m_bIsModified = true;
    }

    void removeAction() {
        JList jList = this.m_jduarDialog.getAllowAccessList();
        Object[] objectArray = jList.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            this.m_dlmAccessAllowedServerList.removeElement(objectArray[i]);
            this.m_dlmAccessDeniedServerList.addElement(objectArray[i]);
        }
        jList.clearSelection();
        this.m_jduarDialog.getRemoveButton().setEnabled(false);
        this.m_bIsModified = true;
    }

    public Component createView() {
        this.m_jduarDialog = new JDialogUserAccessRights(this, (JDialog)this.m_amucParentController.getView());
        this.initializeView();
        return this.m_jduarDialog;
    }

    public void initializeView() {
        JList jList = this.m_jduarDialog.getAllowAccessList();
        JList jList2 = this.m_jduarDialog.getNoAccessList();
        this.m_jduarDialog.getNoAccessScrollPane().getViewport().setPreferredSize(new Dimension(150, 150));
        this.m_jduarDialog.getAllowAccessScrollPane().getViewport().setPreferredSize(new Dimension(150, 150));
        this.m_dlmAccessAllowedServerList = new DefaultListModel();
        this.m_dlmAccessDeniedServerList = new DefaultListModel();
        jList.setModel(this.m_dlmAccessAllowedServerList);
        jList2.setModel(this.m_dlmAccessDeniedServerList);
        this.m_jduarDialog.setSize(this.m_jduarDialog.getPreferredSize());
        jList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl;
                boolean bl2 = bl = AccessRightsDialogController.this.m_jduarDialog.getAllowAccessList().getSelectedIndices().length > 0;
                if (bl) {
                    AccessRightsDialogController.this.m_jduarDialog.getNoAccessList().clearSelection();
                }
                AccessRightsDialogController.this.m_jduarDialog.getRemoveButton().setEnabled(bl);
            }
        });
        jList2.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl;
                boolean bl2 = bl = AccessRightsDialogController.this.m_jduarDialog.getNoAccessList().getSelectedIndices().length > 0;
                if (bl) {
                    AccessRightsDialogController.this.m_jduarDialog.getAllowAccessList().clearSelection();
                }
                AccessRightsDialogController.this.m_jduarDialog.getAddButton().setEnabled(bl);
            }
        });
        this.m_jduarDialog.getAddButton().setEnabled(false);
        this.m_jduarDialog.getRemoveButton().setEnabled(false);
        this.m_jduarDialog.setResizable(false);
        ButtonPanel.equalize((JPanel)this.m_jduarDialog.getButtonPanel());
    }

    public Component getView() {
        if (this.m_jduarDialog == null) {
            this.createView();
        }
        return this.m_jduarDialog;
    }
}

