/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.common;

import com.avocent.avworks.nmm.common.AbstractNmmInterface;
import com.avocent.avworks.nmm.common.Appliance;
import com.avocent.avworks.nmm.common.AsmpConnection;
import com.avocent.avworks.nmm.common.ExceptionSnmpRequestFailed;
import com.avocent.avworks.nmm.common.InterfaceAmpPanelController;
import com.avocent.avworks.nmm.common.InterfaceSnmpClient;
import com.avocent.avworks.nmm.common.JFrameAmp;
import com.avocent.avworks.nmm.common.JPanelAmpPanel;
import com.avocent.avworks.nmm.common.PanelTreePathPair;
import com.avocent.avworks.nmm.common.SnmpHelper;
import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.avworks.services.AVWorksEventBroadcaster;
import com.avocent.avworks.services.AVWorksWindow;
import com.avocent.avworks.services.AVWorksWindowManager;
import com.avocent.avworks.services.ApplianceInfo;
import com.avocent.avworks.services.AppliancesDb;
import com.avocent.avworks.services.BrowserHelper;
import com.avocent.avworks.services.InterfaceAVWorksEventBroadcasterListener;
import com.avocent.avworks.services.InterfaceAmpPanel;
import com.avocent.avworks.services.UnitInfo;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.components.ButtonPanel;
import com.avocent.lib.gui.dialogs.JDialogElapsedTime;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.gui.panels.JPanelLinearGradient;
import com.avocent.lib.util.ObserverHint;
import com.avocent.lib.util.ResourceManager;
import com.avocent.protocols.snmp.SnmpRequest;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public abstract class AmpController
implements ActionListener,
Observer,
InterfaceAVWorksEventBroadcasterListener {
    public static final String CNAME = "AmpController";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.common.Res");
    private static String ESCAPE_KEY = "Escape Key";
    public static Object[] APPLIANCE = new Object[]{AVWorksBranding.getApplianceName((boolean)true)};
    public static Object[] APPLIANCE_SERVER = new Object[]{AVWorksBranding.getApplianceName((boolean)true), AVWorksBranding.getServerName((boolean)true)};
    protected Vector m_vPanelList = new Vector();
    protected ApplianceInfo m_aiAppliance;
    protected InetAddress m_iaApplianceIp;
    protected AsmpConnection m_acAsmpConnection;
    protected InterfaceAmpPanel m_jpCurrentPanel;
    protected DefaultMutableTreeNode m_dmtnRootNode = null;
    public static final int MIN_TREE_WIDTH = 156;
    protected int m_nLastTabIndex;
    protected static final int SETTINGS_TAB_INDEX = 0;
    protected static final int STATUS_TAB_INDEX = 1;
    protected static final int TOOLS_TAB_INDEX = 2;
    public static final String TRACE_CONTEXT = "AMP Frame";
    private boolean m_bAsmpSessionClosed = false;
    protected boolean m_bStartupCanceled = false;
    private boolean m_bIgnoreTreeSelection = false;
    protected JFrameAmp m_jfa;
    protected AbstractNmmInterface m_aniNmmInterface = null;
    protected JDialogElapsedTime m_jdetElapsed;
    protected boolean m_bStandaloneExecution = false;
    private Hashtable m_hashtable = new Hashtable();
    protected Appliance m_aAppliance;
    protected PropertyChangeSupport m_propertyChangeSupport = new PropertyChangeSupport(this);

    public AmpController(int n, AbstractNmmInterface abstractNmmInterface) {
        this.m_acAsmpConnection = new AsmpConnection(this.getLoginTimeout(n) * 1000);
        this.m_aniNmmInterface = abstractNmmInterface;
    }

    public void launchAmp(int n, Frame frame) throws Exception {
        try {
            this.m_aiAppliance = AppliancesDb.getApplianceInfo((int)n);
            if (!this.showExistingAmp(n, frame)) {
                this.showAmp(n, frame);
            }
        }
        catch (ExceptionNoValue exceptionNoValue) {
            throw new Exception("Unable to launch an AMP to: " + n, exceptionNoValue);
        }
        int[] nArray = new int[]{6};
        try {
            AVWorksEventBroadcaster.addListener((InterfaceAVWorksEventBroadcasterListener)this, (int[])nArray);
        }
        catch (Exception exception) {
            Trace.logError((String)CNAME, (String)"Failed to create listener for DB.", (Throwable)exception);
        }
    }

    public boolean showExistingAmp(int n, Frame frame) {
        String string = this.getWindowIdentifier();
        AVWorksWindow[] aVWorksWindowArray = AVWorksWindowManager.findWindowsByID((String)string, (boolean)false);
        if (aVWorksWindowArray.length > 0) {
            Window window = aVWorksWindowArray[0].getWindow();
            Trace.logInfo((String)TRACE_CONTEXT, (String)"FOUND Existing Window, Bringing it to front.");
            if (window instanceof Frame && ((Frame)window).getState() == 1) {
                ((Frame)window).setState(0);
            } else {
                window.toFront();
            }
            window.requestFocus();
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void showAmp(int n, Frame frame) throws Exception {
        block17: {
            block16: {
                try {
                    try {
                        Object object;
                        block15: {
                            Frame frame2;
                            if (this.m_aiAppliance == null) {
                                this.m_aiAppliance = AppliancesDb.getApplianceInfo((int)n);
                            }
                            Object[] objectArray = new Object[]{this.m_aiAppliance.getName()};
                            String string = MessageFormat.format(res.getString("AmpController_Connecting_to_0"), objectArray);
                            String string2 = res.getString("AmpController_ElapsedTime_Title");
                            Frame frame3 = frame2 = frame == null ? this.m_jfa : frame;
                            if (this.m_jdetElapsed == null) {
                                this.m_jdetElapsed = new JDialogElapsedTime(frame2, string2, string);
                            }
                            this.m_jdetElapsed.addListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    AmpController.this.m_bStartupCanceled = true;
                                }
                            });
                            this.m_jdetElapsed.setEnableCancelButton(true);
                            this.m_jdetElapsed.setVisible(true);
                            String string3 = this.m_aiAppliance.getAddress();
                            Trace.logInfo((String)TRACE_CONTEXT, (String)("Connecting to appliance at IP:" + string3));
                            this.m_iaApplianceIp = InetAddress.getByName(string3);
                            try {
                                object = this.m_aiAppliance.getPolicy();
                                if (this.m_acAsmpConnection.openConnection(this.m_iaApplianceIp, frame, this.m_jdetElapsed, object.getUseCache()) != 3) break block15;
                                this.m_jdetElapsed.setVisible(false);
                            }
                            catch (Exception exception) {
                                if (this.m_jdetElapsed != null) {
                                    this.m_jdetElapsed.setVisible(false);
                                }
                                Trace.logError((String)TRACE_CONTEXT, (String)"Unable to connect to appliance.", (Throwable)exception);
                                String string4 = MessageFormat.format(res.getString("AmpController_UnableToConnect"), APPLIANCE);
                                Message.show((Component)frame, (String)string4);
                                this.closeAmp();
                                Object var11_13 = null;
                                if (this.m_jdetElapsed == null) return;
                                this.m_jdetElapsed.setVisible(false);
                                this.m_jdetElapsed.dispose();
                                this.m_jdetElapsed = null;
                                return;
                            }
                            Object var11_12 = null;
                            if (this.m_jdetElapsed == null) return;
                            break block16;
                        }
                        if (this.m_bStartupCanceled) {
                            this.closeAmp();
                        }
                        this.m_acAsmpConnection.addSessionObserver(this);
                        this.m_jfa = this.createAmpFrame();
                        object = MessageFormat.format(res.getString("AmpController_Manage_0_"), APPLIANCE);
                        this.m_jfa.setTitle(this.m_aiAppliance.getName() + " - " + (String)object);
                        this.initializeFrame();
                        AVWorksWindowManager.registerWindow((String)this.getWindowIdentifier(), (String)object, (int)1, (Window)this.m_jfa);
                        if (this.m_bStartupCanceled) {
                            this.closeAmp();
                            break block17;
                        } else {
                            this.setVisible(true);
                        }
                        break block17;
                    }
                    catch (Exception exception) {
                        if (this.m_jdetElapsed != null) {
                            this.m_jdetElapsed.setVisible(false);
                            this.m_jdetElapsed.dispose();
                            this.m_jdetElapsed = null;
                        }
                        Trace.logError((String)TRACE_CONTEXT, (String)("Unable to connect. Reason:" + exception.getMessage()), (Throwable)exception);
                        String string = MessageFormat.format(res.getString("AmpController_Unable_to_connect_to_Appliance0"), APPLIANCE);
                        Message.show((Component)this.m_jfa, (String)string);
                        this.closeAmp();
                        throw new Exception("Unable to construct JFrameAvrAmp.", exception);
                    }
                }
                catch (Throwable throwable) {
                    Object var11_15 = null;
                    if (this.m_jdetElapsed == null) throw throwable;
                    this.m_jdetElapsed.setVisible(false);
                    this.m_jdetElapsed.dispose();
                    this.m_jdetElapsed = null;
                    throw throwable;
                }
            }
            this.m_jdetElapsed.setVisible(false);
            this.m_jdetElapsed.dispose();
            this.m_jdetElapsed = null;
            return;
        }
        Object var11_14 = null;
        if (this.m_jdetElapsed == null) return;
        this.m_jdetElapsed.setVisible(false);
        this.m_jdetElapsed.dispose();
        this.m_jdetElapsed = null;
    }

    public JFrameAmp createAmpFrame() throws Exception {
        return new JFrameAmp(this);
    }

    public abstract void addSettingsPanels() throws ExceptionRequestFailed;

    public abstract boolean checkIfRebootRequired();

    protected void initializeFrame() throws ExceptionRequestFailed {
        try {
            this.m_dmtnRootNode = new DefaultMutableTreeNode(res.getString("AmpController_Categories"));
            DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
            defaultTreeCellRenderer.setOpenIcon(null);
            defaultTreeCellRenderer.setClosedIcon(null);
            defaultTreeCellRenderer.setLeafIcon(null);
            this.m_jfa.getCategoryTree().setCellRenderer(defaultTreeCellRenderer);
            this.addSettingsPanels();
            JPanelAmpPanel jPanelAmpPanel = this.createStatusPanel();
            this.m_jfa.setStatusPanel(jPanelAmpPanel);
            this.m_vPanelList.addElement(new PanelTreePathPair(jPanelAmpPanel, null));
            this.m_jfa.setToolsPanel(this.createToolsPanel());
            DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this.m_dmtnRootNode);
            this.m_jfa.getCategoryTree().setModel(defaultTreeModel);
            this.m_jfa.getCategoryTree().setRootVisible(false);
            this.setTreeDimension();
            this.m_nLastTabIndex = 0;
            this.m_jfa.getTabbedPane().addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    AmpController.this.jTabbedPaneTabs_stateChanged(changeEvent);
                }
            });
            this.m_jfa.addWindowListener(new WindowAdapter(){

                public void windowActivated(WindowEvent windowEvent) {
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                }

                public void windowClosing(WindowEvent windowEvent) {
                    AmpController.this.thisWindowClosing(windowEvent);
                }
            });
            this.m_jfa.getRootPane().registerKeyboardAction(this, ESCAPE_KEY, KeyStroke.getKeyStroke(27, 0), 2);
            this.m_jfa.getGlassPane().addMouseListener(new MouseAdapter(){});
            this.m_jfa.getGlassPane().addKeyListener(new KeyAdapter(){});
            this.m_jfa.getCategoryTree().addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    if (AmpController.this.m_bIgnoreTreeSelection) {
                        AmpController.this.m_bIgnoreTreeSelection = false;
                    } else {
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)AmpController.this.m_jfa.getCategoryTree().getLastSelectedPathComponent();
                        if (defaultMutableTreeNode != null) {
                            TreePath treePath;
                            InterfaceAmpPanel interfaceAmpPanel = (InterfaceAmpPanel)defaultMutableTreeNode.getUserObject();
                            if (!AmpController.this.m_bStartupCanceled && !AmpController.this.setActivePanel(interfaceAmpPanel) && (treePath = treeSelectionEvent.getOldLeadSelectionPath()) != null) {
                                AmpController.this.m_bIgnoreTreeSelection = true;
                                AmpController.this.m_jfa.getCategoryTree().setSelectionPath(treePath);
                            }
                        }
                    }
                }
            });
            ButtonPanel.equalize((JPanel)this.m_jfa.getButtonsPanel());
            this.m_jfa.pack();
            ImageIcon imageIcon = new ImageIcon(JFrameAmp.class.getResource("manageappliance16.gif"));
            this.m_jfa.setIconImage(imageIcon.getImage());
            this.m_jfa.getCategoryTree().setSelectionRow(0);
        }
        catch (Exception exception) {
            throw new ExceptionRequestFailed("", (Throwable)exception);
        }
    }

    protected void setTreeDimension() {
        int n;
        int n2;
        Dimension dimension = this.m_jfa.getCategoryTree().getPreferredSize();
        int n3 = dimension.width + 10;
        for (n2 = 0; n2 < this.m_jfa.getCategoryTree().getRowCount(); ++n2) {
            this.m_jfa.getCategoryTree().expandRow(n2);
        }
        dimension = this.m_jfa.getCategoryTree().getPreferredSize();
        n2 = dimension.width + 10;
        for (n = 0; n < this.m_jfa.getCategoryTree().getRowCount(); ++n) {
            this.m_jfa.getCategoryTree().collapseRow(n);
        }
        n = Math.min(n2, 156);
        n = Math.max(n, n3);
        dimension.setSize(n, dimension.height);
        this.m_jfa.getCategoryTreeScrollPane().setMinimumSize(dimension);
    }

    public abstract String getWindowIdentifier();

    public abstract JPanel createToolsPanel() throws Exception;

    public abstract JPanelAmpPanel createStatusPanel() throws Exception;

    public JFrameAmp getMainFrame() {
        return this.m_jfa;
    }

    public DefaultMutableTreeNode addSettingsPanel(InterfaceAmpPanelController interfaceAmpPanelController, DefaultMutableTreeNode defaultMutableTreeNode) {
        this.m_jfa.getSettingsPanelContainer().add((Component)interfaceAmpPanelController.getContentPane(), interfaceAmpPanelController.getPanelKey());
        this.m_jfa.getSettingsHeaderContainer().add((Component)this.createPanelHeader(interfaceAmpPanelController), interfaceAmpPanelController.getPanelKey());
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(interfaceAmpPanelController);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        TreePath treePath = new TreePath(defaultMutableTreeNode2.getPath());
        this.m_vPanelList.addElement(new PanelTreePathPair(interfaceAmpPanelController, treePath));
        return defaultMutableTreeNode2;
    }

    public DefaultMutableTreeNode addSettingsPanel(JPanelAmpPanel jPanelAmpPanel, DefaultMutableTreeNode defaultMutableTreeNode) {
        this.m_jfa.getSettingsPanelContainer().add((Component)((Object)jPanelAmpPanel), jPanelAmpPanel.getPanelKey());
        this.m_jfa.getSettingsHeaderContainer().add((Component)this.createPanelHeader(jPanelAmpPanel), jPanelAmpPanel.getPanelKey());
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(jPanelAmpPanel);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        TreePath treePath = new TreePath(defaultMutableTreeNode2.getPath());
        this.m_vPanelList.addElement(new PanelTreePathPair(jPanelAmpPanel, treePath));
        return defaultMutableTreeNode2;
    }

    public void removeAllSettingsPanels() {
        this.m_dmtnRootNode.removeAllChildren();
        this.m_vPanelList.removeAllElements();
        this.m_jfa.getSettingsPanelContainer().removeAll();
        this.m_jfa.getSettingsHeaderContainer().removeAll();
    }

    private JPanel createPanelHeader(InterfaceAmpPanel interfaceAmpPanel) {
        JPanelLinearGradient jPanelLinearGradient = new JPanelLinearGradient();
        jPanelLinearGradient.setLayout((LayoutManager)new GridBagLayout());
        jPanelLinearGradient.setBackground((Color)SystemColor.controlShadow);
        jPanelLinearGradient.setForeground((Color)SystemColor.control);
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        jLabel.setFont(new Font("Dialog", 1, 12));
        jLabel.setForeground(SystemColor.controlText);
        jLabel.setText(interfaceAmpPanel.getPanelTitle());
        jLabel2.setText(interfaceAmpPanel.getPanelDescription());
        jPanelLinearGradient.add((Component)jLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 12), 0, 0));
        jPanelLinearGradient.add((Component)jLabel2, (Object)new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 13, 0, new Insets(0, 12, 0, 5), 0, 0));
        return jPanelLinearGradient;
    }

    public boolean setActivePanel(InterfaceAmpPanel interfaceAmpPanel) {
        boolean bl;
        boolean bl2 = bl = this.m_jpCurrentPanel == null || !this.m_jpCurrentPanel.onKillActive();
        if (bl) {
            this.m_jfa.getRootPane().setDefaultButton(this.m_jfa.getOkButton());
            interfaceAmpPanel.onSetActive();
            this.m_jpCurrentPanel = interfaceAmpPanel;
            this.m_jfa.getSettingsPanelCardLayout().show(this.m_jfa.getSettingsPanelContainer(), interfaceAmpPanel.getPanelKey());
            this.m_jfa.getSettingsHeaderCardLayout().show(this.m_jfa.getSettingsHeaderContainer(), interfaceAmpPanel.getPanelKey());
        }
        return bl;
    }

    void reloadCurrentPanel() {
        if (this.m_jpCurrentPanel instanceof InterfaceAmpPanelController) {
            ((InterfaceAmpPanelController)this.m_jpCurrentPanel).setReloadData();
        } else if (this.m_jpCurrentPanel instanceof JPanelAmpPanel) {
            ((JPanelAmpPanel)this.m_jpCurrentPanel).setReloadData();
        }
    }

    public void setModified(boolean bl) {
        if (bl) {
            this.m_jfa.getApplyButton().setEnabled(bl);
        }
    }

    public void closeAmp() {
        this.m_bAsmpSessionClosed = true;
        this.m_bStartupCanceled = true;
        try {
            AVWorksEventBroadcaster.removeListener((InterfaceAVWorksEventBroadcasterListener)this);
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Exception while removing the AmpController event broadcast listener.", (Throwable)exceptionInvalidArgument);
        }
        this.m_jfa.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        if (this.m_jfa != null) {
            this.setBusy(true);
            this.destroyPanels();
            this.setVisible(false);
            this.m_jfa.dispose();
        }
        try {
            this.m_acAsmpConnection.closeAsmpSession();
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Error while closing ASMP session.", (Throwable)exception);
        }
        if (this.m_bStandaloneExecution) {
            System.exit(0);
        }
    }

    public void closeAsmpSession() {
        if (this.m_acAsmpConnection.isConnected()) {
            Thread thread = new Thread(){

                public void run() {
                    try {
                        AmpController.this.m_acAsmpConnection.removeSessionObserver(AmpController.this);
                        AmpController.this.m_acAsmpConnection.closeAsmpSession();
                    }
                    catch (Exception exception) {
                        Trace.logError((String)AmpController.TRACE_CONTEXT, (String)"Exception during AMP shutdown.", (Throwable)exception);
                    }
                }
            };
            thread.start();
        }
    }

    public AsmpConnection getAsmpConnection() {
        return this.m_acAsmpConnection;
    }

    public int asmpRequest(SnmpRequest snmpRequest) throws ExceptionRequestFailed {
        if (this.m_acAsmpConnection.isConnected()) {
            try {
                return this.m_acAsmpConnection.asmpRequest(snmpRequest);
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                ExceptionRequestFailed exceptionRequestFailed2;
                if (exceptionRequestFailed.getMessage() == null || exceptionRequestFailed.getMessage().trim().length() == 0) {
                    String string = MessageFormat.format(res.getString("AmpController_Request_Failed_ASMP_communications"), APPLIANCE);
                    exceptionRequestFailed2 = new ExceptionRequestFailed(string);
                }
                this.showException(null, TRACE_CONTEXT, "", exceptionRequestFailed2);
                this.closeAmp();
                return 4096;
            }
        }
        throw new ExceptionRequestFailed(res.getString("AmpController_ASMP_No_Session"));
    }

    public InetAddress getIpAddress() {
        return this.m_iaApplianceIp;
    }

    public Vector getPanelList() {
        return this.m_vPanelList;
    }

    void okAction(ActionEvent actionEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"OK button pressed.");
        if (this.m_jpCurrentPanel != null) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("Current panel is " + this.m_jpCurrentPanel.getPanelTitle() + " : " + this.m_jpCurrentPanel.getPanelDescription()));
            InterfaceAmpPanel interfaceAmpPanel = this.m_jpCurrentPanel;
            if (!this.m_jpCurrentPanel.onKillActive()) {
                this.applyValues(true);
            }
            if (interfaceAmpPanel == this.m_jpCurrentPanel) {
                this.m_jpCurrentPanel.onSetActive();
            }
        } else {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"m_jpCurrentPanel variable is null. Not sure how this can happen, if OK was pressed...");
        }
    }

    void cancelAction(ActionEvent actionEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"Cancel button pressed.");
        this.closeAmp();
    }

    void applyAction(ActionEvent actionEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"Apply button pressed.");
        if (this.m_jpCurrentPanel != null) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("Current panel is " + this.m_jpCurrentPanel.getPanelTitle() + " : " + this.m_jpCurrentPanel.getPanelDescription()));
            InterfaceAmpPanel interfaceAmpPanel = this.m_jpCurrentPanel;
            if (!this.m_jpCurrentPanel.onKillActive()) {
                this.applyValues(false);
            }
            if (interfaceAmpPanel == this.m_jpCurrentPanel) {
                this.m_jpCurrentPanel.onSetActive();
            }
        } else {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"m_jpCurrentPanel variable is null. Not sure how this can happen, if Apply was pressed...");
        }
    }

    protected void applyValues(final boolean bl) {
        JFrameAmp jFrameAmp = this.m_jfa;
        Thread thread = new Thread(){

            public void run() {
                boolean bl3 = false;
                boolean bl2 = true;
                AmpController.this.disableButtons();
                AmpController.this.setBusy(true);
                for (int i = 0; i < AmpController.this.m_vPanelList.size(); ++i) {
                    PanelTreePathPair panelTreePathPair = (PanelTreePathPair)AmpController.this.m_vPanelList.elementAt(i);
                    InterfaceAmpPanel interfaceAmpPanel = panelTreePathPair.getPanel();
                    if (!interfaceAmpPanel.isModified()) continue;
                    bl3 |= interfaceAmpPanel.doesModifyAppliance();
                    if (interfaceAmpPanel.onApply()) continue;
                    bl2 = false;
                    SwingUtilities.invokeLater(new Runnable(this, panelTreePathPair){
                        private final /* synthetic */ PanelTreePathPair val$pair;
                        private final /* synthetic */ 8 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$pair = panelTreePathPair;
                        }

                        public void run() {
                            8.access$300(this.this$1).m_jfa.getTabbedPane().setSelectedIndex(0);
                            8.access$300(this.this$1).m_jfa.getCategoryTree().setSelectionPath(this.val$pair.getTreePath());
                        }
                    });
                    break;
                }
                if (bl3 && bl2 && AmpController.this.checkIfRebootRequired()) {
                    AmpController.this.closeAmp();
                    return;
                }
                if (bl2 && bl) {
                    AmpController.this.closeAmp();
                    return;
                }
                if (bl2 && !bl) {
                    AmpController.this.enableButtons(false);
                } else {
                    AmpController.this.enableButtons(true);
                }
                AmpController.this.setBusy(false);
            }

            static /* synthetic */ AmpController access$300(8 var0) {
                return var0.AmpController.this;
            }
        };
        thread.start();
    }

    private void disableButtons() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AmpController.this.m_jfa.getOkButton().setEnabled(false);
                AmpController.this.m_jfa.getCancelButton().setEnabled(false);
                AmpController.this.m_jfa.getApplyButton().setEnabled(false);
                AmpController.this.m_jfa.getHelpButton().setEnabled(false);
            }
        });
    }

    private void enableButtons(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AmpController.this.m_jfa.getOkButton().setEnabled(true);
                AmpController.this.m_jfa.getCancelButton().setEnabled(true);
                AmpController.this.m_jfa.getApplyButton().setEnabled(bl);
                AmpController.this.m_jfa.getHelpButton().setEnabled(true);
            }
        });
    }

    void helpAction(ActionEvent actionEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"Help button pressed.");
        String string = null;
        switch (this.m_jfa.getTabbedPane().getSelectedIndex()) {
            case 0: {
                if (this.m_jpCurrentPanel == null || (string = this.m_jpCurrentPanel.getHelpID()) != null && string.trim().length() != 0) break;
                Trace.logError((String)TRACE_CONTEXT, (String)("Help ID not set for panel=" + this.m_jpCurrentPanel.getPanelLabel() + "."));
                Message.show((Component)this.m_jfa, (String)res.getString("AmpController_Help_Launch_Failure"));
                break;
            }
            case 1: {
                string = this.m_jfa.getStatusPanel().getHelpID();
                if (string != null && string.trim().length() != 0) break;
                Trace.logError((String)TRACE_CONTEXT, (String)"Help ID not set for Status panel.");
                Message.show((Component)this.m_jfa, (String)res.getString("AmpController_Help_Launch_Failure"));
                break;
            }
            case 2: {
                string = "IDH_TOOLS_TAB";
                break;
            }
            default: {
                Trace.logError((String)TRACE_CONTEXT, (String)("Unknown tab index=" + this.m_jfa.getTabbedPane().getSelectedIndex()));
                Message.show((Component)this.m_jfa, (String)res.getString("AmpController_Help_Launch_Failure"));
            }
        }
        if (string != null) {
            try {
                String string2 = this.getHelpUrlForId(string);
                BrowserHelper.showHelpPage((JFrame)this.m_jfa, (String)string2);
            }
            catch (Throwable throwable) {
                Trace.logError((String)TRACE_CONTEXT, (String)("Exception launching help.  exception msg: " + throwable.getMessage()), (Throwable)throwable);
                Message.show((Component)this.m_jfa, (String)res.getString("AmpController_Help_Launch_Failure"));
            }
        }
    }

    public ApplianceInfo getApplianceInfo() {
        return this.m_aiAppliance;
    }

    public AbstractNmmInterface getNmmInterface() {
        return this.m_aniNmmInterface;
    }

    void jTabbedPaneTabs_stateChanged(ChangeEvent changeEvent) {
        JTabbedPane jTabbedPane = this.m_jfa.getTabbedPane();
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Tab selection changed from " + this.m_nLastTabIndex + " to " + jTabbedPane.getSelectedIndex() + "."));
        switch (jTabbedPane.getSelectedIndex()) {
            case 0: {
                if (this.m_nLastTabIndex == 1) {
                    this.m_jfa.getStatusPanel().onKillActive();
                }
                if (this.m_jpCurrentPanel == null) break;
                this.m_jpCurrentPanel.onSetActive();
                break;
            }
            case 1: {
                if (this.m_nLastTabIndex == 0) {
                    if (this.m_jpCurrentPanel == null) break;
                    if (this.m_jpCurrentPanel.onKillActive()) {
                        this.m_jfa.getTabbedPane().setSelectedIndex(0);
                        break;
                    }
                    this.m_jfa.getStatusPanel().onSetActive();
                    break;
                }
                this.m_jfa.getStatusPanel().onSetActive();
                break;
            }
            case 2: {
                if (this.m_nLastTabIndex == 0) {
                    if (this.m_jpCurrentPanel == null || !this.m_jpCurrentPanel.onKillActive()) break;
                    this.m_jfa.getTabbedPane().setSelectedIndex(0);
                    this.m_jfa.getHelpButton().setEnabled(true);
                    break;
                }
                if (this.m_nLastTabIndex != 1) break;
                this.m_jfa.getStatusPanel().onKillActive();
                this.m_jfa.getHelpButton().setEnabled(true);
                break;
            }
            default: {
                Trace.logError((String)TRACE_CONTEXT, (String)("Unknown tab index=" + this.m_jfa.getTabbedPane().getSelectedIndex()));
            }
        }
        this.m_jfa.getRootPane().setDefaultButton(this.m_jfa.getOkButton());
        if (this.m_jfa.getCancelButton().hasFocus() || this.m_jfa.getApplyButton().hasFocus() || this.m_jfa.getHelpButton().hasFocus()) {
            this.m_jfa.getOkButton().requestFocus();
        }
        this.m_nLastTabIndex = this.m_jfa.getTabbedPane().getSelectedIndex();
    }

    public void setBusy(boolean bl) {
        if (this.m_jfa == null) {
            return;
        }
        final Component component = this.m_jfa.getGlassPane();
        final boolean bl2 = bl;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (bl2) {
                    component.setVisible(true);
                    AmpController.this.m_jfa.setCursor(Cursor.getPredefinedCursor(3));
                } else {
                    component.setVisible(false);
                    AmpController.this.m_jfa.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
    }

    public void setVisible(final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (bl) {
                    AmpController.this.m_jfa.getRootPane().setDefaultButton(AmpController.this.m_jfa.getOkButton());
                }
                AmpController.this.m_jfa.setVisible(bl);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void showInternalError() {
        String string = res.getString("AmpController_Req_Failed_internal");
        Message.show((Component)this.m_jfa, (String)string);
    }

    public void showException(InterfaceSnmpClient interfaceSnmpClient, String string, String string2, Throwable throwable) {
        this.showException(this.m_jfa, interfaceSnmpClient, string, string2, throwable);
    }

    public void showException(Window window, InterfaceSnmpClient interfaceSnmpClient, String string, String string2, Throwable throwable) {
        if (this.m_bAsmpSessionClosed) {
            return;
        }
        if (throwable != null && throwable instanceof ExceptionRequestFailed && throwable.getMessage() != null && throwable.getMessage().trim().length() > 0) {
            Message.show((Component)window, (String)throwable.getMessage());
            if (interfaceSnmpClient != null && throwable instanceof ExceptionSnmpRequestFailed) {
                interfaceSnmpClient.setErrorFieldFocus(((ExceptionSnmpRequestFailed)((Object)throwable)).getErrorIndex());
            }
        } else if (throwable != null && string2 != null && string2.trim().length() > 0 && throwable.getMessage() != null && throwable.getMessage().trim().length() > 0) {
            String string3 = string2 + res.getString("AmpController_Reason_") + throwable.getMessage();
            Trace.logError((String)string, (String)(string2 + "\n Reason: " + throwable.getMessage()), (Throwable)throwable);
            Message.show((Component)window, (String)string3);
        } else {
            Message.show((Component)window, (String)res.getString("AmpController_Req_Failed_internal"));
        }
        Trace.logError((String)string, (String)("Exception: " + throwable.getMessage()), (Throwable)throwable);
    }

    public void update(Observable observable, Object object) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Observer update called with Observable=" + observable + " and hint object=" + object + "."));
        if (object != null && object instanceof ObserverHint) {
            ObserverHint observerHint = (ObserverHint)object;
            int n = observerHint.getHint();
            Trace.logInfo((String)TRACE_CONTEXT, (String)("Observer update called with hintType=" + String.valueOf(n)));
            if (n == 1) {
                if (!this.m_bAsmpSessionClosed) {
                    this.m_bAsmpSessionClosed = true;
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"***Received a broadcast disconnect message from the appliance.");
                    observable.deleteObserver(this);
                    this.destroyPanels();
                    String string = "";
                    if (observerHint.getHintObject() instanceof Integer) {
                        switch ((Integer)observerHint.getHintObject()) {
                            case 2: {
                                string = res.getString("AmpController_Connection_Reboot");
                                break;
                            }
                            case 1: {
                                string = res.getString("AmpController_Connection_Rejected");
                                break;
                            }
                            default: {
                                string = res.getString("AmpController_Connection_default");
                                break;
                            }
                        }
                    } else {
                        string = (String)observerHint.getHintObject();
                    }
                    String string2 = res.getString("AmpController_disconnect_msg_Appliance0_Name1_Reason2");
                    String string3 = AVWorksBranding.getApplianceName((boolean)true);
                    Object[] objectArray = new Object[]{string3, this.m_aiAppliance.getName(), string};
                    string2 = MessageFormat.format(string2, objectArray);
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("The broadcast disconnect message sent by appliance was: \"" + string2 + "\"."));
                    Message.show((Component)this.m_jfa, (String)string2);
                    this.closeAmp();
                }
            } else if (n == 2 && !this.m_bAsmpSessionClosed) {
                this.m_bAsmpSessionClosed = true;
                Trace.logInfo((String)TRACE_CONTEXT, (String)"***Received connection lost notification from ThreadAsmpSession.  Notifying user and closing.");
                observable.deleteObserver(this);
                this.destroyPanels();
                String string = MessageFormat.format(res.getString("AmpController_Request_Failed_ASMP_communications"), APPLIANCE);
                Message.show((Component)this.m_jfa, (String)string);
                this.closeAmp();
            }
        }
    }

    private void thisWindowClosing(WindowEvent windowEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"AMP window closing--destroying all panels, and closing AMP.");
        this.closeAmp();
    }

    private void destroyPanels() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (int i = 0; i < AmpController.this.m_vPanelList.size(); ++i) {
                    PanelTreePathPair panelTreePathPair = (PanelTreePathPair)AmpController.this.m_vPanelList.elementAt(i);
                    InterfaceAmpPanel interfaceAmpPanel = panelTreePathPair.getPanel();
                    if (interfaceAmpPanel == null) continue;
                    interfaceAmpPanel.onDestroy();
                }
                if (AmpController.this.m_jfa.getStatusPanel() != null) {
                    AmpController.this.m_jfa.getStatusPanel().onDestroy();
                }
            }
        });
    }

    public void showCancelButton() {
        this.m_jfa.getCancelButton().setText(res.getString("AmpController_Cancel"));
        ButtonPanel.equalize((JPanel)this.m_jfa.getButtonsPanel());
        this.m_jfa.getButtonsPanel().invalidate();
        this.m_jfa.validate();
    }

    public void showCloseButton() {
        this.m_jfa.getCancelButton().setText(res.getString("AmpController_Close"));
        ButtonPanel.equalize((JPanel)this.m_jfa.getButtonsPanel());
        this.m_jfa.getButtonsPanel().invalidate();
        this.m_jfa.validate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ESCAPE_KEY)) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Escape button pressed.");
            this.closeAmp();
        }
    }

    public Object putValue(Object object, Object object2) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Setting property \"" + object.toString() + "\" to \"" + object2.toString() + "\""));
        Object v = this.m_hashtable.get(object);
        this.m_hashtable.put(object, object2);
        if (v != null && !v.equals(object2) || v != object2) {
            this.m_propertyChangeSupport.firePropertyChange(object.toString(), v, object2);
        }
        return v;
    }

    public Object getValue(Object object) {
        return this.m_hashtable.get(object);
    }

    public Appliance getAppliance() {
        return this.m_aAppliance;
    }

    public abstract SnmpHelper getSnmpHelper();

    public abstract String getHelpUrlForId(String var1);

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public static void validateIntProperty(JTextField jTextField, String string, int n, int n2) throws ExceptionInvalidArgument {
        int n3;
        String string2 = jTextField.getText().trim();
        try {
            n3 = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            jTextField.requestFocusInWindow();
            Object[] objectArray = new Object[]{string, String.valueOf(n), String.valueOf(n2)};
            String string3 = JPanelAmpPanel.getResourceString(res, "JPanelAmpPanel_Invald_number_entered", objectArray);
            throw new ExceptionInvalidArgument(string3);
        }
        if (n3 < n || n3 > n2) {
            jTextField.requestFocus();
            Object[] objectArray = new Object[]{string, String.valueOf(n), String.valueOf(n2)};
            String string4 = JPanelAmpPanel.getResourceString(res, "JPanelAmpPanel_Invald_number_entered", objectArray);
            throw new ExceptionInvalidArgument(string4);
        }
    }

    public abstract String getResource(String var1);

    public abstract String getResource(String var1, Object[] var2);

    public boolean isFeatureSupported(String string) {
        return this.m_aAppliance.isFeatureSupported(string);
    }

    public void doHandleEvent(Object object, int n) {
        Trace.logInfo((String)"AmpController:doHandleEvent", (String)("Received event ID=" + n));
        if (n == 6) {
            UnitInfo[] unitInfoArray = (UnitInfo[])object;
            for (int i = 0; i < unitInfoArray.length; ++i) {
                if (unitInfoArray[i].getID() != this.getApplianceInfo().getID()) continue;
                this.closeAmp();
            }
        }
    }

    public void resetAmp() throws ExceptionRequestFailed {
        this.getAppliance().resetAppliance();
        this.removeAllSettingsPanels();
        this.addSettingsPanels();
        ((DefaultTreeModel)this.m_jfa.getCategoryTree().getModel()).nodeStructureChanged(this.m_dmtnRootNode);
    }

    public void invalidateSettingsPanels() {
        for (int i = 0; i < this.m_vPanelList.size(); ++i) {
            PanelTreePathPair panelTreePathPair = (PanelTreePathPair)this.m_vPanelList.elementAt(i);
            InterfaceAmpPanel interfaceAmpPanel = panelTreePathPair.getPanel();
            if (interfaceAmpPanel == this.m_jpCurrentPanel) {
                interfaceAmpPanel.setPanelState(102);
                interfaceAmpPanel.onSetActive();
                continue;
            }
            interfaceAmpPanel.setPanelState(101);
        }
    }

    public int getLoginTimeout(int n) {
        return 30;
    }
}

