/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.common;

import com.avocent.avworks.nmm.common.AsmpConnection;
import com.avocent.avworks.nmm.common.DiscoverInfo;
import com.avocent.avworks.nmm.common.InterfaceValueObject;
import com.avocent.avworks.nmm.common.Port;
import com.avocent.avworks.nmm.common.SnmpHelper;
import com.avocent.avworks.nmm.common.SnmpValueObject;
import com.avocent.avworks.nmm.common.User;
import com.avocent.avworks.nmm.common.UserAccessLevel;
import com.avocent.avworks.nmm.common.model.AuthSupport;
import com.avocent.avworks.nmm.common.model.LdapSupport;
import com.avocent.avworks.nmm.common.model.RadiusSupport;
import com.avocent.avworks.nmm.common.model.SSHSupport;
import com.avocent.avworks.nmm.common.model.SnmpSupport;
import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.net.MacAddress;
import com.avocent.protocols.snmp.AsnObjectIdentifier;
import com.avocent.protocols.snmp.Mib;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;

public abstract class Appliance {
    private static final String TRACE_CONTEXT = "Appliance";
    protected AsmpConnection m_acAsmpConnection;
    protected Hashtable m_hashtable = new Hashtable();
    protected HashMap m_ampValues = new HashMap();
    protected PropertyChangeSupport m_propertyChangeSupport;
    protected boolean m_snmpValuesLoaded = false;

    public Appliance(AsmpConnection asmpConnection) {
        this.m_acAsmpConnection = asmpConnection;
        this.m_propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public abstract UserAccessLevel[] getAccessLevelArray() throws Exception;

    public abstract String getApplianceAdministratorLabel();

    public abstract Integer getMibMajorVersion();

    public abstract Integer getMibMinorVersion();

    public abstract int mapToApplicationAccessLevel(int var1);

    public abstract User[] loadUserTable() throws Exception;

    public abstract Port[] loadPortTable() throws Exception;

    public abstract UserAccessLevel getUserAccessLevel(int var1) throws Exception;

    public abstract int getSecurityLockoutDuration() throws Exception;

    public abstract void setSecurityLockoutDuration(int var1) throws Exception;

    public abstract void unlockUser(String var1) throws Exception;

    public abstract User newUser() throws ExceptionConstructorFailed;

    public abstract void deleteUser(User var1) throws Exception;

    public abstract void addUser(User var1) throws Exception;

    public abstract void modifyUser(User var1) throws Exception;

    public abstract void clearPortAccessList(User var1) throws Exception;

    public abstract void setPortAccess(User var1, Port var2) throws Exception;

    public abstract boolean isSecurityLockoutSupported() throws Exception;

    public abstract LdapSupport getLdapSupport();

    public abstract AuthSupport getLocalAuthSupport();

    public abstract SnmpSupport getSnmpSupport();

    public abstract RadiusSupport getRadiusSupport();

    public abstract SSHSupport getSSHSupport();

    public abstract boolean isUserApplianceAdmin();

    public InterfaceValueObject[] getSnmpValues(Object[] objectArray) throws Exception {
        InterfaceValueObject[] interfaceValueObjectArray = this.getSnmpHelper().getMibValues(this.m_acAsmpConnection, objectArray);
        if (interfaceValueObjectArray.length != interfaceValueObjectArray.length) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Error retrieving values from appliance.");
            throw new ExceptionRequestFailed();
        }
        return interfaceValueObjectArray;
    }

    public InterfaceValueObject[][] getSnmpTableValues(Object[] objectArray) throws Exception {
        InterfaceValueObject[][] interfaceValueObjectArray = this.getSnmpHelper().getMibTableValues(this.m_acAsmpConnection, objectArray);
        if (interfaceValueObjectArray.length != interfaceValueObjectArray.length) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Error retrieving values from appliance.");
            throw new ExceptionRequestFailed();
        }
        return interfaceValueObjectArray;
    }

    public void set(AsmpConnection asmpConnection, Object[] objectArray, Object[] objectArray2) throws Exception {
        this.getSnmpHelper().setMibValues(this.m_acAsmpConnection, objectArray, objectArray2);
    }

    public abstract SnmpHelper getSnmpHelper();

    public int getIntSnmpAttribute(String string, SnmpHelper snmpHelper) throws Exception {
        int n = 0;
        Object[] objectArray = new Object[]{string};
        InterfaceValueObject[] interfaceValueObjectArray = snmpHelper.getMibValues(this.m_acAsmpConnection, objectArray);
        if (interfaceValueObjectArray.length != interfaceValueObjectArray.length) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Unable to request " + string));
            throw new ExceptionRequestFailed();
        }
        n = interfaceValueObjectArray[0].getInteger();
        return n;
    }

    public String getStringSnmpAttribute(String string, SnmpHelper snmpHelper) throws Exception {
        String string2 = null;
        Object[] objectArray = new Object[]{string};
        InterfaceValueObject[] interfaceValueObjectArray = snmpHelper.getMibValues(this.m_acAsmpConnection, objectArray);
        if (interfaceValueObjectArray.length != 1) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Unable to request " + string));
            throw new ExceptionRequestFailed();
        }
        string2 = interfaceValueObjectArray[0].toString();
        return string2;
    }

    public String getSysObjectId() throws Exception {
        return this.getStringSnmpAttribute("mib-2.system.sysObjectID.0", new SnmpHelper());
    }

    public int determineEthernetInterface() throws Exception {
        boolean bl = false;
        int n = 0;
        Object[] objectArray = null;
        SnmpValueObject[] snmpValueObjectArray = null;
        SnmpHelper snmpHelper = new SnmpHelper();
        AsnObjectIdentifier asnObjectIdentifier = Mib.NameToOid((String)"mib-2.interfaces.ifTable.ifEntry.ifType");
        objectArray = new Object[]{"mib-2.interfaces.ifTable.ifEntry.ifType"};
        while ((snmpValueObjectArray = snmpHelper.getNextMibValues(this.m_acAsmpConnection, objectArray)).length == objectArray.length) {
            AsnObjectIdentifier asnObjectIdentifier2 = Mib.NameToOid((String)snmpValueObjectArray[0].getVarBind().getName());
            if (Mib.OidCompare((AsnObjectIdentifier)asnObjectIdentifier, (AsnObjectIdentifier)asnObjectIdentifier2) != asnObjectIdentifier.getOidValue().length || asnObjectIdentifier.getOidValue().length + 1 != asnObjectIdentifier2.getOidValue().length) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"Unable to find ethernet interface");
                return 0;
            }
            n = snmpValueObjectArray[0].getInteger();
            if (n == 6) {
                return asnObjectIdentifier2.getOidValue()[asnObjectIdentifier2.getOidValue().length - 1];
            }
            objectArray = new Object[]{snmpValueObjectArray[0].getVarBind().getName()};
        }
        Trace.logError((String)TRACE_CONTEXT, (String)"Incorrect dataset in ASMP response");
        return 0;
    }

    public DiscoverInfo discover() throws Exception {
        SnmpHelper snmpHelper = new SnmpHelper();
        DiscoverInfo discoverInfo = null;
        int n = this.determineEthernetInterface();
        if (n <= 0) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Unable to locate Ethernet Interface");
            return null;
        }
        Object[] objectArray = new Object[]{"mib-2.system.sysObjectID.0", "mib-2.system.sysName.0", "mib-2.interfaces.ifTable.ifEntry.ifPhysAddress"};
        InterfaceValueObject[] interfaceValueObjectArray = snmpHelper.getMibValues(this.m_acAsmpConnection, objectArray, Integer.toString(n));
        if (interfaceValueObjectArray.length == objectArray.length) {
            discoverInfo = new DiscoverInfo(interfaceValueObjectArray[0].toString(), interfaceValueObjectArray[1].toString(), new MacAddress(interfaceValueObjectArray[2].getByteArray()));
        }
        return discoverInfo;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.m_propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.m_propertyChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public Object updateValue(Object object) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Updated cached value \"" + object.toString() + "\" with value from the AMP cache."));
        Object v = this.m_ampValues.get(object);
        if (v != null) {
            this.m_hashtable.put(object, v);
            if (v != null) {
                this.m_ampValues.remove(object);
            }
        }
        return v;
    }

    public Object setValue(Object object, int n, Object object2) {
        String string = object.toString() + "[" + n + "]";
        return this.setValue(string, object2);
    }

    public Object setValue(Object object, Object object2) {
        Object v;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Set cached value \"" + object.toString() + "\" to \"" + object2.toString() + "\""));
        Object v2 = this.m_hashtable.get(object);
        this.m_hashtable.put(object, object2);
        if (v2 != null && !v2.equals(object2) || v2 != object2) {
            this.m_propertyChangeSupport.firePropertyChange(object.toString(), v2, object2);
        }
        if ((v = this.m_ampValues.get(object)) != null && v.equals(object2)) {
            this.m_ampValues.remove(object);
        }
        return v2;
    }

    public Object getValue(Object object) {
        Object v = this.m_ampValues.get(object);
        if (v == null) {
            v = this.m_hashtable.get(object);
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Get value \"" + object.toString() + "\" of \"" + v + "\""));
        return v;
    }

    public Object getCachedValue(Object object) {
        Object v = this.m_hashtable.get(object);
        return v;
    }

    public Object getAmpValue(Object object) {
        Object v = this.m_ampValues.get(object);
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Get amp value \"" + object.toString() + "\" to \"" + v + "\""));
        return v;
    }

    public String getStringValue(Object object) {
        Object object2 = this.getValue(object);
        String string = object2 == null ? null : object2.toString();
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Get cached value \"" + object.toString() + "\" to \"" + string + "\""));
        return string;
    }

    public Integer getIntValue(Object object, int n) {
        String string = object.toString() + "[" + n + "]";
        return this.getIntValue(string);
    }

    public Integer getIntValue(Object object) {
        try {
            Integer n = null;
            Object object2 = this.getValue(object);
            if (object2 == null) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("No cached value found for: \"" + object.toString()));
                throw new RuntimeException("No value found for: " + object.toString());
            }
            n = object2 instanceof Integer ? (Integer)object2 : new Integer(object2.toString().trim());
            Trace.logInfo((String)TRACE_CONTEXT, (String)("Get cached value \"" + object.toString() + "\" to \"" + n + "\""));
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Exception: " + numberFormatException.getMessage()), (Throwable)numberFormatException);
            throw numberFormatException;
        }
    }

    public Boolean getBooleanValue(Object object, int n) {
        String string = object.toString() + "[" + n + "]";
        return this.getBooleanValue(string);
    }

    public Boolean getBooleanValue(Object object) {
        Boolean bl = (Boolean)this.getValue(object);
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Get cached value \"" + object.toString() + "\" to \"" + bl + "\""));
        return bl;
    }

    public boolean setAmpValue(Object object, Object object2) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Set amp value \"" + object.toString() + "\" to \"" + object2 + "\""));
        boolean bl = false;
        Object object3 = this.getCachedValue(object);
        if (object3 != null && this.compareValues(object3, object2)) {
            Object v = this.m_ampValues.remove(object);
            if (v != null) {
                this.m_propertyChangeSupport.firePropertyChange(object.toString(), v, object2);
            }
            bl = false;
        } else {
            Object object4 = this.m_ampValues.put(object, object2);
            if (object4 == null || !object4.equals(object2)) {
                this.m_propertyChangeSupport.firePropertyChange(object.toString(), object4, object2);
                bl = true;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public void clearAmpValue(Object object) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Removing amp value for \"" + object.toString() + "\""));
        this.m_ampValues.remove(object);
    }

    boolean compareValues(Object object, Object object2) {
        boolean bl = false;
        if (object.getClass().isInstance(object2)) {
            bl = object.equals(object2);
        } else if (object instanceof Integer) {
            try {
                bl = Integer.valueOf(object2.toString().trim()).equals(object);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        } else if (object instanceof Long) {
            try {
                bl = Long.valueOf(object2.toString().trim()).equals(object);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        } else if (object instanceof Boolean) {
            try {
                bl = Boolean.valueOf(object2.toString().trim()).equals(object);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        } else {
            try {
                bl = object2.toString().equals(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean areValuesModified() {
        return this.m_ampValues.size() > 0;
    }

    public AsmpConnection getAsmpConnection() {
        return this.m_acAsmpConnection;
    }

    public boolean isFeatureSupported(String string) {
        String string2 = AVWorksBranding.getString((String)string, null);
        if (string2 == null) {
            return false;
        }
        if (string2.equalsIgnoreCase("true")) {
            return true;
        }
        if (string2.equalsIgnoreCase("false")) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":;");
        int n = stringTokenizer.countTokens();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            try {
                int n2 = string2.indexOf(".");
                String string4 = string3.substring(0, n2);
                String string5 = string3.substring(n2 + 1);
                int n3 = Integer.parseInt(string4.trim());
                int n4 = Integer.parseInt(string5.trim());
                if (n == 1) {
                    return this.hasMinMibVersion(n3, n4);
                }
                if (!this.hasMajorMibVersion(n3)) continue;
                return this.hasMinMibVersion(n3, n4);
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    public void setReloadData() {
        this.m_snmpValuesLoaded = false;
    }

    public void resetAppliance() {
        this.setReloadData();
        this.m_hashtable.clear();
        this.m_ampValues.clear();
    }

    public boolean hasMinMibVersion(int n, int n2) {
        int n3 = this.getMibMajorVersion();
        int n4 = this.getMibMinorVersion();
        return n3 > n || n3 == n && n4 >= n2;
    }

    public boolean hasMajorMibVersion(int n) {
        int n2 = this.getMibMajorVersion();
        return n2 == n;
    }
}

