/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.common;

import com.avocent.avworks.nmm.common.AmpController;
import com.avocent.avworks.nmm.common.SnmpHelper;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.dialogs.JDialogElapsedTime;
import com.avocent.lib.gui.dialogs.JDialogLogin;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.CachedCredentials;
import com.avocent.lib.util.ResourceManager;
import com.avocent.lib.util.UsernamePassword;
import com.avocent.protocols.asmp.ThreadAsmpSession;
import com.avocent.protocols.snmp.SnmpRequest;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Observer;
import javax.swing.SwingUtilities;

public class AsmpConnection
implements ActionListener {
    public static final String TRACE_CONTEXT = "AsmpConnection";
    public static final String CNAME = "AsmpConnection";
    static ResourceManager res;
    public static final int SUCCESS = 1;
    public static final int ERROR = 2;
    public static final int CANCELED = 3;
    public static final int DFLT_LOGIN_TIMEOUT = 30;
    protected InetAddress m_iaApplianceIp;
    protected ThreadAsmpSession m_asmpsession;
    protected JDialogLogin m_jdlLoginDialog;
    protected JDialogElapsedTime m_jdetProgress;
    protected ThreadCreateConnection m_tccOpenSession;
    protected boolean m_bStartupCanceled;
    protected boolean m_bSslSessionStarted = false;
    protected int m_loginTimeout = 30;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AsmpConnection() {
    }

    public AsmpConnection(int n) {
        this.m_loginTimeout = n;
    }

    public int openConnection(InetAddress inetAddress, Component component, JDialogElapsedTime jDialogElapsedTime, boolean bl) throws ExceptionRequestFailed, IOException {
        int n;
        if (jDialogElapsedTime != null) {
            this.m_jdetProgress = jDialogElapsedTime;
            this.m_jdetProgress.addListener((ActionListener)this);
            this.m_jdetProgress.setEnableCancelButton(true);
        }
        if ((n = this.openAsmpSession(component, inetAddress)) == 3) {
            return 3;
        }
        if (n == 2) {
            Trace.logError((String)"AsmpConnection", (String)"Failed to open ASMP connection.");
            if (jDialogElapsedTime != null) {
                this.m_jdetProgress.removeListener((ActionListener)this);
            }
            if (this.m_asmpsession != null) {
                this.m_asmpsession.stopThread();
            }
            throw new ExceptionRequestFailed();
        }
        if (!this.asmpLogin(component, bl)) {
            if (this.m_bStartupCanceled) {
                Trace.logInfo((String)"AsmpConnection", (String)"User canceled ASMP connection.");
            } else {
                Trace.logError((String)"AsmpConnection", (String)"Failed to log in on ASMP connection.");
            }
            if (jDialogElapsedTime != null) {
                this.m_jdetProgress.removeListener((ActionListener)this);
            }
            this.m_asmpsession.stopThread();
            return 3;
        }
        if (jDialogElapsedTime != null) {
            this.m_jdetProgress.removeListener((ActionListener)this);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int openAsmpSession(Component component, InetAddress inetAddress) throws ExceptionRequestFailed, IOException {
        if (!$assertionsDisabled && SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (inetAddress == null) {
            throw new ExceptionRequestFailed();
        }
        this.m_iaApplianceIp = inetAddress;
        this.m_bStartupCanceled = false;
        this.m_tccOpenSession = new ThreadCreateConnection();
        this.m_tccOpenSession.start();
        AsmpConnection asmpConnection = this;
        synchronized (asmpConnection) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                Trace.logError((String)"AsmpConnection", (String)("Interrupted while creating ASMP session: " + interruptedException.getMessage()), (Throwable)interruptedException);
                throw new IOException();
            }
        }
        int n = 2;
        if (this.m_bStartupCanceled) {
            n = 3;
        } else if (this.m_bSslSessionStarted) {
            n = 1;
        }
        return n;
    }

    public void openAnonymousConnection(InetAddress inetAddress) throws ExceptionRequestFailed, IOException {
        this.m_iaApplianceIp = inetAddress;
        this.m_asmpsession = new ThreadAsmpSession(this.m_iaApplianceIp, false, 30000);
        this.m_asmpsession.setProperty("LOGIN_TIMEOUT", Integer.toString(this.m_loginTimeout));
        this.m_asmpsession.startSession();
    }

    public void openAnonymousConnection(InetAddress inetAddress, int n, int n2) throws ExceptionRequestFailed, IOException {
        this.m_iaApplianceIp = inetAddress;
        this.m_asmpsession = new ThreadAsmpSession(this.m_iaApplianceIp, false, 30000, n, n2);
        this.m_asmpsession.setProperty("LOGIN_TIMEOUT", Integer.toString(this.m_loginTimeout));
        this.m_asmpsession.startSession();
    }

    public boolean isConnected() {
        return this.m_asmpsession != null;
    }

    public boolean asmpLogin(Component component, boolean bl) {
        UsernamePassword usernamePassword = CachedCredentials.getCredentials();
        UsernamePassword usernamePassword2 = new UsernamePassword(usernamePassword);
        if (!bl) {
            usernamePassword = new UsernamePassword();
            usernamePassword2 = new UsernamePassword(usernamePassword);
        }
        if (usernamePassword.getUsername().trim().length() == 0 && !this.showLoginPrompt(component, usernamePassword2)) {
            return false;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            do {
                if (bl2 && !this.showLoginPrompt(component, usernamePassword2)) {
                    return false;
                }
                Trace.logInfo((String)"AsmpConnection", (String)("Login to appliance with user (" + usernamePassword2.getUsername() + "), password(" + usernamePassword2.getPassword() + ")."));
                int n = this.m_asmpsession.login(usernamePassword2.getUsername(), usernamePassword2.getPassword());
                this.m_asmpsession.setProperty("KEEP_ALIVE", Integer.toString(30000));
                if (this.m_bStartupCanceled) {
                    return false;
                }
                Trace.logInfo((String)"AsmpConnection", (String)("Login status=" + n));
                switch (n) {
                    case 0: {
                        if (this.m_jdetProgress != null) {
                            if (this.m_bStartupCanceled) {
                                this.m_jdetProgress.setVisible(false);
                                this.m_jdetProgress.removeNotify();
                            } else {
                                this.m_jdetProgress.showMessageForKey("amp_connection_msg");
                            }
                        }
                        Trace.logInfo((String)"AsmpConnection", (String)"Login successful");
                        if (bl) {
                            CachedCredentials.setCredentials((UsernamePassword)usernamePassword2);
                        }
                        bl2 = false;
                        break;
                    }
                    case 259: {
                        if (this.m_jdetProgress != null) {
                            this.m_jdetProgress.setVisible(false);
                            this.m_jdetProgress.removeNotify();
                        }
                        Trace.logError((String)"AsmpConnection", (String)"Failed login. Reason: Unknown User or Password");
                        Message.show((Component)component, (String)AmpController.res.getString("AsmpConnection_Login_failure_Bad_username"));
                        bl2 = true;
                        this.m_jdlLoginDialog = null;
                        break;
                    }
                    case 260: {
                        if (this.m_jdetProgress != null) {
                            this.m_jdetProgress.setVisible(false);
                            this.m_jdetProgress.removeNotify();
                        }
                        Trace.logError((String)"AsmpConnection", (String)"Failed login. Reason: Max Sessions Active");
                        Message.show((Component)component, (String)AmpController.res.getString("AsmpConnection_Login_failure_Maximum_number"));
                        bl3 = true;
                        break;
                    }
                    case 268: {
                        if (this.m_jdetProgress != null) {
                            this.m_jdetProgress.setVisible(false);
                            this.m_jdetProgress.removeNotify();
                        }
                        Trace.logError((String)"AsmpConnection", (String)"Failed login. Reason: User is locked out");
                        Message.show((Component)component, (String)AmpController.res.getString("AsmpConnection_Login_Failure_Locked_User"));
                        bl2 = true;
                        this.m_jdlLoginDialog = null;
                        break;
                    }
                    case 4096: {
                        if (this.m_jdetProgress != null) {
                            this.m_jdetProgress.setVisible(false);
                            this.m_jdetProgress.removeNotify();
                        }
                        String string = SnmpHelper.getErrorStatusMessage(n);
                        Trace.logError((String)"AsmpConnection", (String)("Failed login. Reason: " + string));
                        Message.show((Component)component, (String)string);
                        bl3 = true;
                        break;
                    }
                    case 269: {
                        if (this.m_jdetProgress != null) {
                            this.m_jdetProgress.setVisible(false);
                            this.m_jdetProgress.removeNotify();
                        }
                        Trace.logError((String)"AsmpConnection", (String)"Failed login. Reason: User Access Denied");
                        Message.show((Component)component, (String)AmpController.res.getString("AsmpConnection_Login_Failure_User_Access_Denied"));
                        bl2 = true;
                        this.m_jdlLoginDialog = null;
                        break;
                    }
                    case 270: {
                        if (this.m_jdetProgress != null) {
                            this.m_jdetProgress.setVisible(false);
                            this.m_jdetProgress.removeNotify();
                        }
                        Trace.logError((String)"AsmpConnection", (String)"Failed login. Reason: Auth Server Failed");
                        Message.show((Component)component, (String)AmpController.res.getString("AsmpConnection_Login_Failure_Auth_Server"));
                        bl2 = true;
                        this.m_jdlLoginDialog = null;
                        break;
                    }
                    case 271: {
                        if (this.m_jdetProgress != null) {
                            this.m_jdetProgress.setVisible(false);
                            this.m_jdetProgress.removeNotify();
                        }
                        Trace.logError((String)"AsmpConnection", (String)"Failed login. Reason: Bad CA Certificate on appliance");
                        Message.show((Component)component, (String)AmpController.res.getString("AsmpConnection_Login_failure_Bad_cert"));
                        bl2 = true;
                        this.m_jdlLoginDialog = null;
                        break;
                    }
                    default: {
                        if (this.m_jdetProgress != null) {
                            this.m_jdetProgress.setVisible(false);
                            this.m_jdetProgress.removeNotify();
                        }
                        Trace.logError((String)"AsmpConnection", (String)"Failed login. Reason: Internal Error");
                        Message.show((Component)component, (String)AmpController.res.getString("AsmpConnection_Login_failure_Internal_Error"));
                        bl3 = true;
                    }
                }
            } while (bl2 && !bl3);
        }
        catch (Exception exception) {
            Message.show((Component)component, (String)AmpController.res.getString("AsmpConnection_Login_failure_Internal_Error"));
            bl3 = true;
        }
        return !bl3;
    }

    public void addSessionObserver(Observer observer) {
        this.m_asmpsession.addObserver(observer);
    }

    public void removeSessionObserver(Observer observer) {
        this.m_asmpsession.removeObserver(observer);
    }

    public void closeAsmpSession() throws ExceptionRequestFailed {
        if (this.m_asmpsession != null) {
            this.m_asmpsession.logout();
            this.m_asmpsession.stopThread();
            this.m_asmpsession = null;
        }
    }

    public int asmpRequest(SnmpRequest snmpRequest) throws ExceptionRequestFailed {
        if (this.m_asmpsession != null) {
            return this.m_asmpsession.snmpRequest(snmpRequest);
        }
        throw new ExceptionRequestFailed(AmpController.res.getString("AsmpConnection_ASMP_No_Session"));
    }

    public InetAddress getIpAddress() {
        return this.m_iaApplianceIp;
    }

    boolean showLoginPrompt(Component component, UsernamePassword usernamePassword) {
        try {
            if (this.m_jdetProgress != null) {
                this.m_jdetProgress.setVisible(false);
            }
            if (component instanceof Frame) {
                this.m_jdlLoginDialog = new JDialogLogin((Frame)component, AmpController.res.getString("AsmpConnection_Login"), usernamePassword);
                this.m_jdlLoginDialog.setLocationRelativeTo(component);
            } else if (component instanceof Dialog) {
                this.m_jdlLoginDialog = new JDialogLogin((Dialog)component, AmpController.res.getString("AsmpConnection_Login"), usernamePassword);
                this.m_jdlLoginDialog.setLocationRelativeTo(component);
            } else {
                this.m_jdlLoginDialog = new JDialogLogin((Frame)null, AmpController.res.getString("AsmpConnection_Login"), usernamePassword);
            }
            this.m_jdlLoginDialog.setVisible(true);
            if (!this.m_jdlLoginDialog.wasOkPressed()) {
                this.m_bStartupCanceled = true;
                return false;
            }
            if (this.m_jdetProgress != null) {
                this.m_jdetProgress.setVisible(true);
            }
            return true;
        }
        catch (ExceptionConstructorFailed exceptionConstructorFailed) {
            Trace.logError((String)"AsmpConnection", (String)"Unable to get login credentials.", (Throwable)exceptionConstructorFailed);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        this.m_bStartupCanceled = this.m_jdetProgress.checkCancelButton();
        if (this.m_bStartupCanceled) {
            Trace.logInfo((String)"AsmpConnection", (String)"User canceled ASMP connection startup.");
            this.m_jdetProgress.setVisible(false);
            if (this.m_tccOpenSession != null) {
                this.m_tccOpenSession.cancelConnectionCreation();
                AsmpConnection asmpConnection = this;
                synchronized (asmpConnection) {
                    this.notifyAll();
                }
            }
        }
    }

    public ThreadAsmpSession getAsmpSession() {
        return this.m_asmpsession;
    }

    static {
        $assertionsDisabled = !AsmpConnection.class.desiredAssertionStatus();
        res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.common.Res");
    }

    class ThreadCreateConnection
    extends Thread {
        protected boolean m_bConnectCancelled = false;

        ThreadCreateConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                AsmpConnection.this.m_bSslSessionStarted = false;
                AsmpConnection.this.m_asmpsession = new ThreadAsmpSession(AsmpConnection.this.m_iaApplianceIp, true, 30000);
                AsmpConnection.this.m_asmpsession.setProperty("LOGIN_TIMEOUT", Integer.toString(AsmpConnection.this.m_loginTimeout));
                AsmpConnection.this.m_asmpsession.setProperty("KEEP_ALIVE", Integer.toString(AsmpConnection.this.m_loginTimeout + 5));
                if (this.m_bConnectCancelled && AsmpConnection.this.m_asmpsession != null) {
                    AsmpConnection.this.m_asmpsession.stopThread();
                }
                AsmpConnection.this.m_asmpsession.startSession();
                AsmpConnection.this.m_bSslSessionStarted = true;
            }
            catch (IOException iOException) {
                Trace.logError((String)"AsmpConnection", (String)("Error while creating ASMP session: " + iOException.getMessage()), (Throwable)iOException);
            }
            catch (Throwable throwable) {
                Trace.logError((String)"AsmpConnection", (String)("Error while creating ASMP session: " + throwable.getMessage()), (Throwable)throwable);
            }
            finally {
                AsmpConnection.this.m_tccOpenSession = null;
            }
            AsmpConnection asmpConnection = AsmpConnection.this;
            synchronized (asmpConnection) {
                AsmpConnection.this.notifyAll();
            }
        }

        public void cancelConnectionCreation() {
            this.m_bConnectCancelled = true;
        }
    }
}

