/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.common;

import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.avworks.services.AVWorksEventBroadcaster;
import com.avocent.avworks.services.DatabaseSession;
import com.avocent.avworks.services.InterfacesDb;
import com.avocent.avworks.services.ServerInfo;
import com.avocent.avworks.services.ServerPropertiesDb;
import com.avocent.avworks.services.ServersDb;
import com.avocent.avworks.services.UnitInfo;
import com.avocent.lib.database.DBaseRequestQueryResults;
import com.avocent.lib.database.SqlCmd;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import java.util.ArrayList;

public class DatabaseHelper {
    private static final String TRACE_CONTEXT = "DatabaseHelper";

    public static boolean isServerDeleteOk(int n) throws ExceptionRequestFailed {
        if (InterfacesDb.getNumConnectedTo((int)n, (int)1) > 1) {
            return false;
        }
        if (AVWorksBranding.getBoolean((String)"VirtualConnectionSupport", (boolean)false)) {
            String string = ServerPropertiesDb.getStringValue((int)n, (String)"TELNET_IP", null);
            if (string != null && string.length() > 0) {
                return false;
            }
            String string2 = ServersDb.getBrowserUrl((int)n);
            if (string2 != null && string2.length() > 0) {
                return false;
            }
        }
        return true;
    }

    public static boolean deleteServer(int n) throws ExceptionRequestFailed {
        if (!DatabaseHelper.isServerDeleteOk(n)) {
            return false;
        }
        int[] nArray = new int[]{n};
        ServersDb.delete((int[])nArray);
        return true;
    }

    public static boolean deleteServers(int[] nArray) throws ExceptionRequestFailed, ExceptionNoValue {
        int n = 0;
        int[] nArray2 = new int[nArray.length];
        ArrayList<ServerInfo> arrayList = new ArrayList<ServerInfo>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            if (!DatabaseHelper.isServerDeleteOk(nArray[i])) continue;
            arrayList.add(ServersDb.getServerInfo((int)nArray[i]));
            nArray2[n] = nArray[i];
            ++n;
        }
        if (n == 0) {
            return false;
        }
        if (n < nArray.length) {
            nArray = new int[n];
            System.arraycopy(nArray2, 0, nArray, 0, n);
        }
        ServersDb.delete((int[])nArray);
        ServerInfo[] serverInfoArray = arrayList.toArray(new ServerInfo[0]);
        AVWorksEventBroadcaster.appendDeletedServers((UnitInfo[])serverInfoArray);
        return true;
    }

    public static ServerInfo createServerInfoConnRules(String string, int n, String string2, int n2, int n3) throws ExceptionRequestFailed {
        ServerInfo serverInfo = null;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("createServerInfoConnRules(" + string + "," + n + "," + string2 + ")"));
        try {
            ServerInfo[] serverInfoArray = ServersDb.getServerList((String)("WHERE (UPPER(NAME)=" + SqlCmd.quote((String)string.toUpperCase()) + ")"));
            for (int i = 0; i < serverInfoArray.length; ++i) {
                if (!serverInfoArray[i].getName().equalsIgnoreCase(string)) continue;
                serverInfo = serverInfoArray[i];
                break;
            }
        }
        catch (ExceptionNoValue exceptionNoValue) {
            serverInfo = null;
        }
        if (serverInfo == null) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Server does not already exist, creating one");
            serverInfo = new ServerInfo(0, string, "", "", n3);
            return serverInfo;
        }
        if (DatabaseHelper.getServerConnectionCountByNmm(serverInfo.getID(), n) > 0) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("Server exists and already has a connection of type " + string2));
            serverInfo = new ServerInfo(0, string, "", "", n3);
            return serverInfo;
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Server exists and can have another connection of type " + string2));
        return serverInfo;
    }

    public static int getServerConnectionCountByNmm(int n, int n2) throws ExceptionRequestFailed {
        DBaseRequestQueryResults dBaseRequestQueryResults = null;
        int n3 = 0;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Getting Server Connections for [" + n + "]"));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT COUNT(*) as NumOfConns FROM INTERFACES, APPLIANCES WHERE").append(" INTERFACES.CONN_ID=").append(Integer.toString(n)).append(" AND INTERFACES.CONN_TYPE=").append(Integer.toString(1)).append(" AND INTERFACES.APPLIANCE_ID=APPLIANCES.ID ").append(" AND APPLIANCES.NMM=").append(Integer.toString(n2));
        Trace.logInfo((String)TRACE_CONTEXT, (String)("SQL Query[" + stringBuffer.toString() + "]"));
        int n4 = DatabaseSession.executeQuery((String)stringBuffer.toString());
        dBaseRequestQueryResults = DatabaseSession.getQueryResults((int)n4, (int)100);
        DatabaseSession.closeQuery((int)n4);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Unexpected number of rows returned " + dBaseRequestQueryResults.getRowCount()));
            throw new ExceptionRequestFailed();
        }
        dBaseRequestQueryResults.nextRow();
        n3 = dBaseRequestQueryResults.getInt(1);
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Connection Count=[" + n3 + "]"));
        return n3;
    }
}

