/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.common;

import com.avocent.avworks.services.Products;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.net.IpAddress;
import com.avocent.lib.net.MacAddress;
import com.avocent.protocols.aidp.AidpDiscoverInfo;

public class DiscoverInfo {
    private String m_szSysObjectId;
    private String m_szName;
    private MacAddress m_maAppliance;
    IpAddress m_ipaAppliance;
    IpAddress m_ipaSubnetMask;
    IpAddress m_ipaGateway;
    private int m_nProductID;

    public DiscoverInfo(String string, String string2, MacAddress macAddress) {
        this.m_szSysObjectId = string;
        this.m_szName = string2;
        this.m_maAppliance = macAddress;
        this.m_nProductID = Products.getProductIDForSysObjectId((String)this.m_szSysObjectId);
    }

    public DiscoverInfo(String string, String string2, MacAddress macAddress, IpAddress ipAddress, IpAddress ipAddress2, IpAddress ipAddress3) {
        this.m_szSysObjectId = string;
        this.m_szName = string2;
        this.m_maAppliance = macAddress;
        this.m_ipaAppliance = ipAddress;
        this.m_ipaSubnetMask = ipAddress2;
        this.m_ipaGateway = ipAddress3;
        this.m_nProductID = Products.getProductIDForSysObjectId((String)this.m_szSysObjectId);
    }

    public DiscoverInfo(AidpDiscoverInfo aidpDiscoverInfo) {
        this.m_szSysObjectId = "";
        this.m_szName = "";
        this.m_maAppliance = aidpDiscoverInfo.getMacAddress();
        this.m_ipaAppliance = aidpDiscoverInfo.getIpAddress();
        this.m_ipaSubnetMask = aidpDiscoverInfo.getSubnetMask();
        this.m_ipaGateway = aidpDiscoverInfo.getGateway();
        try {
            this.m_nProductID = Products.getProductIDForModelType((int)aidpDiscoverInfo.getModel());
        }
        catch (ExceptionNoValue exceptionNoValue) {
            this.m_nProductID = Integer.MAX_VALUE;
        }
    }

    public DiscoverInfo(AidpDiscoverInfo aidpDiscoverInfo, String string) {
        this.m_szSysObjectId = "";
        this.m_szName = string;
        this.m_maAppliance = aidpDiscoverInfo.getMacAddress();
        this.m_ipaAppliance = aidpDiscoverInfo.getIpAddress();
        this.m_ipaSubnetMask = aidpDiscoverInfo.getSubnetMask();
        this.m_ipaGateway = aidpDiscoverInfo.getGateway();
        try {
            this.m_nProductID = Products.getProductIDForModelType((int)aidpDiscoverInfo.getModel());
        }
        catch (ExceptionNoValue exceptionNoValue) {
            this.m_nProductID = Integer.MAX_VALUE;
        }
    }

    public String getSysObjectId() {
        return this.m_szSysObjectId;
    }

    public String getName() {
        return this.m_szName;
    }

    public MacAddress getMacAddress() {
        return this.m_maAppliance;
    }

    public IpAddress getIpAddress() {
        return this.m_ipaAppliance;
    }

    public IpAddress getSubnetMask() {
        return this.m_ipaSubnetMask;
    }

    public IpAddress getGateway() {
        return this.m_ipaGateway;
    }

    public int getProductID() {
        return this.m_nProductID;
    }
}

