/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.common;

import com.avocent.avworks.nmm.common.AccessRightsDialogController;
import com.avocent.avworks.nmm.common.Appliance;
import com.avocent.avworks.nmm.common.InterfaceController;
import com.avocent.avworks.nmm.common.InterfaceEditUsersDialog;
import com.avocent.avworks.nmm.common.User;
import com.avocent.avworks.nmm.common.UserAccessLevel;
import com.avocent.avworks.nmm.common.UsersPanelController;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import javax.swing.UIManager;

public abstract class EditUserDialogController
implements InterfaceController {
    public static final String CNAME = "EditUserDialogController";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.common.Res");
    protected User m_jpusUser;
    private User m_jpusTemporaryUser;
    protected int m_nMode;
    public static final int MODIFY = 2;
    public static final int ADD = 3;
    public static final String TRACE_CONTEXT = "Edit User Dialog";
    protected boolean m_bIsAccessListModified = false;
    protected UsersPanelController m_upcUsersPanelController;
    protected InterfaceEditUsersDialog m_jdauView;
    protected AccessRightsDialogController m_ardcAccessRightsController = null;
    protected boolean bStrongPasswordRequired = true;
    protected UserAccessLevel[] m_aualAccessLevels;

    public EditUserDialogController(UsersPanelController usersPanelController) throws ExceptionConstructorFailed {
        try {
            this.m_upcUsersPanelController = usersPanelController;
            this.m_aualAccessLevels = this.m_upcUsersPanelController.getAmpController().getAppliance().getAccessLevelArray();
        }
        catch (Exception exception) {
            String string = res.getString("EditUserDialogController_Failed_to_construct2");
            throw new ExceptionConstructorFailed(string, (Throwable)exception);
        }
    }

    public Component getView() {
        if (this.m_jdauView == null) {
            this.createView();
        }
        return this.m_jdauView.getDialog();
    }

    public void initializeView() {
        if (this.m_jdauView == null) {
            throw new RuntimeException("Initialize view method called before the view was created.");
        }
        this.m_jdauView.getAccessLevelComboBox().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                UserAccessLevel userAccessLevel = (UserAccessLevel)itemEvent.getItem();
                if (userAccessLevel.getValue() == 30) {
                    EditUserDialogController.this.m_jdauView.getAccessRightsButton().setEnabled(true);
                } else {
                    EditUserDialogController.this.m_jdauView.getAccessRightsButton().setEnabled(false);
                }
            }
        });
        for (int i = 0; i < this.m_aualAccessLevels.length; ++i) {
            this.m_jdauView.getAccessLevelComboBox().addItem(this.m_aualAccessLevels[i]);
        }
        this.m_bIsAccessListModified = false;
        this.m_jdauView.getNameTextField().setText(this.m_jpusUser.getName());
        this.m_jdauView.getPasswordField().setText(this.m_jpusUser.m_szPassword);
        this.m_jdauView.getVerifyPasswordField().setText(this.m_jpusUser.m_szPassword);
        this.m_jdauView.getAccessLevelComboBox().setSelectedItem(this.m_jpusUser.getAccessLevel());
        if (this.m_jpusUser.getAccessLevel().getValue() == 30) {
            this.m_jdauView.getAccessRightsButton().setEnabled(true);
        } else {
            this.m_jdauView.getAccessRightsButton().setEnabled(false);
        }
        this.m_jdauView.getDialog().getRootPane().setDefaultButton(this.m_jdauView.getOkButton());
    }

    public void showModifyUser(User user) {
        this.m_nMode = 2;
        this.m_jpusUser = user;
        this.m_jpusTemporaryUser = (User)user.clone();
        this.createView();
        this.m_jdauView.getDialog().setTitle(res.getString("EditUserDialogController_Modify_User"));
        this.m_jdauView.getNameTextField().setEditable(false);
        if (this.m_upcUsersPanelController.getMode() == 2) {
            this.m_jdauView.getPasswordField().setEnabled(false);
            this.m_jdauView.getPasswordField().setBackground(UIManager.getColor("control"));
            this.m_jdauView.getVerifyPasswordField().setEnabled(false);
            this.m_jdauView.getVerifyPasswordField().setBackground(UIManager.getColor("control"));
        } else {
            this.m_jdauView.getPasswordField().requestFocus();
        }
        this.m_jdauView.getDialog().setVisible(true);
    }

    public void showAddUser() throws ExceptionConstructorFailed {
        this.m_jpusUser = null;
        Appliance appliance = this.m_upcUsersPanelController.getAmpController().getAppliance();
        this.m_jpusTemporaryUser = this.m_jpusUser = appliance.newUser();
        this.m_nMode = 3;
        this.createView();
        this.m_jdauView.getDialog().setTitle(res.getString("EditUserDialogController_Add_User"));
        this.m_jdauView.getNameTextField().setEditable(true);
        this.m_jdauView.getDialog().getRootPane().setDefaultButton(this.m_jdauView.getOkButton());
        this.m_jdauView.getNameTextField().requestFocus();
        if (this.m_upcUsersPanelController.getMode() == 2) {
            this.m_jdauView.getPasswordField().setEnabled(false);
            this.m_jdauView.getVerifyPasswordField().setEnabled(false);
            this.m_jdauView.getPasswordField().setBackground(UIManager.getColor("control"));
            this.m_jdauView.getVerifyPasswordField().setBackground(UIManager.getColor("control"));
        }
        this.m_jdauView.getDialog().setVisible(true);
    }

    public void setVisible(boolean bl) {
        try {
            if (bl) {
                this.showAddUser();
            } else {
                this.m_jdauView.getDialog().setVisible(bl);
            }
        }
        catch (Exception exception) {
            this.m_upcUsersPanelController.logError("Exception while showing add user dialog.", exception);
            Message.show((Component)this.m_jdauView.getDialog(), (String)res.getString("EditUserDialogController_Exception_while"));
        }
    }

    public void accessRightsAction() {
        try {
            if (this.m_ardcAccessRightsController == null) {
                this.m_ardcAccessRightsController = this.createAccessRightsDialogController();
            }
            this.m_jpusTemporaryUser.m_szName = this.m_jdauView.getNameTextField().getText();
            this.m_ardcAccessRightsController.showUser(this.m_jpusTemporaryUser);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unable to show server access list dialog.", (Throwable)exception);
            String string = res.getString("EditUserDialogController_Unable_to_show_user");
            Message.show((Component)this.m_jdauView.getDialog(), (String)string);
        }
    }

    public void cancelAction() {
        this.m_jdauView.getDialog().setVisible(false);
        this.m_jdauView.getDialog().dispose();
    }

    public void okAction() {
        if (!this.validateFields()) {
            return;
        }
        this.applyValuesToUsersPanelController();
        this.m_jdauView.getDialog().setVisible(false);
        this.m_jdauView.getDialog().dispose();
    }

    public boolean haveValuesChanged() {
        if (this.m_bIsAccessListModified) {
            return true;
        }
        if (this.m_nMode == 3) {
            return true;
        }
        String string = this.m_jdauView.getNameTextField().getText().trim();
        String string2 = new String(this.m_jdauView.getPasswordField().getPassword());
        string2 = string2.trim();
        UserAccessLevel userAccessLevel = (UserAccessLevel)this.m_jdauView.getAccessLevelComboBox().getSelectedItem();
        int n = userAccessLevel.getValue();
        return !this.m_jpusUser.m_szName.equals(string) || !this.m_jpusUser.m_szPassword.equals(string2) || this.m_jpusUser.getAccessLevel().getValue() != userAccessLevel.getValue();
    }

    public void applyValuesToUsersPanelController() {
        boolean bl = this.haveValuesChanged();
        if (bl) {
            this.m_upcUsersPanelController.setIsModified(true);
        }
        if (bl) {
            UserAccessLevel userAccessLevel = (UserAccessLevel)this.m_jdauView.getAccessLevelComboBox().getSelectedItem();
            boolean bl2 = this.m_jpusUser.isApplianceAdministrator() && userAccessLevel.getValue() != 20;
            boolean bl3 = this.m_upcUsersPanelController.getAmpController().getAppliance().isFeatureSupported("OverrideAdminUser");
            if (bl2 && !bl3 && this.m_upcUsersPanelController.getApplianceAdministratorCount() == 1) {
                String string = res.getString("EditUserDialogController_Cannot_modify_last_app_admin");
                String string2 = this.m_upcUsersPanelController.getAmpController().getAppliance().getApplianceAdministratorLabel();
                Object[] objectArray = new Object[]{string2};
                string = MessageFormat.format(string, objectArray);
                Message.show((Component)this.m_jdauView.getDialog(), (String)string);
                return;
            }
            String string = this.m_jdauView.getNameTextField().getText().trim();
            String string3 = new String(this.m_jdauView.getPasswordField().getPassword());
            string3 = string3.trim();
            this.m_jpusUser.m_szName = string;
            if (this.m_upcUsersPanelController.getMode() != 2) {
                this.m_jpusUser.m_szPassword = string3;
            }
            this.m_jpusUser.setAccessLevel(userAccessLevel);
            if (this.m_nMode == 3) {
                this.m_upcUsersPanelController.addToAddUserList(this.m_jpusUser);
            } else if (this.m_nMode == 2) {
                this.m_upcUsersPanelController.addToModifyUserList(this.m_jpusUser, bl2);
            } else {
                throw new RuntimeException(res.getString("EditUserDialogController_Unexpected_exception"));
            }
        }
        if (this.m_bIsAccessListModified) {
            this.m_jpusUser.setAccessList(this.m_jpusTemporaryUser.m_vPortList);
            this.m_upcUsersPanelController.addToModifyAccessList(this.m_jpusUser);
        }
    }

    public boolean validateFields() {
        String string;
        String string2;
        if (this.bStrongPasswordRequired) {
            string2 = res.getString("EditUserDialogController_add_strong_password_required");
            string = res.getString("EditUserDialogController_mod_strong_password_required");
        } else {
            string2 = res.getString("EditUserDialogController_add_password_requirement");
            string = res.getString("EditUserDialogController_mod_password_requirement");
        }
        String string3 = res.getString("EditUserDialogController_overwrite_file");
        String string4 = this.m_jdauView.getNameTextField().getText();
        if (string4 == null || string4.length() == 0) {
            String string5 = res.getString("EditUserDialogController_bad_username_for_add");
            Message.show((Component)this.m_jdauView.getDialog(), (String)string5);
            this.m_jdauView.getNameTextField().requestFocus();
            return false;
        }
        if ((string4 = string4.trim()).length() < 1 || string4.length() > 16) {
            String string6 = this.m_nMode == 3 ? res.getString("EditUserDialogController_bad_username_for_add") : res.getString("EditUserDialogController_User_name_must_be");
            Message.show((Component)this.m_jdauView.getDialog(), (String)string6);
            this.m_jdauView.getNameTextField().requestFocus();
            return false;
        }
        if (this.m_upcUsersPanelController.getMode() != 2) {
            char[] cArray;
            char[] cArray2 = this.m_jdauView.getPasswordField().getPassword();
            if (cArray2 == null || cArray2.length == 0) {
                String string7 = this.m_nMode == 3 ? string2 : string;
                Message.showReasonMessage((Component)this.m_jdauView.getDialog(), (String)string3, (String)string7);
                this.m_jdauView.getPasswordField().requestFocus();
                return false;
            }
            String string8 = new String(cArray2).trim();
            if (string8.length() < 5 || string8.length() > 16) {
                String string9 = this.m_nMode == 3 ? string2 : string;
                Message.showReasonMessage((Component)this.m_jdauView.getDialog(), (String)string3, (String)string9);
                this.m_jdauView.getPasswordField().requestFocus();
                return false;
            }
            if (this.bStrongPasswordRequired) {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                for (int i = 0; i < string8.length(); ++i) {
                    char c = string8.charAt(i);
                    if (!bl2 && Character.isUpperCase(c)) {
                        bl2 = true;
                        continue;
                    }
                    if (!bl3 && Character.isLowerCase(c)) {
                        bl3 = true;
                        continue;
                    }
                    if (!bl && Character.isDigit(c)) {
                        bl = true;
                        continue;
                    }
                    if (bl4 || Character.isLetterOrDigit(c) || Character.isSpaceChar(c)) continue;
                    bl4 = true;
                }
                if (!bl || !bl2 || !bl3 || bl4) {
                    String string10 = this.m_nMode == 3 ? string2 : string;
                    Message.showReasonMessage((Component)this.m_jdauView.getDialog(), (String)string3, (String)string10);
                    this.m_jdauView.getPasswordField().requestFocus();
                    return false;
                }
            }
            if ((cArray = this.m_jdauView.getVerifyPasswordField().getPassword()) == null || cArray.length == 0) {
                String string11 = this.m_nMode == 3 ? res.getString("EditUserDialogController_add_password_match") : res.getString("EditUserDialogController_Passwords_do_not");
                Message.show((Component)this.m_jdauView.getDialog(), (String)string11);
                this.m_jdauView.getVerifyPasswordField().requestFocus();
                return false;
            }
            String string12 = new String(cArray).trim();
            if (!string8.equals(string12)) {
                String string13 = this.m_nMode == 3 ? res.getString("EditUserDialogController_add_password_match") : res.getString("EditUserDialogController_Passwords_do_not");
                Message.show((Component)this.m_jdauView.getDialog(), (String)string13);
                this.m_jdauView.getVerifyPasswordField().requestFocus();
                return false;
            }
            if (this.m_nMode == 3 && this.m_upcUsersPanelController.userExists(string4)) {
                String string14 = res.getString("EditUserDialogController_duplicate_user_name");
                Message.show((Component)this.m_jdauView.getDialog(), (String)string14);
                this.m_jdauView.getNameTextField().requestFocus();
                return false;
            }
        }
        return true;
    }

    public void setIsAccessListModified(boolean bl) {
        this.m_bIsAccessListModified = bl;
    }

    public boolean isAccessListModified() {
        return this.m_bIsAccessListModified;
    }

    public UsersPanelController getUsersPanelController() {
        return this.m_upcUsersPanelController;
    }

    public abstract AccessRightsDialogController createAccessRightsDialogController() throws ExceptionConstructorFailed;

    public void setIsStrongPasswordRequired(boolean bl) {
        this.bStrongPasswordRequired = bl;
    }

    public abstract String getAccessRightsDialogHelpUrl();
}

