/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.common;

import com.avocent.avworks.nmm.common.AmpController;
import com.avocent.avworks.nmm.common.BadFieldValueException;
import com.avocent.avworks.nmm.common.ExceptionAsmpRequestFailed;
import com.avocent.avworks.nmm.common.ExceptionSnmpRequestFailed;
import com.avocent.avworks.nmm.common.InterfaceController;
import com.avocent.avworks.nmm.common.InterfaceSnmpClient;
import com.avocent.avworks.nmm.common.JPanelAccessDeniedMessage;
import com.avocent.avworks.nmm.common.JPanelGenericErrorMessage;
import com.avocent.avworks.nmm.common.PanelController;
import com.avocent.avworks.services.InterfaceAmpPanel;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.net.IpAddress;
import com.avocent.lib.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.net.URL;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public abstract class InterfaceAmpPanelController
extends PanelController
implements InterfaceSnmpClient,
InterfaceAmpPanel,
InterfaceController {
    public static final String CNAME = "InterfaceAmpPanelController";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.common.Res");
    public static final int UNINITIALIZED = 101;
    public static final int LOADING = 102;
    public static final int READY = 103;
    public static final int DESTROYED = 104;
    public static final String TRACE_CONTEXT = "AMP Panel";
    public static int ASCII_NUL = 0;
    public static int ASCII_BEL = 7;
    public static int ASCII_BS = 8;
    public static int ASCII_HT = 9;
    public static int ASCII_LF = 10;
    public static int ASCII_VT = 11;
    public static int ASCII_FF = 12;
    public static int ASCII_CR = 13;
    public static int ASCII_SPACE = 32;
    public static int ASCII_TILDE = 126;
    protected static int m_nNextPanelId = 1;
    protected boolean m_bIsModified;
    protected int m_nState = 101;
    protected AmpController m_acAmpController;
    protected String m_szHelpKey = "NO_HELP_AVAILABLE";
    protected String m_szPanelKey = "amp_panel_" + m_nNextPanelId++;
    protected String m_szTitle = "No title defined";
    protected String m_szLabel = "No label defined";
    protected String m_szDescription = "No description defined";
    protected String m_szLoggingContextLabel;
    protected JPanel m_jpErrorPanel;
    protected int m_nErrorStatus;
    protected String m_szErrorLabel;
    protected JPanel m_jpContentPanel = new JPanel();
    protected Component m_view;

    public InterfaceAmpPanelController() {
        super(null, null);
    }

    public InterfaceAmpPanelController(AmpController ampController, String string, String string2, String string3, String string4) {
        super(null, null);
        this.m_acAmpController = ampController;
        this.m_szLabel = string;
        this.m_szTitle = string2;
        this.m_szDescription = string3;
        this.m_szHelpKey = string4;
        this.m_szLoggingContextLabel = "AMP Panel:" + this.getPanelTitle();
        this.m_jpContentPanel.setLayout(new BorderLayout());
        this.m_ampPanelController = this;
    }

    protected boolean initialize() {
        try {
            this.setPanelState(101);
            return this.initializeImpl();
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            this.setErrorStatus(exceptionAsmpRequestFailed.getErrorCode());
            this.logError(exceptionAsmpRequestFailed.getMessage(), (Exception)((Object)exceptionAsmpRequestFailed));
            return false;
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            String string = exceptionInvalidArgument.getMessage();
            if (string.length() != 0) {
                Message.show((Component)this.getAmpController().getMainFrame(), (String)exceptionInvalidArgument.getMessage());
            }
            return false;
        }
        catch (Exception exception) {
            this.getAmpController().showException(null, this.getTraceContext(), "", exception);
            return false;
        }
    }

    protected abstract boolean initializeImpl() throws ExceptionAsmpRequestFailed, Exception;

    public boolean isModified() {
        return this.m_bIsModified;
    }

    public JFrame getParentFrame() {
        return this.m_acAmpController.getMainFrame();
    }

    public String getPanelKey() {
        return this.m_szPanelKey;
    }

    public String getPanelLabel() {
        return this.m_szLabel;
    }

    public String getPanelTitle() {
        return this.m_szTitle;
    }

    public String getPanelDescription() {
        return this.m_szDescription;
    }

    public JPanel getContentPane() {
        return this.m_jpContentPanel;
    }

    public boolean onInit() {
        return true;
    }

    public boolean onSetActive() {
        try {
            if (this.m_jpErrorPanel != null) {
                this.m_jpContentPanel.removeAll();
                this.m_jpContentPanel.add(this.getView());
                this.m_jpErrorPanel = null;
            }
            if (this.m_nState == 101) {
                this.m_nState = 102;
                ThreadedInitialize threadedInitialize = new ThreadedInitialize("AVR AMP Initialize - " + this.getPanelLabel());
                threadedInitialize.start();
            }
            return true;
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Error in onSetActive method", (Throwable)exception);
            return false;
        }
    }

    public void onCancel() {
        this.logInfo("onCancel() was called.");
    }

    public String getHelpID() {
        return this.m_szHelpKey;
    }

    public void onDestroy() {
        this.logInfo("onDestroy() was called.");
        this.m_nState = 104;
    }

    public boolean onKillActive() {
        if (this.m_nState == 103) {
            try {
                return !this.validateInputFields();
            }
            catch (ExceptionInvalidArgument exceptionInvalidArgument) {
                Message.show((Component)this.getView(), (String)exceptionInvalidArgument.getMessage());
                return true;
            }
            catch (Exception exception) {
                this.getAmpController().showException(null, this.getTraceContext(), "", exception);
                return true;
            }
        }
        return false;
    }

    public boolean onOK() {
        boolean bl = this.applyValues();
        if (bl) {
            this.m_bIsModified = false;
        }
        return bl;
    }

    public boolean onApply() {
        boolean bl = this.applyValues();
        if (bl) {
            this.m_bIsModified = false;
        }
        return bl;
    }

    protected abstract boolean applyValuesImpl() throws Exception;

    protected abstract boolean validateInputFields() throws ExceptionInvalidArgument;

    protected boolean applyValues() {
        try {
            return this.applyValuesImpl();
        }
        catch (BadFieldValueException badFieldValueException) {
            JTextField jTextField;
            int n;
            Object object;
            if (badFieldValueException.getCause() instanceof ExceptionSnmpRequestFailed) {
                object = (ExceptionSnmpRequestFailed)((Object)badFieldValueException.getCause());
                this.setErrorStatus(object.getErrorCode());
                this.logError(object.getMessage(), (Exception)object);
            }
            this.setErrorFieldLabel(null);
            object = this.setErrorFieldFocus(badFieldValueException.getBadFieldId());
            if (this.getErrorFieldLabel() != null) {
                String[] stringArray = new String[]{this.getErrorFieldLabel()};
                object = this.getResource("InterfaceAmpPanelController_Apply_Failed", stringArray);
            } else {
                object = this.getResource("InterfaceAmpPanelController_SNMP_Apply_Failed");
            }
            if (badFieldValueException.getComponent() instanceof JTextField && badFieldValueException.getLocationIndex() > 0 && (n = badFieldValueException.getLocationIndex()) < (jTextField = (JTextField)badFieldValueException.getComponent()).getText().length()) {
                jTextField.setCaretPosition(n);
            }
            Message.show((Component)this.getAmpController().getMainFrame(), (String)((String)object + " " + badFieldValueException.getCause().getMessage()));
            return false;
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            this.setErrorStatus(exceptionAsmpRequestFailed.getErrorCode());
            this.logError(exceptionAsmpRequestFailed.getMessage(), (Exception)((Object)exceptionAsmpRequestFailed));
            String string = this.getResource("InterfaceAmpPanelController_SNMP_Apply_Failed");
            Message.show((Component)this.getAmpController().getMainFrame(), (String)(string + " " + exceptionAsmpRequestFailed.getMessage()));
            return false;
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            String string = exceptionInvalidArgument.getMessage();
            if (string.length() != 0) {
                Message.show((Component)this.getAmpController().getMainFrame(), (String)exceptionInvalidArgument.getMessage());
            }
            return false;
        }
        catch (Exception exception) {
            this.getAmpController().showException(null, this.getTraceContext(), "", exception);
            return false;
        }
    }

    public String toString() {
        return this.getPanelLabel();
    }

    public static void validateIpAddress(JTextField jTextField, JLabel jLabel, boolean bl) throws ExceptionInvalidArgument {
        String string;
        String string2 = jTextField.getText().trim();
        if (string2.length() == 0) {
            Object[] objectArray = new Object[]{InterfaceAmpPanelController.removeColon(jLabel.getText())};
            String string3 = InterfaceAmpPanelController.getResourceString(res, "InterfaceAmpPanelController_The_0_field_is_not", objectArray);
            jTextField.requestFocus();
            throw new ExceptionInvalidArgument(string3);
        }
        if (!IpAddress.isValid((String)string2)) {
            Object[] objectArray = new Object[]{InterfaceAmpPanelController.removeColon(jLabel.getText())};
            String string4 = InterfaceAmpPanelController.getResourceString(res, "InterfaceAmpPanelController_The_0_field_is_not", objectArray);
            jTextField.requestFocus();
            throw new ExceptionInvalidArgument(string4);
        }
        if (string2.startsWith("127.")) {
            Object[] objectArray = new Object[]{InterfaceAmpPanelController.removeColon(jLabel.getText())};
            String string5 = InterfaceAmpPanelController.getResourceString(res, "InterfaceAmpPanelController_The_0_field_is_not1", objectArray);
            jTextField.requestFocus();
            throw new ExceptionInvalidArgument(string5);
        }
        if (!bl && (string = new IpAddress(string2).getString()).equals("0.0.0.0")) {
            Object[] objectArray = new Object[]{InterfaceAmpPanelController.removeColon(jLabel.getText())};
            String string6 = InterfaceAmpPanelController.getResourceString(res, "InterfaceAmpPanelController_The_0_field_is_not2", objectArray);
            jTextField.requestFocus();
            throw new ExceptionInvalidArgument(string6);
        }
    }

    public static void validateIpAddress(JTextField jTextField, JLabel jLabel) throws ExceptionInvalidArgument {
        InterfaceAmpPanelController.validateIpAddress(jTextField, jLabel, false);
    }

    public static void validateString(JTextField jTextField, JLabel jLabel, int n, int n2, boolean bl) throws ExceptionInvalidArgument {
        String string = jTextField.getText();
        int n3 = string.length();
        if (n3 < n || n3 > n2) {
            Object[] objectArray = new Object[]{InterfaceAmpPanelController.removeColon(jLabel.getText()), String.valueOf(n), String.valueOf(n2)};
            String string2 = InterfaceAmpPanelController.getResourceString(res, "InterfaceAmpPanelController_minmax_string_len0", objectArray);
            jTextField.requestFocus();
            throw new ExceptionInvalidArgument(string2);
        }
        if (bl) {
            byte[] byArray = string.getBytes();
            for (int i = 0; i < byArray.length; ++i) {
                if ((byArray[i] >= ASCII_SPACE || byArray[i] == ASCII_NUL || byArray[i] == ASCII_BEL || byArray[i] == ASCII_BS || byArray[i] == ASCII_HT || byArray[i] == ASCII_LF || byArray[i] == ASCII_VT || byArray[i] == ASCII_FF || byArray[i] == ASCII_CR) && byArray[i] <= ASCII_TILDE) continue;
                Object[] objectArray = new Object[]{InterfaceAmpPanelController.removeColon(jLabel.getText())};
                String string3 = InterfaceAmpPanelController.getResourceString(res, "InterfaceAmpPanelController_printable_ascii", objectArray);
                jTextField.requestFocus();
                throw new ExceptionInvalidArgument(string3);
            }
        }
    }

    public static void validateString(JTextField jTextField, JLabel jLabel, int n, int n2) throws ExceptionInvalidArgument {
        InterfaceAmpPanelController.validateString(jTextField, jLabel, n, n2, false);
    }

    public static String removeColon(String string) {
        String string2 = string;
        if (string != null && string.length() > 0 && string.charAt(string.length() - 1) == ':') {
            string2 = string.substring(0, string.length() - 1);
        }
        return string2;
    }

    public void setIsModified(boolean bl) {
        this.m_bIsModified = bl;
        if (bl) {
            this.m_acAmpController.setModified(this.m_bIsModified);
        }
    }

    public void logInfo(String string) {
        Trace.logInfo((String)this.m_szLoggingContextLabel, (String)string);
    }

    public void logError(String string) {
        Trace.logError((String)this.m_szLoggingContextLabel, (String)string);
    }

    public void logError(String string, Exception exception) {
        Trace.logError((String)this.m_szLoggingContextLabel, (String)string, (Throwable)exception);
    }

    public void setBusy(boolean bl) {
        final boolean bl2 = bl;
        Runnable runnable = new Runnable(){

            public void run() {
                if (bl2) {
                    InterfaceAmpPanelController.this.m_jpContentPanel.setCursor(Cursor.getPredefinedCursor(3));
                } else {
                    InterfaceAmpPanelController.this.m_jpContentPanel.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void showErrorPane() {
        if (this.m_nErrorStatus == 6) {
            this.m_jpErrorPanel = new JPanelAccessDeniedMessage();
            this.m_acAmpController.getMainFrame().getHelpButton().setEnabled(false);
        } else {
            this.m_jpErrorPanel = new JPanelGenericErrorMessage();
        }
        this.m_jpContentPanel.removeAll();
        this.m_jpContentPanel.add((Component)this.m_jpErrorPanel, "Center");
        this.m_jpContentPanel.invalidate();
        this.m_acAmpController.getMainFrame().validate();
        this.m_nErrorStatus = 0;
    }

    public abstract void setErrorFieldFocus(int var1);

    protected abstract String setErrorFieldFocus(Object var1);

    public String getTraceContext() {
        return TRACE_CONTEXT;
    }

    public void setPanelState(int n) {
        this.m_nState = n;
    }

    public int getPanelState() {
        return this.m_nState;
    }

    public void setReloadData() {
        if (this.m_jpContentPanel.isShowing()) {
            this.m_nState = 102;
            ThreadedInitialize threadedInitialize = new ThreadedInitialize("AMP Reload - " + this.getPanelLabel());
            threadedInitialize.start();
        } else {
            this.m_nState = 101;
        }
    }

    public static String getResourceString(ResourceManager resourceManager, String string, Object[] objectArray) {
        String string2 = "";
        if (resourceManager != null) {
            try {
                string2 = resourceManager.getString(string);
                if (objectArray != null) {
                    string2 = MessageFormat.format(string2, objectArray);
                }
            }
            catch (MissingResourceException missingResourceException) {
                Trace.logError((String)"AMP Panel:getResourceString", (String)("Resource string for key: " + string + " not found in given ResourceBundle: " + resourceManager + "."));
            }
        } else {
            Trace.logError((String)"AMP Panel:getResourceString", (String)"The given ResourceBundle is null.");
        }
        return string2;
    }

    public boolean doesModifyAppliance() {
        return true;
    }

    public AmpController getAmpController() {
        return this.m_acAmpController;
    }

    public ImageIcon loadImageIcon(String string, Class clazz) {
        URL uRL = clazz.getResource(string);
        return uRL != null ? new ImageIcon(uRL) : null;
    }

    public void setVisible(boolean bl) {
        try {
            this.getView().setVisible(bl);
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception in call to AMP panels setVisible method", exception);
        }
    }

    public void setErrorStatus(int n) {
        this.m_nErrorStatus = n;
    }

    public void setErrorFieldLabel(String string) {
        this.m_szErrorLabel = string;
    }

    public String getErrorFieldLabel() {
        return this.m_szErrorLabel;
    }

    public void reload() {
        if (this.m_nState != 101) {
            this.setPanelState(101);
            if (this.getView().isShowing()) {
                this.initialize();
            }
        }
    }

    public String getResource(String string) {
        return this.m_acAmpController.getResource(string);
    }

    public String getResource(String string, String[] stringArray) {
        return this.m_acAmpController.getResource(string);
    }

    public void initializeView() {
    }

    public Component getView() {
        if (this.m_view == null) {
            this.createView();
        }
        return this.m_view;
    }

    class ThreadedInitialize
    extends Thread {
        ThreadedInitialize(String string) {
            super(string);
        }

        public void run() {
            try {
                InterfaceAmpPanelController.this.m_acAmpController.setBusy(true);
                if (InterfaceAmpPanelController.this.initialize()) {
                    InterfaceAmpPanelController.this.m_nState = 103;
                } else {
                    InterfaceAmpPanelController.this.m_nState = 101;
                    InterfaceAmpPanelController.this.showErrorPane();
                }
                InterfaceAmpPanelController.this.m_acAmpController.setBusy(false);
            }
            catch (Throwable throwable) {
                InterfaceAmpPanelController.this.m_nState = 101;
                InterfaceAmpPanelController.this.m_acAmpController.setBusy(false);
                Trace.logError((String)InterfaceAmpPanelController.this.getTraceContext(), (String)("Unexpected exception:" + throwable.getMessage()), (Throwable)throwable);
            }
        }
    }
}

