/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.common;

import com.avocent.avworks.nmm.common.AmpController;
import com.avocent.avworks.nmm.common.InterfaceSnmpClient;
import com.avocent.avworks.nmm.common.JFrameAmp;
import com.avocent.avworks.nmm.common.JPanelAccessDeniedMessage;
import com.avocent.avworks.nmm.common.JPanelGenericErrorMessage;
import com.avocent.avworks.nmm.common.SafeTextFieldUpdate;
import com.avocent.avworks.services.InterfaceAmpPanel;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.gui.panels.EventTrappingPanel;
import com.avocent.lib.net.IpAddress;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class JPanelAmpPanel
extends EventTrappingPanel
implements InterfaceSnmpClient,
InterfaceAmpPanel {
    public static final String CNAME = "JPanelAmpPanel";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.common.Res");
    public static final int UNINITIALIZED = 101;
    public static final int LOADING = 102;
    public static final int READY = 103;
    public static final int DESTROYED = 104;
    public static final String TRACE_CONTEXT = "AVR AMP panel";
    public static int ASCII_NUL = 0;
    public static int ASCII_BEL = 7;
    public static int ASCII_BS = 8;
    public static int ASCII_HT = 9;
    public static int ASCII_LF = 10;
    public static int ASCII_VT = 11;
    public static int ASCII_FF = 12;
    public static int ASCII_CR = 13;
    public static int ASCII_SPACE = 32;
    public static int ASCII_TILDE = 126;
    protected static int m_nNextPanelId = 1;
    protected boolean m_bIsModified;
    protected int m_nState = 101;
    protected AmpController m_acController;
    protected String m_szHelpKey = "NO_HELP_AVAILABLE";
    protected String m_szPanelKey = "ds_amp_panel_" + m_nNextPanelId++;
    protected String m_szTitle = "No title defined";
    protected String m_szLabel = "No label defined";
    protected String m_szDescription = "No description defined";
    protected String m_szLoggingContextLabel;
    protected Container m_jpDefaultContentPane = this.getContentPane();
    protected JPanel m_jpErrorPanel;
    protected int m_nErrorStatus;
    protected String m_szErrorLabel;

    public JPanelAmpPanel() {
        this.m_jpDefaultContentPane.setVisible(true);
        this.m_szLoggingContextLabel = TRACE_CONTEXT;
    }

    public JPanelAmpPanel(AmpController ampController, String string, String string2, String string3, String string4) {
        this.m_jpDefaultContentPane.setVisible(true);
        this.m_acController = ampController;
        this.m_szLabel = string;
        this.m_szTitle = string2;
        this.m_szDescription = string3;
        this.m_szHelpKey = string4;
        this.m_szLoggingContextLabel = "AVR AMP panel:" + this.getPanelTitle();
    }

    protected boolean initialize() {
        return true;
    }

    public boolean isModified() {
        return this.m_bIsModified;
    }

    public JFrame getParentFrame() {
        return this.m_acController.getMainFrame();
    }

    public String getPanelKey() {
        return this.m_szPanelKey;
    }

    public String getPanelLabel() {
        return this.m_szLabel;
    }

    public String getPanelTitle() {
        return this.m_szTitle;
    }

    public String getPanelDescription() {
        return this.m_szDescription;
    }

    public boolean onInit() {
        return true;
    }

    public boolean onSetActive() {
        this.logInfo("onSetActive() was called.");
        if (this.m_jpErrorPanel != null) {
            this.setContentPane(this.m_jpDefaultContentPane);
        }
        this.setHelpButtonEnabled();
        if (this.m_nState == 101) {
            this.m_nState = 102;
            ThreadedInitialize threadedInitialize = new ThreadedInitialize("AVR AMP Initialize - " + this.getPanelLabel());
            threadedInitialize.start();
        }
        return true;
    }

    public void onCancel() {
        this.logInfo("onCancel() was called.");
    }

    public String getHelpID() {
        return this.m_szHelpKey;
    }

    public void onDestroy() {
        this.logInfo("onDestroy() was called.");
        this.m_nState = 104;
    }

    public boolean onKillActive() {
        this.logInfo("onKillActive() was called.");
        return false;
    }

    public boolean onOK() {
        boolean bl = this.applyValues();
        if (bl) {
            this.m_bIsModified = false;
        }
        return bl;
    }

    public boolean onApply() {
        boolean bl = this.applyValues();
        if (bl) {
            this.m_bIsModified = false;
        }
        return bl;
    }

    protected boolean applyValues() {
        Message.show((Component)((Object)this), (String)"Storing of values has not been implemented for this panel.");
        return false;
    }

    public String toString() {
        return this.getPanelLabel();
    }

    public static void validateIpAddress(JTextField jTextField, JLabel jLabel, boolean bl) throws ExceptionInvalidArgument {
        String string;
        String string2 = jTextField.getText().trim();
        if (string2.length() != jTextField.getText().length()) {
            SafeTextFieldUpdate.setTextField(jTextField, string2);
        }
        if (string2.length() == 0) {
            Object[] objectArray = new Object[]{JPanelAmpPanel.removeColon(jLabel.getText())};
            String string3 = JPanelAmpPanel.getResourceString(res, "JPanelAmpPanel_The_0_field_is_not", objectArray);
            jTextField.requestFocus();
            throw new ExceptionInvalidArgument(string3);
        }
        if (!IpAddress.isValid((String)string2)) {
            Object[] objectArray = new Object[]{JPanelAmpPanel.removeColon(jLabel.getText())};
            String string4 = JPanelAmpPanel.getResourceString(res, "JPanelAmpPanel_The_0_field_is_not", objectArray);
            jTextField.requestFocus();
            throw new ExceptionInvalidArgument(string4);
        }
        if (string2.startsWith("127.")) {
            Object[] objectArray = new Object[]{JPanelAmpPanel.removeColon(jLabel.getText())};
            String string5 = JPanelAmpPanel.getResourceString(res, "JPanelAmpPanel_The_0_field_is_not1", objectArray);
            jTextField.requestFocus();
            throw new ExceptionInvalidArgument(string5);
        }
        if (!bl && (string = new IpAddress(string2).getString()).equals("0.0.0.0")) {
            Object[] objectArray = new Object[]{JPanelAmpPanel.removeColon(jLabel.getText())};
            String string6 = JPanelAmpPanel.getResourceString(res, "JPanelAmpPanel_The_0_field_is_not2", objectArray);
            jTextField.requestFocus();
            throw new ExceptionInvalidArgument(string6);
        }
    }

    public static void validateIpAddress(JTextField jTextField, JLabel jLabel) throws ExceptionInvalidArgument {
        JPanelAmpPanel.validateIpAddress(jTextField, jLabel, false);
    }

    public static void validateString(JTextField jTextField, JLabel jLabel, int n, int n2, boolean bl) throws ExceptionInvalidArgument {
        try {
            JPanelAmpPanel.validateString(jTextField.getText(), jLabel.getText(), n, n2, bl);
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            jTextField.requestFocus();
            throw exceptionInvalidArgument;
        }
    }

    public static void validateString(String string, String string2, int n, int n2, boolean bl) throws ExceptionInvalidArgument {
        int n3 = string.length();
        if (n3 < n || n3 > n2) {
            Object[] objectArray = new Object[]{JPanelAmpPanel.removeColon(string2), String.valueOf(n), String.valueOf(n2)};
            String string3 = JPanelAmpPanel.getResourceString(res, "JPanelAmpPanel_minmax_string_len0", objectArray);
            throw new ExceptionInvalidArgument(string3);
        }
        if (bl) {
            byte[] byArray = string.getBytes();
            for (int i = 0; i < byArray.length; ++i) {
                if ((byArray[i] >= ASCII_SPACE || byArray[i] == ASCII_NUL || byArray[i] == ASCII_BEL || byArray[i] == ASCII_BS || byArray[i] == ASCII_HT || byArray[i] == ASCII_LF || byArray[i] == ASCII_VT || byArray[i] == ASCII_FF || byArray[i] == ASCII_CR) && byArray[i] <= ASCII_TILDE) continue;
                Object[] objectArray = new Object[]{JPanelAmpPanel.removeColon(string2)};
                String string4 = JPanelAmpPanel.getResourceString(res, "JPanelAmpPanel_printable_ascii", objectArray);
                throw new ExceptionInvalidArgument(string4);
            }
        }
    }

    public static void validateString(JTextField jTextField, JLabel jLabel, int n, int n2) throws ExceptionInvalidArgument {
        JPanelAmpPanel.validateString(jTextField, jLabel, n, n2, false);
    }

    public static void validateInt(JTextField jTextField, JLabel jLabel, int n, int n2) throws ExceptionInvalidArgument {
        int n3;
        String string = jTextField.getText().trim();
        try {
            n3 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            jTextField.requestFocus();
            Object[] objectArray = new Object[]{JPanelAmpPanel.removeColon(jLabel.getText()), String.valueOf(n), String.valueOf(n2)};
            String string2 = JPanelAmpPanel.getResourceString(res, "JPanelAmpPanel_Invald_number_entered", objectArray);
            throw new ExceptionInvalidArgument(string2);
        }
        if (n3 < n || n3 > n2) {
            jTextField.requestFocus();
            Object[] objectArray = new Object[]{JPanelAmpPanel.removeColon(jLabel.getText()), String.valueOf(n), String.valueOf(n2)};
            String string3 = JPanelAmpPanel.getResourceString(res, "JPanelAmpPanel_Invald_number_entered", objectArray);
            throw new ExceptionInvalidArgument(string3);
        }
    }

    public static String removeColon(String string) {
        String string2 = string;
        if (string != null && string.length() > 0) {
            if (string.charAt(string.length() - 1) == ':') {
                string2 = string.substring(0, string.length() - 1);
            }
            string2 = string2.trim();
        }
        return string2;
    }

    public void setIsModified(boolean bl) {
        if (this.m_nState == 103) {
            this.m_bIsModified = bl;
            this.m_acController.setModified(this.m_bIsModified);
        }
    }

    public void logInfo(String string) {
        Trace.logInfo((String)this.m_szLoggingContextLabel, (String)string);
    }

    public void logError(String string) {
        Trace.logError((String)this.m_szLoggingContextLabel, (String)string);
    }

    public void logError(String string, Exception exception) {
        Trace.logError((String)this.m_szLoggingContextLabel, (String)string, (Throwable)exception);
    }

    public void setBusy(boolean bl) {
        final boolean bl2 = bl;
        Runnable runnable = new Runnable(){

            public void run() {
                if (bl2) {
                    JPanelAmpPanel.this.enableEventTrapping();
                    JPanelAmpPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                } else {
                    JPanelAmpPanel.this.disableEventTrapping();
                    JPanelAmpPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void showErrorPane() {
        this.m_jpErrorPanel = this.m_nErrorStatus == 6 ? new JPanelAccessDeniedMessage() : new JPanelGenericErrorMessage();
        if (this.getContentPane() != this.m_jpErrorPanel) {
            this.setContentPane(this.m_jpErrorPanel);
        }
        this.invalidate();
        this.m_acController.getMainFrame().validate();
        this.m_nErrorStatus = 0;
    }

    public void setContentPane(Container container) {
        super.setContentPane(container);
        this.setHelpButtonEnabled();
    }

    public void setHelpButtonEnabled() {
        JFrameAmp jFrameAmp = this.m_acController.getMainFrame();
        JButton jButton = jFrameAmp.getHelpButton();
        jButton.setEnabled(this.contentPane != this.m_jpErrorPanel);
    }

    public void setErrorFieldFocus(int n) {
    }

    public String getTraceContext() {
        return TRACE_CONTEXT;
    }

    public void setPanelState(int n) {
        this.m_nState = n;
    }

    public void setReloadData() {
        if (this.isShowing()) {
            this.m_nState = 102;
            ThreadedInitialize threadedInitialize = new ThreadedInitialize("AVR AMP Reload - " + this.getPanelLabel());
            threadedInitialize.start();
        } else {
            this.m_nState = 101;
        }
    }

    public static String getResourceString(ResourceManager resourceManager, String string, Object[] objectArray) {
        String string2 = resourceManager.getString(string);
        if (objectArray != null) {
            string2 = MessageFormat.format(string2, objectArray);
        }
        return string2;
    }

    public boolean doesModifyAppliance() {
        return true;
    }

    public AmpController getController() {
        return this.m_acController;
    }

    class ThreadedInitialize
    extends Thread {
        ThreadedInitialize(String string) {
            super(string);
        }

        public void run() {
            try {
                JPanelAmpPanel.this.m_acController.setBusy(true);
                if (JPanelAmpPanel.this.initialize()) {
                    JPanelAmpPanel.this.m_nState = 103;
                } else {
                    JPanelAmpPanel.this.m_nState = 101;
                    JPanelAmpPanel.this.showErrorPane();
                }
                JPanelAmpPanel.this.m_acController.setBusy(false);
            }
            catch (Throwable throwable) {
                JPanelAmpPanel.this.m_nState = 101;
                JPanelAmpPanel.this.m_acController.setBusy(false);
                Trace.logError((String)JPanelAmpPanel.this.getTraceContext(), (String)("Unexpected exception:" + throwable.getMessage()), (Throwable)throwable);
            }
        }
    }
}

