/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.common;

import com.avocent.avworks.nmm.common.MibEnumObject;
import com.avocent.lib.gui.renderers.NameValue;
import com.avocent.lib.util.ResourceManager;
import com.avocent.lib.util.StringArray;
import com.avocent.protocols.snmp.ExceptionBadEnumValue;
import com.avocent.protocols.snmp.ExceptionUnknownMibName;
import java.util.StringTokenizer;
import java.util.Vector;

public class MibEnum {
    public static final String CNAME = "MibEnum";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.common.Res");
    public static final String UNEXPECTED_VALUE = res.getString("MibEnum_ENUM_Unexpected_Value");
    protected static Vector m_lMibEnumLists = new Vector();

    public static void registerEnumerationList(String string, MibEnumObject[] mibEnumObjectArray) {
        m_lMibEnumLists.addElement(new NameValue(string, (Object)mibEnumObjectArray));
    }

    public static String getEnumForValue(String string, int n) throws ExceptionUnknownMibName, ExceptionBadEnumValue {
        MibEnumObject[] mibEnumObjectArray = MibEnum.getMibEnumTable(string);
        if (mibEnumObjectArray == null) {
            throw new ExceptionUnknownMibName(string);
        }
        int n2 = MibEnum.getOidNameIndex(mibEnumObjectArray, string);
        if (n2 == -1) {
            throw new ExceptionUnknownMibName(string);
        }
        String string2 = mibEnumObjectArray[n2].getOidName();
        for (int i = n2; i < mibEnumObjectArray.length; ++i) {
            if (mibEnumObjectArray[i].getOidName() != null && !mibEnumObjectArray[i].getOidName().equals(string2)) {
                return UNEXPECTED_VALUE;
            }
            if (n != mibEnumObjectArray[i].getIntValue()) continue;
            return mibEnumObjectArray[i].getStrValue();
        }
        return UNEXPECTED_VALUE;
    }

    public static int getValueForEnum(String string, String string2) throws ExceptionUnknownMibName, ExceptionBadEnumValue {
        MibEnumObject[] mibEnumObjectArray = MibEnum.getMibEnumTable(string);
        if (mibEnumObjectArray == null) {
            throw new ExceptionUnknownMibName(string);
        }
        int n = MibEnum.getOidNameIndex(mibEnumObjectArray, string);
        if (n == -1) {
            throw new ExceptionUnknownMibName(string);
        }
        int n2 = -1;
        String string3 = mibEnumObjectArray[n].getOidName();
        for (int i = n; i < mibEnumObjectArray.length && (mibEnumObjectArray[i].getOidName() == null || mibEnumObjectArray[i].getOidName().equals(string3)); ++i) {
            if (!string2.equals(mibEnumObjectArray[i].getStrValue())) continue;
            n2 = mibEnumObjectArray[i].getIntValue();
            break;
        }
        if (n2 == -1) {
            throw new ExceptionBadEnumValue(string2);
        }
        return n2;
    }

    public static StringArray getEnumsForOID(String string) throws ExceptionUnknownMibName {
        MibEnumObject[] mibEnumObjectArray = MibEnum.getMibEnumTable(string);
        if (mibEnumObjectArray == null) {
            throw new ExceptionUnknownMibName(string);
        }
        int n = MibEnum.getOidNameIndex(mibEnumObjectArray, string);
        if (n == -1) {
            throw new ExceptionUnknownMibName(string);
        }
        StringArray stringArray = new StringArray();
        String string2 = mibEnumObjectArray[n].getOidName();
        for (int i = n; i < mibEnumObjectArray.length && (mibEnumObjectArray[i].getOidName() == null || mibEnumObjectArray[i].getOidName().equals(string2)); ++i) {
            stringArray.addElement(mibEnumObjectArray[i].getStrValue());
        }
        return stringArray;
    }

    public static MibEnumObject[] getEnumObjectsForOID(String string) throws ExceptionUnknownMibName {
        int n;
        MibEnumObject[] mibEnumObjectArray = MibEnum.getMibEnumTable(string);
        if (mibEnumObjectArray == null) {
            throw new ExceptionUnknownMibName(string);
        }
        int n2 = MibEnum.getOidNameIndex(mibEnumObjectArray, string);
        if (n2 == -1) {
            throw new ExceptionUnknownMibName(string);
        }
        Vector<MibEnumObject> vector = new Vector<MibEnumObject>(20);
        String string2 = mibEnumObjectArray[n2].getOidName();
        int n3 = 0;
        for (n = n2; n < mibEnumObjectArray.length && (mibEnumObjectArray[n].getOidName() == null || mibEnumObjectArray[n].getOidName().equals(string2)); ++n) {
            vector.addElement(mibEnumObjectArray[n]);
        }
        n = vector.size();
        MibEnumObject[] mibEnumObjectArray2 = new MibEnumObject[n];
        for (n3 = 0; n3 < n; ++n3) {
            mibEnumObjectArray2[n3] = (MibEnumObject)vector.elementAt(n3);
        }
        return mibEnumObjectArray2;
    }

    private static MibEnumObject[] getMibEnumTable(String string) {
        MibEnumObject[] mibEnumObjectArray = null;
        for (int i = 0; i < m_lMibEnumLists.size(); ++i) {
            NameValue nameValue = (NameValue)m_lMibEnumLists.elementAt(i);
            if (!string.startsWith(nameValue.getName())) continue;
            mibEnumObjectArray = (MibEnumObject[])nameValue.getValue();
        }
        return mibEnumObjectArray;
    }

    private static int getOidNameIndex(MibEnumObject[] mibEnumObjectArray, String string) {
        String string2;
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens() && !Character.isDigit(c = (string2 = stringTokenizer.nextToken()).charAt(0))) {
            stringBuffer.append(string2);
            stringBuffer.append('.');
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) == '.') {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        String string3 = stringBuffer.toString();
        String string4 = "";
        for (int i = 0; i < mibEnumObjectArray.length; ++i) {
            string4 = mibEnumObjectArray[i].getOidName();
            if (string4 == null || !string4.equals(string3)) continue;
            return i;
        }
        return -1;
    }

    public static void main(String[] stringArray) {
        String string = "";
        int n = 0;
        try {
            StringArray stringArray2 = MibEnum.getEnumsForOID("equinox.emserver.debugSetting.4.234.1.98");
            string = MibEnum.getEnumForValue("equinox.emserver.debugSetting.1.1.2.0", 1);
            n = MibEnum.getValueForEnum("equinox.emserver.debugSetting", "Enabled");
            n = MibEnum.getValueForEnum("equinox.emserver.debugSetting", "Disabled");
            n = MibEnum.getValueForEnum("equinox.emserver.debugSetting", "GoodBye");
            n = MibEnum.getValueForEnum("equinox.sst.port.portDscopeTable.portDscopeEntry.portDscopeTriggerStopSignal", "DCD off to on");
            System.out.println("GoodEnum MIB Name, Enum Val: " + string);
            n = MibEnum.getValueForEnum("equinox.sst.port.portDscopeTable.portDscopeEntry.portDscopeTriggerStopSignal", "Goodbye");
        }
        catch (ExceptionUnknownMibName exceptionUnknownMibName) {
            System.out.println("Exception Unknown MIB Name: " + exceptionUnknownMibName.getMessage());
        }
        catch (ExceptionBadEnumValue exceptionBadEnumValue) {
            System.out.println(exceptionBadEnumValue.getMessage());
        }
    }
}

