/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.common;

import com.avocent.avworks.nmm.common.AmpController;
import com.avocent.avworks.nmm.common.Appliance;
import com.avocent.avworks.nmm.common.InterfaceAmpPanelController;
import com.avocent.lib.debug.Trace;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public abstract class PanelController {
    public static final String TRACE_CTXT = "PanelController";
    protected PanelController m_parentController;
    protected InterfaceAmpPanelController m_ampPanelController;
    protected boolean m_inUpdate = false;
    private UpdateViewsRunnable m_updateViews = new UpdateViewsRunnable();
    protected HashMap m_fieldMapping = new HashMap();

    public PanelController(InterfaceAmpPanelController interfaceAmpPanelController, PanelController panelController) {
        this.m_ampPanelController = interfaceAmpPanelController;
        this.m_parentController = panelController;
    }

    public InterfaceAmpPanelController getAmpPanelController() {
        return this.m_ampPanelController;
    }

    public Appliance getAppliance() {
        return this.getAmpPanelController().getAmpController().getAppliance();
    }

    public AmpController getAmpController() {
        return this.getAmpPanelController().getAmpController();
    }

    public void addFieldMapping(Object object, Component component) {
        this.m_fieldMapping.put(object, component);
    }

    public Component getComponentForField(Object object) {
        return (Component)this.m_fieldMapping.get(object);
    }

    public void addDocumentListener(JTextField jTextField, String string) {
        jTextField.getDocument().addDocumentListener(new NmmDocumentListener(string));
    }

    public void addDocumentListener(Document document, String string) {
        document.addDocumentListener(new NmmDocumentListener(string));
    }

    public void updateViews() {
        if (!this.m_inUpdate) {
            this.setInUpdate(true);
            if (SwingUtilities.isEventDispatchThread()) {
                this.m_updateViews.run();
            } else {
                SwingUtilities.invokeLater(this.m_updateViews);
            }
        }
    }

    protected abstract void updateViewsImpl() throws Exception;

    protected void setInUpdate(boolean bl) {
        Trace.logInfo((String)TRACE_CTXT, (String)("Set in update to: " + bl));
        this.m_inUpdate = bl;
    }

    public boolean getInUpdated() {
        return this.m_inUpdate;
    }

    public void setFocusOnField(Object object) {
        Component component;
        if (object != null && (component = this.getComponentForField(object)) != null) {
            component.requestFocusInWindow();
        }
    }

    class UpdateViewsRunnable
    implements Runnable {
        UpdateViewsRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                PanelController.this.updateViewsImpl();
            }
            catch (Throwable throwable) {
                Trace.logError((String)PanelController.TRACE_CTXT, (String)"Error while updating GUI.", (Throwable)throwable);
            }
            finally {
                PanelController.this.setInUpdate(false);
            }
        }
    }

    class NmmDocumentListener
    implements DocumentListener {
        String m_propertyName;

        NmmDocumentListener(String string) {
            this.m_propertyName = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setValue(DocumentEvent documentEvent) {
            if (PanelController.this.m_inUpdate) {
                Trace.logInfo((String)PanelController.TRACE_CTXT, (String)"in update true in document listener.");
            }
            if (!PanelController.this.m_inUpdate && PanelController.this.getAmpPanelController().getPanelState() != 101) {
                try {
                    Appliance appliance = PanelController.this.getAmpPanelController().getAmpController().getAppliance();
                    Document document = documentEvent.getDocument();
                    String string = document.getText(0, document.getLength());
                    PanelController.this.setInUpdate(true);
                    PanelController.this.getAmpPanelController().setIsModified(appliance.setAmpValue(this.m_propertyName, string));
                }
                catch (BadLocationException badLocationException) {
                    Trace.logError((String)PanelController.TRACE_CTXT, (String)("Failed to update property for: " + this.m_propertyName));
                }
                finally {
                    PanelController.this.setInUpdate(false);
                }
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.setValue(documentEvent);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.setValue(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.setValue(documentEvent);
        }
    }
}

