/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.common;

import com.avocent.avworks.nmm.common.AsmpConnection;
import com.avocent.avworks.nmm.common.ExceptionAsmpRequestFailed;
import com.avocent.avworks.nmm.common.ExceptionSnmpRequestFailed;
import com.avocent.avworks.nmm.common.InterfaceSnmpConstants;
import com.avocent.avworks.nmm.common.InterfaceValueObject;
import com.avocent.avworks.nmm.common.MibEnum;
import com.avocent.avworks.nmm.common.MibEnumMibII;
import com.avocent.avworks.nmm.common.MibEnumObject;
import com.avocent.avworks.nmm.common.MibVar;
import com.avocent.avworks.nmm.common.SnmpValueObject;
import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.exceptions.ExceptionUserCancelled;
import com.avocent.lib.gui.renderers.NameValue;
import com.avocent.lib.net.MacAddress;
import com.avocent.lib.util.ResourceManager;
import com.avocent.protocols.asmp.AsmpErrorStatus;
import com.avocent.protocols.asmp.AsmpFileData;
import com.avocent.protocols.asmp.AsmpFileInfo;
import com.avocent.protocols.asmp.ThreadAsmpSession;
import com.avocent.protocols.snmp.AsnObjectIdentifier;
import com.avocent.protocols.snmp.AsnOctetString;
import com.avocent.protocols.snmp.ExceptionBadEnumValue;
import com.avocent.protocols.snmp.ExceptionInvalidIndex;
import com.avocent.protocols.snmp.ExceptionUnknownMibName;
import com.avocent.protocols.snmp.Mib;
import com.avocent.protocols.snmp.MibNode;
import com.avocent.protocols.snmp.SnmpErrorStatus;
import com.avocent.protocols.snmp.SnmpRequest;
import com.avocent.protocols.snmp.SnmpSessionInfo;
import com.avocent.protocols.snmp.ThreadSnmpService;
import com.avocent.protocols.snmp.VarBind;
import com.avocent.protocols.snmp.VarBindList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SnmpHelper
implements InterfaceSnmpConstants {
    private static final String TRACE_CONTEXT = "SnmpHelper";
    public static final String CNAME = "SnmpHelper";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.common.Res");
    protected static Object[] APPLIANCE = new Object[]{AVWorksBranding.getApplianceName((boolean)true)};
    protected static String UTF8_ENCODING = "UTF-8";
    protected static int BLOCK_SIZE = 4096;
    protected Hashtable m_htMibVarTable = new Hashtable(200);

    public SnmpHelper() {
        this.registerSnmpHelperOids();
        MibEnum.registerEnumerationList("mib-2", MibEnumMibII.m_aEnumObjects);
    }

    private void registerSnmpHelperOids() {
        this.mvPut("mib-2.system.sysName.0", 4, false, true);
        this.mvPut("mib-2.system.sysDescr.0", 4, false, true);
        this.mvPut("mib-2.system.sysContact.0", 4, false, true);
        this.mvPut("mib-2.system.sysObjectID.0", 4, false, true);
        this.mvPut("mib-2.interfaces.ifTable.ifEntry.ifType", 2, true, false);
        this.mvPut("mib-2.interfaces.ifTable.ifEntry.ifPhysAddress", 4, false, false);
    }

    public Object[] get(AsmpConnection asmpConnection, Object[] objectArray) throws ExceptionInvalidArgument, ExceptionAsmpRequestFailed, ExceptionSnmpRequestFailed, ExceptionRequestFailed, Exception {
        return this.get(asmpConnection, objectArray, "");
    }

    public Object[] get(AsmpConnection asmpConnection, Object[] objectArray, String string) throws ExceptionInvalidArgument, ExceptionAsmpRequestFailed, ExceptionSnmpRequestFailed, ExceptionRequestFailed, Exception {
        Object[] objectArray2;
        block11: {
            if (asmpConnection == null || objectArray == null || objectArray.length == 0 || string == null) {
                String string2 = "get method called with an invalid argument.";
                SnmpHelper.logError(string2);
                string2 = res.getString("SnmpHelper_Req_Failed_internal");
                throw new ExceptionInvalidArgument(string2);
            }
            objectArray2 = new Object[objectArray.length];
            try {
                VarBindList varBindList = this.createVarBindList(objectArray, string);
                if (varBindList.size() != objectArray.length) {
                    String string3 = "Size of varbind list=" + varBindList.size() + " returned by createVarBindList method is " + "less than requested number of fields=" + objectArray.length + ".";
                    SnmpHelper.logError(string3);
                    string3 = res.getString("SnmpHelper_Req_Failed_internal");
                    throw new ExceptionRequestFailed(string3);
                }
                SnmpRequest snmpRequest = new SnmpRequest(varBindList, null, "", 160, 0, 0);
                SnmpHelper.logGetInfo("get", varBindList);
                SnmpHelper.logInfo("Making ASMP Get request.");
                int n = asmpConnection.asmpRequest(snmpRequest);
                if (n == 0 && snmpRequest.getErrorStatus() == 0) {
                    SnmpHelper.logInfo("ASMP Get request succeeded.");
                    VarBindList varBindList2 = snmpRequest.getVarBindList();
                    varBindList2 = this.reorderPerOriginalRequest(varBindList2, objectArray);
                    if (varBindList2.size() != objectArray.length) {
                        String string4 = "ASMP Get did not return all of the values requested.";
                        SnmpHelper.logError(string4);
                        string4 = res.getString("SnmpHelper_Req_Failed_internal");
                        throw new ExceptionRequestFailed(string4);
                    }
                    for (int i = 0; i < varBindList2.size(); ++i) {
                        VarBind varBind = varBindList2.varbindAt(i);
                        SnmpValueObject snmpValueObject = (SnmpValueObject)this.createReturnValue(varBind, objectArray[i]);
                        objectArray2[i] = snmpValueObject.getValue();
                    }
                    break block11;
                }
                if (n != 0) {
                    if (n < 256) {
                        int n2 = snmpRequest.getErrorIndex();
                        String string5 = "ASMP Get request failed. AsmpStatus=" + n + ", SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + "), ErrorIndex=" + n2 + ".";
                        SnmpHelper.logError(string5);
                        string5 = SnmpHelper.getErrorStatusMessage(snmpRequest.getErrorStatus());
                        throw new ExceptionSnmpRequestFailed(string5, snmpRequest.getErrorStatus(), n2);
                    }
                    String string6 = "ASMP Get request failed. AsmpStatus=" + n + " " + AsmpErrorStatus.getErrorStatusMessage((int)n) + ".";
                    SnmpHelper.logError(string6);
                    string6 = SnmpHelper.getErrorStatusMessage(n);
                    throw new ExceptionAsmpRequestFailed(string6, n);
                }
                if (snmpRequest.getErrorStatus() != 0) {
                    int n3 = snmpRequest.getErrorIndex();
                    String string7 = "ASMP Get request failed. AsmpStatus=" + n + ", SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + "), ErrorIndex=" + n3 + ".";
                    SnmpHelper.logError(string7);
                    string7 = SnmpHelper.getErrorStatusMessage(snmpRequest.getErrorStatus());
                    throw new ExceptionSnmpRequestFailed(string7, snmpRequest.getErrorStatus(), n3);
                }
                String string8 = "ASMP Get request failed. AsmpStatus=" + n + ", SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + ".";
                SnmpHelper.logError(string8);
                string8 = SnmpHelper.getErrorStatusMessage(n);
                throw new ExceptionRequestFailed(string8);
            }
            catch (Exception exception) {
                SnmpHelper.logError(exception.getMessage(), exception);
                String string9 = exception.getMessage();
                if (string9 == null || string9.trim().length() == 0) {
                    string9 = MessageFormat.format(res.getString("SnmpHelper_Request_Failed_ASMP_communications"), APPLIANCE);
                    throw new ExceptionRequestFailed(string9);
                }
                throw exception;
            }
        }
        return objectArray2;
    }

    public InterfaceValueObject[] getMibValues(AsmpConnection asmpConnection, Object[] objectArray) throws ExceptionInvalidArgument, ExceptionAsmpRequestFailed, ExceptionSnmpRequestFailed, ExceptionRequestFailed, Exception {
        return this.getMibValues(asmpConnection, objectArray, "");
    }

    public InterfaceValueObject[] getMibValues(AsmpConnection asmpConnection, Object[] objectArray, String string) throws ExceptionInvalidArgument, ExceptionAsmpRequestFailed, ExceptionSnmpRequestFailed, ExceptionRequestFailed, Exception {
        InterfaceValueObject[] interfaceValueObjectArray;
        block11: {
            if (asmpConnection == null || objectArray == null || objectArray.length == 0 || string == null) {
                String string2 = "getValues method called with an invalid argument.";
                SnmpHelper.logError(string2);
                string2 = res.getString("SnmpHelper_Req_Failed_internal");
                throw new ExceptionInvalidArgument(string2);
            }
            interfaceValueObjectArray = new SnmpValueObject[objectArray.length];
            try {
                VarBindList varBindList = this.createVarBindList(objectArray, string);
                if (varBindList.size() != objectArray.length) {
                    String string3 = "Size of varbind list=" + varBindList.size() + " returned by createVarBindList method is " + "less than requested number of fields=" + objectArray.length + ".";
                    SnmpHelper.logError(string3);
                    string3 = res.getString("SnmpHelper_Req_Failed_internal");
                    throw new ExceptionRequestFailed(string3);
                }
                SnmpRequest snmpRequest = new SnmpRequest(varBindList, null, "", 160, 0, 0);
                SnmpHelper.logGetInfo("getValues", varBindList);
                SnmpHelper.logInfo("Making ASMP Get request.");
                int n = asmpConnection.asmpRequest(snmpRequest);
                if (n == 0 && snmpRequest.getErrorStatus() == 0) {
                    SnmpHelper.logInfo("ASMP Get request succeeded.");
                    VarBindList varBindList2 = snmpRequest.getVarBindList();
                    varBindList2 = this.reorderPerOriginalRequest(varBindList2, objectArray);
                    if (varBindList2.size() != objectArray.length) {
                        String string4 = "ASMP Get did not return all of the values requested.";
                        SnmpHelper.logError(string4);
                        string4 = res.getString("SnmpHelper_Req_Failed_internal");
                        throw new ExceptionRequestFailed(string4);
                    }
                    for (int i = 0; i < varBindList2.size(); ++i) {
                        VarBind varBind = varBindList2.varbindAt(i);
                        interfaceValueObjectArray[i] = (SnmpValueObject)this.createReturnValue(varBind, objectArray[i]);
                    }
                    break block11;
                }
                if (n != 0) {
                    if (n < 256) {
                        int n2 = snmpRequest.getErrorIndex();
                        String string5 = n2 < objectArray.length ? objectArray[n2].toString() : "";
                        String string6 = "ASMP Get request failed. AsmpStatus=" + n + ", SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + "), ErrorIndex=" + n2 + ", Field=" + string5 + ".";
                        SnmpHelper.logError(string6);
                        string6 = SnmpHelper.getErrorStatusMessage(snmpRequest.getErrorStatus());
                        throw new ExceptionSnmpRequestFailed(string6, snmpRequest.getErrorStatus(), n2);
                    }
                    String string7 = "ASMP Get request failed. AsmpStatus=" + n + " " + AsmpErrorStatus.getErrorStatusMessage((int)n) + ".";
                    SnmpHelper.logError(string7);
                    string7 = SnmpHelper.getErrorStatusMessage(n);
                    throw new ExceptionAsmpRequestFailed(string7, n);
                }
                if (snmpRequest.getErrorStatus() != 0) {
                    int n3 = snmpRequest.getErrorIndex();
                    String string8 = "ASMP Get request failed. AsmpStatus=" + n + ", SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + "), ErrorIndex=" + n3 + ".";
                    SnmpHelper.logError(string8);
                    string8 = SnmpHelper.getErrorStatusMessage(snmpRequest.getErrorStatus());
                    throw new ExceptionSnmpRequestFailed(string8, snmpRequest.getErrorStatus(), n3);
                }
                String string9 = "ASMP Get request failed. AsmpStatus=" + n + ", SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + ".";
                SnmpHelper.logError(string9);
                string9 = SnmpHelper.getErrorStatusMessage(n);
                throw new ExceptionRequestFailed(string9);
            }
            catch (Exception exception) {
                SnmpHelper.logError(exception.getMessage(), exception);
                String string10 = exception.getMessage();
                if (string10 == null || string10.trim().length() == 0) {
                    string10 = MessageFormat.format(res.getString("SnmpHelper_Request_Failed_ASMP_communications"), APPLIANCE);
                    throw new ExceptionRequestFailed(string10, (Throwable)exception);
                }
                throw exception;
            }
        }
        return interfaceValueObjectArray;
    }

    public SnmpValueObject[] getNextMibValues(AsmpConnection asmpConnection, Object[] objectArray) throws ExceptionInvalidArgument, ExceptionAsmpRequestFailed, ExceptionSnmpRequestFailed, ExceptionRequestFailed, Exception {
        SnmpValueObject[] snmpValueObjectArray;
        block14: {
            if (asmpConnection == null || objectArray == null || objectArray.length == 0) {
                String string = "getNextMibValues method called with an invalid argument.";
                SnmpHelper.logError(string);
                string = res.getString("SnmpHelper_Req_Failed_internal");
                throw new ExceptionInvalidArgument(string);
            }
            snmpValueObjectArray = new SnmpValueObject[objectArray.length];
            try {
                VarBindList varBindList = this.createVarBindList(objectArray, "", true);
                if (varBindList.size() != objectArray.length) {
                    String string = "Size of varbind list=" + varBindList.size() + " returned by createVarBindList method is " + "less than requested number of fields=" + objectArray.length + ".";
                    SnmpHelper.logError(string);
                    string = res.getString("SnmpHelper_Req_Failed_internal");
                    throw new ExceptionRequestFailed(string);
                }
                SnmpRequest snmpRequest = new SnmpRequest(varBindList, null, "", 161, 0, 0);
                SnmpHelper.logGetInfo("getNextMibValues", varBindList);
                SnmpHelper.logInfo("Making ASMP GetNext request.");
                int n = asmpConnection.asmpRequest(snmpRequest);
                if (n == 0 && snmpRequest.getErrorStatus() == 0) {
                    SnmpHelper.logInfo("ASMP GetNext request succeeded.");
                    VarBindList varBindList2 = snmpRequest.getVarBindList();
                    if (varBindList2 == null || varBindList2.size() == 0) {
                        SnmpHelper.logInfo("ASMP GetNext response empty--reached end of MIB.");
                    } else {
                        if (varBindList2.size() != objectArray.length) {
                            String string = "ASMP GetNext did not return all of the values requested.";
                            SnmpHelper.logError(string);
                            string = res.getString("SnmpHelper_Req_Failed_internal");
                            throw new ExceptionRequestFailed(string);
                        }
                        for (int i = 0; i < varBindList2.size(); ++i) {
                            VarBind varBind = varBindList2.varbindAt(i);
                            snmpValueObjectArray[i] = (SnmpValueObject)this.createReturnValue(varBind, objectArray[i]);
                        }
                    }
                    break block14;
                }
                if (n == 2) {
                    SnmpHelper.logInfo("ASMP GetNext reached end of MIB.");
                    break block14;
                }
                if (n != 0) {
                    if (n < 256) {
                        int n2 = snmpRequest.getErrorIndex();
                        String string = "ASMP GetNext request failed. AsmpStatus=" + n + ", SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + "), ErrorIndex=" + n2 + ".";
                        SnmpHelper.logError(string);
                        string = SnmpHelper.getErrorStatusMessage(snmpRequest.getErrorStatus());
                        throw new ExceptionSnmpRequestFailed(string, snmpRequest.getErrorStatus(), n2);
                    }
                    String string = "ASMP GetNext request failed. AsmpStatus=" + n + " " + AsmpErrorStatus.getErrorStatusMessage((int)n) + ".";
                    SnmpHelper.logError(string);
                    string = SnmpHelper.getErrorStatusMessage(n);
                    throw new ExceptionAsmpRequestFailed(string, n);
                }
                if (snmpRequest.getErrorStatus() != 0) {
                    int n3 = snmpRequest.getErrorIndex();
                    String string = "ASMP GetNext request failed. AsmpStatus=" + n + ", SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + "), ErrorIndex=" + n3 + ".";
                    SnmpHelper.logError(string);
                    string = SnmpHelper.getErrorStatusMessage(snmpRequest.getErrorStatus());
                    throw new ExceptionSnmpRequestFailed(string, snmpRequest.getErrorStatus(), n3);
                }
                String string = "ASMP GetNext request failed. AsmpStatus=" + n + ", SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + ".";
                SnmpHelper.logError(string);
                string = SnmpHelper.getErrorStatusMessage(n);
                throw new ExceptionRequestFailed(string);
            }
            catch (Exception exception) {
                SnmpHelper.logError(exception.getMessage(), exception);
                String string = exception.getMessage();
                if (string == null || string.trim().length() == 0) {
                    string = MessageFormat.format(res.getString("SnmpHelper_Request_Failed_ASMP_communications"), APPLIANCE);
                    throw new ExceptionRequestFailed(string);
                }
                throw exception;
            }
        }
        return snmpValueObjectArray;
    }

    public InterfaceValueObject[][] getMibTableValues(AsmpConnection asmpConnection, Object[] objectArray) throws ExceptionInvalidArgument, ExceptionAsmpRequestFailed, ExceptionSnmpRequestFailed, ExceptionRequestFailed, Exception {
        Object object;
        Object object2;
        int n;
        InterfaceValueObject[][] interfaceValueObjectArray;
        block22: {
            if (asmpConnection == null || objectArray == null || objectArray.length == 0) {
                String string = "getTableValues method called with an invalid argument.";
                SnmpHelper.logError(string);
                string = res.getString("SnmpHelper_Req_Failed_internal");
                throw new ExceptionInvalidArgument(string);
            }
            try {
                this.getMibValues(asmpConnection, objectArray, ".1");
            }
            catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
                if (exceptionAsmpRequestFailed.getErrorCode() == 2) break block22;
                throw exceptionAsmpRequestFailed;
            }
        }
        Vector vector = new Vector(10, 5);
        try {
            interfaceValueObjectArray = this.createVarBindList(objectArray, "");
            if (interfaceValueObjectArray.size() != objectArray.length) {
                String string = "Size of varbind list=" + interfaceValueObjectArray.size() + " returned by createVarBindList method is " + "less than requested number of fields=" + objectArray.length + ".";
                SnmpHelper.logError(string);
                string = res.getString("SnmpHelper_Req_Failed_internal");
                throw new ExceptionRequestFailed(string);
            }
            SnmpRequest snmpRequest = new SnmpRequest((VarBindList)interfaceValueObjectArray, null, "", 161, 0, 0);
            String string = "";
            while (true) {
                String string2;
                Vector<SnmpValueObject> vector2 = new Vector<SnmpValueObject>(objectArray.length);
                SnmpHelper.logGetInfo("getTableValues", snmpRequest.getVarBindList());
                SnmpHelper.logInfo("Making ASMP GetNext request.");
                n = asmpConnection.asmpRequest(snmpRequest);
                if (n == 0 && snmpRequest.getErrorStatus() == 0) {
                    SnmpHelper.logInfo("ASMP GetNext request succeeded.");
                    object2 = snmpRequest.getVarBindList();
                    if (object2 == null || object2.size() == 0) {
                        SnmpHelper.logInfo("ASMP GetNext response empty--reached end of MIB.");
                        break;
                    }
                    if ((object2 = this.reorderPerOriginalRequest((VarBindList)object2, objectArray)).size() != objectArray.length) {
                        SnmpHelper.logInfo("ASMP GetNext reached end of table.");
                        break;
                    }
                    object = object2.varbindAt(0);
                    string2 = object.getName();
                    if (string2.equals(string)) {
                        SnmpHelper.logError("GetNext returned previous OID (" + string2 + ").");
                        break;
                    }
                    string = string2;
                    if (this.isEmptyRow((VarBindList)object2)) continue;
                    for (int i = 0; i < object2.size(); ++i) {
                        object = object2.varbindAt(i);
                        vector2.addElement((SnmpValueObject)this.createReturnValue((VarBind)object, objectArray[i]));
                    }
                } else {
                    if (n == 2) {
                        SnmpHelper.logInfo("ASMP GetNext reached end of MIB.");
                        break;
                    }
                    if (n != 0) {
                        if (n < 256) {
                            int n2 = snmpRequest.getErrorIndex();
                            string2 = "ASMP Get request failed. AsmpStatus=" + n + ", SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + "), ErrorIndex=" + n2 + ".";
                            SnmpHelper.logError(string2);
                            string2 = SnmpHelper.getErrorStatusMessage(snmpRequest.getErrorStatus());
                            throw new ExceptionSnmpRequestFailed(string2, snmpRequest.getErrorStatus(), n2);
                        }
                        object = "ASMP Get request failed. AsmpStatus=" + n + " " + AsmpErrorStatus.getErrorStatusMessage((int)n) + ".";
                        SnmpHelper.logError((String)object);
                        object = SnmpHelper.getErrorStatusMessage(n);
                        throw new ExceptionAsmpRequestFailed((String)object, n);
                    }
                    if (snmpRequest.getErrorStatus() != 0) {
                        int n3 = snmpRequest.getErrorIndex();
                        string2 = "ASMP GetNext request failed. AsmpStatus=" + n + ", SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + "), ErrorIndex=" + n3 + ".";
                        SnmpHelper.logError(string2);
                        string2 = SnmpHelper.getErrorStatusMessage(snmpRequest.getErrorStatus());
                        throw new ExceptionSnmpRequestFailed(string2, snmpRequest.getErrorStatus(), n3);
                    }
                    object = "ASMP GetNext request failed. AsmpStatus=" + n + ", SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + ".";
                    SnmpHelper.logError((String)object);
                    object = SnmpHelper.getErrorStatusMessage(n);
                    throw new ExceptionRequestFailed((String)object);
                }
                vector.addElement(vector2);
                snmpRequest.setNewVarBindList((VarBindList)object2);
            }
        }
        catch (Exception exception) {
            SnmpHelper.logError(exception.getMessage(), exception);
            String string = exception.getMessage();
            if (string == null || string.trim().length() == 0) {
                string = MessageFormat.format(res.getString("SnmpHelper_Request_Failed_ASMP_communications"), APPLIANCE);
                throw new ExceptionRequestFailed(string);
            }
            throw exception;
        }
        int n4 = vector.size();
        if (n4 > 0) {
            int n5 = ((Vector)vector.elementAt(0)).size();
            interfaceValueObjectArray = new SnmpValueObject[n4][n5];
            for (int i = 0; i < n4; ++i) {
                object2 = (Vector)vector.elementAt(i);
                for (n = 0; n < n5; ++n) {
                    interfaceValueObjectArray[i][n] = object = (SnmpValueObject)((Vector)object2).elementAt(n);
                }
            }
        } else {
            interfaceValueObjectArray = new SnmpValueObject[][]{};
        }
        return interfaceValueObjectArray;
    }

    public void setMibValues(AsmpConnection asmpConnection, Object[] objectArray, Object[] objectArray2) throws ExceptionInvalidArgument, ExceptionAsmpRequestFailed, ExceptionSnmpRequestFailed, ExceptionRequestFailed, Exception {
        this.setMibValues(asmpConnection, objectArray, objectArray2, "");
    }

    public void setMibValues(AsmpConnection asmpConnection, Object[] objectArray, Object[] objectArray2, String string) throws ExceptionInvalidArgument, ExceptionAsmpRequestFailed, ExceptionSnmpRequestFailed, ExceptionRequestFailed, Exception {
        if (asmpConnection == null || objectArray == null || objectArray.length == 0 || objectArray2 == null || objectArray2.length < objectArray.length || string == null) {
            String string2 = "set method called with an invalid argument.";
            SnmpHelper.logError(string2);
            string2 = res.getString("SnmpHelper_Req_Failed_internal");
            throw new ExceptionInvalidArgument(string2);
        }
        try {
            VarBindList varBindList = this.createVarBindList(objectArray, objectArray2, string);
            if (varBindList.size() != objectArray.length) {
                String string3 = "Size of varbind list=" + varBindList.size() + " returned by createVarBindList method is " + "less than requested number of fields=" + objectArray.length + ".";
                SnmpHelper.logError(string3);
                string3 = res.getString("SnmpHelper_Req_Failed_internal");
                throw new ExceptionRequestFailed(string3);
            }
            SnmpRequest snmpRequest = new SnmpRequest(varBindList, null, "", 163, 0, 0);
            SnmpHelper.logSetInfo("set", varBindList, objectArray2);
            SnmpHelper.logInfo("Making ASMP Set request.");
            int n = asmpConnection.asmpRequest(snmpRequest);
            if (n != 0 || snmpRequest.getErrorStatus() != 0) {
                if (n != 0) {
                    if (n < 256) {
                        int n2 = snmpRequest.getErrorIndex();
                        String string4 = "ASMP Set request failed. AsmpStatus=" + n + ", SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + "), ErrorIndex=" + n2 + ".";
                        SnmpHelper.logError(string4);
                        string4 = SnmpHelper.getErrorStatusMessage(snmpRequest.getErrorStatus());
                        throw new ExceptionSnmpRequestFailed(string4, snmpRequest.getErrorStatus(), n2);
                    }
                    String string5 = "ASMP Set request failed. AsmpStatus=" + n + " " + AsmpErrorStatus.getErrorStatusMessage((int)n) + ".";
                    SnmpHelper.logError(string5);
                    string5 = SnmpHelper.getErrorStatusMessage(n);
                    throw new ExceptionAsmpRequestFailed(string5, n);
                }
                if (snmpRequest.getErrorStatus() != 0) {
                    int n3 = snmpRequest.getErrorIndex();
                    String string6 = "ASMP Set request failed. AsmpStatus=" + n + ", SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + "), ErrorIndex=" + n3 + ".";
                    SnmpHelper.logError(string6);
                    string6 = SnmpHelper.getErrorStatusMessage(snmpRequest.getErrorStatus());
                    throw new ExceptionSnmpRequestFailed(string6, snmpRequest.getErrorStatus(), n3);
                }
                String string7 = "ASMP Set request failed. AsmpStatus=" + n + ", SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + ".";
                SnmpHelper.logError(string7);
                string7 = SnmpHelper.getErrorStatusMessage(n);
                throw new ExceptionRequestFailed(string7);
            }
            SnmpHelper.logInfo("ASMP Set request succeeded.");
        }
        catch (Exception exception) {
            SnmpHelper.logError(exception.getMessage(), exception);
            String string8 = exception.getMessage();
            if (string8 == null || string8.trim().length() == 0) {
                string8 = MessageFormat.format(res.getString("SnmpHelper_Request_Failed_ASMP_communications"), APPLIANCE);
                throw new ExceptionRequestFailed(string8);
            }
            throw exception;
        }
    }

    public void setMibValues(AsmpConnection asmpConnection, InterfaceValueObject[] interfaceValueObjectArray) throws ExceptionInvalidArgument, ExceptionAsmpRequestFailed, ExceptionSnmpRequestFailed, ExceptionRequestFailed, Exception {
        if (asmpConnection == null || interfaceValueObjectArray == null || interfaceValueObjectArray.length == 0) {
            String string = "setValues method called with an invalid argument.";
            SnmpHelper.logError(string);
            string = res.getString("SnmpHelper_Req_Failed_internal");
            throw new ExceptionInvalidArgument(string);
        }
        try {
            VarBindList varBindList = new VarBindList();
            for (int i = 0; i < interfaceValueObjectArray.length; ++i) {
                VarBind varBind = ((SnmpValueObject)interfaceValueObjectArray[i]).getVarBind();
                varBindList.addVarBind(varBind);
            }
            SnmpRequest snmpRequest = new SnmpRequest(varBindList, null, "", 163, 0, 0);
            SnmpHelper.logSetInfo("setValues", varBindList, interfaceValueObjectArray);
            SnmpHelper.logInfo("Making ASMP Set request.");
            int n = asmpConnection.asmpRequest(snmpRequest);
            if (n != 0 || snmpRequest.getErrorStatus() != 0) {
                if (n != 0) {
                    if (n < 256) {
                        int n2 = snmpRequest.getErrorIndex();
                        String string = "ASMP Set request failed. AsmpStatus=" + n + ", SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + "), ErrorIndex=" + n2 + ".";
                        SnmpHelper.logError(string);
                        string = SnmpHelper.getErrorStatusMessage(snmpRequest.getErrorStatus());
                        throw new ExceptionSnmpRequestFailed(string, snmpRequest.getErrorStatus(), n2);
                    }
                    String string = "ASMP Set request failed. AsmpStatus=" + n + " " + AsmpErrorStatus.getErrorStatusMessage((int)n) + ".";
                    SnmpHelper.logError(string);
                    string = SnmpHelper.getErrorStatusMessage(n);
                    throw new ExceptionAsmpRequestFailed(string, n);
                }
                if (snmpRequest.getErrorStatus() != 0) {
                    int n3 = snmpRequest.getErrorIndex();
                    String string = "ASMP Set request failed. AsmpStatus=" + n + ", SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + "), ErrorIndex=" + n3 + ".";
                    SnmpHelper.logError(string);
                    string = SnmpErrorStatus.getErrorStatusMessage((int)snmpRequest.getErrorStatus());
                    throw new ExceptionSnmpRequestFailed(string, snmpRequest.getErrorStatus(), n3);
                }
                String string = "ASMP Set request failed. AsmpStatus=" + n + ", SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + ".";
                SnmpHelper.logError(string);
                string = SnmpHelper.getErrorStatusMessage(n);
                throw new ExceptionRequestFailed(string);
            }
            SnmpHelper.logInfo("ASMP Set request succeeded.");
        }
        catch (Exception exception) {
            SnmpHelper.logError(exception.getMessage(), exception);
            String string = exception.getMessage();
            if (string == null || string.trim().length() == 0) {
                string = MessageFormat.format(res.getString("SnmpHelper_Request_Failed_ASMP_communications"), APPLIANCE);
                throw new ExceptionRequestFailed(string);
            }
            throw exception;
        }
    }

    public void addRow(AsmpConnection asmpConnection, Object[] objectArray, Object[] objectArray2) throws ExceptionInvalidArgument, ExceptionAsmpRequestFailed, ExceptionSnmpRequestFailed, ExceptionRequestFailed, Exception {
        block4: {
            if (asmpConnection == null || objectArray == null || objectArray.length == 0 || objectArray2 == null || objectArray2.length < objectArray.length) {
                String string = "addRow method called with an invalid argument.";
                SnmpHelper.logError(string);
                string = res.getString("SnmpHelper_Req_Failed_internal");
                throw new ExceptionInvalidArgument(string);
            }
            try {
                this.getMibValues(asmpConnection, objectArray, ".1");
            }
            catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
                if (exceptionAsmpRequestFailed.getErrorCode() == 2) break block4;
                throw exceptionAsmpRequestFailed;
            }
        }
        String string = this.findEmptyRow(asmpConnection, objectArray[0]);
        if (string == null || string.trim().length() == 0) {
            String string2 = res.getString("SnmpHelper_Add_failed_the_table");
            SnmpHelper.logError(string2);
            throw new ExceptionRequestFailed(string2);
        }
        this.setMibValues(asmpConnection, objectArray, objectArray2, string);
    }

    public void deleteRow(AsmpConnection asmpConnection, InterfaceValueObject interfaceValueObject) throws ExceptionInvalidArgument, ExceptionAsmpRequestFailed, ExceptionSnmpRequestFailed, ExceptionRequestFailed, Exception {
        if (asmpConnection == null || interfaceValueObject == null || !(interfaceValueObject instanceof SnmpValueObject)) {
            String string = "deleteRow method called with an invalid argument.";
            SnmpHelper.logError(string);
            string = res.getString("SnmpHelper_Req_Failed_internal");
            throw new ExceptionInvalidArgument(string);
        }
        VarBind varBind = ((SnmpValueObject)interfaceValueObject).getVarBind();
        if (varBind == null) {
            String string = "deleteRow method called with an invalid argument.";
            SnmpHelper.logError(string);
            string = res.getString("SnmpHelper_Req_Failed_internal");
            throw new ExceptionInvalidArgument(string);
        }
        String string = this.trimMibPrefix(varBind.getName());
        Object[] objectArray = new Object[]{this.getEmptyRowFieldId(string)};
        Object[] objectArray2 = new Object[]{this.getEmptyRowFieldValue(string)};
        String string2 = this.getInstance(varBind);
        if (string2 == null || string2.trim().length() == 0) {
            String string3 = "Attempt to delete row for given varBind=" + string + ", failed--could not determine index.";
            SnmpHelper.logError(string3);
            string3 = res.getString("SnmpHelper_DeleteRow_failed");
            throw new ExceptionRequestFailed(string3);
        }
        this.setMibValues(asmpConnection, objectArray, objectArray2, string2);
    }

    public NameValue[] getMibEnumPairs(Object object) throws ExceptionInvalidArgument, ExceptionUnknownMibName, ExceptionBadEnumValue {
        if (object == null) {
            String string = "getMibEnumPairs method called with an invalid argument.";
            SnmpHelper.logError(string);
            string = res.getString("SnmpHelper_Req_Failed_internal");
            throw new ExceptionInvalidArgument(string);
        }
        MibVar mibVar = (MibVar)this.m_htMibVarTable.get(object);
        if (mibVar != null) {
            MibEnumObject[] mibEnumObjectArray = MibEnum.getEnumObjectsForOID(mibVar.szName);
            if (mibEnumObjectArray != null) {
                NameValue[] nameValueArray = new NameValue[mibEnumObjectArray.length];
                for (int i = 0; i < nameValueArray.length; ++i) {
                    String string = mibEnumObjectArray[i].getStrValue();
                    int n = mibEnumObjectArray[i].getIntValue();
                    nameValueArray[i] = new NameValue(string, (Object)new Integer(n));
                }
                return nameValueArray;
            }
        } else {
            SnmpHelper.logError("Could not find MibVar item for given field ID=" + object + ".");
            return null;
        }
        SnmpHelper.logError("Could not get the MIB enum objects for variable name=" + mibVar.szName + ".");
        return null;
    }

    public static void sendFile(ThreadAsmpSession threadAsmpSession, InputStream inputStream, long l, String string) throws ExceptionRequestFailed, ExceptionAsmpRequestFailed, ExceptionUserCancelled {
        try {
            int n;
            block20: {
                int n2 = 2;
                AsmpFileInfo asmpFileInfo = new AsmpFileInfo(string, n2, l);
                int n3 = threadAsmpSession.openWrite(asmpFileInfo);
                if (n3 == 0) {
                    SnmpHelper.logInfo("ASMP openWrite request for remote file (" + string + ") succeeded.");
                    n = 0;
                    int n4 = 0;
                    byte[] byArray = new byte[BLOCK_SIZE];
                    while (true) {
                        int n5;
                        if ((n5 = inputStream.read(byArray, n4, BLOCK_SIZE - n4)) == -1) {
                            if (n4 > 0) {
                                byte[] byArray2 = new byte[n4];
                                System.arraycopy(byArray, 0, byArray2, 0, n4);
                                SnmpHelper.write(threadAsmpSession, ++n, byArray2);
                            }
                            break block20;
                        }
                        if ((n4 += n5) < BLOCK_SIZE) continue;
                        if (n4 > BLOCK_SIZE) {
                            SnmpHelper.logInfo("Read more than BLOCK_SIZE=" + BLOCK_SIZE + " worth of data from input stream for file: " + string + " (nCurBlockSize=" + n4 + ").");
                        }
                        SnmpHelper.write(threadAsmpSession, ++n, byArray);
                        n4 = 0;
                    }
                }
                String string2 = "ASMP openWrite request failed for remote file (" + string + "). AsmpStatus=" + n3;
                SnmpHelper.logError(string2);
                string2 = SnmpHelper.getErrorStatusMessage(n3);
                throw new ExceptionAsmpRequestFailed(string2, n3);
            }
            SnmpHelper.logInfo("Successfully sent remote file (" + string + ").  Total blocks written=" + n + ".");
            SnmpHelper.closeWrite(threadAsmpSession, string);
        }
        catch (IOException iOException) {
            try {
                SnmpHelper.closeWrite(threadAsmpSession, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (iOException.getMessage().indexOf("cancel") > 0) {
                throw new ExceptionUserCancelled();
            }
            String string3 = "IOException caught reading input stream for  remote file (" + string + ") to be sent." + "  exception: " + iOException.getMessage();
            SnmpHelper.logError(string3);
            string3 = MessageFormat.format(res.getString("SnmpHelper_Write_request_failed2_Appliance0"), APPLIANCE);
            throw new ExceptionRequestFailed(string3);
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            try {
                SnmpHelper.closeWrite(threadAsmpSession, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string4 = "ExceptionAsmpRequestFailed caught attempting to send remote file (" + string + ").  exception: " + exceptionAsmpRequestFailed.getMessage();
            SnmpHelper.logError(string4);
            throw exceptionAsmpRequestFailed;
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            try {
                SnmpHelper.closeWrite(threadAsmpSession, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string5 = "ExceptionRequestFailed caught attempting to send remote file (" + string + ").  exception: " + exceptionRequestFailed.getMessage();
            SnmpHelper.logError(string5);
            string5 = exceptionRequestFailed.getMessage();
            if (string5.trim().length() == 0) {
                string5 = res.getString("SnmpHelper_Write_request_failed1_Appliance0");
                string5 = MessageFormat.format(string5, APPLIANCE);
            }
            throw new ExceptionRequestFailed(string5);
        }
        catch (Exception exception) {
            try {
                SnmpHelper.closeWrite(threadAsmpSession, string);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            String string6 = "Exception attempting to send remote file (" + string + ").  exception: " + exception.getMessage();
            SnmpHelper.logError(string6);
            string6 = res.getString("SnmpHelper_Write_request_failed2_Appliance0");
            string6 = MessageFormat.format(string6, APPLIANCE);
            throw new ExceptionRequestFailed(string6);
        }
    }

    public static void retrieveFile(ThreadAsmpSession threadAsmpSession, OutputStream outputStream, String string) throws ExceptionRequestFailed, ExceptionAsmpRequestFailed {
        try {
            int n;
            block12: {
                AsmpFileInfo asmpFileInfo = new AsmpFileInfo(string);
                int n2 = threadAsmpSession.openRead(asmpFileInfo);
                if (n2 == 0) {
                    Object object;
                    AsmpFileData asmpFileData;
                    long l = asmpFileInfo.getFileSize();
                    SnmpHelper.logInfo("ASMP openRead request for remote file (" + string + ") succeeded.  File size=" + l + ".");
                    n = 0;
                    while ((n2 = threadAsmpSession.read(asmpFileData = new AsmpFileData(++n))) == 0) {
                        SnmpHelper.logInfo("ASMP read request for block=" + n + " succeeded.");
                        object = asmpFileData.getData();
                        outputStream.write((byte[])object);
                        if ((l -= (long)((Object)object).length) > 0L) continue;
                        break block12;
                    }
                    object = "ASMP read request for block=" + n + " failed. AsmpStatus=" + n2;
                    SnmpHelper.logError((String)object);
                    object = AsmpErrorStatus.getErrorStatusMessage((int)n2);
                    throw new ExceptionAsmpRequestFailed((String)object, n2);
                }
                String string2 = "ASMP openRead request failed for remote file (" + string + "). AsmpStatus=" + n2;
                SnmpHelper.logError(string2);
                string2 = SnmpHelper.getErrorStatusMessage(n2);
                throw new ExceptionAsmpRequestFailed(string2, n2);
            }
            SnmpHelper.logInfo("Successfully retrieved remote file (" + string + ").  Total blocks read=" + n + ".");
            SnmpHelper.closeRead(threadAsmpSession, string);
        }
        catch (IOException iOException) {
            try {
                SnmpHelper.closeRead(threadAsmpSession, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string3 = "IOException caught writing to output stream  while retrieving remote file (" + string + ". exception: " + iOException.getMessage();
            SnmpHelper.logError(string3, iOException);
            string3 = MessageFormat.format(res.getString("SnmpHelper_Read_request_failed1_Appliance0"), APPLIANCE);
            throw new ExceptionRequestFailed(string3);
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            try {
                SnmpHelper.closeRead(threadAsmpSession, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string4 = "ExceptionAsmpRequestFailed caught attempting to retrieve remote file (" + string + ").  exception: " + exceptionAsmpRequestFailed.getMessage();
            SnmpHelper.logError(string4);
            throw exceptionAsmpRequestFailed;
        }
        catch (Exception exception) {
            try {
                SnmpHelper.closeRead(threadAsmpSession, string);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            String string5 = "Exception attempting to retrieve remote file (" + string + ").  exception: " + exception.getMessage();
            SnmpHelper.logError(string5, exception);
            string5 = res.getString("SnmpHelper_Read_request_failed1_Appliance0");
            string5 = MessageFormat.format(string5, APPLIANCE);
            throw new ExceptionRequestFailed(string5);
        }
    }

    public static long getRemoteFileSize(ThreadAsmpSession threadAsmpSession, String string) throws ExceptionRequestFailed, ExceptionAsmpRequestFailed {
        try {
            AsmpFileInfo asmpFileInfo = new AsmpFileInfo(string);
            int n = threadAsmpSession.openRead(asmpFileInfo);
            if (n == 0) {
                long l = asmpFileInfo.getFileSize();
                SnmpHelper.logInfo("ASMP openRead request for remote file (" + string + ") succeeded.  File size=" + l + ".");
                SnmpHelper.closeRead(threadAsmpSession, string);
                return l;
            }
            String string2 = "ASMP openRead request failed for remote file (" + string + "). AsmpStatus=" + n;
            SnmpHelper.logError(string2);
            string2 = SnmpHelper.getErrorStatusMessage(n);
            throw new ExceptionAsmpRequestFailed(string2, n);
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            String string3 = "ExceptionAsmpRequestFailed caught attempting to open remote file (" + string + ").  exception: " + exceptionAsmpRequestFailed.getMessage();
            SnmpHelper.logError(string3);
            throw exceptionAsmpRequestFailed;
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            String string4 = "ExceptionRequestFailed caught attempting to open remote file (" + string + ").  exception: " + exceptionRequestFailed.getMessage();
            SnmpHelper.logError(string4);
            throw new ExceptionRequestFailed(exceptionRequestFailed.getMessage());
        }
    }

    protected static void write(ThreadAsmpSession threadAsmpSession, int n, byte[] byArray) throws ExceptionRequestFailed, ExceptionAsmpRequestFailed {
        AsmpFileData asmpFileData = new AsmpFileData(n, byArray);
        int n2 = threadAsmpSession.write(asmpFileData);
        if (n2 != 0) {
            String string = "ASMP write request for block=" + n + " failed. AsmpStatus=" + n2;
            SnmpHelper.logError(string);
            string = SnmpHelper.getErrorStatusMessage(n2);
            throw new ExceptionAsmpRequestFailed(string, n2);
        }
        SnmpHelper.logInfo("ASMP write request for block=" + n + " succeeded.");
    }

    protected static void closeWrite(ThreadAsmpSession threadAsmpSession, String string) throws ExceptionRequestFailed {
        int n = threadAsmpSession.closeWrite();
        if (n != 0) {
            SnmpHelper.logError("ASMP closeWrite request failed for remote file (" + string + "). AsmpStatus=" + n);
        }
    }

    protected static void closeRead(ThreadAsmpSession threadAsmpSession, String string) throws ExceptionRequestFailed {
        int n = threadAsmpSession.closeRead();
        if (n != 0) {
            SnmpHelper.logError("ASMP closeRead request failed for remote file (" + string + "). AsmpStatus=" + n);
        }
    }

    protected VarBindList createVarBindList(Object[] objectArray, String string) throws ExceptionUnknownMibName, ExceptionInvalidArgument {
        return this.createVarBindList(objectArray, string, false);
    }

    protected VarBindList createVarBindList(Object[] objectArray, String string, boolean bl) throws ExceptionUnknownMibName, ExceptionInvalidArgument {
        VarBindList varBindList = new VarBindList();
        MibNode mibNode = MibNode.getRoot();
        for (int i = 0; i < objectArray.length; ++i) {
            VarBind varBind;
            String string2 = objectArray[i].toString();
            MibVar mibVar = (MibVar)this.m_htMibVarTable.get(objectArray[i]);
            if (mibVar != null) {
                if (mibVar.isScalor()) {
                    varBind = new VarBind(mibVar.szName);
                } else {
                    String string3 = string == null || string.length() == 0 ? "" : (string.startsWith(".") ? "" : ".");
                    varBind = new VarBind(mibVar.szName + string3 + string);
                }
                varBindList.addVarBind(varBind);
                continue;
            }
            if (bl) {
                varBind = new VarBind((String)objectArray[i]);
                varBindList.addVarBind(varBind);
                continue;
            }
            SnmpHelper.logError("Could not find field=" + objectArray[i] + ".");
        }
        return varBindList;
    }

    protected VarBindList createVarBindList(Object[] objectArray, Object[] objectArray2, String string) throws ExceptionUnknownMibName, ExceptionInvalidArgument, ExceptionRequestFailed {
        VarBindList varBindList = new VarBindList();
        for (int i = 0; i < objectArray.length; ++i) {
            MibVar mibVar = (MibVar)this.m_htMibVarTable.get(objectArray[i]);
            if (mibVar != null) {
                VarBind varBind = this.createVarBind(mibVar, objectArray2[i], string);
                varBindList.addVarBind(varBind);
                continue;
            }
            SnmpHelper.logError("Could not find field=" + objectArray[i] + ".");
        }
        return varBindList;
    }

    protected InterfaceValueObject createReturnValue(VarBind varBind, Object object) throws ExceptionRequestFailed {
        Object object2 = null;
        boolean bl = false;
        String string = this.trimMibPrefix(varBind.getName());
        MibVar mibVar = (MibVar)this.m_htMibVarTable.get(object);
        if (mibVar == null || !mibVar.isScalor()) {
            string = this.trimInstance(string);
        }
        try {
            int n = varBind.getSyntax();
            switch (n) {
                case 2: {
                    mibVar = (MibVar)this.m_htMibVarTable.get(string);
                    if (mibVar != null) {
                        bl = mibVar.isEnum();
                    } else {
                        SnmpHelper.logError("Could not find field=" + string);
                    }
                    if (bl) {
                        int n2 = varBind.getIntegerValue();
                        try {
                            String string2 = MibEnum.getEnumForValue(string, n2);
                            object2 = new NameValue(string2, (Object)new Integer(n2));
                        }
                        catch (ExceptionUnknownMibName exceptionUnknownMibName) {
                            String string3 = "The MIB variable=" + string + " is an enum, but its enums " + "have not been defined.";
                            SnmpHelper.logError(string3, (Exception)((Object)exceptionUnknownMibName));
                            object2 = new NameValue(String.valueOf(n2), (Object)new Integer(n2));
                        }
                        break;
                    }
                    object2 = new Integer(varBind.getIntegerValue());
                    break;
                }
                case 5: {
                    object2 = null;
                    break;
                }
                case 65: 
                case 66: 
                case 67: {
                    object2 = new Long(varBind.getUnsignedValue());
                    break;
                }
                case 3: 
                case 6: 
                case 64: {
                    object2 = varBind.getStringValue();
                    break;
                }
                case 4: {
                    Object object3;
                    boolean bl2 = false;
                    mibVar = (MibVar)this.m_htMibVarTable.get(string);
                    if (mibVar != null) {
                        object3 = (MibVar)this.m_htMibVarTable.get("mib-2.interfaces.ifTable.ifEntry.ifPhysAddress");
                        bl2 = mibVar.equals(object3);
                    } else {
                        SnmpHelper.logError("Could not find field=" + string);
                    }
                    if (bl2) {
                        object3 = (AsnOctetString)varBind.getAsnObject();
                        if (object3.getSizeOfValueField() > 0) {
                            object2 = object3.getStringValue(1);
                            break;
                        }
                        object2 = "";
                        break;
                    }
                    object3 = varBind.getOctetStringValue();
                    String string4 = mibVar != null && mibVar.isUtf8() ? new String((byte[])object3, UTF8_ENCODING) : new String((byte[])object3);
                    object2 = string4;
                    break;
                }
                default: {
                    String string5 = "Invalid syntax=" + n + " returned for VarBind.";
                    throw new ExceptionRequestFailed(string5);
                }
            }
        }
        catch (Exception exception) {
            String string6 = "Creating return value for VarBind=" + string + " (" + exception.getMessage() + ").";
            SnmpHelper.logError(string6);
            string6 = res.getString("SnmpHelper_Req_Failed_internal");
            throw new ExceptionRequestFailed(string6, (Throwable)exception);
        }
        SnmpValueObject snmpValueObject = new SnmpValueObject(varBind, object2);
        snmpValueObject.setIsEnum(bl);
        return snmpValueObject;
    }

    protected VarBind createVarBind(MibVar mibVar, Object object, String string) throws ExceptionUnknownMibName, ExceptionInvalidArgument, ExceptionRequestFailed {
        Object object2;
        VarBind varBind;
        if (mibVar.bIsScalor) {
            varBind = new VarBind(mibVar.szName);
        } else {
            object2 = string == null || string.length() == 0 ? "" : (string.startsWith(".") ? "" : ".");
            varBind = new VarBind(mibVar.szName + (String)object2 + string);
        }
        try {
            switch (mibVar.nAsnType) {
                case 2: {
                    if (mibVar.bIsEnum && object instanceof NameValue) {
                        object2 = (Integer)((NameValue)object).getValue();
                        varBind.setIntegerValue(((Integer)object2).intValue());
                        break;
                    }
                    if (object instanceof String) {
                        object2 = new Integer(((String)object).trim());
                        varBind.setIntegerValue(((Integer)object2).intValue());
                        break;
                    }
                    varBind.setIntegerValue(((Integer)object).intValue());
                    break;
                }
                case 5: {
                    varBind.setNullValue();
                    break;
                }
                case 65: 
                case 66: 
                case 67: {
                    object2 = (Long)object;
                    varBind.setUnsignedValue(((Long)object2).longValue(), mibVar.nAsnType);
                    break;
                }
                case 4: {
                    object2 = (String)object;
                    byte[] byArray = mibVar.bIsUtf8 ? ((String)object2).getBytes(UTF8_ENCODING) : ((String)object2).getBytes();
                    varBind.setOctetStringValue(byArray);
                    break;
                }
                case 3: 
                case 6: 
                case 64: {
                    varBind.setStringValue((String)object, mibVar.nAsnType);
                    break;
                }
                default: {
                    object2 = "Unknown syntax=" + mibVar.nAsnType;
                    throw new ExceptionRequestFailed((String)object2);
                }
            }
            return varBind;
        }
        catch (Exception exception) {
            String string2 = "createVarBind method failed for " + varBind.getName() + " (" + exception.getMessage() + ").";
            SnmpHelper.logError(string2, exception);
            string2 = res.getString("SnmpHelper_Req_Failed_internal");
            throw new ExceptionRequestFailed(string2, (Throwable)exception);
        }
    }

    protected VarBindList reorderPerOriginalRequest(VarBindList varBindList, Object[] objectArray) {
        VarBindList varBindList2 = null;
        int n = varBindList.size();
        if (varBindList != null && n > 0 && objectArray != null && objectArray.length > 0) {
            varBindList2 = new VarBindList();
            block2: for (int i = 0; i < objectArray.length; ++i) {
                for (int j = 0; j < n; ++j) {
                    try {
                        VarBind varBind = varBindList.varbindAt(j);
                        String string = varBind.getName();
                        if (string.indexOf((String)objectArray[i]) <= 0) continue;
                        varBindList2.addVarBind(varBind);
                        continue block2;
                    }
                    catch (ExceptionInvalidIndex exceptionInvalidIndex) {
                        SnmpHelper.logError("ExceptionInvalidIndex thrown by call to varbindAt method in VarBindList.  i=" + i + ", size of VarBindList is " + n, (Exception)((Object)exceptionInvalidIndex));
                    }
                }
            }
        }
        return varBindList2;
    }

    protected boolean isEmptyRow(VarBindList varBindList) {
        return false;
    }

    protected String findEmptyRow(AsmpConnection asmpConnection, Object object) throws ExceptionInvalidArgument, ExceptionSnmpRequestFailed, ExceptionRequestFailed, Exception {
        String string;
        block13: {
            string = null;
            try {
                String string2;
                String string3;
                int n;
                Object[] objectArray = new Object[]{this.getEmptyRowFieldId(object.toString())};
                VarBindList varBindList = this.createVarBindList(objectArray, "");
                if (varBindList.size() != 1) {
                    String string4 = "Size of varbind list=" + varBindList.size() + " returned by createVarBindList method is " + "more than one.";
                    SnmpHelper.logError(string4);
                    string4 = res.getString("SnmpHelper_Req_Failed_internal");
                    throw new ExceptionRequestFailed(string4);
                }
                SnmpRequest snmpRequest = new SnmpRequest(varBindList, null, "", 161, 0, 0);
                String string5 = "";
                while (true) {
                    SnmpHelper.logGetInfo("findEmptyRow", snmpRequest.getVarBindList());
                    SnmpHelper.logInfo("Making ASMP GetNext request.");
                    n = asmpConnection.asmpRequest(snmpRequest);
                    if (n != 0 || snmpRequest.getErrorStatus() != 0) break;
                    SnmpHelper.logInfo("ASMP GetNext request succeeded.");
                    VarBindList varBindList2 = snmpRequest.getVarBindList();
                    if (varBindList2 == null || varBindList2.size() == 0) {
                        SnmpHelper.logInfo("ASMP GetNext response empty--reached end of MIB.");
                        break block13;
                    }
                    if ((varBindList2 = this.reorderPerOriginalRequest(varBindList2, objectArray)).size() != objectArray.length) {
                        SnmpHelper.logInfo("ASMP GetNext reached end of table.");
                        break block13;
                    }
                    string3 = varBindList2.varbindAt(0);
                    string2 = string3.getName();
                    if (string2.equals(string5)) {
                        SnmpHelper.logError("GetNext returned previous OID (" + string2 + ").");
                        break block13;
                    }
                    string5 = string2;
                    if (this.isEmptyRow(varBindList2)) {
                        string = this.getInstance(varBindList2.varbindAt(0));
                        SnmpHelper.logError("Found empty row with index=" + string);
                        break block13;
                    }
                    snmpRequest.setNewVarBindList(varBindList2);
                }
                if (n == 2) {
                    SnmpHelper.logInfo("ASMP GetNext reached end of MIB.");
                    break block13;
                }
                if (n != 0) {
                    if (n < 256) {
                        int n2 = snmpRequest.getErrorIndex();
                        string2 = "ASMP GetNext request failed. AsmpStatus=" + n + ", SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + "), ErrorIndex=" + n2 + ".";
                        SnmpHelper.logError(string2);
                        string2 = SnmpHelper.getErrorStatusMessage(snmpRequest.getErrorStatus());
                        throw new ExceptionSnmpRequestFailed(string2, snmpRequest.getErrorStatus(), n2);
                    }
                    string3 = "ASMP GetNext request failed. AsmpStatus=" + n + " " + AsmpErrorStatus.getErrorStatusMessage((int)n) + ".";
                    SnmpHelper.logError(string3);
                    string3 = SnmpHelper.getErrorStatusMessage(n);
                    throw new ExceptionAsmpRequestFailed(string3, n);
                }
                if (snmpRequest.getErrorStatus() != 0) {
                    int n3 = snmpRequest.getErrorIndex();
                    string2 = "ASMP GetNext request failed. AsmpStatus=" + n + ", SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + "), ErrorIndex=" + n3 + ".";
                    SnmpHelper.logError(string2);
                    string2 = SnmpHelper.getErrorStatusMessage(snmpRequest.getErrorStatus());
                    throw new ExceptionSnmpRequestFailed(string2, snmpRequest.getErrorStatus(), n3);
                }
                string3 = "ASMP GetNext request failed. AsmpStatus=" + n + ", SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + ".";
                SnmpHelper.logError(string3);
                string3 = SnmpHelper.getErrorStatusMessage(n);
                throw new ExceptionRequestFailed(string3);
            }
            catch (Exception exception) {
                SnmpHelper.logError(exception.getMessage(), exception);
                String string6 = exception.getMessage();
                if (string6 == null || string6.trim().length() == 0) {
                    string6 = MessageFormat.format(res.getString("SnmpHelper_Request_Failed_ASMP_communications"), APPLIANCE);
                    throw new ExceptionRequestFailed(string6);
                }
                throw exception;
            }
        }
        return string;
    }

    protected String getEmptyRowFieldId(String string) throws ExceptionInvalidArgument {
        String string2 = "The table for identifier=" + string + " is not " + "supported by the getEmptyRowFieldId method.";
        SnmpHelper.logError(string2);
        string2 = res.getString("SnmpHelper_Req_Failed_internal");
        throw new ExceptionInvalidArgument(string2);
    }

    protected Object getEmptyRowFieldValue(String string) throws ExceptionInvalidArgument {
        String string2 = null;
        if (string.indexOf("dsManagerTable") != -1) {
            string2 = "0.0.0.0";
        } else if (string.indexOf("dsTrapHostTable") != -1) {
            string2 = "0.0.0.0";
        } else {
            String string3 = "The table for identifier=" + string + " is not " + "supported by the getEmptyRowFieldValue method.";
            SnmpHelper.logError(string3);
            string3 = res.getString("SnmpHelper_Req_Failed_internal");
            throw new ExceptionInvalidArgument(string3);
        }
        return string2;
    }

    protected String trimMibPrefix(String string) {
        String string2 = "iso.org.dod.internet.private.enterprises.";
        String string3 = "iso.org.dod.internet.mgmt.";
        String string4 = string.startsWith(string2) ? string.substring(41) : (string.startsWith(string3) ? string.substring(string3.length()) : string);
        return string4;
    }

    protected String trimInstance(String string) {
        int n = string.lastIndexOf(".");
        String string2 = n != -1 ? string.substring(0, n) : string;
        return string2;
    }

    protected String getInstance(VarBind varBind) {
        String string = this.trimInstance(varBind.getName());
        String string2 = varBind.getName().substring(string.length());
        return string2;
    }

    protected static void logGetInfo(String string, VarBindList varBindList) {
        SnmpHelper.logInfo(string + " retrieving the following MIB variables: ");
        Enumeration enumeration = varBindList.varbinds();
        while (enumeration.hasMoreElements()) {
            VarBind varBind = (VarBind)enumeration.nextElement();
            SnmpHelper.logInfo(varBind.getName());
        }
    }

    protected static void logSetInfo(String string, VarBindList varBindList, Object[] objectArray) {
        SnmpHelper.logInfo(string + " setting the following MIB variables and values: ");
        int n = 0;
        int n2 = objectArray.length;
        Enumeration enumeration = varBindList.varbinds();
        while (enumeration.hasMoreElements()) {
            VarBind varBind = (VarBind)enumeration.nextElement();
            String string2 = n < n2 ? objectArray[n++].toString() : "<no more field values>";
            SnmpHelper.logInfo(varBind.getName() + " = " + string2);
        }
    }

    protected static void logInfo(String string) {
        Trace.logInfo((String)"NMM: SnmpHelper", (String)string);
    }

    protected static void logError(String string) {
        Trace.logError((String)"NMM: SnmpHelper", (String)string);
    }

    protected static void logError(String string, Exception exception) {
        Trace.logError((String)"NMM: SnmpHelper", (String)string, (Throwable)exception);
    }

    protected void mvPut(String string, int n, boolean bl, boolean bl2) {
        MibVar mibVar = new MibVar(string, n, bl, bl2, false);
        this.m_htMibVarTable.put(string, mibVar);
    }

    protected void mvPut(String string, int n, boolean bl, boolean bl2, boolean bl3) {
        MibVar mibVar = new MibVar(string, n, bl, bl2, bl3);
        this.m_htMibVarTable.put(string, mibVar);
    }

    public static String getErrorStatusMessage(int n) {
        switch (n) {
            case 0: {
                return res.getString("SnmpHelper_ASMP_Request_successful");
            }
            default: {
                return MessageFormat.format(res.getString("SnmpHelper_ASMP_General_failure"), APPLIANCE);
            }
            case 3: {
                return res.getString("SnmpHelper_ASMP_Set_failed_badvalue");
            }
            case 4: {
                return res.getString("SnmpHelper_ASMP_Set_failed_readonly");
            }
            case 6: {
                return res.getString("SnmpHelper_ASMP_Request_failed_noaccess");
            }
            case 259: {
                return res.getString("SnmpHelper_ASMP_Unknown_User_Password");
            }
            case 260: {
                return res.getString("SnmpHelper_ASMP_Max_Sesions_Active");
            }
            case 261: {
                return res.getString("SnmpHelper_ASMP_No_User_Logged_In");
            }
            case 4096: {
                return MessageFormat.format(res.getString("SnmpHelper_ASMP_Request_timed_out_"), APPLIANCE);
            }
            case 268: 
        }
        return MessageFormat.format(res.getString("SnmpHelper_ASMP_Locked_User"), APPLIANCE);
    }

    public MacAddress getMacAddress(ThreadSnmpService threadSnmpService, SnmpSessionInfo snmpSessionInfo) throws Exception {
        MacAddress macAddress = null;
        int n = this.determineEthernetInterface(threadSnmpService, snmpSessionInfo);
        if (n <= 0) {
            Trace.logInfo((String)"SnmpHelper", (String)"Unable to locate Ethernet Interface");
            return null;
        }
        Object[] objectArray = new Object[]{"mib-2.interfaces.ifTable.ifEntry.ifPhysAddress"};
        InterfaceValueObject[] interfaceValueObjectArray = this.getMibValues(threadSnmpService, snmpSessionInfo, objectArray, Integer.toString(n));
        if (interfaceValueObjectArray.length == objectArray.length) {
            macAddress = new MacAddress(interfaceValueObjectArray[0].getByteArray());
        }
        return macAddress;
    }

    public int determineEthernetInterface(ThreadSnmpService threadSnmpService, SnmpSessionInfo snmpSessionInfo) throws Exception {
        boolean bl = false;
        int n = 0;
        Object[] objectArray = null;
        SnmpValueObject[] snmpValueObjectArray = null;
        SnmpHelper snmpHelper = new SnmpHelper();
        AsnObjectIdentifier asnObjectIdentifier = Mib.NameToOid((String)"mib-2.interfaces.ifTable.ifEntry.ifType");
        objectArray = new Object[]{"mib-2.interfaces.ifTable.ifEntry.ifType"};
        while ((snmpValueObjectArray = this.getNextMibValues(threadSnmpService, snmpSessionInfo, objectArray)).length == objectArray.length) {
            AsnObjectIdentifier asnObjectIdentifier2 = Mib.NameToOid((String)snmpValueObjectArray[0].getVarBind().getName());
            if (Mib.OidCompare((AsnObjectIdentifier)asnObjectIdentifier, (AsnObjectIdentifier)asnObjectIdentifier2) != asnObjectIdentifier.getOidValue().length || asnObjectIdentifier.getOidValue().length + 1 != asnObjectIdentifier2.getOidValue().length) {
                Trace.logInfo((String)"SnmpHelper", (String)"Unable to find ethernet interface");
                return 0;
            }
            n = snmpValueObjectArray[0].getInteger();
            if (n == 6) {
                return asnObjectIdentifier2.getOidValue()[asnObjectIdentifier2.getOidValue().length - 1];
            }
            objectArray = new Object[]{snmpValueObjectArray[0].getVarBind().getName()};
        }
        Trace.logError((String)"SnmpHelper", (String)"Incorrect dataset in SNMP response");
        return 0;
    }

    public InterfaceValueObject[] getMibValues(ThreadSnmpService threadSnmpService, SnmpSessionInfo snmpSessionInfo, Object[] objectArray, String string) throws ExceptionInvalidArgument, ExceptionSnmpRequestFailed, ExceptionRequestFailed, Exception {
        if (threadSnmpService == null || snmpSessionInfo == null || objectArray == null || objectArray.length == 0 || string == null) {
            String string2 = "getValues method called with an invalid argument.";
            SnmpHelper.logError(string2);
            string2 = res.getString("SnmpHelper_Req_Failed_internal");
            throw new ExceptionInvalidArgument(string2);
        }
        InterfaceValueObject[] interfaceValueObjectArray = new SnmpValueObject[objectArray.length];
        try {
            VarBindList varBindList = this.createVarBindList(objectArray, string);
            if (varBindList.size() != objectArray.length) {
                String string3 = "Size of varbind list=" + varBindList.size() + " returned by createVarBindList method is " + "less than requested number of fields=" + objectArray.length + ".";
                SnmpHelper.logError(string3);
                string3 = res.getString("SnmpHelper_Req_Failed_internal");
                throw new ExceptionRequestFailed(string3);
            }
            SnmpRequest snmpRequest = new SnmpRequest(varBindList, snmpSessionInfo.getAddress(), snmpSessionInfo.getCommunityPassword(), 160, snmpSessionInfo.getTimeout(), snmpSessionInfo.getRetries());
            SnmpHelper.logGetInfo("getValues", varBindList);
            SnmpHelper.logInfo("Making SNMP Get request.");
            if (!threadSnmpService.request(snmpRequest)) {
                String string4 = "SNMP Get request failed. , SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + "), ErrorIndex=" + snmpRequest.getErrorIndex() + ".";
                SnmpHelper.logError(string4);
                string4 = SnmpHelper.getErrorStatusMessage(snmpRequest.getErrorStatus());
                throw new ExceptionSnmpRequestFailed(string4, snmpRequest.getErrorStatus(), snmpRequest.getErrorIndex());
            }
            SnmpHelper.logInfo("SNMP Get request succeeded.");
            VarBindList varBindList2 = snmpRequest.getVarBindList();
            varBindList2 = this.reorderPerOriginalRequest(varBindList2, objectArray);
            if (varBindList2.size() != objectArray.length) {
                String string5 = "SNMP Get did not return all of the values requested.";
                SnmpHelper.logError(string5);
                string5 = res.getString("SnmpHelper_Req_Failed_internal");
                throw new ExceptionRequestFailed(string5);
            }
            for (int i = 0; i < varBindList2.size(); ++i) {
                VarBind varBind = varBindList2.varbindAt(i);
                interfaceValueObjectArray[i] = (SnmpValueObject)this.createReturnValue(varBind, objectArray[i]);
            }
        }
        catch (Exception exception) {
            SnmpHelper.logError(exception.getMessage(), exception);
            String string6 = exception.getMessage();
            if (string6 == null || string6.trim().length() == 0) {
                string6 = MessageFormat.format(res.getString("SnmpHelper_Unable_to_connect_to_Appliance0"), APPLIANCE);
                throw new ExceptionRequestFailed(string6);
            }
            throw exception;
        }
        return interfaceValueObjectArray;
    }

    public SnmpValueObject[] getNextMibValues(ThreadSnmpService threadSnmpService, SnmpSessionInfo snmpSessionInfo, Object[] objectArray) throws ExceptionInvalidArgument, ExceptionSnmpRequestFailed, ExceptionRequestFailed, Exception {
        if (threadSnmpService == null || snmpSessionInfo == null || objectArray == null || objectArray.length == 0) {
            String string = "getNextMibValues method called with an invalid argument.";
            SnmpHelper.logError(string);
            string = res.getString("SnmpHelper_Req_Failed_internal");
            throw new ExceptionInvalidArgument(string);
        }
        SnmpValueObject[] snmpValueObjectArray = new SnmpValueObject[objectArray.length];
        try {
            VarBindList varBindList = this.createVarBindList(objectArray, "", true);
            if (varBindList.size() != objectArray.length) {
                String string = "Size of varbind list=" + varBindList.size() + " returned by createVarBindList method is " + "less than requested number of fields=" + objectArray.length + ".";
                SnmpHelper.logError(string);
                string = res.getString("SnmpHelper_Req_Failed_internal");
                throw new ExceptionRequestFailed(string);
            }
            SnmpRequest snmpRequest = new SnmpRequest(varBindList, snmpSessionInfo.getAddress(), snmpSessionInfo.getCommunityPassword(), 161, snmpSessionInfo.getTimeout(), snmpSessionInfo.getRetries());
            SnmpHelper.logGetInfo("getNextMibValues", varBindList);
            SnmpHelper.logInfo("Making SNMP GetNext request.");
            if (!threadSnmpService.request(snmpRequest)) {
                String string = "SNMP GetNext request failed. , SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + "), ErrorIndex=" + snmpRequest.getErrorIndex() + ".";
                SnmpHelper.logError(string);
                string = SnmpHelper.getErrorStatusMessage(snmpRequest.getErrorStatus());
                throw new ExceptionSnmpRequestFailed(string, snmpRequest.getErrorStatus(), snmpRequest.getErrorIndex());
            }
            SnmpHelper.logInfo("SNMP GetNext request succeeded.");
            VarBindList varBindList2 = snmpRequest.getVarBindList();
            if (varBindList2 == null || varBindList2.size() == 0) {
                SnmpHelper.logInfo("SNMP GetNext response empty--reached end of MIB.");
            } else {
                if (varBindList2.size() != objectArray.length) {
                    String string = "SNMP GetNext did not return all of the values requested.";
                    SnmpHelper.logError(string);
                    string = res.getString("SnmpHelper_Req_Failed_internal");
                    throw new ExceptionRequestFailed(string);
                }
                for (int i = 0; i < varBindList2.size(); ++i) {
                    VarBind varBind = varBindList2.varbindAt(i);
                    snmpValueObjectArray[i] = (SnmpValueObject)this.createReturnValue(varBind, objectArray[i]);
                }
            }
        }
        catch (Exception exception) {
            SnmpHelper.logError(exception.getMessage(), exception);
            String string = exception.getMessage();
            if (string == null || string.trim().length() == 0) {
                string = MessageFormat.format(res.getString("SnmpHelper_Unable_to_connect_to_Appliance0"), APPLIANCE);
                throw new ExceptionRequestFailed(string);
            }
            throw exception;
        }
        return snmpValueObjectArray;
    }
}

