/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.common;

import com.avocent.avworks.nmm.common.InterfaceValueObject;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.gui.renderers.NameValue;
import com.avocent.protocols.snmp.VarBind;

public class SnmpValueObject
implements InterfaceValueObject {
    private VarBind m_vbInfo;
    private Object m_oValue;
    private boolean m_bIsEnum;

    public SnmpValueObject(VarBind varBind) {
        this(varBind, null);
    }

    public SnmpValueObject(VarBind varBind, Object object) {
        this.m_vbInfo = varBind;
        this.m_oValue = object;
        this.m_bIsEnum = false;
    }

    public VarBind getVarBind() {
        return this.m_vbInfo;
    }

    public Object getValue() {
        return this.m_oValue;
    }

    public void setValue(Object object) {
        this.m_oValue = object;
        if (this.m_vbInfo != null) {
            this.setVarBindValue(object);
        }
    }

    private void setVarBindValue(Object object) {
        try {
            int n = this.m_vbInfo.getSyntax();
            switch (n) {
                case 2: {
                    if (this.isEnum() && object instanceof NameValue) {
                        Integer n2 = (Integer)((NameValue)object).getValue();
                        this.m_vbInfo.setIntegerValue(n2.intValue());
                        break;
                    }
                    this.m_vbInfo.setIntegerValue(((Integer)object).intValue());
                    break;
                }
                case 5: {
                    this.m_vbInfo.setNullValue();
                    break;
                }
                case 65: 
                case 66: 
                case 67: {
                    Long l = (Long)object;
                    this.m_vbInfo.setUnsignedValue(l.longValue(), n);
                    break;
                }
                case 3: 
                case 6: 
                case 64: {
                    this.m_vbInfo.setStringValue((String)object, n);
                    break;
                }
                case 4: {
                    if (object instanceof byte[]) {
                        this.m_vbInfo.setOctetStringValue((byte[])object);
                        break;
                    }
                    this.m_vbInfo.setStringValue((String)object, n);
                    break;
                }
                default: {
                    String string = "Invalid syntax: " + n + " for VarBind.";
                    Trace.logError((String)"DS NMM: SnmpValueObject", (String)string);
                    break;
                }
            }
        }
        catch (Exception exception) {
            String string = "Setting value for SnmpValueObject=" + this.m_vbInfo.getName() + " (" + exception.getMessage() + ").";
            Trace.logError((String)"DS NMM: SnmpValueObject", (String)string);
            throw new RuntimeException("Unable to set value for " + this.m_vbInfo.getName());
        }
    }

    public String toString() {
        return this.m_oValue.toString();
    }

    public void setIsEnum(boolean bl) {
        this.m_bIsEnum = bl;
    }

    public boolean isEnum() {
        return this.m_bIsEnum;
    }

    public String getString() {
        return this.toString();
    }

    public Integer getInteger() throws Exception {
        if (this.m_oValue instanceof Integer) {
            return (Integer)this.m_oValue;
        }
        if (this.m_oValue instanceof NameValue) {
            return (Integer)((NameValue)this.m_oValue).getValue();
        }
        throw new Exception("Expecting a Integer and found a " + this.m_oValue.getClass().getName());
    }

    public byte[] getByteArray() throws Exception {
        if (this.m_vbInfo.getSyntax() == 4) {
            return this.m_vbInfo.getOctetStringValue();
        }
        throw new Exception("Cannot convert to byte[] from non AsnOctetString type.");
    }

    public Long getLong() throws Exception {
        if (this.m_oValue instanceof Long) {
            return (Long)this.m_oValue;
        }
        throw new Exception("Expecting a Long and found a " + this.m_oValue.getClass().getName());
    }

    public int compareTo(Object object) {
        if (object instanceof SnmpValueObject) {
            SnmpValueObject snmpValueObject = (SnmpValueObject)object;
            if (this.m_oValue instanceof Comparable) {
                return ((Comparable)this.m_oValue).compareTo(snmpValueObject.getValue());
            }
            if (this.m_oValue instanceof NameValue && snmpValueObject.getValue() instanceof NameValue) {
                return ((NameValue)this.m_oValue).getName().compareTo(((NameValue)snmpValueObject.getValue()).getName());
            }
        }
        return this.toString().compareTo(object.toString());
    }

    public boolean isStringComparable() {
        return this.m_oValue instanceof String || this.m_oValue instanceof NameValue;
    }
}

