/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.common;

import com.avocent.avworks.nmm.common.Appliance;
import com.avocent.avworks.nmm.common.Port;
import com.avocent.avworks.nmm.common.UserAccessLevel;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.util.InterfaceStringComparable;
import java.util.Vector;

public class User
implements InterfaceStringComparable,
Cloneable {
    Integer m_iUserId;
    String m_szName;
    String m_szPassword;
    boolean m_bIsLocked;
    Vector m_vPortList = new Vector();
    protected UserAccessLevel m_ualAccessLevel;
    static final /* synthetic */ boolean $assertionsDisabled;

    public User(Appliance appliance) throws ExceptionConstructorFailed {
        try {
            UserAccessLevel[] userAccessLevelArray = appliance.getAccessLevelArray();
            if (!$assertionsDisabled && userAccessLevelArray.length != 0) {
                throw new AssertionError((Object)"Could not create new user, user access level are not defined.");
            }
            this.m_szName = "";
            this.m_szPassword = "";
            this.m_ualAccessLevel = userAccessLevelArray[0];
            this.m_bIsLocked = false;
        }
        catch (Exception exception) {
            throw new ExceptionConstructorFailed("Failed to create a user instance: " + exception.getMessage(), (Throwable)exception);
        }
    }

    public User(Integer n, String string, String string2, UserAccessLevel userAccessLevel) {
        this.m_iUserId = n;
        this.m_szName = string;
        this.m_szPassword = string2;
        this.m_ualAccessLevel = userAccessLevel;
        this.m_bIsLocked = false;
        this.m_ualAccessLevel = userAccessLevel;
    }

    public User(Integer n, String string, String string2, boolean bl, UserAccessLevel userAccessLevel) {
        this.m_iUserId = n;
        this.m_szName = string;
        this.m_szPassword = string2;
        this.m_ualAccessLevel = userAccessLevel;
        this.m_bIsLocked = false;
        this.m_ualAccessLevel = userAccessLevel;
        this.m_bIsLocked = bl;
    }

    public Object clone() {
        User user = new User(this.m_iUserId, this.m_szName, this.m_szPassword, this.m_bIsLocked, this.m_ualAccessLevel);
        user.setAccessList((Vector)this.m_vPortList.clone());
        return user;
    }

    public void setAccessList(Vector vector) {
        if (this.m_vPortList != vector) {
            this.m_vPortList.removeAllElements();
            for (int i = 0; i < vector.size(); ++i) {
                this.m_vPortList.addElement(vector.elementAt(i));
            }
        }
    }

    public Vector getAccessList() {
        return this.m_vPortList;
    }

    public String toString() {
        return this.m_szName;
    }

    public void addPort(Port port) {
        this.m_vPortList.addElement(port);
    }

    public int getPortCount() {
        return this.m_vPortList.size();
    }

    public Port getPortAt(int n) {
        return (Port)this.m_vPortList.elementAt(n);
    }

    public void clearPortList() {
        this.m_vPortList.removeAllElements();
    }

    public int compareTo(Object object) {
        if (object instanceof User) {
            return this.m_szName.compareTo(((User)object).m_szName);
        }
        return 0;
    }

    public boolean isStringComparable() {
        return true;
    }

    public boolean isApplianceAdministrator() {
        return this.m_ualAccessLevel.getValue() == 20;
    }

    public boolean isAdministrator() {
        return this.m_ualAccessLevel.getValue() == 10;
    }

    public boolean isUser() {
        return this.m_ualAccessLevel.getValue() == 30;
    }

    public boolean isLocked() {
        return this.m_bIsLocked;
    }

    public void setLockStatus(boolean bl) {
        this.m_bIsLocked = bl;
    }

    public Integer getUserId() {
        return this.m_iUserId;
    }

    public String getName() {
        return this.m_szName;
    }

    public String getPassword() {
        return this.m_szPassword;
    }

    public UserAccessLevel getAccessLevel() {
        return this.m_ualAccessLevel;
    }

    public void setAccessLevel(UserAccessLevel userAccessLevel) {
        this.m_ualAccessLevel = userAccessLevel;
    }

    static {
        $assertionsDisabled = !User.class.desiredAssertionStatus();
    }
}

