/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.common;

import com.avocent.avworks.nmm.common.AmpController;
import com.avocent.avworks.nmm.common.Appliance;
import com.avocent.avworks.nmm.common.EditUserDialogController;
import com.avocent.avworks.nmm.common.ExceptionAsmpRequestFailed;
import com.avocent.avworks.nmm.common.ExceptionSnmpRequestFailed;
import com.avocent.avworks.nmm.common.InterfaceAmpPanelController;
import com.avocent.avworks.nmm.common.InterfaceController;
import com.avocent.avworks.nmm.common.JPanelUsersSettings;
import com.avocent.avworks.nmm.common.Port;
import com.avocent.avworks.nmm.common.User;
import com.avocent.avworks.nmm.common.model.AuthSupport;
import com.avocent.avworks.nmm.common.model.LdapSupport;
import com.avocent.avworks.services.AVWorksEventBroadcaster;
import com.avocent.avworks.services.InterfaceAVWorksEventBroadcasterListener;
import com.avocent.avworks.services.ServerInfo;
import com.avocent.avworks.services.ServersDb;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.gui.components.TableModelColumnSorted;
import com.avocent.lib.gui.dialogs.JOptionPaneFixedSize;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.ResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public abstract class UsersPanelController
extends InterfaceAmpPanelController
implements InterfaceController {
    public static final String CNAME = "UsersPanelController";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.common.Res");
    public static final String LOG_KEY = "UsersPanelController";
    private int COLUMN_LOCK_STATUS = -1;
    private int COLUMN_USER_NAME = -1;
    private int COLUMN_ACCESS_LEVEL = -1;
    private int NUM_COLUMNS = -1;
    private static final int MAX_CHARS_DURATION = 2;
    private static final int MIN_DURATION = 1;
    private static final int MAX_DURATION = 99;
    private DocumentListener dl = null;
    public static final String DEFAULT_DURATION_BLANK = "";
    public static final String BLANK_ICON = "blank11.gif";
    public static final String LOCK_NOT_SELECTED_ICON = "lock11.gif";
    public static final String LOCK_SELECTED_ICON = "locksel11.gif";
    protected boolean m_bTableColumnsSized = false;
    protected int m_nApplianceAdministratorCount = 0;
    protected ImageIcon m_iiUserSelLockedIcon = null;
    protected ImageIcon m_iiUserNotSelLockedIcon = null;
    protected ImageIcon m_iiUserUnlockedIcon = null;
    protected Hashtable m_hToDeleteUser = new Hashtable();
    protected Hashtable m_hToAddUser = new Hashtable();
    protected Hashtable m_hToModifyUser = new Hashtable();
    protected Hashtable m_hToModifyAccess = new Hashtable();
    protected Hashtable m_hToUnlockUser = new Hashtable();
    protected Vector m_vUserList = new Vector();
    protected Vector m_vPortList = new Vector();
    protected TableModelColumnSorted m_dtmUserTableModel;
    protected Hashtable m_hUserIdMap = new Hashtable();
    protected Hashtable m_hUserNameMap = new Hashtable();
    protected boolean m_bPortDataLoaded = false;
    protected InterfaceAVWorksEventBroadcasterListener m_broadcasterListener;
    protected Hashtable m_hRipToChannelCount = new Hashtable();
    protected JPanelUsersSettings m_jpusView;
    protected EditUserDialogController m_eudcEditUserController;
    protected boolean m_bIsSecLockoutSupported;
    private User m_uFailedUser;
    public static final int FULLY_ENABLED_MODE = 1;
    public static final int PASSWORD_DISABLED_MODE = 2;
    public static int DISABLED_MODE = 3;
    protected int m_mode;

    public UsersPanelController(AmpController ampController, String string, String string2, String string3, String string4) throws ExceptionConstructorFailed {
        super(ampController, string, string2, string3, string4);
        try {
            this.m_acAmpController.getAppliance().addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (UsersPanelController.this.m_nState != 101 && (propertyChangeEvent.getPropertyName().equalsIgnoreCase("LDAP_FOR_AUTH_ONLY") || propertyChangeEvent.getPropertyName().equalsIgnoreCase("LDAP_METHOD_IS_ENABLED") || propertyChangeEvent.getPropertyName().equalsIgnoreCase("LOCAL_METHOD_IS_ENABLED"))) {
                        try {
                            UsersPanelController.this.setupPanelMode();
                        }
                        catch (Exception exception) {
                            UsersPanelController.this.m_acAmpController.showException(null, "AMP Panel", null, exception);
                        }
                    }
                }
            });
            this.m_bIsSecLockoutSupported = ampController.getAppliance().isSecurityLockoutSupported();
            this.m_jpusView = (JPanelUsersSettings)this.createView();
            this.getContentPane().add((Component)this.m_jpusView, "Center");
            this.m_eudcEditUserController = this.createEditUserDialogController();
        }
        catch (Exception exception) {
            String string5 = res.getString("UsersPanelController_Failed_to_construct_JPUS");
            Trace.logError((String)"UsersPanelController", (String)"Constructor failed.", (Throwable)exception);
            throw new ExceptionConstructorFailed(string5, (Throwable)exception);
        }
    }

    public abstract EditUserDialogController createEditUserDialogController() throws ExceptionConstructorFailed;

    public boolean initialize() {
        try {
            this.m_nState = 101;
            this.m_vPortList.removeAllElements();
            this.m_vUserList.removeAllElements();
            this.m_nApplianceAdministratorCount = 0;
            this.m_hToAddUser = new Hashtable();
            this.m_hToDeleteUser = new Hashtable();
            this.m_hToModifyAccess = new Hashtable();
            this.m_hToModifyUser = new Hashtable();
            this.m_hToUnlockUser = new Hashtable();
            if (this.isSecLockoutSupported()) {
                int n;
                ItemListener[] itemListenerArray = this.m_jpusView.getLockoutCheckBox().getItemListeners();
                for (n = 0; n < itemListenerArray.length; ++n) {
                    this.m_jpusView.getLockoutCheckBox().removeItemListener(itemListenerArray[n]);
                }
                this.m_jpusView.getDurationTextField().getDocument().removeDocumentListener(this.dl);
                this.loadSecLockoutDuration();
                for (n = 0; n < itemListenerArray.length; ++n) {
                    this.m_jpusView.getLockoutCheckBox().addItemListener(itemListenerArray[n]);
                }
                this.m_jpusView.getDurationTextField().getDocument().addDocumentListener(this.dl);
            }
            this.setupPanelMode();
            this.loadUserTable();
            this.loadPortTable();
            this.setPanelState(103);
            this.m_bIsModified = false;
            return true;
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            this.m_nErrorStatus = exceptionAsmpRequestFailed.getErrorCode();
            this.logError(exceptionAsmpRequestFailed.getMessage(), (Exception)((Object)exceptionAsmpRequestFailed));
            return false;
        }
        catch (Exception exception) {
            String string = "Unable to initialize user settings panel.";
            this.logError(string, exception);
            return false;
        }
    }

    public void onDestroy() {
        this.logInfo("onDestroy() was called.");
        try {
            AVWorksEventBroadcaster.removeListener((InterfaceAVWorksEventBroadcasterListener)this.m_broadcasterListener);
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            Trace.logError((String)"AMP Panel", (String)"Error in onDestroy method.", (Throwable)exceptionInvalidArgument);
        }
    }

    public boolean onKillActive() {
        if (this.m_nState == 103 && !this.isValidSecLockoutDuration()) {
            String string = res.getString("UsersPanelController_Invalid_Duration");
            Message.show((Component)this.m_jpusView, (String)string);
            this.m_jpusView.getDurationTextField().grabFocus();
            return true;
        }
        return false;
    }

    public User getUserForId(Integer n) throws ExceptionNoValue {
        User user = (User)this.m_hUserIdMap.get(n);
        return user;
    }

    public User getUserForName(String string) throws ExceptionNoValue {
        User user = (User)this.m_hUserNameMap.get(string);
        if (user == null) {
            throw new ExceptionNoValue(res.getString("UsersPanelController_Unable_to_find_user"));
        }
        return user;
    }

    public boolean userExists(String string) {
        User user = (User)this.m_hUserNameMap.get(string);
        return user != null;
    }

    protected void loadUserTable() throws Exception {
        this.m_vUserList.removeAllElements();
        this.m_nApplianceAdministratorCount = 0;
        this.m_hUserIdMap.clear();
        this.m_hUserNameMap.clear();
        this.m_bPortDataLoaded = false;
        this.m_vPortList.removeAllElements();
        User[] userArray = this.m_acAmpController.getAppliance().loadUserTable();
        for (int i = 0; i < userArray.length; ++i) {
            User user = userArray[i];
            this.m_vUserList.addElement(user);
            this.m_hUserIdMap.put(user.m_iUserId, user);
            this.m_hUserNameMap.put(user.m_szName, user);
            if (!user.isApplianceAdministrator()) continue;
            ++this.m_nApplianceAdministratorCount;
        }
        this.resizeTableColumnWidths();
    }

    protected void loadPortTable() throws Exception {
        if (this.m_bPortDataLoaded) {
            return;
        }
        Port[] portArray = this.m_acAmpController.getAppliance().loadPortTable();
        for (int i = 0; i < portArray.length; ++i) {
            ServerInfo serverInfo = ServersDb.getServerInfo((int)this.m_acAmpController.getApplianceInfo().getID(), (int)portArray[i].getPortId());
            if (serverInfo != null) {
                portArray[i].setName(serverInfo.getName());
            }
            this.m_vPortList.addElement(portArray[i]);
            byte[] byArray = portArray[i].getRawAccessControlList();
            for (int j = 0; j < byArray.length; ++j) {
                User user = this.getUserForId(new Integer(byArray[j]));
                if (user == null) continue;
                user.addPort(portArray[i]);
            }
        }
        this.m_bPortDataLoaded = true;
    }

    public int getApplianceAdministratorCount() {
        return this.m_nApplianceAdministratorCount;
    }

    public JFrame getFrame() {
        return this.getAmpController().getMainFrame();
    }

    public int getPortCount() throws Exception {
        if (!this.m_bPortDataLoaded) {
            this.loadPortTable();
        }
        return this.m_vPortList.size();
    }

    public Port getPortAt(int n) throws Exception {
        if (!this.m_bPortDataLoaded) {
            this.loadPortTable();
        }
        return (Port)this.m_vPortList.elementAt(n);
    }

    public void addToAddUserList(User user) {
        if (this.m_hUserNameMap.get(user.m_szName) != null) {
            Message.show((Component)this.m_jpusView, (String)res.getString("UsersPanelController_duplicate_user_name"));
            return;
        }
        this.m_hToAddUser.put(user.m_szName, user);
        this.m_vUserList.addElement(user);
        if (user.isApplianceAdministrator()) {
            ++this.m_nApplianceAdministratorCount;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                UsersPanelController.this.m_dtmUserTableModel.fireTableDataChanged();
            }
        };
        SwingUtilities.invokeLater(runnable);
        this.m_hUserNameMap.put(user.m_szName, user);
        this.setIsModified(true);
    }

    public void addToModifyUserList(User user, boolean bl) {
        if (this.m_hToAddUser.get(user) == null) {
            this.m_hToModifyUser.put(user, user);
        }
        if (bl) {
            --this.m_nApplianceAdministratorCount;
        } else if (user.isApplianceAdministrator()) {
            ++this.m_nApplianceAdministratorCount;
        }
        this.setIsModified(true);
        Runnable runnable = new Runnable(){

            public void run() {
                UsersPanelController.this.m_dtmUserTableModel.fireTableDataChanged();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void addToModifyAccessList(User user) {
        this.m_hToModifyAccess.put(user, user);
        this.setIsModified(true);
    }

    public void modifyAction(ActionEvent actionEvent) {
        try {
            int[] nArray = this.m_jpusView.getUserTable().getSelectedRows();
            if (nArray.length == 0) {
                Message.show((Component)this.getView(), (String)res.getString("UsersPanelController_Please_select_a_user"));
                return;
            }
            User user = (User)this.m_jpusView.getUserTable().getValueAt(nArray[0], this.COLUMN_USER_NAME);
            this.m_eudcEditUserController.showModifyUser(user);
        }
        catch (Exception exception) {
            this.logError("Exception while attempting to showt the modify user dialog.", exception);
            String string = res.getString("UsersPanelController_Error_while");
            Message.show((Component)this.getView(), (String)string);
        }
    }

    public void deleteAction(ActionEvent actionEvent) {
        int n;
        int[] nArray = this.m_jpusView.getUserTable().getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        Vector<User> vector = new Vector<User>();
        for (n = 0; n < nArray.length; ++n) {
            vector.addElement((User)this.m_jpusView.getUserTable().getValueAt(nArray[n], this.COLUMN_USER_NAME));
        }
        n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            if (!((User)vector.elementAt(i)).isApplianceAdministrator()) continue;
            ++n;
        }
        Appliance appliance = this.m_acAmpController.getAppliance();
        if (!appliance.isFeatureSupported("OverrideAdminUser") && this.getApplianceAdministratorCount() - n < 1) {
            String string = res.getString("UsersPanelController_Cannot_remove_last_app_admin");
            Object[] objectArray = new Object[]{this.m_acAmpController.getAppliance().getApplianceAdministratorLabel()};
            string = MessageFormat.format(string, objectArray);
            Message.show((Component)this.getAmpController().getMainFrame(), (String)string);
            return;
        }
        String string = res.getString("UsersPanelController_Delete_0_selected");
        Object[] objectArray = new Object[]{DEFAULT_DURATION_BLANK + nArray.length};
        string = MessageFormat.format(string, objectArray);
        int n2 = JOptionPaneFixedSize.showConfirmDialog((Component)this.getView(), (Object)string, (String)res.getString("UsersPanelController_Confirm_Deletion"), (int)0);
        if (n2 == 0) {
            this.m_jpusView.getUserTable().clearSelection();
            Arrays.sort(nArray);
            for (int i = 0; i < vector.size(); ++i) {
                User user = (User)vector.elementAt(i);
                if (user.m_iUserId != null && this.m_hUserIdMap.get(user.m_iUserId) != null) {
                    this.m_hToDeleteUser.put(user.m_szName, user);
                }
                this.m_vUserList.remove(user);
                if (user.isApplianceAdministrator()) {
                    --this.m_nApplianceAdministratorCount;
                }
                this.m_hToModifyUser.remove(user);
                this.m_hToModifyAccess.remove(user);
                this.m_hToAddUser.remove(user.m_szName);
                if (user.m_iUserId != null) {
                    this.m_hUserIdMap.remove(user.m_iUserId);
                }
                this.m_hUserNameMap.remove(user.m_szName);
            }
            this.m_dtmUserTableModel.fireTableDataChanged();
            this.setIsModified(true);
        }
    }

    public void addAction(ActionEvent actionEvent) {
        try {
            int n = this.m_vUserList.size();
            if (n >= 64) {
                Message.show((Component)this.getView(), (String)res.getString("UsersPanelController_Maximum_number_of"));
                return;
            }
            this.m_eudcEditUserController.showAddUser();
        }
        catch (Exception exception) {
            this.logError("Exception while showing add user dialog.", exception);
            Message.show((Component)this.getView(), (String)res.getString("UsersPanelController_Exception_while"));
        }
    }

    public void unlockAction(ActionEvent actionEvent) {
        int n = 0;
        int[] nArray = this.m_jpusView.getUserTable().getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            User user = (User)this.m_dtmUserTableModel.getValueAt(nArray[i], this.COLUMN_USER_NAME);
            user.setLockStatus(false);
            this.m_hToUnlockUser.put(user.m_szName, user);
            ++n;
        }
        if (n > 0) {
            Runnable runnable = new Runnable(){

                public void run() {
                    UsersPanelController.this.m_dtmUserTableModel.fireTableRowsUpdated(0, UsersPanelController.this.m_jpusView.getUserTable().getRowCount() - 1);
                    UsersPanelController.this.m_jpusView.getUnlockButton().setEnabled(false);
                    UsersPanelController.this.m_jpusView.getUserTable().grabFocus();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
            this.setIsModified(true);
        }
    }

    public boolean applyValues() {
        try {
            if (this.isSecLockoutSupported()) {
                ((JPanel)this.getView()).grabFocus();
                if (!this.applySecurityLockoutChanges()) {
                    return false;
                }
            }
            try {
                this.applyDeleteChanges();
            }
            catch (ExceptionSnmpRequestFailed exceptionSnmpRequestFailed) {
                Object object;
                Trace.logError((String)"AMP Panel", (String)("Error while attempting to delete user: " + exceptionSnmpRequestFailed.getMessage()), (Throwable)((Object)exceptionSnmpRequestFailed));
                if (this.m_uFailedUser != null) {
                    this.m_hToDeleteUser.remove(this.m_uFailedUser.getName());
                    this.m_vUserList.add(this.m_uFailedUser);
                    this.m_hUserIdMap.put(this.m_uFailedUser.m_iUserId, this.m_uFailedUser);
                    this.m_hUserNameMap.put(this.m_uFailedUser.m_szName, this.m_uFailedUser);
                    if (this.m_uFailedUser.isApplianceAdministrator()) {
                        ++this.m_nApplianceAdministratorCount;
                    }
                    object = new Runnable(){

                        public void run() {
                            UsersPanelController.this.m_dtmUserTableModel.fireTableDataChanged();
                        }
                    };
                    SwingUtilities.invokeLater((Runnable)object);
                }
                object = res.getString("UsersPanelController_Users_Delete_Failed");
                Object[] objectArray = new Object[]{this.m_uFailedUser.getName()};
                object = MessageFormat.format((String)object, objectArray);
                String string = res.getString("UsersPanelController_overwrite_file");
                Message.showReasonMessage((Component)this.m_acAmpController.getMainFrame(), (String)string, (String)object);
                return false;
            }
            try {
                this.applyAddAndModifyChanges();
            }
            catch (ExceptionSnmpRequestFailed exceptionSnmpRequestFailed) {
                Trace.logError((String)"AMP Panel", (String)("Error while applying user data changes: " + exceptionSnmpRequestFailed.getMessage()), (Throwable)((Object)exceptionSnmpRequestFailed));
                if (exceptionSnmpRequestFailed.getErrorIndex() == 2) {
                    String string = res.getString("UsersPanelController_Password_Invalid");
                    Object[] objectArray = new Object[]{this.m_uFailedUser.getName()};
                    string = MessageFormat.format(string, objectArray);
                    Message.show((Component)this.m_jpusView, (String)string);
                } else {
                    String string = res.getString("UsersPanelController_Users_Apply_Failed_User");
                    Object[] objectArray = new Object[]{this.m_uFailedUser.getName()};
                    string = MessageFormat.format(string, objectArray);
                    Message.show((Component)this.m_jpusView, (String)(string + " " + exceptionSnmpRequestFailed.getMessage()));
                }
                return false;
            }
            catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
                this.m_nErrorStatus = exceptionAsmpRequestFailed.getErrorCode();
                this.logError(exceptionAsmpRequestFailed.getMessage(), (Exception)((Object)exceptionAsmpRequestFailed));
                String string = res.getString("UsersPanelController_Users_Apply_Failed");
                Message.show((Component)this.m_jpusView, (String)(string + " " + exceptionAsmpRequestFailed.getMessage()));
                return false;
            }
            this.applyAccessListChanges();
            if (this.getView().isShowing()) {
                this.initialize();
            }
            return true;
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            this.m_nErrorStatus = exceptionAsmpRequestFailed.getErrorCode();
            this.logError(exceptionAsmpRequestFailed.getMessage(), (Exception)((Object)exceptionAsmpRequestFailed));
            String string = res.getString("UsersPanelController_Users_Apply_Failed");
            Message.show((Component)this.getView(), (String)(string + " " + exceptionAsmpRequestFailed.getMessage()));
            return false;
        }
        catch (Exception exception) {
            Trace.logError((String)"AMP Panel", (String)"Exception while applying user settings: ", (Throwable)exception);
            String string = res.getString("UsersPanelController_Error_while_modifying");
            Message.show((Component)this.getView(), (String)string);
            return false;
        }
    }

    protected boolean isValidSecLockoutDuration() {
        try {
            String string = this.m_jpusView.getDurationTextField().getText().trim();
            if (string.length() == 0) {
                return !this.m_jpusView.getLockoutCheckBox().isSelected();
            }
            int n = Integer.parseInt(string);
            if (this.m_jpusView.getLockoutCheckBox().isSelected() && (n < 1 || n > 99)) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private void enableSecLockoutDuration() {
        this.m_jpusView.getDurationTextField().setEnabled(true);
        this.m_jpusView.getDurationTextField().setEditable(true);
    }

    private void disableSecLockoutDuration() {
        this.m_jpusView.getDurationTextField().setEnabled(false);
        this.m_jpusView.getDurationTextField().setEditable(false);
        this.m_jpusView.getDurationTextField().setText(DEFAULT_DURATION_BLANK);
    }

    private void loadSecLockoutDuration() {
        try {
            int n = this.m_acAmpController.getAppliance().getSecurityLockoutDuration();
            if (n == 0) {
                this.m_jpusView.getLockoutCheckBox().setSelected(false);
                this.disableSecLockoutDuration();
            } else {
                this.m_jpusView.getLockoutCheckBox().setSelected(true);
                this.enableSecLockoutDuration();
                this.m_jpusView.getDurationTextField().setText(Integer.toString(n));
            }
        }
        catch (Exception exception) {
            this.disableSecLockoutDuration();
            return;
        }
    }

    protected void resizeTableColumnWidths() {
        Runnable runnable = new Runnable(){

            public void run() {
                if (!UsersPanelController.this.m_bTableColumnsSized) {
                    UsersPanelController.this.m_dtmUserTableModel.packAllColumns(2);
                    if (UsersPanelController.this.isSecLockoutSupported()) {
                        DefaultTableColumnModel defaultTableColumnModel = (DefaultTableColumnModel)UsersPanelController.this.m_jpusView.getUserTable().getColumnModel();
                        TableColumn tableColumn = defaultTableColumnModel.getColumn(UsersPanelController.this.COLUMN_LOCK_STATUS);
                    }
                    UsersPanelController.this.m_dtmUserTableModel.sortByColumn(UsersPanelController.this.COLUMN_USER_NAME, true);
                    UsersPanelController.this.m_bTableColumnsSized = true;
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private boolean isSecLockoutSupported() {
        return this.m_bIsSecLockoutSupported;
    }

    protected boolean applySecurityLockoutChanges() throws Exception {
        if (!this.isValidSecLockoutDuration()) {
            String string = res.getString("UsersPanelController_Invalid_Duration");
            Message.show((Component)this.m_jpusView, (String)string);
            this.m_jpusView.getDurationTextField().grabFocus();
            return false;
        }
        Appliance appliance = this.m_acAmpController.getAppliance();
        int n = appliance.getSecurityLockoutDuration();
        String string = this.m_jpusView.getDurationTextField().getText().trim();
        int n2 = 0;
        if (string.length() > 0) {
            n2 = Integer.parseInt(string);
        }
        if (n != n2) {
            appliance.setSecurityLockoutDuration(n2);
        }
        Enumeration enumeration = this.m_hToUnlockUser.elements();
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            User user = (User)enumeration2.nextElement();
            boolean bl = false;
            Enumeration enumeration3 = this.m_hToDeleteUser.elements();
            while (enumeration3.hasMoreElements()) {
                User user2 = (User)enumeration3.nextElement();
                if (!user.getName().equals(user2.getName())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            try {
                appliance.unlockUser(user.getName());
                this.m_hToUnlockUser.remove(user.getName());
            }
            catch (ExceptionSnmpRequestFailed exceptionSnmpRequestFailed) {
                Trace.logError((String)"AMP Panel", (String)("Error while attempting to unlock user \"" + user.getName() + "\" : " + exceptionSnmpRequestFailed.getMessage()), (Throwable)((Object)exceptionSnmpRequestFailed));
                this.m_hToUnlockUser.remove(user.getName());
                user.setLockStatus(true);
                String string2 = res.getString("UsersPanelController_Users_Unlock_Failed");
                Object[] objectArray = new Object[]{user.getName()};
                string2 = MessageFormat.format(string2, objectArray);
                String string3 = res.getString("UsersPanelController_overwrite_file");
                Message.showReasonMessage((Component)this.m_acAmpController.getMainFrame(), (String)string3, (String)string2);
                Runnable runnable = new Runnable(){

                    public void run() {
                        UsersPanelController.this.m_dtmUserTableModel.fireTableRowsUpdated(0, UsersPanelController.this.m_jpusView.getUserTable().getRowCount() - 1);
                        UsersPanelController.this.m_bIsModified = UsersPanelController.this.m_hToUnlockUser.size() > 0;
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeLater(runnable);
                }
                return false;
            }
        }
        return true;
    }

    protected void applyDeleteChanges() throws Exception {
        Enumeration enumeration = this.m_hToDeleteUser.elements();
        Appliance appliance = this.m_acAmpController.getAppliance();
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        for (int i = 0; i < vector.size(); ++i) {
            User user;
            this.m_uFailedUser = user = (User)vector.elementAt(i);
            appliance.deleteUser(user);
            this.m_hToDeleteUser.remove(user.getName());
        }
    }

    protected void applyAddAndModifyChanges() throws Exception {
        User user = null;
        Appliance appliance = this.m_acAmpController.getAppliance();
        Enumeration enumeration = this.m_hToAddUser.elements();
        while (enumeration.hasMoreElements()) {
            this.m_uFailedUser = user = (User)enumeration.nextElement();
            appliance.addUser(user);
        }
        enumeration = this.m_hToModifyUser.elements();
        while (enumeration.hasMoreElements()) {
            this.m_uFailedUser = user = (User)enumeration.nextElement();
            appliance.modifyUser(user);
        }
    }

    protected void applyAccessListChanges() throws Exception {
        Enumeration enumeration = this.m_hToModifyAccess.elements();
        Appliance appliance = this.m_acAmpController.getAppliance();
        while (enumeration.hasMoreElements()) {
            User user = (User)enumeration.nextElement();
            if (!user.isUser()) continue;
            appliance.clearPortAccessList(user);
            for (int i = 0; i < user.getPortCount(); ++i) {
                Port port = user.getPortAt(i);
                appliance.setPortAccess(user, port);
            }
        }
    }

    public Component createView() {
        this.m_jpusView = new JPanelUsersSettings(this, this.isSecLockoutSupported());
        this.initializeView();
        return this.m_jpusView;
    }

    public Component getView() {
        if (this.m_jpusView == null) {
            this.createView();
        }
        return this.m_jpusView;
    }

    public void initializeView() {
        this.m_iiUserSelLockedIcon = this.loadImageIcon(LOCK_SELECTED_ICON, this.getClass());
        this.m_iiUserNotSelLockedIcon = this.loadImageIcon(LOCK_NOT_SELECTED_ICON, this.getClass());
        this.m_iiUserUnlockedIcon = this.loadImageIcon(BLANK_ICON, this.getClass());
        if (this.isSecLockoutSupported()) {
            this.COLUMN_LOCK_STATUS = 0;
            this.COLUMN_USER_NAME = 1;
            this.COLUMN_ACCESS_LEVEL = 2;
            this.NUM_COLUMNS = 3;
        } else {
            this.COLUMN_USER_NAME = 0;
            this.COLUMN_ACCESS_LEVEL = 1;
            this.NUM_COLUMNS = 2;
        }
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (object != null) {
                    if (object instanceof LockStatus) {
                        ImageIcon imageIcon = UsersPanelController.this.m_iiUserUnlockedIcon;
                        this.setHorizontalAlignment(2);
                        int n3 = ((LockStatus)object).getState();
                        if (n3 == 1) {
                            imageIcon = bl ? UsersPanelController.this.m_iiUserSelLockedIcon : UsersPanelController.this.m_iiUserNotSelLockedIcon;
                        }
                        this.setIcon(imageIcon);
                        this.setText(UsersPanelController.DEFAULT_DURATION_BLANK);
                    } else {
                        this.setHorizontalAlignment(2);
                        this.setIcon(null);
                        this.setText(object.toString());
                    }
                }
                this.setBorder(bl2 && jTable.getRowSelectionAllowed() ? UIManager.getBorder("Table.focusCellHighlightBorder") : DefaultTableCellRenderer.noFocusBorder);
                return this;
            }
        };
        UserTableModel userTableModel = new UserTableModel();
        this.m_dtmUserTableModel = new TableModelColumnSorted((TableModel)userTableModel, this.m_jpusView.getUserTable());
        this.m_dtmUserTableModel.fireTableStructureChanged();
        this.m_jpusView.getUserTable().setDefaultRenderer(ImageIcon.class, defaultTableCellRenderer);
        this.m_jpusView.getUserTable().setDefaultRenderer(String.class, defaultTableCellRenderer);
        this.m_jpusView.getUserTable().setAutoResizeMode(3);
        this.m_jpusView.getUserTable().setColumnSelectionAllowed(false);
        this.m_jpusView.getUserTable().getTableHeader().setReorderingAllowed(false);
        this.m_jpusView.getUserTable().setShowGrid(false);
        this.m_jpusView.getUserTable().setIntercellSpacing(new Dimension(0, 0));
        this.m_jpusView.getUnlockButton().setEnabled(false);
        this.m_jpusView.getDeleteButton().setEnabled(false);
        this.m_jpusView.getModifyButton().setEnabled(false);
        this.dl = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                UsersPanelController.this.setIsModified(true);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                UsersPanelController.this.setIsModified(true);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        this.m_jpusView.getDurationTextField().getDocument().addDocumentListener(this.dl);
        this.m_jpusView.getUserTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (UsersPanelController.this.m_jpusView.getUserTable().getSelectedRowCount() > 0) {
                    UsersPanelController.this.m_jpusView.getDeleteButton().setEnabled(true);
                    UsersPanelController.this.m_jpusView.getUnlockButton().setEnabled(UsersPanelController.this.selectedUsersAreLocked());
                } else {
                    UsersPanelController.this.m_jpusView.getDeleteButton().setEnabled(false);
                    UsersPanelController.this.m_jpusView.getUnlockButton().setEnabled(false);
                }
                if (UsersPanelController.this.m_jpusView.getUserTable().getSelectedRowCount() == 1) {
                    UsersPanelController.this.m_jpusView.getModifyButton().setEnabled(true);
                } else {
                    UsersPanelController.this.m_jpusView.getModifyButton().setEnabled(false);
                }
            }
        });
        this.m_jpusView.getLockoutCheckBox().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n = itemEvent.getStateChange();
                if (n == 1) {
                    UsersPanelController.this.setIsModified(true);
                    UsersPanelController.this.enableSecLockoutDuration();
                    return;
                }
                if (n == 2) {
                    UsersPanelController.this.setIsModified(true);
                    UsersPanelController.this.disableSecLockoutDuration();
                    return;
                }
            }
        });
    }

    public void setVisible(boolean bl) {
        this.m_jpusView.setVisible(bl);
    }

    protected void updateViewsImpl() {
    }

    protected String setErrorFieldFocus(Object object) {
        return null;
    }

    public void setErrorFieldFocus(int n) {
    }

    protected boolean validateInputFields() {
        return true;
    }

    protected boolean applyValuesImpl() {
        return true;
    }

    protected boolean initializeImpl() {
        return true;
    }

    void setupPanelMode() throws Exception {
        Appliance appliance = this.m_acAmpController.getAppliance();
        LdapSupport ldapSupport = appliance.getLdapSupport();
        AuthSupport authSupport = appliance.getLocalAuthSupport();
        boolean bl = true;
        if (appliance.isFeatureSupported("LDAPAuthenticationSupport")) {
            bl = authSupport.getIsEnabled(false);
        }
        int n = DISABLED_MODE;
        if (bl) {
            n = 1;
        } else if (ldapSupport.getIsLicensed(false) && ldapSupport.getIsEnabled(false)) {
            n = ldapSupport.getIsEnabled() && ldapSupport.isLdapForAuthOnly(false) ? 2 : DISABLED_MODE;
        }
        this.setMode(n);
    }

    public void setMode(int n) {
        this.m_mode = n;
        Color color = UIManager.getColor("control");
        Color color2 = UIManager.getColor("TextField.background");
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = this.m_jpusView.getLockoutCheckBox().isSelected();
        if (n == DISABLED_MODE) {
            bl = false;
            bl2 = false;
        } else if (n == 1) {
            bl = true;
            bl2 = true;
        } else if (n == 2) {
            bl = true;
            bl2 = false;
        }
        int n2 = this.m_jpusView.getUserTable().getSelectedRowCount();
        this.m_jpusView.getAddButton().setEnabled(bl);
        this.m_jpusView.getModifyButton().setEnabled(bl && n2 == 1);
        this.m_jpusView.getDeleteButton().setEnabled(bl && n2 >= 1);
        this.m_jpusView.getUnlockButton().setEnabled(bl && this.selectedUsersAreLocked());
        this.m_jpusView.getUserTable().setEnabled(bl);
        this.m_jpusView.getUserTable().setBackground(bl ? color2 : color);
        this.m_jpusView.getUserTableScrollPane().getViewport().setBackground(bl ? color2 : color);
        this.m_jpusView.getLockoutCheckBox().setEnabled(bl2);
        this.m_jpusView.getDurationTextField().setEnabled(bl2 && bl3);
        this.m_jpusView.getDurationTextField().setBackground(bl2 && bl3 ? color2 : color);
        if (!bl) {
            this.m_jpusView.getUserTable().clearSelection();
        }
    }

    public int getMode() {
        return this.m_mode;
    }

    private boolean selectedUsersAreLocked() {
        int[] nArray = this.m_jpusView.getUserTable().getSelectedRows();
        if (nArray.length == 0) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            User user = (User)this.m_jpusView.getUserTable().getValueAt(nArray[i], this.COLUMN_USER_NAME);
            if (user.isLocked()) continue;
            return false;
        }
        return true;
    }

    class UserTableModel
    extends AbstractTableModel {
        String[] m_aszColumnName;

        UserTableModel() {
            int n = 0;
            if (UsersPanelController.this.m_bIsSecLockoutSupported) {
                this.m_aszColumnName = new String[3];
                this.m_aszColumnName[0] = res.getString("UsersPanelController_Status");
                n = 1;
            } else {
                this.m_aszColumnName = new String[2];
            }
            this.m_aszColumnName[0 + n] = res.getString("UsersPanelController_Name");
            this.m_aszColumnName[1 + n] = res.getString("UsersPanelController_Access_Level");
        }

        public int getColumnCount() {
            return UsersPanelController.this.NUM_COLUMNS;
        }

        public int getRowCount() {
            return UsersPanelController.this.m_vUserList.size();
        }

        public String getColumnName(int n) {
            return this.m_aszColumnName[n];
        }

        public Class getColumnClass(int n) {
            if (UsersPanelController.this.isSecLockoutSupported()) {
                Class clazz = n == UsersPanelController.this.COLUMN_LOCK_STATUS ? (class$javax$swing$ImageIcon == null ? (class$javax$swing$ImageIcon = UsersPanelController.class$("javax.swing.ImageIcon")) : class$javax$swing$ImageIcon) : (class$java$lang$String == null ? (class$java$lang$String = UsersPanelController.class$("java.lang.String")) : class$java$lang$String);
                return clazz;
            }
            return class$java$lang$String == null ? (class$java$lang$String = UsersPanelController.class$("java.lang.String")) : class$java$lang$String;
        }

        public Object getValueAt(int n, int n2) {
            User user = (User)UsersPanelController.this.m_vUserList.elementAt(n);
            if (UsersPanelController.this.isSecLockoutSupported() && n2 == UsersPanelController.this.COLUMN_LOCK_STATUS) {
                return new LockStatus(user.isLocked());
            }
            if (n2 == UsersPanelController.this.COLUMN_USER_NAME) {
                return user;
            }
            if (n2 == UsersPanelController.this.COLUMN_ACCESS_LEVEL) {
                return user.getAccessLevel();
            }
            throw new RuntimeException(res.getString("UsersPanelController_Invalid_column_index_"));
        }
    }

    class LockStatus
    implements Comparable {
        static final int LOCKED = 1;
        static final int UNLOCKED = 2;
        protected int m_nState;
        protected boolean m_bLockStatus;

        public LockStatus(boolean bl) {
            this.m_bLockStatus = bl;
            this.m_nState = this.m_bLockStatus ? 1 : 2;
        }

        public int getState() {
            return this.m_nState;
        }

        public void setState(int n) {
            this.m_nState = n;
        }

        public int compareTo(Object object) {
            if (object instanceof LockStatus) {
                LockStatus lockStatus = (LockStatus)object;
                if (lockStatus.m_nState > this.m_nState) {
                    return -1;
                }
                if (lockStatus.m_nState < this.m_nState) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }
    }
}

