/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.common.authentication;

import com.avocent.avworks.nmm.common.AmpController;
import com.avocent.avworks.nmm.common.Appliance;
import com.avocent.avworks.nmm.common.BadFieldValueException;
import com.avocent.avworks.nmm.common.ExceptionAsmpRequestFailed;
import com.avocent.avworks.nmm.common.ExceptionSnmpRequestFailed;
import com.avocent.avworks.nmm.common.InterfaceAmpPanelController;
import com.avocent.avworks.nmm.common.InterfaceController;
import com.avocent.avworks.nmm.common.authentication.AuthMethodController;
import com.avocent.avworks.nmm.common.authentication.LdapController;
import com.avocent.avworks.nmm.common.authentication.LdapSimpleController;
import com.avocent.avworks.nmm.common.authentication.LocalAuthController;
import com.avocent.avworks.nmm.common.authentication.MethodSelectionController;
import com.avocent.avworks.nmm.common.authentication.PrioritizedLdapSelectionController;
import com.avocent.avworks.nmm.common.authentication.PrioritizedMethodSelectionController;
import com.avocent.avworks.nmm.common.authentication.RadiusController;
import com.avocent.avworks.nmm.common.authentication.SingleMethodSelectionController;
import com.avocent.avworks.nmm.common.authentication.components.AuthSettingsPanel;
import com.avocent.avworks.nmm.common.model.ApplianceRequest;
import com.avocent.avworks.nmm.common.model.LdapSupport;
import com.avocent.avworks.nmm.common.model.RadiusSupport;
import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public abstract class AuthSettingsPanelController
extends InterfaceAmpPanelController
implements InterfaceController,
PropertyChangeListener {
    public static final String TRACE_CTXT = "Auth Panel";
    public static final String CNAME = "JPanelAuthSettings";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    protected ArrayList m_authMethodControllerList = new ArrayList();
    protected MethodSelectionController m_methodSelectionController;
    protected AuthSettingsPanel m_view = (AuthSettingsPanel)this.createView();

    public AuthSettingsPanelController(AmpController ampController) throws Exception {
        super(ampController, res.getString("JPanelAuthSettings_Authentication"), res.getString("JPanelAuthSettings_Global") + " - " + res.getString("JPanelAuthSettings_Authentication"), res.getString("JPanelAuthSettings_Specify_auth"), "IDH_SETTINGS_AUTHENTICATION");
        Object object;
        this.m_authMethodControllerList = new ArrayList();
        if (this.isLocalAuthAvailable()) {
            this.m_authMethodControllerList.add(new LocalAuthController(this));
        }
        if (this.isLDAPAuthAvailable() && this.useSimpleLDAPAuth()) {
            this.m_authMethodControllerList.add(new LdapSimpleController(this));
        } else if (this.isLDAPAuthAvailable()) {
            this.m_authMethodControllerList.add(new LdapController(this));
        }
        if (this.isRadiusAuthAvailable()) {
            this.m_authMethodControllerList.add(new RadiusController(this));
        }
        if (this.m_authMethodControllerList.size() == 0) {
            throw new Exception("No authentication methods selected.");
        }
        LinkedHashMap<String, JPanel> linkedHashMap = new LinkedHashMap<String, JPanel>();
        for (int i = 0; i < this.m_authMethodControllerList.size(); ++i) {
            object = (AuthMethodController)this.m_authMethodControllerList.get(i);
            JPanel jPanel = object.getOptionsPanel();
            if (jPanel == null) continue;
            String string = this.m_acAmpController.getResource(object.getShortNameKey());
            linkedHashMap.put(string, jPanel);
        }
        Iterator iterator = linkedHashMap.entrySet().iterator();
        if (linkedHashMap.size() == 1) {
            object = iterator.next();
            this.m_view.getOptionsContainer().add((Component)object.getValue());
        } else if (linkedHashMap.size() > 1) {
            while (iterator.hasNext()) {
                object = iterator.next();
                this.m_view.getOptionsTabbedPane().add((Component)object.getValue(), (String)object.getKey());
            }
        }
        this.m_view.showNoAuthMethodOptions();
        this.getContentPane().add(this.m_view);
        this.m_methodSelectionController = ampController.isFeatureSupported("AvrLdapWithLocalAlwaysSelectionMethod") ? new PrioritizedLdapSelectionController(this) : (AVWorksBranding.getBoolean((String)"singleAuthMethodSelection", (boolean)false) ? new SingleMethodSelectionController(this) : new PrioritizedMethodSelectionController(this));
        this.registerPropertyListeners();
    }

    public boolean isLocalAuthAvailable() {
        return true;
    }

    public boolean isLDAPAuthAvailable() {
        return false;
    }

    public boolean useSimpleLDAPAuth() {
        return false;
    }

    public boolean isRadiusAuthAvailable() {
        return false;
    }

    public ArrayList getLicensedMethods() {
        ArrayList<AuthMethodController> arrayList = new ArrayList<AuthMethodController>();
        for (int i = 0; i < this.m_authMethodControllerList.size(); ++i) {
            AuthMethodController authMethodController = (AuthMethodController)this.m_authMethodControllerList.get(i);
            if (!authMethodController.getAuthSupport().getIsLicensed()) continue;
            arrayList.add(authMethodController);
        }
        return arrayList;
    }

    protected void registerPropertyListeners() {
        Appliance appliance = this.m_acAmpController.getAppliance();
        appliance.addPropertyChangeListener("SNMP_SYS_NAME", this);
    }

    public List getSupportedAuthMethods() {
        return Collections.unmodifiableList(this.m_authMethodControllerList);
    }

    public int getSupportedAuthMethodCount() {
        return this.m_authMethodControllerList.size();
    }

    public AuthMethodController getSupportedAuthMethodControllerAt(int n) {
        return (AuthMethodController)this.m_authMethodControllerList.get(n);
    }

    public JPanel getMethodSelectionPanel() {
        return this.m_view.getAuthSelectionPanel();
    }

    public boolean validateInputFields() {
        if (this.m_nState == 103) {
            ArrayList arrayList = this.getLicensedMethods();
            for (int i = 0; i < arrayList.size(); ++i) {
                AuthMethodController authMethodController = (AuthMethodController)arrayList.get(i);
                if (authMethodController.validateInputFields()) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean initializeImpl() throws Exception {
        this.setPanelState(101);
        this.m_view.showNoAuthMethodOptions();
        Appliance appliance = this.m_acAmpController.getAppliance();
        try {
            LdapSupport ldapSupport = appliance.getLdapSupport();
            if (this.isLDAPAuthAvailable()) {
                ldapSupport.clearModifications();
                ldapSupport.loadValues();
            }
            appliance.getSnmpSupport().loadValues();
            appliance.getLocalAuthSupport().loadValues();
            RadiusSupport radiusSupport = appliance.getRadiusSupport();
            if (this.isRadiusAuthAvailable() && radiusSupport.getIsLicensed(false)) {
                radiusSupport.clearModifications();
                radiusSupport.loadValues();
                appliance.getSSHSupport().loadValues();
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        AuthSettingsPanelController.this.updateLicensedMethods();
                        AuthSettingsPanelController.this.updateViews();
                        AuthSettingsPanelController.this.setPanelState(103);
                    }
                    catch (Exception exception) {
                        Trace.logError((String)AuthSettingsPanelController.TRACE_CTXT, (String)"Error updating auth panel view.", (Throwable)exception);
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            this.m_nErrorStatus = exceptionAsmpRequestFailed.getErrorCode();
            this.logError(exceptionAsmpRequestFailed.getMessage(), (Exception)((Object)exceptionAsmpRequestFailed));
            return false;
        }
        catch (Exception exception) {
            String string = res.getString("JPanelAuthSettings_Unable_to_initialize");
            this.logError(string, exception);
            return false;
        }
        return true;
    }

    public Component createView() {
        try {
            this.m_view = new AuthSettingsPanel(this);
            this.initializeView();
            return this.m_view;
        }
        catch (Exception exception) {
            Trace.logError((String)"AMP Panel", (String)"Unable to create view component.", (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    public Component getView() {
        if (this.m_view == null) {
            this.createView();
        }
        return this.m_view;
    }

    public void initializeView() {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.m_nState != 101) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equalsIgnoreCase("SNMP_SYS_NAME")) {
                this.m_view.getNameTextField().setText(propertyChangeEvent.getNewValue().toString());
            } else if (string.equalsIgnoreCase("LDAP_AUTH_LICENSED")) {
                this.updateLicensedMethods();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateViewsImpl() throws Exception {
        try {
            this.m_inUpdate = true;
            Appliance appliance = this.m_acAmpController.getAppliance();
            this.m_view.getNameTextField().setText(appliance.getStringValue("SNMP_SYS_NAME"));
            this.m_methodSelectionController.updateViews();
            this.updateLicensedMethods();
        }
        finally {
            this.m_inUpdate = false;
        }
    }

    protected boolean applyValuesImpl() {
        ApplianceRequest applianceRequest = new ApplianceRequest();
        try {
            AuthMethodController authMethodController;
            int n;
            for (n = 0; n < this.m_authMethodControllerList.size(); ++n) {
                authMethodController = (AuthMethodController)this.m_authMethodControllerList.get(n);
                if (authMethodController.applyValues(applianceRequest)) continue;
                return false;
            }
            applianceRequest.sendSetRequest(this.m_acAmpController.getAppliance());
            for (n = 0; n < this.m_authMethodControllerList.size(); ++n) {
                authMethodController = (AuthMethodController)this.m_authMethodControllerList.get(n);
                authMethodController.updateViews();
            }
        }
        catch (BadFieldValueException badFieldValueException) {
            JTextField jTextField;
            int n;
            Object object;
            if (badFieldValueException.getCause() instanceof ExceptionSnmpRequestFailed) {
                object = (ExceptionSnmpRequestFailed)((Object)badFieldValueException.getCause());
                this.setErrorStatus(((ExceptionSnmpRequestFailed)((Object)object)).getErrorCode());
                this.logError(object.getMessage(), (Exception)object);
            }
            object = badFieldValueException.getCause().getMessage();
            if (badFieldValueException.getComponent() instanceof JTextField && badFieldValueException.getLocationIndex() > 0 && (n = badFieldValueException.getLocationIndex()) < (jTextField = (JTextField)badFieldValueException.getComponent()).getText().length()) {
                jTextField.setCaretPosition(n);
            }
            Message.show((Component)this.m_acAmpController.getMainFrame(), (String)object);
            return false;
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            this.setErrorStatus(exceptionAsmpRequestFailed.getErrorCode());
            this.logError(exceptionAsmpRequestFailed.getMessage(), (Exception)((Object)exceptionAsmpRequestFailed));
            String string = this.getResource("JPanelAuthSettings_SNMP_Apply_Failed");
            Message.show((Component)this.m_acAmpController.getMainFrame(), (String)(string + " " + exceptionAsmpRequestFailed.getMessage()));
            return false;
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            String string = exceptionInvalidArgument.getMessage();
            if (string.length() != 0) {
                Message.show((Component)this.m_acAmpController.getMainFrame(), (String)exceptionInvalidArgument.getMessage());
            }
            return false;
        }
        catch (Exception exception) {
            this.getAmpController().showException(null, this.getTraceContext(), "", exception);
            return false;
        }
        return true;
    }

    void updateLicensedMethods() {
        AuthMethodController authMethodController;
        int n;
        boolean bl = false;
        ArrayList arrayList = this.getLicensedMethods();
        ArrayList<JPanel> arrayList2 = new ArrayList<JPanel>();
        for (n = 0; n < arrayList.size(); ++n) {
            authMethodController = (AuthMethodController)arrayList.get(n);
            authMethodController.updateViews();
            if (authMethodController.getOptionsPanel() == null) continue;
            arrayList2.add(authMethodController.getOptionsPanel());
        }
        if (arrayList2.size() == 0) {
            this.m_view.showNoAuthMethodOptions();
        } else if (arrayList2.size() == 1) {
            this.m_view.getOptionsContainer().removeAll();
            this.m_view.getOptionsContainer().add((Component)arrayList2.get(0));
            this.m_view.showSingleAuthMethodOptions();
        } else if (arrayList2.size() > 1) {
            this.m_view.getOptionsContainer().removeAll();
            for (n = 0; n < arrayList.size(); ++n) {
                authMethodController = (AuthMethodController)arrayList.get(n);
                JPanel jPanel = authMethodController.getOptionsPanel();
                if (jPanel == null) continue;
                String string = this.m_acAmpController.getResource(authMethodController.getShortNameKey());
                this.m_view.getOptionsTabbedPane().add((Component)jPanel, string);
            }
            this.m_view.showMultipleAuthMethodOptions();
        }
    }

    protected String setErrorFieldFocus(Object object) {
        AuthMethodController authMethodController;
        String string = null;
        for (int i = 0; i < this.m_authMethodControllerList.size() && (string = (authMethodController = (AuthMethodController)this.m_authMethodControllerList.get(i)).setErrorFieldFocus(object)) == null; ++i) {
        }
        return string;
    }

    public void setErrorFieldFocus(int n) {
    }

    public void selectOptionsTabFor(AuthMethodController authMethodController) {
        JTabbedPane jTabbedPane;
        if (authMethodController.getOptionsPanel() != null && (jTabbedPane = this.m_view.getOptionsTabbedPane()).getComponentCount() > 1) {
            jTabbedPane.setSelectedComponent(authMethodController.getOptionsPanel());
        }
    }
}

