/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.common.authentication;

import com.avocent.avworks.nmm.common.AmpController;
import com.avocent.avworks.nmm.common.Appliance;
import com.avocent.avworks.nmm.common.BadFieldValueException;
import com.avocent.avworks.nmm.common.PanelController;
import com.avocent.avworks.nmm.common.authentication.AuthMethodController;
import com.avocent.avworks.nmm.common.authentication.AuthSettingsPanelController;
import com.avocent.avworks.nmm.common.authentication.MethodSelectionController;
import com.avocent.avworks.nmm.common.authentication.components.LdapOptionsPanel;
import com.avocent.avworks.nmm.common.model.ApplianceRequest;
import com.avocent.avworks.nmm.common.model.AuthSupport;
import com.avocent.avworks.nmm.common.model.LdapSupport;
import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.avworks.services.ApplianceInfo;
import com.avocent.avworks.services.AppliancePropertiesDb;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.components.JTextFieldIPAddress;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.gui.renderers.NameValue;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LdapController
extends PanelController
implements AuthMethodController,
PropertyChangeListener,
ActionListener {
    public static final String CNAME = "JPanelAuthSettings";
    protected LdapOptionsPanel m_view;
    protected MethodSelectionController m_methodSelectionController;
    protected boolean m_allwaysOn;
    TabPaneChangeListener tabPaneChangeListener = new TabPaneChangeListener();
    protected AuthSettingsPanelController m_parent;
    boolean isTabListenerActive = false;

    public LdapController(AuthSettingsPanelController authSettingsPanelController) {
        super(authSettingsPanelController, null);
        this.m_parent = authSettingsPanelController;
        this.m_view = new LdapOptionsPanel(this);
        Appliance appliance = this.getAppliance();
        String string = this.getAmpController().getResource("JPanelAuthSettings_Query_Mode_App");
        Object[] objectArray = new Object[]{AVWorksBranding.getApplianceName((boolean)true)};
        String string2 = MessageFormat.format(string, objectArray);
        this.m_view.getApplianceQueryModeLabel().setText(string2);
        string = this.getAmpController().getResource("JPanelAuthSettings_Query_Mode_Server");
        Object[] objectArray2 = new String[]{AVWorksBranding.getServerName((boolean)true)};
        String string3 = MessageFormat.format(string, objectArray2);
        this.m_view.getServerQueryModeLabel().setText(string3);
        boolean bl = appliance.isFeatureSupported("LDAPSchemaExtensions");
        this.m_view.getSchemaExtensionCheckBox().setVisible(bl);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_view.getPrimaryLdapRadioButton());
        buttonGroup.add(this.m_view.getPrimaryLdapsRadioButton());
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.m_view.getSecondaryLdapRadioButton());
        buttonGroup2.add(this.m_view.getSecondaryLdapsRadioButton());
        JRadioButton[] jRadioButtonArray = new JRadioButton[]{this.m_view.getSwitchModeBasicRadioButton(), this.m_view.getSwitchModeAttributeRadioButton(), this.m_view.getSwitchModeGroupRadioButton()};
        ButtonGroup buttonGroup3 = new ButtonGroup();
        for (int i = 0; i < jRadioButtonArray.length; ++i) {
            buttonGroup3.add(jRadioButtonArray[i]);
            jRadioButtonArray[i].addActionListener(this);
        }
        JRadioButton[] jRadioButtonArray2 = new JRadioButton[]{this.m_view.getServerModeBasicRadioButton(), this.m_view.getServerModeAttributeRadioButton(), this.m_view.getServerModeGroupRadioButton()};
        ButtonGroup buttonGroup4 = new ButtonGroup();
        for (int i = 0; i < jRadioButtonArray2.length; ++i) {
            buttonGroup4.add(jRadioButtonArray2[i]);
            jRadioButtonArray2[i].addActionListener(this);
        }
        this.m_view.getPrimaryLdapRadioButton().addActionListener(this);
        this.m_view.getPrimaryLdapsRadioButton().addActionListener(this);
        this.m_view.getSecondaryLdapRadioButton().addActionListener(this);
        this.m_view.getSecondaryLdapsRadioButton().addActionListener(this);
        this.m_view.getLdapForAuthOnlyCheckbox().addActionListener(this);
        this.m_view.getLdapSyntaxValidationCheckbox().addActionListener(this);
        this.m_view.getSchemaExtensionCheckBox().addActionListener(this);
        this.m_view.getLdapForAuthOnlyCheckbox().setVisible(appliance.getLdapSupport().isLdapForAuthOnlyBrandingEnabled());
        JTextFieldIPAddress jTextFieldIPAddress = this.m_view.getPrimaryIpTextField();
        jTextFieldIPAddress.setStyle(1);
        jTextFieldIPAddress = this.m_view.getSecondaryIpTextField();
        this.addDocumentListener((JTextField)this.m_view.getPrimaryIpTextField(), "LDAP_PRI_SERVER_IP");
        this.addDocumentListener(this.m_view.getPrimaryPortTextField(), "LDAP_PRI_SERVER_PORT");
        this.addDocumentListener((JTextField)this.m_view.getSecondaryIpTextField(), "LDAP_SEC_SERVER_IP");
        this.addDocumentListener(this.m_view.getSecondaryPortTextField(), "LDAP_SEC_SERVER_PORT");
        this.addDocumentListener(this.m_view.getSearchDnTextField(), "LDAP_SEARCH_DN");
        this.addDocumentListener(this.m_view.getSearchPasswordTextField(), "LDAP_SEARCH_PASSWORD");
        this.addDocumentListener(this.m_view.getSearchBaseTextField(), "LDAP_SEARCH_BASE");
        this.addDocumentListener(this.m_view.getUidMaskTextField(), "LDAP_SEARCH_UID");
        this.addDocumentListener(this.m_view.getGroupContainerTextField(), "LDAP_GROUP_CONTAINER");
        this.addDocumentListener(this.m_view.getGroupMaskTextField(), "LDAP_GROUP_MASK");
        this.addDocumentListener(this.m_view.getTargetMaskTextField(), "LDAP_TARGET_MASK");
        this.addDocumentListener(this.m_view.getAccessControlTextField(), "LDAP_ACCESS_CONTROL");
        this.addFieldMapping("LDAP_SEARCH_DN", this.m_view.getSearchDnTextField());
        this.addFieldMapping("LDAP_SEARCH_PASSWORD", this.m_view.getSearchPasswordTextField());
        this.addFieldMapping("LDAP_SEARCH_BASE", this.m_view.getSearchBaseTextField());
        this.addFieldMapping("LDAP_SEARCH_UID", this.m_view.getUidMaskTextField());
        this.addFieldMapping("LDAP_PRI_SERVER_IP", (Component)this.m_view.getPrimaryIpTextField());
        this.addFieldMapping("LDAP_PRI_SERVER_PORT", this.m_view.getPrimaryPortTextField());
        this.addFieldMapping("LDAP_SEC_SERVER_IP", (Component)this.m_view.getSecondaryIpTextField());
        this.addFieldMapping("LDAP_SEC_SERVER_PORT", this.m_view.getSecondaryPortTextField());
        this.addFieldMapping("LDAP_GROUP_CONTAINER", this.m_view.getGroupContainerTextField());
        this.addFieldMapping("LDAP_GROUP_MASK", this.m_view.getGroupMaskTextField());
        this.addFieldMapping("LDAP_TARGET_MASK", this.m_view.getTargetMaskTextField());
        this.addFieldMapping("LDAP_ACCESS_CONTROL", this.m_view.getAccessControlTextField());
        appliance.addPropertyChangeListener("LDAP_METHOD_PRIORITY", this);
        appliance.addPropertyChangeListener("LDAP_METHOD_IS_ENABLED", this);
        appliance.addPropertyChangeListener("LDAP_AUTH_LICENSED", this);
    }

    public JPanel getOptionsPanel() {
        return this.m_view;
    }

    public String getShortNameKey() {
        return "JPanelAuthSettings_ENUM_Ldap";
    }

    public String getUsePrompt() {
        return this.getAmpController().getResource("JPanelAuthSettings_UseLDAP");
    }

    public void priorityChanged(int n) {
        this.setActiveFields();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        Appliance appliance = this.getAppliance();
        LdapSupport ldapSupport = appliance.getLdapSupport();
        boolean bl = true;
        if (object == this.m_view.getPrimaryLdapRadioButton()) {
            Object object2 = ldapSupport.getConstant("DEFAULT_LDAP_PORT");
            Object object3 = ldapSupport.getConstant("ACCESS_MODE_LDAP");
            this.m_view.getPrimaryPortTextField().setText(object2.toString());
            appliance.setAmpValue("LDAP_PRI_SERVER_PORT", object2);
            appliance.setAmpValue("LDAP_PRI_SERVER_ACCESS", object3);
        } else if (object == this.m_view.getPrimaryLdapsRadioButton()) {
            Object object4 = ldapSupport.getConstant("DEFAULT_LDAPS_PORT");
            Object object5 = ldapSupport.getConstant("ACCESS_MODE_LDAPS");
            this.m_view.getPrimaryPortTextField().setText(object4.toString());
            appliance.setAmpValue("LDAP_PRI_SERVER_PORT", object4);
            appliance.setAmpValue("LDAP_PRI_SERVER_ACCESS", object5);
        } else if (object == this.m_view.getSecondaryLdapRadioButton()) {
            Object object6 = ldapSupport.getConstant("DEFAULT_LDAP_PORT");
            Object object7 = ldapSupport.getConstant("ACCESS_MODE_LDAP");
            this.m_view.getSecondaryPortTextField().setText(object6.toString());
            appliance.setAmpValue("LDAP_SEC_SERVER_PORT", object6);
            appliance.setAmpValue("LDAP_SEC_SERVER_ACCESS", object7);
        } else if (object == this.m_view.getSecondaryLdapsRadioButton()) {
            Object object8 = ldapSupport.getConstant("DEFAULT_LDAPS_PORT");
            Object object9 = ldapSupport.getConstant("ACCESS_MODE_LDAPS");
            this.m_view.getSecondaryPortTextField().setText(object8.toString());
            appliance.setAmpValue("LDAP_SEC_SERVER_PORT", object8);
            appliance.setAmpValue("LDAP_SEC_SERVER_ACCESS", object9);
        } else if (object == this.m_view.getLdapForAuthOnlyCheckbox()) {
            boolean bl2 = this.m_view.getLdapForAuthOnlyCheckbox().isSelected();
            appliance.setAmpValue("LDAP_FOR_AUTH_ONLY", new Boolean(bl2));
            this.updateIsLdapForAuthOnly(bl2);
        } else if (object == this.m_view.getSchemaExtensionCheckBox()) {
            boolean bl3 = this.m_view.getSchemaExtensionCheckBox().isSelected();
            appliance.setAmpValue("SCHEMA_EXTENSIONS", new Boolean(bl3));
            this.updateSchemaExtensions(bl3);
        } else if (object == this.m_view.getLdapSyntaxValidationCheckbox()) {
            boolean bl4 = this.m_view.getLdapSyntaxValidationCheckbox().isSelected();
            appliance.setAmpValue("LDAP_SYNTAX_VALIDATION", new Boolean(bl4));
            this.updateIsLdapSyntaxValidated(bl4);
        } else if (object == this.m_view.getSwitchModeBasicRadioButton()) {
            Object object10 = ldapSupport.getConstant("QUERY_MODE_BASIC");
            appliance.setAmpValue("LDAP_QUERY_MODE_APPLIANCE", object10);
            appliance.setAmpValue("LDAP_QUERY_MODE_SERVER", object10);
            this.updateSwitchQueryMode(object10);
        } else if (object == this.m_view.getSwitchModeAttributeRadioButton()) {
            Object object11 = ldapSupport.getConstant("QUERY_MODE_ATTRIBUTE");
            appliance.setAmpValue("LDAP_QUERY_MODE_APPLIANCE", object11);
            this.updateSwitchQueryMode(object11);
        } else if (object == this.m_view.getSwitchModeGroupRadioButton()) {
            Object object12 = ldapSupport.getConstant("QUERY_MODE_GROUP");
            appliance.setAmpValue("LDAP_QUERY_MODE_APPLIANCE", object12);
            this.updateSwitchQueryMode(object12);
        } else if (object == this.m_view.getServerModeBasicRadioButton()) {
            Object object13 = ldapSupport.getConstant("QUERY_MODE_BASIC");
            appliance.setAmpValue("LDAP_QUERY_MODE_SERVER", object13);
            this.updateServerQueryMode(object13);
        } else if (object == this.m_view.getServerModeAttributeRadioButton()) {
            Object object14 = ldapSupport.getConstant("QUERY_MODE_ATTRIBUTE");
            appliance.setAmpValue("LDAP_QUERY_MODE_SERVER", object14);
            this.updateServerQueryMode(object14);
        } else if (object == this.m_view.getServerModeGroupRadioButton()) {
            Object object15 = ldapSupport.getConstant("QUERY_MODE_GROUP");
            appliance.setAmpValue("LDAP_QUERY_MODE_SERVER", object15);
            this.updateServerQueryMode(object15);
        }
        this.getAmpPanelController().setIsModified(bl);
    }

    public void updateViewsImpl() {
        Appliance appliance = this.getAppliance();
        LdapSupport ldapSupport = appliance.getLdapSupport();
        this.updateServerPanel(appliance, ldapSupport);
        this.updateSearchPanel(appliance, ldapSupport);
        this.updateQueryPanel(appliance, ldapSupport);
        ApplianceInfo applianceInfo = this.getAmpController().getApplianceInfo();
        try {
            this.setSyntaxValidated(AppliancePropertiesDb.getBooleanValue((int)applianceInfo.getID(), (String)"LDAP_SYNTAX_VALIDATION", (boolean)true));
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)CNAME, (String)("Exception getting LDAP_SYNTAX_VALIDATION from database for appliance id " + applianceInfo.getID()), (Throwable)exceptionRequestFailed);
            this.setSyntaxValidated(true);
        }
        this.setActiveFields();
    }

    protected void updateServerPanel(Appliance appliance, LdapSupport ldapSupport) {
        Object[] objectArray = new Object[4];
        objectArray[0] = "LDAP_PRI_SERVER_IP";
        objectArray[1] = "LDAP_SEC_SERVER_IP";
        objectArray[2] = "LDAP_PRI_SERVER_PORT";
        objectArray[3] = "LDAP_SEC_SERVER_PORT";
        Object[] objectArray2 = objectArray;
        JTextField[] jTextFieldArray = new JTextField[]{this.m_view.getPrimaryIpTextField(), this.m_view.getSecondaryIpTextField(), this.m_view.getPrimaryPortTextField(), this.m_view.getSecondaryPortTextField()};
        this.updateTextFields(appliance, jTextFieldArray, objectArray2);
        Object object = ldapSupport.getConstant("ACCESS_MODE_LDAP");
        Object object2 = appliance.getValue("LDAP_PRI_SERVER_ACCESS");
        boolean bl = object2.equals(object);
        this.m_view.getPrimaryLdapRadioButton().setSelected(bl);
        this.m_view.getPrimaryLdapsRadioButton().setSelected(!bl);
        Object object3 = appliance.getValue("LDAP_SEC_SERVER_ACCESS");
        bl = object3.equals(object);
        this.m_view.getSecondaryLdapRadioButton().setSelected(bl);
        this.m_view.getSecondaryLdapsRadioButton().setSelected(!bl);
        Boolean bl2 = (Boolean)appliance.getValue("LDAP_FOR_AUTH_ONLY");
        if (bl2 != null) {
            this.m_view.getLdapForAuthOnlyCheckbox().setSelected(bl2);
        }
        this.m_view.getLdapSyntaxValidationCheckbox().setSelected(this.isSyntaxValidated());
        Boolean bl3 = (Boolean)appliance.getValue("SCHEMA_EXTENSIONS");
        this.m_view.getSchemaExtensionCheckBox().setSelected(bl3 != null && bl3 != false);
    }

    public void updateSearchPanel(Appliance appliance, LdapSupport ldapSupport) {
        JTextField[] jTextFieldArray = new JTextField[]{this.m_view.getSearchDnTextField(), this.m_view.getSearchPasswordTextField(), this.m_view.getSearchBaseTextField(), this.m_view.getUidMaskTextField()};
        Object[] objectArray = new Object[4];
        objectArray[0] = "LDAP_SEARCH_DN";
        objectArray[1] = "LDAP_SEARCH_PASSWORD";
        objectArray[2] = "LDAP_SEARCH_BASE";
        objectArray[3] = "LDAP_SEARCH_UID";
        Object[] objectArray2 = objectArray;
        this.updateTextFields(appliance, jTextFieldArray, objectArray2);
    }

    public void updateQueryPanel(Appliance appliance, LdapSupport ldapSupport) {
        JTextField[] jTextFieldArray = new JTextField[]{this.m_view.getGroupContainerTextField(), this.m_view.getGroupMaskTextField(), this.m_view.getTargetMaskTextField(), this.m_view.getAccessControlTextField()};
        Object[] objectArray = new Object[4];
        objectArray[0] = "LDAP_GROUP_CONTAINER";
        objectArray[1] = "LDAP_GROUP_MASK";
        objectArray[2] = "LDAP_TARGET_MASK";
        objectArray[3] = "LDAP_ACCESS_CONTROL";
        Object[] objectArray2 = objectArray;
        this.updateTextFields(appliance, jTextFieldArray, objectArray2);
        Object object = appliance.getValue("LDAP_QUERY_MODE_APPLIANCE");
        this.updateSwitchQueryMode(object);
        Object object2 = appliance.getValue("LDAP_QUERY_MODE_SERVER");
        this.updateServerQueryMode(object2);
    }

    public void setMethodSelectionController(MethodSelectionController methodSelectionController) {
        this.m_methodSelectionController = methodSelectionController;
    }

    public void updateTextFields(Appliance appliance, JTextField[] jTextFieldArray, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            String string = appliance.getStringValue(objectArray[i]);
            if ((jTextFieldArray[i].equals(this.m_view.getPrimaryPortTextField()) || jTextFieldArray[i].equals(this.m_view.getSecondaryPortTextField())) && string.equals("0")) {
                string = "";
            }
            jTextFieldArray[i].setText(string);
        }
    }

    public void setEnabledState(JRadioButton[] jRadioButtonArray, boolean bl) {
        for (int i = 0; i < jRadioButtonArray.length; ++i) {
            jRadioButtonArray[i].setEnabled(bl);
        }
    }

    protected void updateIsLdapForAuthOnly(boolean bl) {
        JCheckBox jCheckBox = this.m_view.getLdapForAuthOnlyCheckbox();
        if (jCheckBox.isSelected() != bl) {
            jCheckBox.setSelected(bl);
        }
        this.setActiveFields();
    }

    protected void updateSchemaExtensions(boolean bl) {
        JCheckBox jCheckBox = this.m_view.getSchemaExtensionCheckBox();
        if (jCheckBox.isSelected() != bl) {
            jCheckBox.setSelected(bl);
        }
        this.setActiveFields();
    }

    protected void updateIsLdapSyntaxValidated(boolean bl) {
        JCheckBox jCheckBox = this.m_view.getLdapSyntaxValidationCheckbox();
        if (jCheckBox.isSelected() != bl) {
            jCheckBox.setSelected(bl);
        }
        this.setActiveFields();
    }

    protected void updateServerQueryMode(Object object) {
        Appliance appliance = this.getAppliance();
        LdapSupport ldapSupport = appliance.getLdapSupport();
        Object object2 = ldapSupport.getConstant("QUERY_MODE_BASIC");
        Object object3 = ldapSupport.getConstant("QUERY_MODE_ATTRIBUTE");
        Object object4 = ldapSupport.getConstant("QUERY_MODE_GROUP");
        this.m_view.getServerModeBasicRadioButton().setSelected(object.equals(object2));
        this.m_view.getServerModeAttributeRadioButton().setSelected(object.equals(object3));
        this.m_view.getServerModeGroupRadioButton().setSelected(object.equals(object4));
        this.setActiveFields();
    }

    protected void updateSwitchQueryMode(Object object) {
        LdapSupport ldapSupport = this.getAppliance().getLdapSupport();
        Object object2 = ldapSupport.getConstant("QUERY_MODE_BASIC");
        Object object3 = ldapSupport.getConstant("QUERY_MODE_ATTRIBUTE");
        Object object4 = ldapSupport.getConstant("QUERY_MODE_GROUP");
        this.m_view.getSwitchModeBasicRadioButton().setSelected(object.equals(object2));
        this.m_view.getSwitchModeAttributeRadioButton().setSelected(object.equals(object3));
        this.m_view.getSwitchModeGroupRadioButton().setSelected(object.equals(object4));
        if (object.equals(object2)) {
            this.m_view.getServerModeBasicRadioButton().setSelected(true);
        }
        this.setActiveFields();
    }

    protected void setActiveFields() {
        boolean bl;
        boolean bl2 = this.m_methodSelectionController.getIsSelected(this);
        boolean bl3 = this.m_view.getSwitchModeBasicRadioButton().isSelected();
        boolean bl4 = this.m_view.getSwitchModeAttributeRadioButton().isSelected();
        boolean bl5 = this.m_view.getSwitchModeGroupRadioButton().isSelected();
        boolean bl6 = this.m_view.getServerModeBasicRadioButton().isSelected();
        boolean bl7 = this.m_view.getServerModeAttributeRadioButton().isSelected();
        boolean bl8 = this.m_view.getServerModeGroupRadioButton().isSelected();
        boolean bl9 = this.m_view.getLdapForAuthOnlyCheckbox().isSelected();
        JTextField[] jTextFieldArray = new JTextField[]{this.m_view.getPrimaryIpTextField(), this.m_view.getPrimaryPortTextField(), this.m_view.getSecondaryIpTextField(), this.m_view.getSecondaryPortTextField(), this.m_view.getSearchDnTextField(), this.m_view.getSearchBaseTextField(), this.m_view.getSearchPasswordTextField(), this.m_view.getUidMaskTextField()};
        if (bl2) {
            if (!this.isTabListenerActive) {
                this.m_view.getTabbedPane().addChangeListener(this.tabPaneChangeListener);
                this.isTabListenerActive = true;
            }
        } else if (this.isTabListenerActive) {
            this.m_view.getTabbedPane().removeChangeListener(this.tabPaneChangeListener);
            this.isTabListenerActive = false;
        }
        boolean bl10 = bl2;
        this.m_view.getLdapForAuthOnlyCheckbox().setEnabled(bl10);
        this.m_view.getLdapSyntaxValidationCheckbox().setEnabled(bl10);
        this.m_view.getSchemaExtensionCheckBox().setEnabled(bl10);
        for (bl = false; bl < jTextFieldArray.length; bl += 1) {
            jTextFieldArray[bl].setEnabled(bl10);
            jTextFieldArray[bl].setEditable(bl10);
        }
        this.m_view.getPrimaryLdapRadioButton().setEnabled(bl10);
        this.m_view.getPrimaryLdapsRadioButton().setEnabled(bl10);
        this.m_view.getSecondaryLdapRadioButton().setEnabled(bl10);
        this.m_view.getSecondaryLdapsRadioButton().setEnabled(bl10);
        bl = bl2 && !bl9;
        this.m_view.getSwitchModeBasicRadioButton().setEnabled(bl);
        this.m_view.getSwitchModeAttributeRadioButton().setEnabled(bl);
        this.m_view.getSwitchModeGroupRadioButton().setEnabled(bl);
        bl = bl2 && !bl9 && !bl3;
        this.m_view.getServerModeBasicRadioButton().setEnabled(bl);
        this.m_view.getServerModeAttributeRadioButton().setEnabled(bl);
        this.m_view.getServerModeGroupRadioButton().setEnabled(bl);
        bl = bl2 && !bl9 && (bl5 || bl8);
        this.m_view.getGroupContainerTextField().setEditable(bl);
        this.m_view.getGroupContainerTextField().setEnabled(bl);
        this.m_view.getGroupMaskTextField().setEditable(bl);
        this.m_view.getGroupMaskTextField().setEnabled(bl);
        this.m_view.getTargetMaskTextField().setEditable(bl);
        this.m_view.getTargetMaskTextField().setEnabled(bl);
        bl = bl2 && !bl9 && (bl5 || bl5 || bl4 || bl7);
        this.m_view.getAccessControlTextField().setEnabled(bl);
        this.m_view.getAccessControlTextField().setEditable(bl);
    }

    public boolean applyValues(ApplianceRequest applianceRequest) throws BadFieldValueException, Exception {
        LdapSupport ldapSupport = this.getAppliance().getLdapSupport();
        ldapSupport.applyValues(applianceRequest);
        ApplianceInfo applianceInfo = this.getAmpController().getApplianceInfo();
        AppliancePropertiesDb.setValue((int)applianceInfo.getID(), (String)"LDAP_SYNTAX_VALIDATION", (boolean)this.isSyntaxValidated());
        return true;
    }

    public String setErrorFieldFocus(Object object) {
        this.setFocusOnField(object);
        return this.getAuthSupport().getFieldResourceKey(object);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        try {
            if (this.getAmpPanelController().getPanelState() != 101) {
                Appliance appliance = this.getAmpController().getAppliance();
                LdapSupport ldapSupport = appliance.getLdapSupport();
                String string = propertyChangeEvent.getPropertyName();
                if (string.equalsIgnoreCase("LDAP_METHOD_IS_ENABLED")) {
                    this.m_methodSelectionController.notifySelectionChanged(this);
                    this.setActiveFields();
                    this.getAmpPanelController().setIsModified(true);
                    if (ldapSupport.getIsEnabled()) {
                        ((AuthSettingsPanelController)this.m_ampPanelController).selectOptionsTabFor(this);
                    }
                } else if (string.equalsIgnoreCase("LDAP_AUTH_LICENSED")) {
                    this.getAmpPanelController().setReloadData();
                } else {
                    String[] stringArray = new String[6];
                    stringArray[0] = "LDAP_PRI_SERVER_IP";
                    stringArray[1] = "LDAP_PRI_SERVER_PORT";
                    stringArray[2] = "LDAP_PRI_SERVER_ACCESS";
                    stringArray[3] = "LDAP_SEC_SERVER_IP";
                    stringArray[4] = "LDAP_SEC_SERVER_PORT";
                    stringArray[5] = "LDAP_SEC_SERVER_ACCESS";
                    String[] stringArray2 = stringArray;
                    for (int i = 0; i < stringArray2.length; ++i) {
                        if (!stringArray2[i].equalsIgnoreCase(string)) continue;
                        this.updateServerPanel(appliance, ldapSupport);
                    }
                    String[] stringArray3 = new String[4];
                    stringArray3[0] = "LDAP_SEARCH_DN";
                    stringArray3[1] = "LDAP_SEARCH_PASSWORD";
                    stringArray3[2] = "LDAP_SEARCH_BASE";
                    stringArray3[3] = "LDAP_SEARCH_UID";
                    String[] stringArray4 = stringArray3;
                    for (int i = 0; i < stringArray4.length; ++i) {
                        if (!stringArray4[i].equalsIgnoreCase(string)) continue;
                        this.updateSearchPanel(appliance, ldapSupport);
                    }
                    String[] stringArray5 = new String[4];
                    stringArray5[0] = "LDAP_SEARCH_DN";
                    stringArray5[1] = "LDAP_SEARCH_PASSWORD";
                    stringArray5[2] = "LDAP_SEARCH_BASE";
                    stringArray5[3] = "LDAP_SEARCH_UID";
                    String[] stringArray6 = stringArray5;
                    for (int i = 0; i < stringArray6.length; ++i) {
                        if (!stringArray6[i].equalsIgnoreCase(string)) continue;
                        this.updateQueryPanel(appliance, ldapSupport);
                    }
                }
            }
        }
        catch (Exception exception) {
            Trace.logError((String)"Auth Panel", (String)"Failed to update on property change event.", (Throwable)exception);
        }
    }

    public void selectTabIndex(int n) {
        this.m_view.getTabbedPane().removeChangeListener(this.tabPaneChangeListener);
        this.m_view.getTabbedPane().setSelectedIndex(n);
        this.m_view.getTabbedPane().addChangeListener(this.tabPaneChangeListener);
    }

    public boolean validateInputFields() {
        Appliance appliance = this.getAppliance();
        if (appliance.getLdapSupport().getIsLicensed() && this.m_methodSelectionController.getIsSelected(this)) {
            if (!this.validateServerPanel()) {
                this.selectTabIndex(0);
                return false;
            }
            if (this.isSyntaxValidated()) {
                if (!this.validateSearchPanel()) {
                    this.selectTabIndex(1);
                    return false;
                }
                if (!this.validateQueryPanel()) {
                    this.selectTabIndex(2);
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    boolean validateServerPanel() {
        try {
            Appliance appliance = this.getAppliance();
            LdapSupport ldapSupport = appliance.getLdapSupport();
            JTextFieldIPAddress jTextFieldIPAddress = this.m_view.getPrimaryIpTextField();
            JTextFieldIPAddress jTextFieldIPAddress2 = this.m_view.getSecondaryIpTextField();
            if (jTextFieldIPAddress.isDataValid() && jTextFieldIPAddress2.isDataValid()) {
                JTextField jTextField = this.m_view.getPrimaryPortTextField();
                String string = ldapSupport.getFieldResourceKey("LDAP_PRI_SERVER_PORT");
                String string2 = this.getAmpController().getResource(string);
                AmpController.validateIntProperty(jTextField, string2, 1, 65535);
                if (jTextFieldIPAddress2.getText().trim().length() > 0) {
                    JTextField jTextField2 = this.m_view.getSecondaryPortTextField();
                    String string3 = ldapSupport.getFieldResourceKey("LDAP_SEC_SERVER_PORT");
                    String string4 = this.getAmpController().getResource(string3);
                    AmpController.validateIntProperty(jTextField2, string4, 1, 65535);
                } else {
                    this.m_view.getSecondaryPortTextField().setText("");
                }
                return true;
            }
            return false;
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            String string = exceptionInvalidArgument.getMessage();
            if (string.length() != 0) {
                Message.show((Component)this.getAmpController().getMainFrame(), (String)string);
            }
            return false;
        }
    }

    boolean validateSearchPanel() {
        Appliance appliance = this.getAmpController().getAppliance();
        LdapSupport ldapSupport = appliance.getLdapSupport();
        try {
            JTextField jTextField = this.m_view.getSearchDnTextField();
            String string = ldapSupport.getFieldResourceKey("LDAP_SEARCH_DN");
            if (jTextField.getText().trim().length() > 0) {
                LdapController.validateNameValuePairs(this.getAmpController(), jTextField, string, ',', ';', '+');
                String string2 = ldapSupport.getFieldResourceKey("LDAP_SEARCH_PASSWORD");
                JPasswordField jPasswordField = this.m_view.getSearchPasswordTextField();
                this.validatePasswd(this.getAmpController(), jPasswordField, string2);
                LdapController.validateMaxFieldLength(this.getAmpController(), jPasswordField, string2, ldapSupport.getMaxFieldLength());
            }
            jTextField = this.m_view.getSearchBaseTextField();
            string = ldapSupport.getFieldResourceKey("LDAP_SEARCH_BASE");
            LdapController.validateFieldNotEmpty(this.getAmpController(), jTextField, string);
            LdapController.validateNameValuePairs(this.getAmpController(), jTextField, string, ',', ';', '+');
            jTextField = this.m_view.getUidMaskTextField();
            string = ldapSupport.getFieldResourceKey("LDAP_SEARCH_UID");
            LdapController.validateFieldNotEmpty(this.getAmpController(), jTextField, string);
            LdapController.validateNameValuePairs(this.getAmpController(), jTextField, string, '#', '#', '#');
            return true;
        }
        catch (BadFieldValueException badFieldValueException) {
            this.showFailedValidationMessage(badFieldValueException);
            return false;
        }
    }

    boolean validateQueryPanel() {
        LdapSupport ldapSupport = this.getAppliance().getLdapSupport();
        try {
            String string;
            JTextField jTextField = this.m_view.getGroupContainerTextField();
            if (jTextField.isEditable()) {
                string = ldapSupport.getFieldResourceKey("LDAP_GROUP_CONTAINER");
                LdapController.validateFieldNotEmpty(this.getAmpController(), jTextField, string);
                LdapController.validateMaxFieldLength(this.getAmpController(), jTextField, string, ldapSupport.getMaxFieldLength());
            }
            if ((jTextField = this.m_view.getGroupMaskTextField()).isEditable()) {
                string = ldapSupport.getFieldResourceKey("LDAP_GROUP_MASK");
                LdapController.validateFieldNotEmpty(this.getAmpController(), jTextField, string);
                LdapController.validateMaxFieldLength(this.getAmpController(), jTextField, string, ldapSupport.getMaxFieldLength());
                LdapController.validateNameValuePairs(this.getAmpController(), jTextField, string, '#', '#', '#');
            }
            if ((jTextField = this.m_view.getTargetMaskTextField()).isEditable()) {
                string = ldapSupport.getFieldResourceKey("LDAP_TARGET_MASK");
                LdapController.validateFieldNotEmpty(this.getAmpController(), jTextField, string);
                LdapController.validateMaxFieldLength(this.getAmpController(), jTextField, string, ldapSupport.getMaxFieldLength());
                LdapController.validateNameValuePairs(this.getAmpController(), jTextField, string, '#', '#', '#');
            }
            if ((jTextField = this.m_view.getAccessControlTextField()).isEditable()) {
                string = ldapSupport.getFieldResourceKey("LDAP_ACCESS_CONTROL");
                LdapController.validateFieldNotEmpty(this.getAmpController(), jTextField, string);
            }
            return true;
        }
        catch (BadFieldValueException badFieldValueException) {
            this.showFailedValidationMessage(badFieldValueException);
            return false;
        }
    }

    public void validatePasswd(AmpController ampController, JPasswordField jPasswordField, String string) throws BadFieldValueException {
        String string2;
        String string3;
        JTextField jTextField = this.m_view.getSearchDnTextField();
        LdapSupport ldapSupport = this.getAppliance().getLdapSupport();
        if (jTextField.getText().toString().trim().length() > 0 && ((string3 = (string2 = new String(jPasswordField.getPassword())).trim()) == null || string3.length() == 0)) {
            String string4 = ampController.getResource("JPanelAuthSettings_invalid_field", null) + ampController.getResource("JPanelAuthSettings_invalid_password", null);
            String string5 = ampController.getResource(string);
            Object[] objectArray = new Object[]{string5};
            String string6 = MessageFormat.format(string4, objectArray);
            String string7 = "Validation Failed: missing password.";
            throw new BadFieldValueException(jPasswordField, string7, string6);
        }
    }

    public static void validateNameValuePairs(AmpController ampController, JTextField jTextField, String string, char c, char c2, char c3) throws BadFieldValueException {
        String string2 = jTextField.getText().toString().trim();
        ArrayList arrayList = LdapController.parseNameValuePairStrings(ampController, string, jTextField, string2, c, c2, c3);
        for (int i = 0; i < arrayList.size(); ++i) {
            NameValue nameValue = (NameValue)arrayList.get(i);
            String string3 = null;
            String string4 = "Validation failed for name/value pair: " + nameValue + ").";
            String string5 = ampController.getResource(string);
            Object[] objectArray = new Object[]{string5};
            if (nameValue.getName().length() == 0 || ((String)nameValue.getValue()).length() == 0) {
                string3 = ampController.getResource("JPanelAuthSettings_invalid_field") + ampController.getResource("JPanelAuthSettings_name_value_error1");
                string4 = "Missing = in name value pair: " + nameValue + ".";
            }
            if (string3 == null) continue;
            String string6 = MessageFormat.format(string3, objectArray);
            throw new BadFieldValueException(jTextField, string4, string6);
        }
    }

    public static ArrayList parseNameValuePairStrings(AmpController ampController, String string, JTextField jTextField, String string2, char c, char c2, char c3) throws BadFieldValueException {
        CharSequence charSequence;
        ArrayList<NameValue> arrayList = new ArrayList<NameValue>();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        boolean bl2 = true;
        int n = 0;
        for (int i = 0; i < string2.length(); ++i) {
            charSequence = bl2 ? stringBuffer : stringBuffer2;
            char c4 = string2.charAt(i);
            if (c4 == '\"') {
                bl = !bl;
                n = bl ? i : 0;
                ((StringBuffer)charSequence).append(c4);
                continue;
            }
            if (bl) {
                ((StringBuffer)charSequence).append(c4);
                continue;
            }
            if (c4 == '\\' && i + 1 < string2.length()) {
                ((StringBuffer)charSequence).append(c4);
                ((StringBuffer)charSequence).append(string2.charAt(++i));
                continue;
            }
            if (c4 == c || c4 == c2 || c4 == c3) {
                arrayList.add(new NameValue(stringBuffer.toString(), (Object)stringBuffer2.toString()));
                stringBuffer.setLength(0);
                stringBuffer2.setLength(0);
                bl2 = true;
                continue;
            }
            if (c4 == '=') {
                if (charSequence == stringBuffer2) {
                    String string3 = ampController.getResource("JPanelAuthSettings_invalid_field") + ampController.getResource("JPanelAuthSettings_need_delimiter");
                    String string4 = ampController.getResource(string);
                    Object[] objectArray = new Object[]{string4, "" + c};
                    String string5 = "Missing separator in name value pair: " + stringBuffer.toString() + ".";
                    String string6 = MessageFormat.format(string3, objectArray);
                    throw new BadFieldValueException(jTextField, i, string5, string6);
                }
                bl2 = charSequence == stringBuffer2;
                continue;
            }
            ((StringBuffer)charSequence).append(c4);
        }
        if (bl) {
            String string7 = ampController.getResource("JPanelAuthSettings_invalid_field") + ampController.getResource("JPanelAuthSettings_ldap_syntax_error");
            charSequence = ampController.getResource(string);
            Object[] objectArray = new Object[]{charSequence, "" + c};
            String string8 = "Missing separator in name value pair: " + stringBuffer.toString() + ".";
            String string9 = MessageFormat.format(string7, objectArray);
            throw new BadFieldValueException(jTextField, n, string8, string9);
        }
        arrayList.add(new NameValue(stringBuffer.toString(), (Object)stringBuffer2.toString()));
        return arrayList;
    }

    public static void validateMaxFieldLength(AmpController ampController, JTextField jTextField, String string, int n) throws BadFieldValueException {
        String string2 = jTextField.getText().toString().trim();
        if (string2.length() > n) {
            String string3 = ampController.getResource("JPanelAuthSettings_invalid_field") + ampController.getResource("JPanelAuthSettings_value_is_too_long");
            String string4 = ampController.getResource(string);
            Object[] objectArray = new Object[]{string4, "" + n};
            String string5 = MessageFormat.format(string3, objectArray);
            String string6 = "Validation Failed: Max length of " + n + " exceeded for (" + string4 + ")";
            throw new BadFieldValueException(jTextField, string6, string5);
        }
    }

    public static void validateFieldNotEmpty(AmpController ampController, JTextField jTextField, String string) throws BadFieldValueException {
        String string2 = jTextField.getText().toString().trim();
        if (string2.length() == 0) {
            String string3 = ampController.getResource("JPanelAuthSettings_invalid_field") + ampController.getResource("JPanelAuthSettings_need_name_value_pair");
            String string4 = ampController.getResource(string);
            Object[] objectArray = new Object[]{string4};
            String string5 = MessageFormat.format(string3, objectArray);
            String string6 = "Validation Failed: Missing field value for (" + string4 + ")";
            throw new BadFieldValueException(jTextField, string6, string5);
        }
    }

    protected void showFailedValidationMessage(BadFieldValueException badFieldValueException) {
        JComponent jComponent = badFieldValueException.getComponent();
        String string = null;
        if (jComponent != null) {
            JTextField jTextField;
            int n;
            jComponent.requestFocusInWindow();
            if (jComponent instanceof JTextField && (n = badFieldValueException.getLocationIndex()) < (jTextField = (JTextField)badFieldValueException.getComponent()).getText().length()) {
                jTextField.setCaretPosition(n);
            }
        }
        if (badFieldValueException.isLocalized()) {
            string = badFieldValueException.getLocalizedMessage();
        }
        if (string == null || string.length() == 0) {
            string = this.getAmpController().getResource("JPanelAuthSettings_badvalue");
        }
        Message.show((Component)this.getAmpController().getMainFrame(), (String)string);
    }

    public AuthSupport getAuthSupport() {
        return this.getAppliance().getLdapSupport();
    }

    private boolean isSyntaxValidated() {
        Appliance appliance = this.getAmpController().getAppliance();
        Boolean bl = (Boolean)appliance.getValue("LDAP_SYNTAX_VALIDATION");
        Trace.logInfo((String)"LdapController", (String)("isSyntaxValidated returning " + bl));
        return bl == null || bl != false;
    }

    private void setSyntaxValidated(boolean bl) {
        Appliance appliance = this.getAmpController().getAppliance();
        Boolean bl2 = (Boolean)appliance.setValue("LDAP_SYNTAX_VALIDATION", bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setAllwaysOn(boolean bl) {
        this.m_allwaysOn = bl;
    }

    public void setIsEnabled(boolean bl) {
        Appliance appliance = this.m_parent.getAmpController().getAppliance();
        if (appliance.setAmpValue("LDAP_METHOD_IS_ENABLED", bl ? Boolean.TRUE : Boolean.FALSE)) {
            this.m_parent.setIsModified(true);
        }
    }

    public boolean getIsEnabled() {
        return this.getAuthSupport().getIsEnabled();
    }

    class TabPaneChangeListener
    implements ChangeListener {
        private int prevSelected = 0;

        TabPaneChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            if (jTabbedPane.isShowing()) {
                int n = jTabbedPane.getSelectedIndex();
                boolean bl = true;
                switch (this.prevSelected) {
                    case 0: {
                        bl = LdapController.this.validateServerPanel();
                        break;
                    }
                    case 1: {
                        if (LdapController.this.isSyntaxValidated()) {
                            bl = LdapController.this.validateSearchPanel();
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case 2: {
                        bl = LdapController.this.isSyntaxValidated() ? LdapController.this.validateQueryPanel() : true;
                    }
                }
                if (bl) {
                    this.prevSelected = n;
                } else {
                    jTabbedPane.removeChangeListener(this);
                    jTabbedPane.setSelectedIndex(this.prevSelected);
                    jTabbedPane.addChangeListener(this);
                }
            }
        }
    }
}

