/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.common.authentication;

import com.avocent.avworks.nmm.common.Appliance;
import com.avocent.avworks.nmm.common.BadFieldValueException;
import com.avocent.avworks.nmm.common.PanelController;
import com.avocent.avworks.nmm.common.authentication.AuthMethodController;
import com.avocent.avworks.nmm.common.authentication.AuthSettingsPanelController;
import com.avocent.avworks.nmm.common.authentication.LdapController;
import com.avocent.avworks.nmm.common.authentication.MethodSelectionController;
import com.avocent.avworks.nmm.common.authentication.components.LdapSimpleOptionsPanel;
import com.avocent.avworks.nmm.common.model.ApplianceRequest;
import com.avocent.avworks.nmm.common.model.AuthSupport;
import com.avocent.avworks.nmm.common.model.LdapSupport;
import com.avocent.avworks.services.ApplianceInfo;
import com.avocent.avworks.services.AppliancePropertiesDb;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.components.JTextFieldIPAddress;
import com.avocent.lib.gui.dialogs.Message;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class LdapSimpleController
extends PanelController
implements AuthMethodController,
PropertyChangeListener,
ActionListener {
    public static final String CNAME = "JPanelAuthSettings";
    protected LdapSimpleOptionsPanel m_view;
    protected MethodSelectionController m_methodSelectionController;
    protected boolean m_allwaysOn;
    protected AuthSettingsPanelController m_parent;

    public LdapSimpleController(AuthSettingsPanelController authSettingsPanelController) {
        super(authSettingsPanelController, null);
        this.m_parent = authSettingsPanelController;
        this.m_view = new LdapSimpleOptionsPanel(this);
        Appliance appliance = this.getAppliance();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_view.getStandardButton());
        buttonGroup.add(this.m_view.getExtendedButton());
        this.m_view.getStandardButton().addActionListener(this);
        this.m_view.getExtendedButton().addActionListener(this);
        boolean bl = appliance.isFeatureSupported("LDAPSchemaExtensions");
        if (!bl) {
            this.m_view.getStandardButton().setSelected(true);
            this.m_view.setSchemaVisibility(false);
        } else {
            this.m_view.setSchemaVisibility(true);
        }
        this.addDocumentListener(this.m_view.getAppDomainName(), "LDAP_APP_DN");
        this.addDocumentListener(this.m_view.getRootDomainName(), "LDAP_ROOT_DN");
        this.addDocumentListener(this.m_view.getGroupContainer(), "LDAP_GROUP_CONTAINER");
        this.addDocumentListener(this.m_view.getGroupContainerDN(), "LDAP_GROUP_CONTAINER_DN");
        this.addDocumentListener(this.m_view.getAccessCtrlAttr(), "LDAP_ACCESS_CONTROL");
        this.addFieldMapping("LDAP_APP_DN", this.m_view.getAppDomainName());
        this.addFieldMapping("LDAP_ROOT_DN", this.m_view.getRootDomainName());
        this.addFieldMapping("LDAP_GROUP_CONTAINER", this.m_view.getGroupContainer());
        this.addFieldMapping("LDAP_GROUP_CONTAINER_DN", this.m_view.getGroupContainerDN());
        this.addFieldMapping("LDAP_ACCESS_CONTROL", this.m_view.getAccessCtrlAttr());
        appliance.addPropertyChangeListener("LDAP_METHOD_PRIORITY", this);
        appliance.addPropertyChangeListener("LDAP_METHOD_IS_ENABLED", this);
        appliance.addPropertyChangeListener("LDAP_AUTH_LICENSED", this);
    }

    public JPanel getOptionsPanel() {
        return this.m_view;
    }

    public String getShortNameKey() {
        return "JPanelAuthSettings_ENUM_Ldap";
    }

    public String getUsePrompt() {
        return this.getAmpController().getResource("JPanelAuthSettings_UseLDAP");
    }

    public void priorityChanged(int n) {
        this.setActiveFields();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        Appliance appliance = this.getAppliance();
        LdapSupport ldapSupport = appliance.getLdapSupport();
        boolean bl = true;
        if (object == this.m_view.getStandardButton()) {
            boolean bl2 = this.m_view.getStandardButton().isSelected();
            appliance.setAmpValue("SCHEMA_EXTENSIONS", new Boolean(!bl2));
            this.updateSchemaExtensions(!bl2);
        } else if (object == this.m_view.getExtendedButton()) {
            boolean bl3 = this.m_view.getExtendedButton().isSelected();
            appliance.setAmpValue("SCHEMA_EXTENSIONS", new Boolean(bl3));
            this.updateSchemaExtensions(bl3);
        }
        this.getAmpPanelController().setIsModified(bl);
    }

    public void updateViewsImpl() {
        Appliance appliance = this.getAppliance();
        LdapSupport ldapSupport = appliance.getLdapSupport();
        this.updatePanel(appliance, ldapSupport);
        ApplianceInfo applianceInfo = this.getAmpController().getApplianceInfo();
        try {
            this.setSyntaxValidated(AppliancePropertiesDb.getBooleanValue((int)applianceInfo.getID(), (String)"LDAP_SYNTAX_VALIDATION", (boolean)true));
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)CNAME, (String)("Exception getting LDAP_SYNTAX_VALIDATION from database for appliance id " + applianceInfo.getID()), (Throwable)exceptionRequestFailed);
            this.setSyntaxValidated(true);
        }
        this.setActiveFields();
    }

    protected void updatePanel(Appliance appliance, LdapSupport ldapSupport) {
        Object[] objectArray = new Object[5];
        objectArray[0] = "LDAP_APP_DN";
        objectArray[1] = "LDAP_ROOT_DN";
        objectArray[2] = "LDAP_GROUP_CONTAINER";
        objectArray[3] = "LDAP_GROUP_CONTAINER_DN";
        objectArray[4] = "LDAP_ACCESS_CONTROL";
        Object[] objectArray2 = objectArray;
        JTextField[] jTextFieldArray = new JTextField[]{this.m_view.getAppDomainName(), this.m_view.getRootDomainName(), this.m_view.getGroupContainer(), this.m_view.getGroupContainerDN(), this.m_view.getAccessCtrlAttr()};
        this.updateTextFields(appliance, jTextFieldArray, objectArray2);
        Boolean bl = (Boolean)appliance.getValue("SCHEMA_EXTENSIONS");
        this.m_view.getExtendedButton().setSelected(bl != null && bl != false);
    }

    public void setMethodSelectionController(MethodSelectionController methodSelectionController) {
        this.m_methodSelectionController = methodSelectionController;
    }

    public void updateTextFields(Appliance appliance, JTextField[] jTextFieldArray, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            String string = appliance.getStringValue(objectArray[i]);
            jTextFieldArray[i].setText(string);
        }
    }

    public void setEnabledState(JRadioButton[] jRadioButtonArray, boolean bl) {
        for (int i = 0; i < jRadioButtonArray.length; ++i) {
            jRadioButtonArray[i].setEnabled(bl);
        }
    }

    protected void updateSchemaExtensions(boolean bl) {
        this.setActiveFields();
    }

    protected void setActiveFields() {
        boolean bl = this.m_methodSelectionController.getIsSelected(this);
        boolean bl2 = this.m_view.getExtendedButton().isSelected();
        this.m_view.getExtendedButton().setEnabled(bl);
        this.m_view.getStandardButton().setEnabled(bl);
        this.m_view.getAppDomainName().setEnabled(bl);
        this.m_view.getAppDomainName().setEditable(bl);
        this.m_view.getRootDomainName().setEnabled(bl);
        this.m_view.getRootDomainName().setEditable(bl);
        JTextField[] jTextFieldArray = new JTextField[]{this.m_view.getGroupContainer(), this.m_view.getGroupContainerDN(), this.m_view.getAccessCtrlAttr()};
        for (int i = 0; i < jTextFieldArray.length; ++i) {
            jTextFieldArray[i].setEnabled(!bl2 && bl);
            jTextFieldArray[i].setEditable(!bl2 && bl);
        }
    }

    public boolean applyValues(ApplianceRequest applianceRequest) throws BadFieldValueException, Exception {
        LdapSupport ldapSupport = this.getAppliance().getLdapSupport();
        ldapSupport.applyValues(applianceRequest);
        ApplianceInfo applianceInfo = this.getAmpController().getApplianceInfo();
        AppliancePropertiesDb.setValue((int)applianceInfo.getID(), (String)"LDAP_SYNTAX_VALIDATION", (boolean)this.isSyntaxValidated());
        return true;
    }

    public String setErrorFieldFocus(Object object) {
        this.setFocusOnField(object);
        return this.getAuthSupport().getFieldResourceKey(object);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        try {
            if (this.getAmpPanelController().getPanelState() != 101) {
                Appliance appliance = this.getAmpController().getAppliance();
                LdapSupport ldapSupport = appliance.getLdapSupport();
                String string = propertyChangeEvent.getPropertyName();
                if (string.equalsIgnoreCase("LDAP_METHOD_IS_ENABLED")) {
                    this.m_methodSelectionController.notifySelectionChanged(this);
                    this.setActiveFields();
                    this.getAmpPanelController().setIsModified(true);
                    if (ldapSupport.getIsEnabled()) {
                        ((AuthSettingsPanelController)this.m_ampPanelController).selectOptionsTabFor(this);
                    }
                } else if (string.equalsIgnoreCase("LDAP_AUTH_LICENSED")) {
                    this.getAmpPanelController().setReloadData();
                } else {
                    String[] stringArray = new String[6];
                    stringArray[0] = "SCHEMA_EXTENSIONS";
                    stringArray[1] = "LDAP_APP_DN";
                    stringArray[2] = "LDAP_ROOT_DN";
                    stringArray[3] = "LDAP_GROUP_CONTAINER";
                    stringArray[4] = "LDAP_GROUP_CONTAINER_DN";
                    stringArray[5] = "LDAP_ACCESS_CONTROL";
                    String[] stringArray2 = stringArray;
                    for (int i = 0; i < stringArray2.length; ++i) {
                        if (!stringArray2[i].equalsIgnoreCase(string)) continue;
                        this.updatePanel(appliance, ldapSupport);
                    }
                }
            }
        }
        catch (Exception exception) {
            Trace.logError((String)"Auth Panel", (String)"Failed to update on property change event.", (Throwable)exception);
        }
    }

    public boolean validateInputFields() {
        Appliance appliance = this.getAppliance();
        if (appliance.getLdapSupport().getIsLicensed() && this.m_methodSelectionController.getIsSelected(this)) {
            boolean bl = this.validatePanel();
            return bl;
        }
        return true;
    }

    boolean validatePanel() {
        try {
            Appliance appliance = this.getAppliance();
            LdapSupport ldapSupport = appliance.getLdapSupport();
            JTextField jTextField = this.m_view.getAppDomainName();
            String string = ldapSupport.getFieldResourceKey("LDAP_APP_DN");
            if (jTextField.isEditable() && !((JTextFieldIPAddress)jTextField).isDataValid()) {
                return false;
            }
            jTextField = this.m_view.getRootDomainName();
            string = ldapSupport.getFieldResourceKey("LDAP_ROOT_DN");
            if (jTextField.isEditable() && !((JTextFieldIPAddress)jTextField).isDataValid()) {
                return false;
            }
            jTextField = this.m_view.getGroupContainer();
            string = ldapSupport.getFieldResourceKey("LDAP_GROUP_CONTAINER");
            if (jTextField.isEditable()) {
                LdapController.validateFieldNotEmpty(this.getAmpController(), jTextField, string);
                LdapController.validateMaxFieldLength(this.getAmpController(), jTextField, string, ldapSupport.getMaxFieldLength());
            }
            jTextField = this.m_view.getGroupContainerDN();
            string = ldapSupport.getFieldResourceKey("LDAP_GROUP_CONTAINER_DN");
            if (jTextField.isEditable() && jTextField.getText().trim().length() > 0 && !((JTextFieldIPAddress)jTextField).isDataValid()) {
                return false;
            }
            jTextField = this.m_view.getAccessCtrlAttr();
            string = ldapSupport.getFieldResourceKey("LDAP_ACCESS_CONTROL");
            if (jTextField.isEditable()) {
                LdapController.validateFieldNotEmpty(this.getAmpController(), jTextField, string);
                LdapController.validateMaxFieldLength(this.getAmpController(), jTextField, string, ldapSupport.getMaxFieldLength());
            }
        }
        catch (BadFieldValueException badFieldValueException) {
            String string = badFieldValueException.getLocalizedMessage();
            if (string.length() != 0) {
                Message.show((Component)this.getAmpController().getMainFrame(), (String)string);
            }
            return false;
        }
        return true;
    }

    protected void showFailedValidationMessage(BadFieldValueException badFieldValueException) {
        JComponent jComponent = badFieldValueException.getComponent();
        String string = null;
        if (jComponent != null) {
            JTextField jTextField;
            int n;
            jComponent.requestFocusInWindow();
            if (jComponent instanceof JTextField && (n = badFieldValueException.getLocationIndex()) < (jTextField = (JTextField)badFieldValueException.getComponent()).getText().length()) {
                jTextField.setCaretPosition(n);
            }
        }
        if (badFieldValueException.isLocalized()) {
            string = badFieldValueException.getLocalizedMessage();
        }
        if (string == null || string.length() == 0) {
            string = this.getAmpController().getResource("JPanelAuthSettings_badvalue");
        }
        Message.show((Component)this.getAmpController().getMainFrame(), (String)string);
    }

    public AuthSupport getAuthSupport() {
        return this.getAppliance().getLdapSupport();
    }

    private boolean isSyntaxValidated() {
        Appliance appliance = this.getAmpController().getAppliance();
        Boolean bl = (Boolean)appliance.getValue("LDAP_SYNTAX_VALIDATION");
        Trace.logInfo((String)"LdapController", (String)("isSyntaxValidated returning " + bl));
        return bl == null || bl != false;
    }

    private void setSyntaxValidated(boolean bl) {
        Appliance appliance = this.getAmpController().getAppliance();
        Boolean bl2 = (Boolean)appliance.setValue("LDAP_SYNTAX_VALIDATION", bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setAllwaysOn(boolean bl) {
        this.m_allwaysOn = bl;
    }

    public void setIsEnabled(boolean bl) {
        Appliance appliance = this.m_parent.getAmpController().getAppliance();
        if (appliance.setAmpValue("LDAP_METHOD_IS_ENABLED", bl ? Boolean.TRUE : Boolean.FALSE)) {
            this.m_parent.setIsModified(true);
        }
    }

    public boolean getIsEnabled() {
        return this.getAuthSupport().getIsEnabled();
    }
}

