/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.common.authentication;

import com.avocent.avworks.nmm.common.authentication.AuthMethodController;
import com.avocent.avworks.nmm.common.authentication.AuthSettingsPanelController;
import com.avocent.avworks.nmm.common.authentication.MethodSelectionController;
import com.avocent.avworks.nmm.common.authentication.components.PrioritizedMethodPanel;
import com.avocent.lib.debug.Trace;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class PrioritizedMethodSelectionController
implements MethodSelectionController {
    public static final String TRACE_CTXT = "Prioritized Method Selection Panel";
    public static final String CNAME = "JPanelAuthSettings";
    protected PrioritizedMethodPanel m_view;
    protected AuthSettingsPanelController m_parent;
    protected AuthTableModel m_authTableModel;

    public PrioritizedMethodSelectionController(AuthSettingsPanelController authSettingsPanelController) {
        this.m_parent = authSettingsPanelController;
        authSettingsPanelController.getMethodSelectionPanel().add(this.createView());
        List list = authSettingsPanelController.getSupportedAuthMethods();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AuthMethodController authMethodController = (AuthMethodController)iterator.next();
            authMethodController.setMethodSelectionController(this);
        }
    }

    public Component createView() {
        this.m_view = new PrioritizedMethodPanel();
        this.m_authTableModel = new AuthTableModel();
        this.m_view.getTable().setModel(this.m_authTableModel);
        this.m_view.getTable().setColumnSelectionAllowed(false);
        this.m_view.getTable().setIntercellSpacing(new Dimension(0, 0));
        this.m_view.getTable().setShowGrid(false);
        this.m_view.getTable().setSelectionMode(0);
        this.m_view.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                PrioritizedMethodSelectionController.this.enableUpAndDownButtons();
                PrioritizedMethodSelectionController.this.m_parent.getAmpPanelController().setIsModified(true);
            }
        });
        this.m_view.getDownButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrioritizedMethodSelectionController.this.changePriorityAction(false);
            }
        });
        this.m_view.getUpButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrioritizedMethodSelectionController.this.changePriorityAction(true);
            }
        });
        this.m_view.getTable().setPreferredScrollableViewportSize(new Dimension(175, 54));
        this.m_view.getScrollPane().getViewport().setMinimumSize(new Dimension(175, 54));
        this.m_view.getUpButton().setEnabled(false);
        this.m_view.getUpButton().setMargin(new Insets(0, 0, 0, 0));
        this.m_view.getDownButton().setEnabled(false);
        this.m_view.getDownButton().setMargin(new Insets(0, 0, 0, 0));
        this.m_view.getScrollPane().getViewport().setBackground(UIManager.getColor("Table.background"));
        this.m_view.getReorderLabel().setText(this.m_parent.getResource("JPanelAuthSettings_Reorder"));
        return this.m_view;
    }

    public void updateViews() {
        ArrayList arrayList = this.m_parent.getLicensedMethods();
        ArrayList<AuthMethodController> arrayList2 = new ArrayList<AuthMethodController>(arrayList);
        boolean bl = true;
        while (bl) {
            bl = false;
            for (int i = 0; i < arrayList2.size() - 1; ++i) {
                AuthMethodController authMethodController = (AuthMethodController)arrayList2.get(i);
                AuthMethodController authMethodController2 = (AuthMethodController)arrayList2.get(i + 1);
                int n = authMethodController.getAuthSupport().getPriority();
                int n2 = authMethodController2.getAuthSupport().getPriority();
                if (n2 >= n || n2 == 0) continue;
                arrayList2.set(i, authMethodController2);
                arrayList2.set(i + 1, authMethodController);
                bl = true;
            }
        }
        Iterator iterator = arrayList2.iterator();
        boolean bl2 = false;
        int n = this.m_authTableModel.getRowCount();
        this.m_authTableModel.clear();
        while (iterator.hasNext()) {
            AuthMethodController authMethodController = (AuthMethodController)iterator.next();
            this.m_authTableModel.add(authMethodController);
        }
        if (n != this.m_authTableModel.getRowCount()) {
            this.m_authTableModel.fireTableDataChanged();
        } else {
            this.m_authTableModel.fireTableRowsUpdated(0, arrayList.size() - 1);
        }
    }

    public Component getView() {
        if (this.m_view == null) {
            this.createView();
        }
        return this.m_view;
    }

    public boolean getIsSelected(AuthMethodController authMethodController) {
        return authMethodController.getAuthSupport().getIsEnabled();
    }

    public void setVisible(boolean bl) {
        this.m_view.setVisible(bl);
    }

    public void notifySelectionChanged(AuthMethodController authMethodController) throws Exception {
    }

    private void changePriorityAction(boolean bl) {
        int n;
        int n2;
        int n3 = this.m_view.getTable().getSelectedRow();
        if (bl && n3 == 0 || !bl && n3 == this.m_authTableModel.getRowCount() - 1) {
            return;
        }
        for (n2 = 0; n2 < this.m_authTableModel.getRowCount(); ++n2) {
            this.m_authTableModel.get(n2).getAuthSupport().setPriority(n2 + 1);
        }
        n2 = bl ? n3 - 1 : n3;
        int n4 = bl ? n3 : n3 + 1;
        AuthMethodController authMethodController = this.m_authTableModel.get(n2);
        AuthMethodController authMethodController2 = this.m_authTableModel.get(n4);
        int n5 = authMethodController.getAuthSupport().getPriority();
        if (n5 == (n = authMethodController2.getAuthSupport().getPriority())) {
            Trace.logError((String)TRACE_CTXT, (String)"Ignoring priority change because two adjacent rows have the same value.");
            return;
        }
        authMethodController2.getAuthSupport().setPriority(n5);
        authMethodController.getAuthSupport().setPriority(n);
        this.updateViews();
        int n6 = n3 + (bl ? -1 : 1);
        this.m_view.getTable().getSelectionModel().setSelectionInterval(n6, n6);
    }

    public void enableUpAndDownButtons() {
        int n = this.m_view.getTable().getSelectedRow();
        int n2 = this.m_authTableModel.getRowCount();
        this.m_view.getUpButton().setEnabled(n2 == 1 || n == -1 ? false : n != 0);
        this.m_view.getDownButton().setEnabled(n2 == 1 || n == -1 ? false : n == 0);
    }

    class AuthTableModel
    extends AbstractTableModel {
        final String[] columnNames;
        protected ArrayList m_data;

        AuthTableModel() {
            this.columnNames = new String[]{PrioritizedMethodSelectionController.this.m_parent.getResource("JPanelAuthSettings_Method"), PrioritizedMethodSelectionController.this.m_parent.getResource("JPanelAuthSettings_Enabled")};
            this.m_data = new ArrayList();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public void clear() {
            this.m_data.clear();
        }

        public void add(AuthMethodController authMethodController) {
            this.m_data.add(authMethodController);
        }

        public AuthMethodController get(int n) {
            return (AuthMethodController)this.m_data.get(n);
        }

        public AuthMethodController getAuthMethodController(int n) {
            return (AuthMethodController)this.m_data.get(n);
        }

        public int getRowCount() {
            return this.m_data.size();
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                AuthMethodController authMethodController = (AuthMethodController)this.m_data.get(n);
                Boolean bl = (Boolean)object;
                authMethodController.getAuthSupport().setIsEnabled(bl);
            }
        }

        public Object getValueAt(int n, int n2) {
            AuthMethodController authMethodController = (AuthMethodController)this.m_data.get(n);
            Object object = null;
            object = n2 == 0 ? PrioritizedMethodSelectionController.this.m_parent.getResource(authMethodController.getShortNameKey()) : new Boolean(authMethodController.getAuthSupport().getIsEnabled());
            return object;
        }
    }
}

