/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.common.authentication;

import com.avocent.avworks.nmm.common.Appliance;
import com.avocent.avworks.nmm.common.BadFieldValueException;
import com.avocent.avworks.nmm.common.ExceptionSnmpRequestFailed;
import com.avocent.avworks.nmm.common.PanelController;
import com.avocent.avworks.nmm.common.ValidationRules;
import com.avocent.avworks.nmm.common.authentication.AuthMethodController;
import com.avocent.avworks.nmm.common.authentication.AuthSettingsPanelController;
import com.avocent.avworks.nmm.common.authentication.MethodSelectionController;
import com.avocent.avworks.nmm.common.authentication.components.RadiusOptionsPanel;
import com.avocent.avworks.nmm.common.model.ApplianceRequest;
import com.avocent.avworks.nmm.common.model.AuthSupport;
import com.avocent.avworks.nmm.common.model.RadiusSupport;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.gui.dialogs.Message;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RadiusController
extends PanelController
implements AuthMethodController,
PropertyChangeListener {
    public static final String CNAME = "RadiusOptionsPanel";
    public static final String TRACE_CTXT = "RadiusController";
    protected RadiusOptionsPanel m_view = new RadiusOptionsPanel(this);
    protected MethodSelectionController m_methodSelectionController;
    protected boolean m_allwaysOn;

    public RadiusController(AuthSettingsPanelController authSettingsPanelController) {
        super(authSettingsPanelController, authSettingsPanelController);
        this.m_view.getPrimaryIPTextField().setStyle(3);
        this.m_view.getSecondaryIPTextField().setStyle(2);
        this.addFieldMapping("RADIUS_PRIMARY_IP", (Component)this.m_view.getPrimaryIPTextField());
        this.addFieldMapping("RADIUS_PRIMARY_SECRET", this.m_view.getPrimarySharedSecretTextField());
        this.addFieldMapping("RADIUS_PRIMARY_ACCESS_RIGHTS", this.m_view.getPrimaryAccessRightsTextField());
        this.addFieldMapping("RADIUS_PRIMARY_UDP_PORT", this.m_view.getPrimaryUDPPortTextField());
        this.addFieldMapping("RADIUS_PRIMARY_TIMEOUT", this.m_view.getPrimaryTimeoutTextField());
        this.addFieldMapping("RADIUS_PRIMARY_RETRY_COUNT", this.m_view.getPrimaryRetryCountTextField());
        this.addFieldMapping("RADIUS_SECONDARY_IP", (Component)this.m_view.getSecondaryIPTextField());
        this.addFieldMapping("RADIUS_SECONDARY_SECRET", this.m_view.getSecondarySharedSecretTextField());
        this.addFieldMapping("RADIUS_SECONDARY_ACCESS_RIGHTS", this.m_view.getSecondaryAccessRightsTextField());
        this.addFieldMapping("RADIUS_SECONDARY_UDP_PORT", this.m_view.getSecondaryUDPPortTextField());
        this.addFieldMapping("RADIUS_SECONDARY_TIMEOUT", this.m_view.getSecondaryTimeoutTextField());
        this.addFieldMapping("RADIUS_SECONDARY_RETRY_COUNT", this.m_view.getSecondaryRetryCountTextField());
        this.addDocumentListener((JTextField)this.m_view.getPrimaryIPTextField(), "RADIUS_PRIMARY_IP");
        this.addDocumentListener(this.m_view.getPrimarySharedSecretTextField(), "RADIUS_PRIMARY_SECRET");
        this.addDocumentListener(this.m_view.getPrimaryAccessRightsTextField(), "RADIUS_PRIMARY_ACCESS_RIGHTS");
        this.addDocumentListener(this.m_view.getPrimaryUDPPortTextField(), "RADIUS_PRIMARY_UDP_PORT");
        this.addDocumentListener(this.m_view.getPrimaryTimeoutTextField(), "RADIUS_PRIMARY_TIMEOUT");
        this.addDocumentListener(this.m_view.getPrimaryRetryCountTextField(), "RADIUS_PRIMARY_RETRY_COUNT");
        this.addDocumentListener((JTextField)this.m_view.getSecondaryIPTextField(), "RADIUS_SECONDARY_IP");
        this.addDocumentListener(this.m_view.getSecondarySharedSecretTextField(), "RADIUS_SECONDARY_SECRET");
        this.addDocumentListener(this.m_view.getSecondaryAccessRightsTextField(), "RADIUS_SECONDARY_ACCESS_RIGHTS");
        this.addDocumentListener(this.m_view.getSecondaryUDPPortTextField(), "RADIUS_SECONDARY_UDP_PORT");
        this.addDocumentListener(this.m_view.getSecondaryTimeoutTextField(), "RADIUS_SECONDARY_TIMEOUT");
        this.addDocumentListener(this.m_view.getSecondaryRetryCountTextField(), "RADIUS_SECONDARY_RETRY_COUNT");
        Appliance appliance = this.getAppliance();
        appliance.addPropertyChangeListener("RADIUS_SECONDARY_IP", this);
        appliance.addPropertyChangeListener("RADIUS_METHOD_IS_ENABLED", this);
        appliance.addPropertyChangeListener("RADIUS_AUTH_LICENSED", this);
    }

    public String getShortNameKey() {
        return "RadiusOptionsPanel_Radius";
    }

    public boolean validateInputFields() {
        try {
            Appliance appliance = this.m_ampPanelController.getAmpController().getAppliance();
            RadiusSupport radiusSupport = appliance.getRadiusSupport();
            if (!this.getAuthSupport().getIsEnabled()) {
                return true;
            }
            if (!this.m_view.getPrimaryIPTextField().isDataValid() || !this.m_view.getSecondaryIPTextField().isDataValid()) {
                return false;
            }
            JTextField jTextField = this.m_view.getPrimarySharedSecretTextField();
            String string = radiusSupport.getFieldResourceKey("RADIUS_PRIMARY_SECRET");
            String string2 = this.getAmpController().getResource(string);
            ValidationRules.stringLength(jTextField, string2, 8, 24);
            jTextField = this.m_view.getPrimaryAccessRightsTextField();
            string = radiusSupport.getFieldResourceKey("RADIUS_PRIMARY_ACCESS_RIGHTS");
            string2 = this.getAmpController().getResource(string);
            ValidationRules.intRange(jTextField, string2, 1, 255);
            jTextField = this.m_view.getPrimaryUDPPortTextField();
            string = radiusSupport.getFieldResourceKey("RADIUS_PRIMARY_UDP_PORT");
            string2 = this.getAmpController().getResource(string);
            ValidationRules.intRange(jTextField, string2, 1, 65535);
            jTextField = this.m_view.getPrimaryTimeoutTextField();
            string = radiusSupport.getFieldResourceKey("RADIUS_PRIMARY_TIMEOUT");
            string2 = this.getAmpController().getResource(string);
            ValidationRules.intRange(jTextField, string2, 1, 60);
            jTextField = this.m_view.getPrimaryRetryCountTextField();
            string = radiusSupport.getFieldResourceKey("RADIUS_PRIMARY_RETRY_COUNT");
            string2 = this.getAmpController().getResource(string);
            ValidationRules.intRange(jTextField, string2, 1, 10);
            if (this.m_view.getSecondaryIPTextField().getText().trim().length() > 0) {
                jTextField = this.m_view.getSecondarySharedSecretTextField();
                string = radiusSupport.getFieldResourceKey("RADIUS_SECONDARY_SECRET");
                string2 = this.getAmpController().getResource(string);
                ValidationRules.stringLength(jTextField, string2, 8, 24);
                jTextField = this.m_view.getSecondaryAccessRightsTextField();
                string = radiusSupport.getFieldResourceKey("RADIUS_SECONDARY_ACCESS_RIGHTS");
                string2 = this.getAmpController().getResource(string);
                ValidationRules.intRange(jTextField, string2, 1, 255);
                jTextField = this.m_view.getSecondaryUDPPortTextField();
                string = radiusSupport.getFieldResourceKey("RADIUS_SECONDARY_UDP_PORT");
                string2 = this.getAmpController().getResource(string);
                ValidationRules.intRange(jTextField, string2, 1, 65535);
                jTextField = this.m_view.getSecondaryTimeoutTextField();
                string = radiusSupport.getFieldResourceKey("RADIUS_SECONDARY_TIMEOUT");
                string2 = this.getAmpController().getResource(string);
                ValidationRules.intRange(jTextField, string2, 1, 60);
                jTextField = this.m_view.getSecondaryRetryCountTextField();
                string = radiusSupport.getFieldResourceKey("RADIUS_SECONDARY_RETRY_COUNT");
                string2 = this.getAmpController().getResource(string);
                ValidationRules.intRange(jTextField, string2, 1, 10);
            }
            return true;
        }
        catch (BadFieldValueException badFieldValueException) {
            JTextField jTextField;
            int n;
            Object object;
            if (badFieldValueException.getCause() instanceof ExceptionSnmpRequestFailed) {
                object = (ExceptionSnmpRequestFailed)((Object)badFieldValueException.getCause());
                this.m_ampPanelController.setErrorStatus(object.getErrorCode());
                this.m_ampPanelController.logError(object.getMessage(), (Exception)object);
            }
            this.m_ampPanelController.setErrorFieldLabel(null);
            object = this.setErrorFieldFocus(badFieldValueException.getBadFieldId());
            if (this.m_ampPanelController.getErrorFieldLabel() != null) {
                String[] stringArray = new String[]{this.m_ampPanelController.getErrorFieldLabel()};
                object = this.m_ampPanelController.getResource("RadiusOptionsPanel_Apply_Failed", stringArray);
            } else {
                object = this.m_ampPanelController.getResource("RadiusOptionsPanel_Generic_Apply_Failed");
            }
            if (badFieldValueException.getComponent() instanceof JTextField && badFieldValueException.getLocationIndex() > 0 && (n = badFieldValueException.getLocationIndex()) < (jTextField = (JTextField)badFieldValueException.getComponent()).getText().length()) {
                jTextField.setCaretPosition(n);
            }
            if (badFieldValueException.getLocalizedMessage() != null) {
                object = badFieldValueException.getLocalizedMessage();
            }
            Message.show((Component)this.m_ampPanelController.getAmpController().getMainFrame(), (String)object);
            return false;
        }
        catch (Exception exception) {
            this.m_ampPanelController.getAmpController().showException(null, this.getAmpPanelController().getTraceContext(), "", exception);
            return false;
        }
    }

    public String setErrorFieldFocus(Object object) {
        this.setFocusOnField(object);
        return this.getAuthSupport().getFieldResourceKey(object);
    }

    public JPanel getOptionsPanel() {
        return this.m_view;
    }

    public String getUsePrompt() {
        return "Use Radius Authentication";
    }

    public void setMethodSelectionController(MethodSelectionController methodSelectionController) {
        this.m_methodSelectionController = methodSelectionController;
    }

    public boolean applyValues(ApplianceRequest applianceRequest) throws BadFieldValueException, Exception {
        this.m_ampPanelController.getAmpController().getAppliance().getRadiusSupport().applyValues(applianceRequest);
        return true;
    }

    public AuthSupport getAuthSupport() {
        return this.m_ampPanelController.getAmpController().getAppliance().getRadiusSupport();
    }

    public void setAllwaysOn(boolean bl) {
        this.m_allwaysOn = bl;
    }

    protected void setSecondaryServerEnabled(boolean bl) {
        this.m_view.getSecondarySharedSecretTextField().setEnabled(bl);
        this.m_view.getSecondaryAccessRightsTextField().setEnabled(bl);
        this.m_view.getSecondaryUDPPortTextField().setEnabled(bl);
        this.m_view.getSecondaryTimeoutTextField().setEnabled(bl);
        this.m_view.getSecondaryRetryCountTextField().setEnabled(bl);
        this.m_view.getSecondarySharedSecretTextField().setEditable(bl);
        this.m_view.getSecondaryAccessRightsTextField().setEditable(bl);
        this.m_view.getSecondaryUDPPortTextField().setEditable(bl);
        this.m_view.getSecondaryTimeoutTextField().setEditable(bl);
        this.m_view.getSecondaryRetryCountTextField().setEditable(bl);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        try {
            if (this.getAmpPanelController().getPanelState() != 101) {
                Appliance appliance = this.m_ampPanelController.getAppliance();
                RadiusSupport radiusSupport = appliance.getRadiusSupport();
                String string = propertyChangeEvent.getPropertyName();
                if (string.equalsIgnoreCase("RADIUS_METHOD_IS_ENABLED")) {
                    this.m_methodSelectionController.updateViews();
                    this.updateViews();
                    if (radiusSupport.getIsEnabled()) {
                        ((AuthSettingsPanelController)this.m_ampPanelController).selectOptionsTabFor(this);
                    }
                } else if (string.equalsIgnoreCase("RADIUS_AUTH_LICENSED")) {
                    this.getAmpPanelController().setReloadData();
                } else if (string.equalsIgnoreCase("RADIUS_SECONDARY_IP")) {
                    this.setSecondaryServerEnabled(propertyChangeEvent.getNewValue().toString().length() > 0);
                    this.m_ampPanelController.setIsModified(true);
                }
            }
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CTXT, (String)"Failed to update on property change event.", (Throwable)exception);
        }
    }

    protected void updateViewsImpl() throws Exception {
        Appliance appliance = this.getAppliance();
        RadiusSupport radiusSupport = appliance.getRadiusSupport();
        String string = appliance.getStringValue("RADIUS_PRIMARY_IP");
        String string2 = appliance.getStringValue("RADIUS_PRIMARY_ACCESS_RIGHTS");
        if (string.trim().equalsIgnoreCase("0.0.0.0")) {
            string = "";
        }
        if (string2.trim().equalsIgnoreCase("0")) {
            string2 = "";
        }
        this.m_view.getPrimaryIPTextField().setText(string);
        this.m_view.getPrimarySharedSecretTextField().setText(appliance.getStringValue("RADIUS_PRIMARY_SECRET"));
        this.m_view.getPrimaryAccessRightsTextField().setText(string2);
        this.m_view.getPrimaryUDPPortTextField().setText(appliance.getStringValue("RADIUS_PRIMARY_UDP_PORT"));
        this.m_view.getPrimaryTimeoutTextField().setText(appliance.getStringValue("RADIUS_PRIMARY_TIMEOUT"));
        this.m_view.getPrimaryRetryCountTextField().setText(appliance.getStringValue("RADIUS_PRIMARY_RETRY_COUNT"));
        String string3 = appliance.getStringValue("RADIUS_SECONDARY_IP");
        String string4 = appliance.getStringValue("RADIUS_SECONDARY_ACCESS_RIGHTS");
        if (string3.trim().equalsIgnoreCase("0.0.0.0")) {
            string3 = "";
        }
        if (string4.trim().equalsIgnoreCase("0")) {
            string4 = "";
        }
        this.m_view.getSecondaryIPTextField().setText(string3);
        this.m_view.getSecondarySharedSecretTextField().setText(appliance.getStringValue("RADIUS_SECONDARY_SECRET"));
        this.m_view.getSecondaryAccessRightsTextField().setText(string4);
        this.m_view.getSecondaryUDPPortTextField().setText(appliance.getStringValue("RADIUS_SECONDARY_UDP_PORT"));
        this.m_view.getSecondaryTimeoutTextField().setText(appliance.getStringValue("RADIUS_SECONDARY_TIMEOUT"));
        this.m_view.getSecondaryRetryCountTextField().setText(appliance.getStringValue("RADIUS_SECONDARY_RETRY_COUNT"));
        boolean bl = radiusSupport.getIsEnabled();
        JTextField[] jTextFieldArray = new JTextField[]{this.m_view.getPrimaryIPTextField(), this.m_view.getPrimarySharedSecretTextField(), this.m_view.getPrimaryAccessRightsTextField(), this.m_view.getPrimaryUDPPortTextField(), this.m_view.getPrimaryTimeoutTextField(), this.m_view.getPrimaryRetryCountTextField(), this.m_view.getSecondaryIPTextField(), this.m_view.getSecondarySharedSecretTextField(), this.m_view.getSecondaryAccessRightsTextField(), this.m_view.getSecondaryUDPPortTextField(), this.m_view.getSecondaryTimeoutTextField(), this.m_view.getSecondaryRetryCountTextField()};
        for (int i = 0; i < jTextFieldArray.length; ++i) {
            jTextFieldArray[i].setEnabled(bl);
            jTextFieldArray[i].setEditable(bl);
        }
        if (bl) {
            this.setSecondaryServerEnabled(string3.length() > 0);
        }
    }

    public void setIsEnabled(boolean bl) {
    }

    public boolean getIsEnabled() {
        return false;
    }
}

