/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.explorer;

import com.avocent.avworks.explorer.CustomFieldLabel;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.util.ResourceManager;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class AbstractTableModelCustomFieldDatastore
extends AbstractTableModel {
    public static final String CNAME = "AbstractTableModelCustomFieldDatastore";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.explorer.Res");
    final String[] m_aszColumnNames = new String[]{res.getString("AbstractTableModelCustomFieldDatastore_ID"), res.getString("AbstractTableModelCustomFieldDatastore_Singular"), res.getString("AbstractTableModelCustomFieldDatastore_Plural")};
    private Vector m_vData = new Vector();

    public int getColumnCount() {
        return this.m_aszColumnNames.length;
    }

    public int getRowCount() {
        return this.m_vData.size();
    }

    public String getColumnName(int n) {
        if (n > this.m_aszColumnNames.length || n < 0) {
            Trace.logError((String)CNAME, (String)"Error: getColumnName method\nAn invalid column number request has been made.");
            return " ";
        }
        return this.m_aszColumnNames[n];
    }

    public synchronized Object getValueAt(int n, int n2) {
        try {
            CustomFieldLabel customFieldLabel = (CustomFieldLabel)this.m_vData.elementAt(n);
            switch (n2) {
                case 0: {
                    return customFieldLabel.getCustomFieldLabelId();
                }
                case 1: {
                    return customFieldLabel.getCustomFieldLabelSingular();
                }
                case 2: {
                    return customFieldLabel.getCustomFieldLabelPlural();
                }
            }
        }
        catch (Exception exception) {
            Trace.logError((String)CNAME, (String)("Exception: getValueAt method\nAn Exception occurred while retrieving data from the datastore" + exception.getMessage()));
        }
        return " ";
    }

    public Class getColumnClass(int n) {
        if (n > this.m_aszColumnNames.length) {
            Trace.logError((String)CNAME, (String)"Error: getColumnClass method\nA request for a non-existent column Class in the Custom\nField Label table was issued. An null value was returned.");
            return null;
        }
        return this.getValueAt(0, n).getClass();
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public synchronized void setValueAt(Object object, int n, int n2) {
        CustomFieldLabel customFieldLabel = (CustomFieldLabel)this.m_vData.elementAt(n);
        if (this.m_vData.elementAt(n2) instanceof CustomFieldLabel) {
            if (n2 == 0) {
                customFieldLabel.setCustomFieldLabelId((String)object);
            } else if (n2 == 1) {
                customFieldLabel.setCustomFieldLabelSingular((String)object);
            } else {
                customFieldLabel.setCustomFieldLabelPlural((String)object);
            }
        } else {
            this.m_vData.setElementAt(object, n2);
        }
        this.fireTableCellUpdated(n, n2);
    }

    synchronized void addCustomFieldLabel(CustomFieldLabel customFieldLabel, int n) {
        if (customFieldLabel == null) {
            Trace.logError((String)CNAME, (String)"Error: addCustomFieldLabel( CustomFieldLabel, int ) method\nCustomFieldLabel reference argument is null");
            return;
        }
        if (n < 0 || n > 2) {
            Trace.logError((String)CNAME, (String)"Error: addCustomFieldLabel( CustomFieldLabel, int ) method\nnIndex argument is not between 0 and 2");
            return;
        }
        this.m_vData.insertElementAt(customFieldLabel, n);
    }

    synchronized void addCustomFieldLabel(CustomFieldLabel customFieldLabel) {
        if (customFieldLabel == null) {
            Trace.logError((String)CNAME, (String)"Error addCustomFieldLabel( CustomFieldLabel ) method\nCustomFieldLabel reference argument is null");
            return;
        }
        this.m_vData.addElement(customFieldLabel);
    }

    void defaultCustomFieldLabel() {
        CustomFieldLabel customFieldLabel = new CustomFieldLabel();
        customFieldLabel.setCustomFieldLabelId(res.getString("AbstractTableModelCustomFieldDatastore_1"));
        customFieldLabel.setCustomFieldLabelSingular(res.getString("AbstractTableModelCustomFieldDatastore_Site"));
        customFieldLabel.setCustomFieldLabelPlural(res.getString("AbstractTableModelCustomFieldDatastore_Sites"));
        CustomFieldLabel customFieldLabel2 = new CustomFieldLabel();
        customFieldLabel2.setCustomFieldLabelId(res.getString("AbstractTableModelCustomFieldDatastore_2"));
        customFieldLabel2.setCustomFieldLabelSingular(res.getString("AbstractTableModelCustomFieldDatastore_Department"));
        customFieldLabel2.setCustomFieldLabelPlural(res.getString("AbstractTableModelCustomFieldDatastore_Departments"));
        CustomFieldLabel customFieldLabel3 = new CustomFieldLabel();
        customFieldLabel3.setCustomFieldLabelId(res.getString("AbstractTableModelCustomFieldDatastore_3"));
        customFieldLabel3.setCustomFieldLabelSingular(res.getString("AbstractTableModelCustomFieldDatastore_Location"));
        customFieldLabel3.setCustomFieldLabelPlural(res.getString("AbstractTableModelCustomFieldDatastore_Locations"));
        this.addCustomFieldLabel(customFieldLabel);
        this.addCustomFieldLabel(customFieldLabel2);
        this.addCustomFieldLabel(customFieldLabel3);
    }

    CustomFieldLabel getCustomFieldLabel(int n) {
        if (n >= this.m_vData.size() || n < 0) {
            Trace.logError((String)CNAME, (String)"Error: getCustomFieldLabel method\nA request for a non-existent row has been issued.");
            return null;
        }
        return (CustomFieldLabel)this.m_vData.elementAt(n);
    }

    String dumpCustomFieldLabelDatastore() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_vData.size(); ++i) {
            CustomFieldLabel customFieldLabel = (CustomFieldLabel)this.m_vData.elementAt(i);
            stringBuffer.append(customFieldLabel.getCustomFieldLabelId() + "\n");
        }
        return stringBuffer.toString();
    }

    String getSite() {
        CustomFieldLabel customFieldLabel = (CustomFieldLabel)this.m_vData.elementAt(0);
        return customFieldLabel.m_szPlural;
    }
}

