/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.explorer;

import com.avocent.avworks.explorer.AbstractTableModelUnitList;
import com.avocent.avworks.explorer.UnitListFilter;
import com.avocent.avworks.services.ServerInfo;
import com.avocent.avworks.services.UnitInfo;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.gui.components.SortArrowIcon;
import com.avocent.lib.gui.renderers.DefaultTableCellRendererIconName;
import com.avocent.lib.gui.renderers.TableCellIconName;
import com.avocent.lib.util.ReverseComparator;
import com.avocent.lib.util.StringUtilities;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class AbstractTableModelUnitList
extends AbstractTableModel {
    public static final String CNAME = "AbstractTableModelUnitList";
    private int m_nColumnHeaderMode = 0;
    public static final int COLUMN_HEADERS_NONE = 0;
    public static final int COLUMN_HEADERS_NAME_TYPE_CF1_CF2_CF3 = 1;
    public static final int COLUMN_HEADERS_NAME_CF1_CF2_CF3 = 2;
    public static final int COLUMN_HEADERS_NAME_TYPE_CF2_CF3 = 3;
    public static final int COLUMN_HEADERS_NAME_TYPE_CF3 = 4;
    private String[] m_aszColumnHeadersCache = new String[]{"", "", "", "", ""};
    private static final int COL_HDR_CACHE_NAME = 0;
    private static final int COL_HDR_CACHE_TYPE = 1;
    private static final int COL_HDR_CACHE_CF1 = 2;
    private static final int COL_HDR_CACHE_CF2 = 3;
    private static final int COL_HDR_CACHE_CF3 = 4;
    private String[] m_aszCurrentColumnHeaders = new String[0];
    private List m_alTableData = new ArrayList();
    private List m_alViewIndex = new ArrayList();
    private List m_alModelIndex = new ArrayList();
    private UnitListFilter m_viewFilter = UnitListFilter.DEFAULT;
    private UnitListFilter m_groupFilter = UnitListFilter.DEFAULT;
    private UnitListFilter m_searchFilter = UnitListFilter.DEFAULT;
    private int m_nSortColumn = 0;
    private boolean m_bAscending = true;
    private Collator m_collator;
    private TableCellIconName m_tcinIconName = new TableCellIconName();
    private Object m_objectTableDataAccessLock = new Object();
    private JTable m_jTable;
    private UnitComparator m_comp = new UnitComparator();
    private Comparator m_rvscomp = new ReverseComparator((Comparator)this.m_comp);
    private Comparator m_internalComp = new InternalComparator();

    public AbstractTableModelUnitList(JTable jTable) throws ExceptionConstructorFailed {
        if (jTable == null) {
            Trace.logError((String)CNAME, (String)"The JTable argument was null");
            throw new ExceptionConstructorFailed();
        }
        this.m_jTable = jTable;
        jTable.setDefaultRenderer(TableCellIconName.class, (TableCellRenderer)new DefaultTableCellRendererIconName());
        jTable.getTableHeader().setDefaultRenderer(new JButtonHeaderRenderer());
        this.createColumnHeaderMouseListener(jTable);
        jTable.getTableHeader().setReorderingAllowed(false);
        this.m_collator = Collator.getInstance();
        this.m_collator.setStrength(1);
        this.m_collator.setDecomposition(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTableData(final UnitInfo[] unitInfoArray) {
        if (unitInfoArray == null) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        AbstractTableModelUnitList.this.setTableData(unitInfoArray);
                    }
                });
            }
            catch (Exception exception) {
                Trace.logError((String)CNAME, (String)"Exception while setting table data", (Throwable)exception);
            }
            return;
        }
        Object object = this.m_objectTableDataAccessLock;
        synchronized (object) {
            this.m_alTableData = new ArrayList();
            this.m_alTableData.addAll(Arrays.asList(unitInfoArray));
            this.sortTableData();
            this.rebuildIndices();
            this.fireTableDataChanged();
        }
    }

    public void initializeTableData(UnitInfo[] unitInfoArray, int n) throws ExceptionInvalidArgument {
        if (unitInfoArray == null) {
            Trace.logError((String)"AbstractTableModelUnitList:setTableData", (String)"The UnitInfo[] argument was null");
            throw new ExceptionInvalidArgument();
        }
        this.m_alTableData = new ArrayList();
        this.m_alTableData.addAll(Arrays.asList(unitInfoArray));
        this.setColumnHeaderMode(n);
        this.sortTableData();
        this.rebuildIndices();
        this.fireTableStructureChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColumnHeaderMode(int n) {
        Object object = this.m_objectTableDataAccessLock;
        synchronized (object) {
            this.m_nColumnHeaderMode = n;
            this.updateColumnHeaders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColumnHeaders(final String[] stringArray) {
        if (stringArray == null || stringArray.length != 5) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        AbstractTableModelUnitList.this.setColumnHeaders(stringArray);
                    }
                });
            }
            catch (Exception exception) {
                Trace.logError((String)CNAME, (String)"Exception while setting column headers", (Throwable)exception);
            }
            return;
        }
        Object object = this.m_objectTableDataAccessLock;
        synchronized (object) {
            System.arraycopy(stringArray, 0, this.m_aszColumnHeadersCache, 0, stringArray.length);
            this.updateColumnHeaders();
        }
        this.fireTableStructureChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUnits(final UnitInfo[] unitInfoArray) {
        if (unitInfoArray == null || unitInfoArray.length == 0) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        AbstractTableModelUnitList.this.addUnits(unitInfoArray);
                    }
                });
            }
            catch (Exception exception) {
                Trace.logError((String)CNAME, (String)"Exception while adding units", (Throwable)exception);
            }
            return;
        }
        Object object = this.m_objectTableDataAccessLock;
        synchronized (object) {
            List list = this.getSelectedUnits();
            for (int i = 0; i < unitInfoArray.length; ++i) {
                unitInfoArray[i].createCollationKeys(this.m_collator);
                int n = Collections.binarySearch(this.m_alTableData, unitInfoArray[i], this.m_internalComp);
                if (n >= 0) {
                    Trace.logInfo((String)CNAME, (String)("Attempting to add duplicate unit " + unitInfoArray[i] + " -- Continuing to next unit"));
                    continue;
                }
                this.m_alTableData.add(-n - 1, unitInfoArray[i]);
            }
            this.rebuildIndices();
            this.fireTableDataChanged();
            this.selectUnits(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUnits(final UnitInfo[] unitInfoArray) {
        if (unitInfoArray == null || unitInfoArray.length == 0) {
            Trace.logError((String)"AbstractTableModelUnitList:updateUnits", (String)"The UnitInfo[] argument was invalid");
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        AbstractTableModelUnitList.this.updateUnits(unitInfoArray);
                    }
                });
            }
            catch (Exception exception) {
                Trace.logError((String)CNAME, (String)"Exception while updating units", (Throwable)exception);
            }
            return;
        }
        Object object = this.m_objectTableDataAccessLock;
        synchronized (object) {
            List list = this.getSelectedUnits();
            for (int i = 0; i < unitInfoArray.length; ++i) {
                UnitInfo unitInfo;
                UnitInfo unitInfo2 = unitInfoArray[i];
                unitInfo2.createCollationKeys(this.m_collator);
                int n = Collections.binarySearch(this.m_alTableData, unitInfo2, this.m_internalComp);
                if (n < 0 || unitInfo2 == (unitInfo = (UnitInfo)this.m_alTableData.get(n))) continue;
                this.m_alTableData.set(n, unitInfo2);
            }
            this.rebuildIndices();
            this.fireTableDataChanged();
            this.selectUnits(list);
        }
    }

    public UnitInfo[] renameServerType(String string, String string2) {
        ArrayList<ServerInfo> arrayList = new ArrayList<ServerInfo>();
        Iterator iterator = this.m_alTableData.iterator();
        while (iterator.hasNext()) {
            ServerInfo serverInfo;
            UnitInfo unitInfo = (UnitInfo)iterator.next();
            if (unitInfo.isAppliance() || !StringUtilities.stringsEqual((String)(serverInfo = (ServerInfo)unitInfo).getType(), (String)string)) continue;
            serverInfo.setType(string2);
            arrayList.add(serverInfo);
        }
        return arrayList.toArray(new UnitInfo[0]);
    }

    public UnitInfo[] renameCustomField1(String string, String string2) {
        ArrayList<UnitInfo> arrayList = new ArrayList<UnitInfo>();
        Iterator iterator = this.m_alTableData.iterator();
        while (iterator.hasNext()) {
            UnitInfo unitInfo = (UnitInfo)iterator.next();
            if (!StringUtilities.stringsEqual((String)unitInfo.getCustomField1(), (String)string)) continue;
            unitInfo.setCustomField1(string2);
            arrayList.add(unitInfo);
        }
        return arrayList.toArray(new UnitInfo[0]);
    }

    public UnitInfo[] renameCustomField2(String string, String string2, String string3) {
        ArrayList<UnitInfo> arrayList = new ArrayList<UnitInfo>();
        Iterator iterator = this.m_alTableData.iterator();
        while (iterator.hasNext()) {
            UnitInfo unitInfo = (UnitInfo)iterator.next();
            if (!StringUtilities.stringsEqual((String)unitInfo.getCustomField1(), (String)string) || !StringUtilities.stringsEqual((String)unitInfo.getCustomField2(), (String)string2)) continue;
            unitInfo.setCustomField2(string3);
            arrayList.add(unitInfo);
        }
        return arrayList.toArray(new UnitInfo[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUnits(final UnitInfo[] unitInfoArray) {
        if (unitInfoArray == null || unitInfoArray.length == 0) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        AbstractTableModelUnitList.this.deleteUnits(unitInfoArray);
                    }
                });
            }
            catch (Exception exception) {
                Trace.logError((String)CNAME, (String)"Exception while adding units", (Throwable)exception);
            }
            return;
        }
        Object object = this.m_objectTableDataAccessLock;
        synchronized (object) {
            List list = this.getSelectedUnits();
            for (int i = 0; i < unitInfoArray.length; ++i) {
                int n = Collections.binarySearch(this.m_alTableData, unitInfoArray[i], this.m_internalComp);
                if (n < 0) {
                    Trace.logInfo((String)CNAME, (String)("Attempting to delete unit " + unitInfoArray[i] + " -- unit not found.  Continuing to next unit"));
                    continue;
                }
                this.m_alTableData.remove(n);
            }
            this.rebuildIndices();
            this.fireTableDataChanged();
            this.selectUnits(list);
        }
    }

    public UnitInfo[] deleteServerType(String string) {
        ArrayList<ServerInfo> arrayList = new ArrayList<ServerInfo>();
        Iterator iterator = this.m_alTableData.iterator();
        while (iterator.hasNext()) {
            ServerInfo serverInfo;
            UnitInfo unitInfo = (UnitInfo)iterator.next();
            if (unitInfo.isAppliance() || !StringUtilities.stringsEqual((String)(serverInfo = (ServerInfo)unitInfo).getType(), (String)string)) continue;
            serverInfo.setType("");
            arrayList.add(serverInfo);
        }
        this.setGroupFilter(UnitListFilter.DEFAULT);
        return arrayList.toArray(new UnitInfo[0]);
    }

    public UnitInfo[] deleteCustomField1Value(String string) {
        ArrayList<UnitInfo> arrayList = new ArrayList<UnitInfo>();
        Iterator iterator = this.m_alTableData.iterator();
        while (iterator.hasNext()) {
            UnitInfo unitInfo = (UnitInfo)iterator.next();
            if (!StringUtilities.stringsEqual((String)unitInfo.getCustomField1(), (String)string)) continue;
            unitInfo.setCustomField1("");
            arrayList.add(unitInfo);
        }
        this.setGroupFilter(UnitListFilter.DEFAULT);
        return arrayList.toArray(new UnitInfo[0]);
    }

    public UnitInfo[] deleteCustomField2Value(String string, String string2) {
        ArrayList<UnitInfo> arrayList = new ArrayList<UnitInfo>();
        Iterator iterator = this.m_alTableData.iterator();
        while (iterator.hasNext()) {
            UnitInfo unitInfo = (UnitInfo)iterator.next();
            if (!StringUtilities.stringsEqual((String)unitInfo.getCustomField1(), (String)string) || !StringUtilities.stringsEqual((String)unitInfo.getCustomField2(), (String)string2)) continue;
            unitInfo.setCustomField1("");
            unitInfo.setCustomField2("");
            arrayList.add(unitInfo);
        }
        this.setGroupFilter(UnitListFilter.DEFAULT);
        return arrayList.toArray(new UnitInfo[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnitInfo getRow(int n) {
        Object object = this.m_objectTableDataAccessLock;
        synchronized (object) {
            int n2 = this.viewToModel(n);
            return (UnitInfo)this.m_alTableData.get(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getColumnName(int n) {
        Object object = this.m_objectTableDataAccessLock;
        synchronized (object) {
            if (n < 0 || n >= this.m_aszCurrentColumnHeaders.length) {
                Trace.logInfo((String)"AbstractTableModelUnitList:getColumnName", (String)"Invalid column requested");
                return "";
            }
            return this.m_aszCurrentColumnHeaders[n];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColumnCount() {
        Object object = this.m_objectTableDataAccessLock;
        synchronized (object) {
            return this.m_aszCurrentColumnHeaders.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() {
        Object object = this.m_objectTableDataAccessLock;
        synchronized (object) {
            return this.m_alViewIndex.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int n, int n2) {
        Object object = this.m_objectTableDataAccessLock;
        synchronized (object) {
            if (n < 0 || n >= this.m_alViewIndex.size()) {
                Trace.logInfo((String)"AbstractTableModelUnitList:getValueAt", (String)"Invalid row requested");
                return "";
            }
            if (n2 < 0 || n2 >= this.m_aszCurrentColumnHeaders.length) {
                Trace.logInfo((String)"AbstractTableModelUnitList:getValueAt", (String)"Invalid column requested");
                return "";
            }
            UnitInfo unitInfo = this.getRow(n);
            return this.getColumnValue(n2, unitInfo);
        }
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return TableCellIconName.class;
        }
        return String.class;
    }

    private Object getColumnValue(int n, UnitInfo unitInfo) {
        if (unitInfo == null) {
            Trace.logInfo((String)"AbstractTableModelUnitList:getColumnValue", (String)"Invalid UnitInfo argument");
            return "";
        }
        String string = null;
        block0 : switch (this.m_nColumnHeaderMode) {
            default: {
                string = "";
                break;
            }
            case 1: {
                switch (n) {
                    case 0: {
                        this.m_tcinIconName.setName(unitInfo.getName());
                        this.m_tcinIconName.setIcon(unitInfo.getIcon());
                        string = this.m_tcinIconName;
                        break block0;
                    }
                    case 1: {
                        string = unitInfo.getType();
                        break block0;
                    }
                    case 2: {
                        string = unitInfo.getCustomField1();
                        break block0;
                    }
                    case 3: {
                        string = unitInfo.getCustomField2();
                        break block0;
                    }
                    case 4: {
                        string = unitInfo.getCustomField3();
                        break block0;
                    }
                }
                string = "";
                break;
            }
            case 2: {
                switch (n) {
                    case 0: {
                        this.m_tcinIconName.setName(unitInfo.getName());
                        this.m_tcinIconName.setIcon(unitInfo.getIcon());
                        string = this.m_tcinIconName;
                        break block0;
                    }
                    case 1: {
                        string = unitInfo.getCustomField1();
                        break block0;
                    }
                    case 2: {
                        string = unitInfo.getCustomField2();
                        break block0;
                    }
                    case 3: {
                        string = unitInfo.getCustomField3();
                        break block0;
                    }
                }
                string = "";
                break;
            }
            case 3: {
                switch (n) {
                    case 0: {
                        this.m_tcinIconName.setName(unitInfo.getName());
                        this.m_tcinIconName.setIcon(unitInfo.getIcon());
                        string = this.m_tcinIconName;
                        break block0;
                    }
                    case 1: {
                        string = unitInfo.getType();
                        break block0;
                    }
                    case 2: {
                        string = unitInfo.getCustomField2();
                        break block0;
                    }
                    case 3: {
                        string = unitInfo.getCustomField3();
                        break block0;
                    }
                }
                string = "";
                break;
            }
            case 4: {
                switch (n) {
                    case 0: {
                        this.m_tcinIconName.setName(unitInfo.getName());
                        this.m_tcinIconName.setIcon(unitInfo.getIcon());
                        string = this.m_tcinIconName;
                        break block0;
                    }
                    case 1: {
                        string = unitInfo.getType();
                        break block0;
                    }
                    case 2: {
                        string = unitInfo.getCustomField3();
                        break block0;
                    }
                }
                string = "";
            }
        }
        return string;
    }

    private void updateColumnHeaders() {
        String string = "";
        if (this.m_aszCurrentColumnHeaders.length != 0) {
            string = this.m_aszCurrentColumnHeaders[this.m_nSortColumn];
        }
        switch (this.m_nColumnHeaderMode) {
            default: {
                this.m_aszCurrentColumnHeaders = new String[0];
                break;
            }
            case 1: {
                this.m_aszCurrentColumnHeaders = new String[]{this.m_aszColumnHeadersCache[0], this.m_aszColumnHeadersCache[1], this.m_aszColumnHeadersCache[2], this.m_aszColumnHeadersCache[3], this.m_aszColumnHeadersCache[4]};
                break;
            }
            case 2: {
                this.m_aszCurrentColumnHeaders = new String[]{this.m_aszColumnHeadersCache[0], this.m_aszColumnHeadersCache[2], this.m_aszColumnHeadersCache[3], this.m_aszColumnHeadersCache[4]};
                break;
            }
            case 3: {
                this.m_aszCurrentColumnHeaders = new String[]{this.m_aszColumnHeadersCache[0], this.m_aszColumnHeadersCache[1], this.m_aszColumnHeadersCache[3], this.m_aszColumnHeadersCache[4]};
                break;
            }
            case 4: {
                this.m_aszCurrentColumnHeaders = new String[]{this.m_aszColumnHeadersCache[0], this.m_aszColumnHeadersCache[1], this.m_aszColumnHeadersCache[4]};
            }
        }
        this.m_nSortColumn = -1;
        for (int i = 0; i < this.m_aszCurrentColumnHeaders.length; ++i) {
            if (!string.equals(this.m_aszCurrentColumnHeaders[i])) continue;
            this.m_nSortColumn = i;
            break;
        }
        if (this.m_nSortColumn == -1) {
            this.m_nSortColumn = 0;
            this.m_bAscending = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSelectedUnits() {
        Object object = this.m_objectTableDataAccessLock;
        synchronized (object) {
            int[] nArray = this.m_jTable.getSelectedRows();
            ArrayList arrayList = new ArrayList(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                int n = this.viewToModel(nArray[i]);
                if (n < 0 || n >= this.m_alTableData.size()) continue;
                arrayList.add(this.m_alTableData.get(n));
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectUnits(final List list) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AbstractTableModelUnitList.this.selectUnits(list);
                    }
                });
            }
            catch (Exception exception) {
                Trace.logError((String)CNAME, (String)"Exception while adding units", (Throwable)exception);
            }
            return;
        }
        Object object = this.m_objectTableDataAccessLock;
        synchronized (object) {
            ListSelectionModel listSelectionModel = this.m_jTable.getSelectionModel();
            listSelectionModel.clearSelection();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                UnitInfo unitInfo = (UnitInfo)iterator.next();
                int n = Collections.binarySearch(this.m_alTableData, unitInfo, this.m_internalComp);
                if (n < 0) continue;
                int n2 = this.modelToView(n);
                listSelectionModel.setValueIsAdjusting(iterator.hasNext());
                listSelectionModel.addSelectionInterval(n2, n2);
            }
        }
    }

    public void fireTableChanged(final TableModelEvent tableModelEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            super.fireTableChanged(tableModelEvent);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        AbstractTableModelUnitList.this.fireTableChanged(tableModelEvent);
                    }
                });
            }
            catch (Exception exception) {
                Trace.logError((String)CNAME, (String)("Exception while firing table event" + tableModelEvent), (Throwable)exception);
            }
        }
    }

    private CollationKey getColumnValueAsCollationKey(int n, UnitInfo unitInfo) {
        CollationKey collationKey;
        block0 : switch (this.m_nColumnHeaderMode) {
            default: {
                collationKey = this.m_collator.getCollationKey("");
                break;
            }
            case 1: {
                switch (n) {
                    case 0: {
                        collationKey = unitInfo.getNameKey();
                        break block0;
                    }
                    case 1: {
                        collationKey = unitInfo.getTypeKey();
                        break block0;
                    }
                    case 2: {
                        collationKey = unitInfo.getCustomFieldKey1();
                        break block0;
                    }
                    case 3: {
                        collationKey = unitInfo.getCustomFieldKey2();
                        break block0;
                    }
                    case 4: {
                        collationKey = unitInfo.getCustomFieldKey3();
                        break block0;
                    }
                }
                collationKey = this.m_collator.getCollationKey("");
                break;
            }
            case 2: {
                switch (n) {
                    case 0: {
                        collationKey = unitInfo.getNameKey();
                        break block0;
                    }
                    case 1: {
                        collationKey = unitInfo.getCustomFieldKey1();
                        break block0;
                    }
                    case 2: {
                        collationKey = unitInfo.getCustomFieldKey2();
                        break block0;
                    }
                    case 3: {
                        collationKey = unitInfo.getCustomFieldKey3();
                        break block0;
                    }
                }
                collationKey = this.m_collator.getCollationKey("");
                break;
            }
            case 3: {
                switch (n) {
                    case 0: {
                        collationKey = unitInfo.getNameKey();
                        break block0;
                    }
                    case 1: {
                        collationKey = unitInfo.getTypeKey();
                        break block0;
                    }
                    case 2: {
                        collationKey = unitInfo.getCustomFieldKey2();
                        break block0;
                    }
                    case 3: {
                        collationKey = unitInfo.getCustomFieldKey3();
                        break block0;
                    }
                }
                collationKey = this.m_collator.getCollationKey("");
                break;
            }
            case 4: {
                switch (n) {
                    case 0: {
                        collationKey = unitInfo.getNameKey();
                        break block0;
                    }
                    case 1: {
                        collationKey = unitInfo.getTypeKey();
                        break block0;
                    }
                    case 2: {
                        collationKey = unitInfo.getCustomFieldKey3();
                        break block0;
                    }
                }
                collationKey = this.m_collator.getCollationKey("");
            }
        }
        return collationKey;
    }

    private void createColumnHeaderMouseListener(JTable jTable) {
        JTable jTable2 = jTable;
        final JTableHeader jTableHeader = jTable.getTableHeader();
        final JButtonHeaderRenderer jButtonHeaderRenderer = (JButtonHeaderRenderer)jTableHeader.getDefaultRenderer();
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (!jTableHeader.isEnabled()) {
                    return;
                }
                TableColumn tableColumn = jTableHeader.getResizingColumn();
                if (tableColumn != null) {
                    return;
                }
                int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
                jButtonHeaderRenderer.setPressedColumn(n);
                jTableHeader.repaint();
                if (AbstractTableModelUnitList.this.m_nSortColumn == n) {
                    AbstractTableModelUnitList.this.m_bAscending = !AbstractTableModelUnitList.this.m_bAscending;
                } else {
                    AbstractTableModelUnitList.this.m_nSortColumn = n;
                    AbstractTableModelUnitList.this.m_bAscending = true;
                }
                Thread thread = new Thread(new Runnable(this){
                    private final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        List list = 8.access$300(this.this$1).getSelectedUnits();
                        Object object = AbstractTableModelUnitList.access$400(8.access$300(this.this$1));
                        synchronized (object) {
                            AbstractTableModelUnitList.access$500(8.access$300(this.this$1));
                            AbstractTableModelUnitList.access$600(8.access$300(this.this$1));
                        }
                        SwingUtilities.invokeLater(new Runnable(this, list){
                            private final /* synthetic */ List val$selections;
                            private final /* synthetic */ 9 this$2;
                            {
                                this.this$2 = var1_1;
                                this.val$selections = list;
                            }

                            public void run() {
                                8.access$300(9.access$700(this.this$2)).fireTableDataChanged();
                                8.access$300(9.access$700(this.this$2)).selectUnits(this.val$selections);
                            }
                        });
                    }

                    static /* synthetic */ 8 access$700(9 var0) {
                        return var0.this$1;
                    }
                });
                thread.start();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                jButtonHeaderRenderer.setPressedColumn(-1);
                jTableHeader.repaint();
            }

            static /* synthetic */ AbstractTableModelUnitList access$300(8 var0) {
                return var0.AbstractTableModelUnitList.this;
            }
        };
        jTableHeader.addMouseListener(mouseAdapter);
    }

    private void sortViewIndex() {
        Collections.sort(this.m_alViewIndex, this.m_bAscending ? this.m_comp : this.m_rvscomp);
    }

    private void sortTableData() {
        for (int i = 0; i < this.m_alTableData.size(); ++i) {
            UnitInfo unitInfo = (UnitInfo)this.m_alTableData.get(i);
            unitInfo.createCollationKeys(this.m_collator);
        }
        Collections.sort(this.m_alTableData, this.m_internalComp);
    }

    private int viewToModel(int n) {
        if (n < 0 || n >= this.m_alViewIndex.size()) {
            return -1;
        }
        return (Integer)this.m_alViewIndex.get(n);
    }

    private int modelToView(int n) {
        return (Integer)this.m_alModelIndex.get(n);
    }

    public void setFiltersAndHeaders(UnitListFilter unitListFilter, UnitListFilter unitListFilter2, int n) {
        if (unitListFilter == null) {
            unitListFilter = UnitListFilter.DEFAULT;
        }
        if (unitListFilter2 == null) {
            unitListFilter2 = UnitListFilter.DEFAULT;
        }
        this.m_viewFilter = unitListFilter;
        this.m_groupFilter = unitListFilter2;
        this.m_searchFilter = UnitListFilter.DEFAULT;
        int n2 = this.m_nColumnHeaderMode;
        this.setColumnHeaderMode(n);
        this.rebuildIndices();
        Trace.logInfo((String)CNAME, (String)("settingFiltersAndHeaders: oldHeader:" + n2 + "; newNeader:" + n));
        if (n2 != n) {
            this.fireTableStructureChanged();
        } else {
            this.fireTableDataChanged();
        }
    }

    public void setViewFilter(UnitListFilter unitListFilter) {
        if (unitListFilter == null) {
            unitListFilter = UnitListFilter.DEFAULT;
        }
        this.m_viewFilter = unitListFilter;
        this.m_searchFilter = UnitListFilter.DEFAULT;
        this.rebuildIndices();
        this.fireTableDataChanged();
    }

    public void setGroupFilter(UnitListFilter unitListFilter) {
        if (unitListFilter == null) {
            unitListFilter = UnitListFilter.DEFAULT;
        }
        this.m_groupFilter = unitListFilter;
        this.rebuildIndices();
        this.fireTableDataChanged();
    }

    public void setSearchFilter(UnitListFilter unitListFilter) {
        if (unitListFilter == null) {
            unitListFilter = UnitListFilter.DEFAULT;
        }
        this.m_searchFilter = unitListFilter;
        this.rebuildIndices();
        this.fireTableDataChanged();
    }

    private synchronized void rebuildIndices() {
        this.buildViewIndex();
        this.sortViewIndex();
        this.buildModelIndex();
    }

    private void buildViewIndex() {
        this.m_alViewIndex = new ArrayList();
        for (int i = 0; i < this.m_alTableData.size(); ++i) {
            if (!this.applyFilters((UnitInfo)this.m_alTableData.get(i))) continue;
            this.m_alViewIndex.add(new Integer(i));
        }
    }

    private void buildModelIndex() {
        int n;
        Integer n2 = new Integer(-1);
        this.m_alModelIndex = new ArrayList(this.m_alTableData.size());
        for (n = 0; n < this.m_alTableData.size(); ++n) {
            this.m_alModelIndex.add(n2);
        }
        for (n = 0; n < this.m_alViewIndex.size(); ++n) {
            int n3 = (Integer)this.m_alViewIndex.get(n);
            this.m_alModelIndex.set(n3, new Integer(n));
        }
    }

    private boolean applyFilters(UnitInfo unitInfo) {
        return !(this.m_viewFilter != UnitListFilter.DEFAULT && !this.m_viewFilter.include(unitInfo) || this.m_groupFilter != UnitListFilter.DEFAULT && !this.m_groupFilter.include(unitInfo) || this.m_searchFilter != UnitListFilter.DEFAULT && !this.m_searchFilter.include(unitInfo));
    }

    static /* synthetic */ Object access$400(AbstractTableModelUnitList abstractTableModelUnitList) {
        return abstractTableModelUnitList.m_objectTableDataAccessLock;
    }

    static /* synthetic */ void access$500(AbstractTableModelUnitList abstractTableModelUnitList) {
        abstractTableModelUnitList.sortViewIndex();
    }

    static /* synthetic */ void access$600(AbstractTableModelUnitList abstractTableModelUnitList) {
        abstractTableModelUnitList.buildModelIndex();
    }

    public static class InternalComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            UnitInfo unitInfo = (UnitInfo)object;
            UnitInfo unitInfo2 = (UnitInfo)object2;
            if (unitInfo.getID() < unitInfo2.getID()) {
                return -1;
            }
            if (unitInfo.getID() > unitInfo2.getID()) {
                return 1;
            }
            if (unitInfo.isAppliance()) {
                if (unitInfo2.isAppliance()) {
                    return 0;
                }
                return -1;
            }
            if (unitInfo2.isAppliance()) {
                return 1;
            }
            return 0;
        }
    }

    private class UnitComparator
    implements Comparator {
        private UnitComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = (Integer)object;
            int n2 = (Integer)object2;
            CollationKey collationKey = AbstractTableModelUnitList.this.getColumnValueAsCollationKey(AbstractTableModelUnitList.this.m_nSortColumn, (UnitInfo)AbstractTableModelUnitList.this.m_alTableData.get(n));
            CollationKey collationKey2 = AbstractTableModelUnitList.this.getColumnValueAsCollationKey(AbstractTableModelUnitList.this.m_nSortColumn, (UnitInfo)AbstractTableModelUnitList.this.m_alTableData.get(n2));
            return collationKey.compareTo(collationKey2);
        }
    }

    class JButtonHeaderRenderer
    extends JButton
    implements TableCellRenderer {
        private SortArrowIcon m_iiAscending;
        private SortArrowIcon m_iiDescending;
        private int m_nPressedColumn = -1;

        public JButtonHeaderRenderer() {
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setHorizontalTextPosition(2);
            this.setHorizontalAlignment(2);
            try {
                this.m_iiAscending = new SortArrowIcon(2);
                this.m_iiDescending = new SortArrowIcon(1);
            }
            catch (Exception exception) {
                Trace.logError((String)"AbstractTableModelUnitList:JButtonHeaderRenderer", (String)"failed to load sort order icons");
            }
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 == AbstractTableModelUnitList.this.m_nSortColumn) {
                if (AbstractTableModelUnitList.this.m_bAscending) {
                    this.setIcon((Icon)this.m_iiAscending);
                } else {
                    this.setIcon((Icon)this.m_iiDescending);
                }
            } else {
                this.setIcon(null);
            }
            if (object != null) {
                this.setText(object.toString());
            } else {
                this.setText("");
            }
            boolean bl3 = n2 == this.m_nPressedColumn;
            this.getModel().setPressed(bl3);
            this.getModel().setArmed(bl3);
            return this;
        }

        public void setPressedColumn(int n) {
            this.m_nPressedColumn = n;
        }
    }
}

