/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.explorer;

import com.avocent.avworks.explorer.BrandingInfo;
import com.avocent.avworks.explorer.DatabaseFilesUtilities;
import com.avocent.avworks.services.AVWorksWindowManager;
import com.avocent.avworks.services.ApplianceInfo;
import com.avocent.avworks.services.AppliancesDb;
import com.avocent.avworks.services.CustomFieldLabelsDb;
import com.avocent.avworks.services.ServerInfo;
import com.avocent.avworks.services.ServersDb;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.dialogs.JDialogProgress;
import com.avocent.lib.gui.dialogs.JFileChooserDialog;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.text.MessageFormat;
import javax.swing.JFrame;

public class DBaseFileExport
extends DatabaseFilesUtilities {
    public static final String CNAME = "DBaseFileExport";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.explorer.Res");
    private File m_fTempFile = null;
    private FileWriter m_FileWriterTemp = null;
    String m_szTempFile = null;
    private String m_szTempFilePath = null;
    private int m_nDbaseRecordCount = 0;
    private int m_nAppCount = 0;
    private int m_nServerCount = 0;
    private String[] m_aszDbaseRecords = null;
    private String m_szColumnHeader = "";
    private JFrame m_jframeWindow = null;
    private boolean isTsvTypeSelected = false;

    public DBaseFileExport(Frame frame) throws ExceptionConstructorFailed {
        if (!(frame instanceof Frame)) {
            this.m_szFailedReason = " " + res.getString("DBaseFileExport_Unable_to_export_the1");
            Message.show((Component)this.m_frameParent, (String)(this.m_szNoSuccessMsg + this.m_szFailedReason));
            throw new ExceptionConstructorFailed("Parent must be a Frame object");
        }
        this.m_frameParent = frame;
        try {
            this.initialize();
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)CNAME, (String)"<ctor>: Unable to construct object", (Throwable)exceptionRequestFailed);
            this.m_szFailedReason = " " + res.getString("DBaseFileExport_Unable_to_export_the1");
            Message.show((Component)this.m_frameParent, (String)(this.m_szNoSuccessMsg + this.m_szFailedReason));
            throw new ExceptionConstructorFailed("Unable to initialize object");
        }
    }

    protected void initialize() throws ExceptionRequestFailed {
        this.m_szClassName = this.getClass().getName();
        this.m_szDialogTitle = res.getString("DBaseFileExport_Database_Export");
        this.m_szDialogButton = res.getString("DBaseFileExport_Export_Button");
        this.m_propFilters.put("csv", CSV_FILE_EXT_DESC);
        this.m_propFilters.put("tsv", TSV_FILE_EXT_DESC);
        this.m_dlgProgress = new JDialogProgress(this.m_frameParent, this.m_szDialogTitle, true);
        this.m_szInProgressMsg = res.getString("DBaseFileExport_The_database_is_being_exported");
        this.m_szSuccessMsg = res.getString("DBaseFileExport_The_database_has_been_successfully_exported");
        this.m_szNoSuccessMsg = res.getString("DBaseFileExport_The_database_has_NOT_been_exported");
        this.m_szTempFile = DBaseFileExport.getLastDirectory() + File.separator + "export" + "temp";
        this.m_nProgBarPercent = 20;
        this.m_nInitProgDisplayTime = 500;
        this.m_nProgBarDisplayTime = 500;
        this.m_jframeWindow = new JFrame();
        try {
            this.m_jframeWindow.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    DBaseFileExport.this.m_jframeWindow = (JFrame)windowEvent.getSource();
                    DBaseFileExport.this.cleanup();
                }
            });
        }
        catch (Exception exception) {
            Trace.logError((String)this.m_szClassName, (String)":.initializeUnable to construct WindowListenerDbaseFile object", (Throwable)exception);
            throw new ExceptionRequestFailed("The export operation failed to initialize");
        }
    }

    public void export() {
        int n = -1;
        try {
            JFileChooserDialog jFileChooserDialog = new JFileChooserDialog((Component)this.m_frameParent, this.m_propFilters, "csv", this.m_szDialogTitle, this.m_szDialogButton, false, DBaseFileExport.getLastDirectory());
            n = jFileChooserDialog.showDialog((Component)this.m_frameParent, this.m_szDialogButton);
            if (n != 0) {
                return;
            }
            this.m_fSelectedFile = jFileChooserDialog.getSelectedFile();
            this.m_bIsSelectedFileExist = this.m_fSelectedFile.exists();
            this.m_szSelectedFile = this.m_fSelectedFile.getName();
            this.m_szSelectedFilePath = this.m_fSelectedFile.getAbsolutePath();
            if (this.m_fSelectedFile != null && !this.m_fSelectedFile.isDirectory()) {
                DBaseFileExport.setLastDirectory(this.m_fSelectedFile.getParent());
            }
            this.isTsvTypeSelected = jFileChooserDialog.getFileFilter().getDescription().endsWith(".tsv)");
            this.exportDbaseToFile();
        }
        catch (Exception exception) {
            Trace.logError((String)(this.m_szClassName + ".export:"), (String)"Unable to export the database", (Throwable)exception);
            this.m_szFailedReason = " " + res.getString("DBaseFileExport_Unable_to_export_the_database");
            Message.show((Component)this.m_frameParent, (String)(this.m_szNoSuccessMsg + this.m_szFailedReason));
        }
    }

    private void exportDbaseToFile() {
        String string = null;
        if (this.m_szSelectedFile.endsWith(".csv")) {
            string = ",";
        } else if (this.m_szSelectedFile.endsWith(".tsv")) {
            string = "\t";
        } else if (this.isTsvTypeSelected) {
            string = "\t";
            this.m_szSelectedFilePath = this.m_szSelectedFilePath + ".tsv";
        } else {
            string = ",";
            this.m_szSelectedFilePath = this.m_szSelectedFilePath + ".csv";
        }
        try {
            AVWorksWindowManager.registerWindow((String)("ID_" + this.m_szDialogTitle), (String)this.m_szDialogTitle, (int)1, (Window)this.m_jframeWindow);
            if (this.m_bIsSelectedFileExist && !this.m_fSelectedFile.canWrite()) {
                this.cleanup();
                this.m_szFailedReason = " " + res.getString("DBaseFileExport_File_cannot_be_overwritten");
                Message.show((Component)this.m_frameParent, (String)(this.m_szNoSuccessMsg + this.m_szFailedReason));
                return;
            }
            boolean bl = this.m_fSelectedFile.renameTo(this.m_fSelectedFile);
            if (this.m_bIsSelectedFileExist && !bl) {
                this.cleanup();
                this.m_szFailedReason = " " + res.getString("DBaseFileExport_File_is_in_use");
                Message.show((Component)this.m_frameParent, (String)(this.m_szNoSuccessMsg + this.m_szFailedReason));
                return;
            }
            this.m_szColumnHeader = this.getColumnHeader(string);
            this.m_aszDbaseRecords = this.getDbaseRecords(string);
            if (this.m_aszDbaseRecords == null) {
                this.cleanup();
                this.m_szFailedReason = " " + res.getString("DBaseFileExport_The_database_to");
                Message.show((Component)this.m_frameParent, (String)(this.m_szNoSuccessMsg + this.m_szFailedReason));
                return;
            }
            int n = this.m_aszDbaseRecords.length;
            if (n != this.m_nDbaseRecordCount) {
                this.cleanup();
                this.m_szFailedReason = " " + res.getString("DBaseFileExport_Unable_to_export_the1");
                Message.show((Component)this.m_frameParent, (String)(this.m_szNoSuccessMsg + this.m_szFailedReason));
                return;
            }
            this.m_fTempFile = new File(this.m_szTempFile);
            this.m_szTempFilePath = this.m_fTempFile.getAbsolutePath();
            this.m_FileWriterTemp = new FileWriter(this.m_fTempFile);
            this.m_FileWriterTemp.write(this.m_szColumnHeader);
            this.m_FileWriterTemp.write("\r\n");
            if (this.m_nServerCount == 0 || this.m_nAppCount == 0) {
                this.updateProgressBar();
            }
            for (int i = 0; i < n; ++i) {
                this.m_FileWriterTemp.write(this.m_aszDbaseRecords[i]);
                this.m_FileWriterTemp.write("\r\n");
                if (i != this.m_nAppCount - 1) continue;
                this.updateProgressBar();
            }
            this.m_FileWriterTemp.close();
            if (this.m_nAppCount == 0) {
                this.updateProgressBar();
            }
            this.updateProgressBar();
            this.copyFile(new BufferedInputStream(new FileInputStream(this.m_szTempFilePath)), new BufferedOutputStream(new FileOutputStream(this.m_szSelectedFilePath)));
            this.updateProgressBar();
            this.cleanup();
            Message.show((Component)this.m_frameParent, (String)this.m_szSuccessMsg);
        }
        catch (Exception exception) {
            Trace.logError((String)(this.m_szClassName + ".export:"), (String)"An ExceptionRequestFailed was caught", (Throwable)exception);
            if (!this.m_bIsCancelPressed) {
                this.m_szFailedReason = " " + res.getString("DBaseFileExport_Unable_to_export_the_database");
                Message.show((Component)this.m_frameParent, (String)(this.m_szNoSuccessMsg + this.m_szFailedReason));
            }
            this.cleanup();
        }
    }

    private String getColumnHeader(String string) {
        String string2;
        String string3 = res.getString("DBaseFileExport_0_Flag");
        Object[] objectArray = new Object[]{BrandingInfo.getApplianceNameSingular()};
        String string4 = string2 = MessageFormat.format(string3, objectArray);
        String string5 = res.getString("DBaseFileExport_Type");
        String string6 = res.getString("DBaseFileExport_Name");
        String string7 = res.getString("DBaseFileExport_Address");
        String string8 = res.getString("DBaseFileExport_Site");
        String string9 = res.getString("DBaseFileExport_Department");
        String string10 = res.getString("DBaseFileExport_Location");
        try {
            string8 = CustomFieldLabelsDb.getSingular((int)1);
            string9 = CustomFieldLabelsDb.getSingular((int)2);
            string10 = CustomFieldLabelsDb.getSingular((int)3);
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)(this.m_szClassName + ".getColumnHeader"), (String)"Failed to read custom field labels", (Throwable)exceptionRequestFailed);
            Message.show((Component)this.m_frameParent, (String)this.m_szNoSuccessMsg);
        }
        String string11 = res.getString("DBaseFileExport_Description");
        String string12 = res.getString("DBaseFileExport_Contact_Name");
        String string13 = res.getString("DBaseFileExport_Contact_Phone");
        String string14 = res.getString("DBaseFileExport_Comments");
        String string15 = res.getString("DBaseFileExport_Browser_URL");
        String string16 = res.getString("DBaseFileExport_Telnet_Port");
        this.m_szColumnHeader = string4 + string + string5 + string + string6 + string + string7 + string + string8 + string + string9 + string + string10 + string + string11 + string + string12 + string + string13 + string + string14 + string + string15 + string + string16;
        return this.m_szColumnHeader;
    }

    private String[] getDbaseRecords(String string) throws ExceptionRequestFailed {
        String string2 = "true";
        String string3 = "false";
        String string4 = "";
        String string5 = "";
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        ApplianceInfo[] applianceInfoArray = null;
        ServerInfo[] serverInfoArray = null;
        this.m_aszDbaseRecords = null;
        this.m_dlgProgress.setRange(1, 100 / this.m_nProgBarPercent);
        this.m_dlgProgress.setStep(1);
        this.m_dlgProgress.setStatusMessage(this.m_szInProgressMsg);
        this.m_dlgProgress.pack();
        this.m_dlgProgress.disableParent();
        this.m_dlgProgress.setVisible(true);
        this.wait(this.m_nInitProgDisplayTime);
        try {
            applianceInfoArray = AppliancesDb.getManagedAppliances();
            this.m_nAppCount = applianceInfoArray.length;
            this.updateProgressBar();
        }
        catch (ExceptionNoValue exceptionNoValue) {
            this.m_nAppCount = 0;
        }
        catch (InterruptedException interruptedException) {
            throw new ExceptionRequestFailed("Getting appliances from database has failed");
        }
        try {
            serverInfoArray = ServersDb.getServerList();
            this.m_nServerCount = serverInfoArray.length;
            this.updateProgressBar();
        }
        catch (ExceptionNoValue exceptionNoValue) {
            this.m_nServerCount = 0;
        }
        catch (InterruptedException interruptedException) {
            throw new ExceptionRequestFailed("Getting servers from database has failed");
        }
        try {
            this.m_nDbaseRecordCount = this.m_nAppCount + this.m_nServerCount;
            if (this.m_nDbaseRecordCount == 0) {
                return null;
            }
            this.m_aszDbaseRecords = new String[this.m_nDbaseRecordCount];
            n2 = 0;
            for (n = 0; n < this.m_nAppCount; ++n) {
                this.m_aszDbaseRecords[n] = string2 + string + applianceInfoArray[n2].getType() + string + applianceInfoArray[n2].getName() + string + applianceInfoArray[n2].getAddress() + string + applianceInfoArray[n2].getCustomField(1) + string + applianceInfoArray[n2].getCustomField(2) + string + applianceInfoArray[n2].getCustomField(3) + string + applianceInfoArray[n2].getDescription() + string + applianceInfoArray[n2].getContact() + string + applianceInfoArray[n2].getContactPhone() + string + applianceInfoArray[n2].getComment() + string + string4 + string + applianceInfoArray[n2].getTelnetPort();
                ++n2;
            }
            n3 = 0;
            for (n = this.m_nAppCount; n < this.m_nDbaseRecordCount; ++n) {
                this.m_aszDbaseRecords[n] = string3 + string + serverInfoArray[n3].getType() + string + serverInfoArray[n3].getName() + string + serverInfoArray[n3].getAddress() + string + serverInfoArray[n3].getCustomField(1) + string + serverInfoArray[n3].getCustomField(2) + string + serverInfoArray[n3].getCustomField(3) + string + serverInfoArray[n3].getDescription() + string + serverInfoArray[n3].getContact() + string + serverInfoArray[n3].getContactPhone() + string + serverInfoArray[n3].getComment() + string + serverInfoArray[n3].getBrowserURL() + string + serverInfoArray[n3].getTelnetPort();
                ++n3;
            }
        }
        catch (Exception exception) {
            Trace.logError((String)(this.m_szClassName + ".getDbaseRecords"), (String)"Unable to get database records.");
            throw new ExceptionRequestFailed("Getting records from database has failed");
        }
        return this.m_aszDbaseRecords;
    }

    protected void cleanup() {
        try {
            Trace.logInfo((String)CNAME, (String)"cleanup");
            if (this.m_FileWriterTemp != null) {
                this.m_FileWriterTemp.close();
            }
            if (this.m_fTempFile != null && this.m_fTempFile.exists()) {
                this.m_fTempFile.delete();
            }
            if (this.m_dlgProgress != null && this.m_bIsCancelPressed && this.m_fSelectedFile != null && !this.m_bIsSelectedFileExist) {
                this.m_fSelectedFile.delete();
            }
            if (this.m_dlgProgress != null) {
                this.m_dlgProgress.reEnableParent();
                this.m_dlgProgress.setVisible(false);
                this.m_dlgProgress.hide();
                this.m_dlgProgress.dispose();
            }
            if (this.m_jframeWindow != null) {
                AVWorksWindowManager.unRegisterWindow((Window)this.m_jframeWindow);
            }
        }
        catch (Exception exception) {
            Trace.logError((String)(this.m_szClassName + ".cleanup:"), (String)"Unable to cleanup.", (Throwable)exception);
        }
    }
}

