/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.explorer;

import com.avocent.avworks.explorer.DatabaseFilesUtilities;
import com.avocent.avworks.services.AVWorksEventBroadcaster;
import com.avocent.avworks.services.AVWorksService;
import com.avocent.avworks.services.AVWorksWindow;
import com.avocent.avworks.services.AVWorksWindowManager;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.dialogs.JDialogProgress;
import com.avocent.lib.gui.dialogs.JFileChooserDialog;
import com.avocent.lib.gui.dialogs.JOptionPaneFixedSize;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.ResourceManager;
import com.avocent.lib.util.StringUtilities;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFrame;

public class DBaseFileLoad
extends DatabaseFilesUtilities {
    public static final String CNAME = "DBaseFileLoad";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.explorer.Res");
    private String[] m_szOldDbaseFiles = this.getDbaseFileList();
    private String[] m_szOptDbaseFiles = this.getSupportedDbaseFileList();
    private String[] m_szReqDbaseFiles = this.getRequiredDbaseFileList();
    private String[] m_szTempDbaseFiles = null;
    private Vector m_vTempFiles = new Vector();
    private Vector m_vTempZipEntries = new Vector();
    private Vector m_vDbaseBakFiles = new Vector();
    private JFrame m_jframeWindow = null;

    public DBaseFileLoad(Frame frame) throws ExceptionConstructorFailed {
        if (!(frame instanceof Frame)) {
            this.m_szFailedReason = " " + res.getString("DBaseFileLoad_Unable_to_load_the1");
            Message.show((Component)this.m_frameParent, (String)(this.m_szNoSuccessMsg + this.m_szFailedReason));
            throw new ExceptionConstructorFailed("Parent must be a Frame object");
        }
        this.m_frameParent = frame;
        try {
            this.initialize();
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            this.m_szFailedReason = " " + res.getString("DBaseFileLoad_Unable_to_load_the1");
            Message.show((Component)this.m_frameParent, (String)(this.m_szNoSuccessMsg + this.m_szFailedReason));
            throw new ExceptionConstructorFailed("Unable to initialize object");
        }
    }

    protected void initialize() throws ExceptionRequestFailed {
        this.m_szClassName = this.getClass().getName();
        this.m_szDialogTitle = res.getString("DBaseFileLoad_Database_Load");
        this.m_szDialogButton = res.getString("DBaseFileLoad_Load_Button");
        this.m_propFilters.put("zip", ZIP_FILE_EXT_DESC);
        this.m_propFilters.put("*", ALL_FILE_EXT_DESC);
        this.m_dlgProgress = new JDialogProgress(this.m_frameParent, this.m_szDialogTitle, true);
        this.m_szInProgressMsg = res.getString("DBaseFileLoad_The_database_is_being_loaded");
        this.m_szSuccessMsg = res.getString("DBaseFileLoad_The_database_has_been_successfully_loaded");
        this.m_szNoSuccessMsg = res.getString("DBaseFileLoad_The_database_has_NOT_been_loaded");
        this.m_nProgBarPercent = 25;
        this.m_nInitProgDisplayTime = 1500;
        this.m_nProgBarDisplayTime = 500;
        this.m_jframeWindow = new JFrame();
        try {
            this.m_jframeWindow.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    DBaseFileLoad.this.m_jframeWindow = (JFrame)windowEvent.getSource();
                    DBaseFileLoad.this.cleanup();
                }
            });
        }
        catch (Exception exception) {
            Trace.logError((String)this.m_szClassName, (String)":.initializeUnable to construct WindowListenerDbaseFile object");
            throw new ExceptionRequestFailed("The load operation has failed to initialize");
        }
    }

    public void load() {
        JFileChooserDialog jFileChooserDialog = null;
        int n = -1;
        boolean bl = false;
        Vector vector = new Vector();
        String string = res.getString("DBaseFileLoad_There_are_other1");
        String string2 = res.getString("DBaseFileLoad_Would_you_like_to");
        String string3 = string + string2;
        AVWorksWindow[] aVWorksWindowArray = AVWorksWindowManager.getRegisteredWindows((boolean)true);
        if (aVWorksWindowArray.length > 0) {
            if (JOptionPaneFixedSize.showConfirmDialog((Component)this.m_frameParent, (Object)string3, (String)this.m_szDialogTitle, (int)0, (int)3) != 0) {
                return;
            }
            AVWorksWindowManager.closeAllWindows();
        }
        try {
            jFileChooserDialog = new JFileChooserDialog((Component)this.m_frameParent, this.m_propFilters, "zip", this.m_szDialogTitle, this.m_szDialogButton, true, DBaseFileLoad.getLastDirectory());
            while (!bl) {
                n = jFileChooserDialog.showDialog((Component)this.m_frameParent, this.m_szDialogButton);
                if (n == 0) {
                    this.m_fSelectedFile = jFileChooserDialog.getSelectedFile();
                    this.m_szSelectedFile = this.m_fSelectedFile.getName();
                    this.m_szSelectedFilePath = this.m_fSelectedFile.getAbsolutePath();
                    if (this.m_fSelectedFile != null && !this.m_fSelectedFile.isDirectory()) {
                        DBaseFileLoad.setLastDirectory(this.m_fSelectedFile.getParent());
                    }
                    if (!(bl = this.isValidZipFile(vector = this.extractZipEntries(this.m_szSelectedFilePath)))) {
                        this.m_szFailedReason = " " + res.getString("DBaseFileLoad_Unable_to_load_the_database");
                        Message.show((Component)this.m_frameParent, (String)(this.m_szNoSuccessMsg + this.m_szFailedReason));
                        continue;
                    }
                    this.loadDbaseFromZippedFile();
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            Trace.logError((String)(this.m_szClassName + ".load:"), (String)"Unable to load the database");
            this.m_szFailedReason = " " + res.getString("DBaseFileLoad_Unable_to_load_the_database");
            Message.show((Component)this.m_frameParent, (String)(this.m_szNoSuccessMsg + this.m_szFailedReason));
        }
    }

    private void loadDbaseFromZippedFile() {
        try {
            Object object;
            String string;
            Object object2;
            AVWorksWindowManager.registerWindow((String)("ID_" + this.m_szDialogTitle), (String)this.m_szDialogTitle, (int)1, (Window)this.m_jframeWindow);
            AVWorksService.shutdownDBase();
            this.m_dlgProgress.setStatusMessage(this.m_szInProgressMsg);
            this.m_dlgProgress.pack();
            this.m_dlgProgress.setStep(1);
            this.m_dlgProgress.setRange(1, 4);
            this.m_dlgProgress.disableParent();
            this.m_dlgProgress.setVisible(true);
            this.wait(this.m_nInitProgDisplayTime);
            this.m_vTempZipEntries = this.extractZipEntries(this.m_szSelectedFilePath);
            this.updateProgressBar();
            this.m_dlgProgress.setEnableCancelButton(false);
            ZipFile zipFile = new ZipFile(this.m_szSelectedFilePath);
            Enumeration enumeration = this.m_vTempZipEntries.elements();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                object2 = DBaseFileLoad.getDatabasePath() + File.separator + zipEntry.getName() + "." + "temp";
                this.m_vTempFiles.add(new File((String)object2));
                Trace.logInfo((String)"DBaseFileLoad.loadDBaseFromZippedFile", (String)("About to copy " + zipEntry + " to " + (String)object2));
                this.copyFile(new BufferedInputStream(zipFile.getInputStream(zipEntry)), new BufferedOutputStream(new FileOutputStream((String)object2)));
            }
            zipFile.close();
            this.updateProgressBar();
            for (int i = 0; i < this.m_szOldDbaseFiles.length; ++i) {
                object2 = DBaseFileLoad.getDatabasePath() + File.separator + this.m_szOldDbaseFiles[i];
                string = (String)object2 + "." + "bak";
                this.m_vDbaseBakFiles.add(new File(string));
                Trace.logInfo((String)"DBaseFileLoad.loadDBaseFromZippedFile", (String)("About to copy " + (String)object2 + " to " + string));
                object = new File((String)object2);
                if (!((File)object).exists()) continue;
                this.copyFile(new BufferedInputStream(new FileInputStream((File)object)), new BufferedOutputStream(new FileOutputStream(string)));
            }
            this.updateProgressBar();
            Enumeration enumeration2 = this.m_vTempFiles.elements();
            while (enumeration2.hasMoreElements()) {
                File file;
                object2 = (File)enumeration2.nextElement();
                string = ((File)object2).getAbsolutePath();
                object = string;
                int n = string.indexOf(".temp");
                if (n != -1) {
                    object = string.substring(0, n);
                }
                if (!(file = new File(string)).exists()) continue;
                this.copyFile(new BufferedInputStream(new FileInputStream(file)), new BufferedOutputStream(new FileOutputStream((String)object)));
            }
            this.updateProgressBar();
            this.cleanup();
            Message.show((Component)this.m_frameParent, (String)this.m_szSuccessMsg);
            AVWorksService.restartDBase();
            AVWorksEventBroadcaster.fireDatabaseLoadedEvent();
        }
        catch (Exception exception) {
            Trace.logError((String)(this.m_szClassName + ".load:"), (String)"An Exception was caught", (Throwable)exception);
            if (!this.m_bIsCancelPressed) {
                this.m_szFailedReason = " " + res.getString("DBaseFileLoad_Unable_to_load_the_database");
                Message.show((Component)this.m_frameParent, (String)(this.m_szNoSuccessMsg + this.m_szFailedReason));
            }
            this.cleanup();
            try {
                AVWorksService.restartDBase();
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                this.m_szFailedReason = " " + res.getString("DBaseFileLoad_Unable_to_restart_the_database");
                Message.show((Component)this.m_frameParent, (String)(this.m_szNoSuccessMsg + this.m_szFailedReason));
            }
        }
    }

    private boolean isValidZipFile(Vector vector) {
        boolean[] blArray = new boolean[this.m_szReqDbaseFiles.length];
        int n = vector.size();
        if (n < this.m_szReqDbaseFiles.length || n > this.m_szOldDbaseFiles.length) {
            return false;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
            String string = zipEntry.getName();
            int n2 = StringUtilities.findStringInArray((String)string, (String[])this.m_szReqDbaseFiles);
            if (n2 >= 0) {
                blArray[n2] = true;
                continue;
            }
            if (StringUtilities.findStringInArray((String)string, (String[])this.m_szOptDbaseFiles) >= 0) continue;
            return false;
        }
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i]) continue;
            return false;
        }
        return true;
    }

    private Vector extractZipEntries(String string) throws ExceptionRequestFailed {
        Vector<ZipEntry> vector = new Vector<ZipEntry>();
        Enumeration<? extends ZipEntry> enumeration = null;
        try {
            ZipFile zipFile = new ZipFile(new File(string));
            enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory()) continue;
                vector.add(zipEntry);
            }
        }
        catch (Exception exception) {
            Trace.logInfo((String)(this.m_szClassName + ".addToZippedFile"), (String)"Unable to extract a file from zip file");
            throw new ExceptionRequestFailed("Extracting zip entries has failed");
        }
        return vector;
    }

    protected void cleanup() {
        try {
            Enumeration enumeration = this.m_vTempFiles.elements();
            while (enumeration.hasMoreElements()) {
                File file = (File)enumeration.nextElement();
                if (file == null || !file.exists()) continue;
                file.delete();
            }
            if (this.m_dlgProgress != null) {
                this.m_dlgProgress.reEnableParent();
                this.m_dlgProgress.setVisible(false);
                this.m_dlgProgress.hide();
                this.m_dlgProgress.dispose();
            }
            if (this.m_jframeWindow != null) {
                AVWorksWindowManager.unRegisterWindow((Window)this.m_jframeWindow);
            }
        }
        catch (Exception exception) {
            Trace.logError((String)(this.m_szClassName + ".cleanup:"), (String)"Unable to cleanup.");
        }
    }
}

