/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.explorer;

import com.avocent.avworks.explorer.DatabaseFilesUtilities;
import com.avocent.avworks.services.AVWorksService;
import com.avocent.avworks.services.AVWorksWindow;
import com.avocent.avworks.services.AVWorksWindowManager;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.dialogs.JDialogProgress;
import com.avocent.lib.gui.dialogs.JFileChooserDialog;
import com.avocent.lib.gui.dialogs.JOptionPaneFixedSize;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JFrame;

public class DBaseFileSave
extends DatabaseFilesUtilities {
    public static final String CNAME = "DBaseFileSave";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.explorer.Res");
    private File m_fTempFile = null;
    private String m_szTempFile = null;
    private String m_szTempFilePath = null;
    private FileOutputStream m_fileOutStream = null;
    private ZipOutputStream m_zipOutStream = null;
    private String[] m_aszFilesToZip = this.getRequiredDbaseFileList();
    private int m_nNumFilesToZip = this.m_aszFilesToZip.length;
    private JFrame m_jframeWindow = null;

    public DBaseFileSave(Frame frame) throws ExceptionConstructorFailed {
        if (!(frame instanceof Frame)) {
            this.m_szFailedReason = " " + res.getString("DBaseFileSave_Unable_to_save_the1");
            Message.show((Component)this.m_frameParent, (String)(this.m_szNoSuccessMsg + this.m_szFailedReason));
            throw new ExceptionConstructorFailed("Parent must be a Frame object");
        }
        this.m_frameParent = frame;
        try {
            this.initialize();
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            this.m_szFailedReason = " " + res.getString("DBaseFileSave_Unable_to_save_the1");
            Message.show((Component)this.m_frameParent, (String)(this.m_szNoSuccessMsg + this.m_szFailedReason));
            throw new ExceptionConstructorFailed("Unable to initialize object");
        }
    }

    protected void initialize() throws ExceptionRequestFailed {
        this.m_szClassName = this.getClass().getName();
        this.m_szDialogTitle = res.getString("DBaseFileSave_Database_Save");
        this.m_szDialogButton = res.getString("DBaseFileSave_Save_Button");
        this.m_propFilters.put("zip", ZIP_FILE_EXT_DESC);
        this.m_propFilters.put("*", ALL_FILE_EXT_DESC);
        this.m_dlgProgress = new JDialogProgress(this.m_frameParent, this.m_szDialogTitle, true);
        this.m_szInProgressMsg = res.getString("DBaseFileSave_The_database_is_being_saved");
        this.m_szSuccessMsg = res.getString("DBaseFileSave_The_database_has_been_successfully_saved");
        this.m_szNoSuccessMsg = res.getString("DBaseFileSave_The_database_has_NOT_been_saved");
        this.m_nProgBarPercent = 20;
        this.m_nInitProgDisplayTime = 1500;
        this.m_nProgBarDisplayTime = 500;
        this.m_jframeWindow = new JFrame();
        try {
            this.m_jframeWindow.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    DBaseFileSave.this.m_jframeWindow = (JFrame)windowEvent.getSource();
                    DBaseFileSave.this.cleanup();
                }
            });
        }
        catch (Exception exception) {
            Trace.logError((String)this.m_szClassName, (String)":.initializeUnable to construct WindowListenerDbaseFile object");
            throw new ExceptionRequestFailed("The save operation has failed to initialize");
        }
    }

    public void save() {
        JFileChooserDialog jFileChooserDialog = null;
        int n = -1;
        String string = res.getString("DBaseFileSave_There_are_other2");
        String string2 = res.getString("DBaseFileSave_Would_you_like_to");
        String string3 = string + string2;
        AVWorksWindow[] aVWorksWindowArray = AVWorksWindowManager.getRegisteredWindows((boolean)true);
        if (aVWorksWindowArray.length > 0) {
            if (JOptionPaneFixedSize.showConfirmDialog((Component)this.m_frameParent, (Object)string3, (String)this.m_szDialogTitle, (int)0, (int)3) != 0) {
                return;
            }
            AVWorksWindowManager.closeAllWindows();
        }
        try {
            jFileChooserDialog = new JFileChooserDialog((Component)this.m_frameParent, this.m_propFilters, "zip", this.m_szDialogTitle, this.m_szDialogButton, false, DBaseFileSave.getLastDirectory());
            n = jFileChooserDialog.showDialog((Component)this.m_frameParent, this.m_szDialogButton);
            if (n != 0) {
                return;
            }
            this.m_fSelectedFile = jFileChooserDialog.getSelectedFile();
            this.m_bIsSelectedFileExist = this.m_fSelectedFile.exists();
            this.m_szSelectedFile = this.m_fSelectedFile.getName();
            this.m_szSelectedFilePath = this.m_fSelectedFile.getAbsolutePath();
            if (this.m_fSelectedFile != null && !this.m_fSelectedFile.isDirectory()) {
                DBaseFileSave.setLastDirectory(this.m_fSelectedFile.getParent());
            }
            this.saveDbaseToFile();
        }
        catch (Exception exception) {
            Trace.logError((String)(this.m_szClassName + ".save:"), (String)"Unable to save the database");
            this.m_szFailedReason = " " + res.getString("DBaseFileSave_Unable_to_save_the_database");
            Message.show((Component)this.m_frameParent, (String)(this.m_szNoSuccessMsg + this.m_szFailedReason));
        }
    }

    private void saveDbaseToFile() {
        try {
            AVWorksWindowManager.registerWindow((String)("ID_" + this.m_szDialogTitle), (String)this.m_szDialogTitle, (int)1, (Window)this.m_jframeWindow);
            AVWorksService.shutdownDBase();
            if (this.m_bIsSelectedFileExist && !this.m_fSelectedFile.canWrite()) {
                this.cleanup();
                this.m_szFailedReason = " " + res.getString("DBaseFileSave_File_cannot_be_overwritten");
                Message.show((Component)this.m_frameParent, (String)(this.m_szNoSuccessMsg + this.m_szFailedReason));
                return;
            }
            boolean bl = this.m_fSelectedFile.renameTo(this.m_fSelectedFile);
            if (this.m_bIsSelectedFileExist && !bl) {
                this.cleanup();
                this.m_szFailedReason = " " + res.getString("DBaseFileSave_File_is_in_use");
                Message.show((Component)this.m_frameParent, (String)(this.m_szNoSuccessMsg + this.m_szFailedReason));
                return;
            }
            this.m_dlgProgress.setStatusMessage(this.m_szInProgressMsg);
            this.m_dlgProgress.pack();
            this.m_dlgProgress.setStep(1);
            this.m_dlgProgress.setRange(1, this.m_nNumFilesToZip + 1);
            this.m_dlgProgress.disableParent();
            this.m_dlgProgress.setVisible(true);
            this.wait(this.m_nInitProgDisplayTime);
            this.m_szTempFile = DBaseFileSave.getLastDirectory() + File.separator + "Temp.zip";
            this.m_fTempFile = new File(this.m_szTempFile);
            this.m_szTempFilePath = this.m_fTempFile.getAbsolutePath();
            this.m_fileOutStream = new FileOutputStream(this.m_szTempFilePath);
            this.m_zipOutStream = new ZipOutputStream(this.m_fileOutStream);
            this.m_zipOutStream.setMethod(8);
            for (int i = 0; i < this.m_nNumFilesToZip; ++i) {
                String string = DBaseFileSave.getDatabasePath() + File.separator + this.m_aszFilesToZip[i];
                FileInputStream fileInputStream = new FileInputStream(string);
                byte[] byArray = new byte[fileInputStream.available()];
                fileInputStream.read(byArray);
                fileInputStream.close();
                ZipEntry zipEntry = new ZipEntry(this.m_aszFilesToZip[i]);
                this.m_zipOutStream.putNextEntry(zipEntry);
                this.m_zipOutStream.write(byArray);
                this.m_zipOutStream.closeEntry();
                this.updateProgressBar();
            }
            this.m_zipOutStream.finish();
            this.m_zipOutStream.close();
            this.m_fileOutStream.close();
            this.copyFile(new BufferedInputStream(new FileInputStream(this.m_szTempFilePath)), new BufferedOutputStream(new FileOutputStream(this.m_szSelectedFilePath)));
            this.updateProgressBar();
            this.cleanup();
            Message.show((Component)this.m_frameParent, (String)this.m_szSuccessMsg);
            AVWorksService.restartDBase();
        }
        catch (Exception exception) {
            Trace.logError((String)(this.m_szClassName + ".save:"), (String)"An ExceptionRequestFailed was caught", (Throwable)exception);
            if (!this.m_bIsCancelPressed) {
                this.m_szFailedReason = " " + res.getString("DBaseFileSave_Unable_to_save_the_database");
                Message.show((Component)this.m_frameParent, (String)(this.m_szNoSuccessMsg + this.m_szFailedReason));
            }
            this.cleanup();
            try {
                AVWorksService.restartDBase();
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)(this.m_szClassName + ".save:"), (String)"An ExceptionRequestFailed was caught while trying to restart database after failed attemtp to save", (Throwable)exception);
                this.m_szFailedReason = " " + res.getString("DBaseFileSave_Unable_to_restart_the_database");
                Message.show((Component)this.m_frameParent, (String)(this.m_szNoSuccessMsg + this.m_szFailedReason));
            }
        }
    }

    protected void cleanup() {
        try {
            if (this.m_fTempFile != null && this.m_fTempFile.exists()) {
                this.m_fTempFile.delete();
            }
            if (this.m_fileOutStream != null) {
                this.m_fileOutStream.close();
            }
            if (this.m_dlgProgress != null && this.m_bIsCancelPressed && this.m_fSelectedFile != null && !this.m_bIsSelectedFileExist) {
                this.m_fSelectedFile.delete();
            }
            if (this.m_dlgProgress != null) {
                this.m_dlgProgress.reEnableParent();
                this.m_dlgProgress.setVisible(false);
                this.m_dlgProgress.hide();
                this.m_dlgProgress.dispose();
            }
            if (this.m_jframeWindow != null) {
                AVWorksWindowManager.unRegisterWindow((Window)this.m_jframeWindow);
            }
        }
        catch (Exception exception) {
            Trace.logError((String)(this.m_szClassName + ".cleanup:"), (String)"Unable to cleanup.");
        }
    }
}

