/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.explorer;

import com.avocent.avworks.services.AVWorksService;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.dialogs.JDialogProgress;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public abstract class DatabaseFilesUtilities {
    public static final String CNAME = "DatabaseFilesUtilities";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.explorer.Res");
    public static final String ALL_FILE_EXT = "*";
    public static final String ALL_FILE_EXT_DESC = res.getString("DatabaseFilesUtilities_All_Files");
    public static final String CVS_FILE_EXT = "csv";
    public static final String CSV_FILE_EXT_DESC = res.getString("DatabaseFilesUtilities_Comma_Separated_Value");
    public static final String TSV_FILE_EXT = "tsv";
    public static final String TSV_FILE_EXT_DESC = res.getString("DatabaseFilesUtilities_Tab_Separated_Value");
    public static final String ZIP_FILE_EXT = "zip";
    public static final String ZIP_FILE_EXT_DESC = res.getString("DatabaseFilesUtilities_Zip_Files_zip");
    public static final String BAK_FILE_EXT = "bak";
    public static final String TEMP_FILE_EXT = "temp";
    public static final String COMMA_DELIMETER = ",";
    public static final String TAB_DELIMETER = "\t";
    public static final String END_OF_LINE = "\r\n";
    public static final String WINDOW_ID = "ID_";
    public static final String DOT = ".";
    public static final String BLANK = " ";
    private static String m_szDbasePath;
    private static String m_szLastDirectory;
    protected String m_szClassName = this.getClass().getName();
    protected Frame m_frameParent = null;
    protected String m_szInProgressMsg = res.getString("DatabaseFilesUtilities_The_file_operation_is");
    protected String m_szSuccessMsg = res.getString("DatabaseFilesUtilities_The_file_operation");
    protected String m_szNoSuccessMsg = res.getString("DatabaseFilesUtilities_The_file_operation1");
    protected String m_szDialogTitle = "";
    protected String m_szDialogButton = res.getString("DatabaseFilesUtilities_Open");
    protected String m_szFailedReason = res.getString("DatabaseFilesUtilities_Unknown_");
    protected File m_fSelectedFile = null;
    protected String m_szSelectedFile = null;
    protected String m_szSelectedFilePath = null;
    protected boolean m_bIsSelectedFileExist = false;
    protected boolean m_bIsCancelPressed = false;
    protected Properties m_propFilters = new Properties();
    protected JDialogProgress m_dlgProgress = null;
    protected int m_nProgBarPercent = 100;
    protected int m_nInitProgDisplayTime = 1000;
    protected int m_nProgBarDisplayTime = 500;
    private String[] m_szaDbaseFiles = new String[]{"vpdbase.script", "vpdbase.properties", "vpdbase.data", "vpdbase.backup"};
    private String[] m_szaRequiredFiles = new String[]{"vpdbase.script", "vpdbase.properties"};
    private String[] m_szaSupportedFiles = new String[]{"vpdbase.data", "vpdbase.backup"};

    DatabaseFilesUtilities() {
    }

    public static String getDatabasePath() {
        if (m_szDbasePath == null) {
            try {
                m_szDbasePath = AVWorksService.getDBasePath();
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                m_szDbasePath = DOT;
            }
        }
        return m_szDbasePath;
    }

    protected static String getLastDirectory() {
        if (m_szLastDirectory == null) {
            m_szLastDirectory = DatabaseFilesUtilities.getDatabasePath();
        }
        return m_szLastDirectory;
    }

    protected static void setLastDirectory(String string) {
        Trace.logInfo((String)CNAME, (String)("LastDirectory is now " + string));
        m_szLastDirectory = string;
    }

    protected void copyFile(InputStream inputStream, OutputStream outputStream) throws ExceptionRequestFailed {
        try {
            int n;
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n);
            }
            inputStream.close();
            outputStream.close();
        }
        catch (Exception exception) {
            Trace.logInfo((String)"DatabaseFilesUtilities:copyFile", (String)"Unable to copy file ");
            throw new ExceptionRequestFailed("The Copy Operation has failed");
        }
    }

    protected void updateProgressBar() throws InterruptedException {
        this.m_dlgProgress.stepIt();
        this.wait(this.m_nProgBarDisplayTime);
        this.m_bIsCancelPressed = this.m_dlgProgress.checkCancelButton();
        if (this.m_dlgProgress.isVisible() && this.m_bIsCancelPressed || !this.m_dlgProgress.isVisible()) {
            Trace.logInfo((String)(this.m_szClassName + ".cleanup:"), (String)res.getString("DatabaseFilesUtilities_The_user_has"));
            this.m_bIsCancelPressed = true;
            this.cleanup();
            this.m_szFailedReason = BLANK + res.getString("DatabaseFilesUtilities_The_user_has");
            Message.show((Component)this.m_frameParent, (String)(this.m_szNoSuccessMsg + this.m_szFailedReason));
            throw new InterruptedException();
        }
    }

    protected void wait(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected String[] getDbaseFileList() {
        return this.m_szaDbaseFiles;
    }

    protected String[] getRequiredDbaseFileList() {
        return this.m_szaRequiredFiles;
    }

    protected String[] getSupportedDbaseFileList() {
        return this.m_szaSupportedFiles;
    }

    protected abstract void initialize() throws ExceptionRequestFailed;

    protected abstract void cleanup();
}

