/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.explorer;

import com.avocent.avworks.services.DatabaseSession;
import com.avocent.avworks.services.NmmDb;
import com.avocent.avworks.services.NmmInfo;
import com.avocent.avworks.services.ProductInfo;
import com.avocent.avworks.services.ProductsDb;
import com.avocent.lib.database.SqlCmd;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class InstallNewProducts {
    public static void install() throws ExceptionRequestFailed {
        try {
            CharSequence charSequence;
            int n;
            boolean bl = new File("nmm.dat").exists();
            boolean bl2 = new File("products.dat").exists();
            boolean bl3 = new File("config.dat").exists();
            if (!(bl && bl2 && bl3)) {
                Trace.logInfo((String)"InstallNewProducts:install", (String)("Did not find all three files.No products will be installed. nmm.dat exists=" + bl + " products.dat exists=" + bl2 + " config.dat exists=" + bl3));
                return;
            }
            NewNmmInfo[] newNmmInfoArray = InstallNewProducts.getNewNmmInformation();
            NewProductInfo[] newProductInfoArray = InstallNewProducts.getNewProductInformation();
            for (n = 0; n < newNmmInfoArray.length; ++n) {
                try {
                    charSequence = "WHERE ID=" + newNmmInfoArray[n].m_szID;
                    NmmInfo[] nmmInfoArray = NmmDb.getNmmList((String)charSequence);
                    Trace.logInfo((String)"InstallNewProducts:install", (String)("NMM ID " + newNmmInfoArray[n].m_szID + " already exists"));
                    continue;
                }
                catch (ExceptionNoValue exceptionNoValue) {
                    Trace.logInfo((String)"InstallNewProducts:install", (String)("NMM ID " + newNmmInfoArray[n].m_szID + " does not exist, new NMM will be installed"));
                    charSequence = new StringBuffer();
                    ((StringBuffer)charSequence).append("INSERT INTO NMM ");
                    ((StringBuffer)charSequence).append("( ");
                    ((StringBuffer)charSequence).append("ID, ");
                    ((StringBuffer)charSequence).append("NAME, ");
                    ((StringBuffer)charSequence).append("JAR, ");
                    ((StringBuffer)charSequence).append("CLASS, ");
                    ((StringBuffer)charSequence).append("PRIORITY ");
                    ((StringBuffer)charSequence).append(") ");
                    ((StringBuffer)charSequence).append("VALUES");
                    ((StringBuffer)charSequence).append("( ");
                    ((StringBuffer)charSequence).append(newNmmInfoArray[n].m_szID + ", ");
                    ((StringBuffer)charSequence).append(SqlCmd.quote((String)newNmmInfoArray[n].m_szName) + ", ");
                    ((StringBuffer)charSequence).append(SqlCmd.quote((String)newNmmInfoArray[n].m_szJar) + ", ");
                    ((StringBuffer)charSequence).append(SqlCmd.quote((String)newNmmInfoArray[n].m_szClass) + ", ");
                    ((StringBuffer)charSequence).append(newNmmInfoArray[n].m_szPriority);
                    ((StringBuffer)charSequence).append(");");
                    Trace.logInfo((String)"InstallNewProducts:install", (String)("Execute SQL command=" + ((StringBuffer)charSequence).toString()));
                    int n2 = DatabaseSession.executeUpdate((String)((StringBuffer)charSequence).toString());
                    if (n2 != 1) {
                        Trace.logError((String)"InstallNewProducts:install", (String)("Failed to add NMM ID " + newNmmInfoArray[n].m_szID + " to the NMM table"));
                        throw new ExceptionRequestFailed();
                    }
                    Trace.logInfo((String)"InstallNewProducts:install", (String)("NMM ID " + newNmmInfoArray[n].m_szID + " successfully inserted new NMM"));
                }
            }
            for (n = 0; n < newProductInfoArray.length; ++n) {
                try {
                    charSequence = "WHERE ID=" + newProductInfoArray[n].m_szID;
                    ProductInfo[] productInfoArray = ProductsDb.getProductList((String)charSequence);
                    Trace.logInfo((String)"InstallNewProducts:install", (String)("Product ID " + newProductInfoArray[n].m_szID + " already exists"));
                    for (int i = 0; i < productInfoArray.length; ++i) {
                        String string = Integer.toString(productInfoArray[i].getID());
                        boolean bl4 = productInfoArray[i].isEnabled();
                        boolean bl5 = newProductInfoArray[n].m_szEnabled.equalsIgnoreCase("1");
                        boolean bl6 = productInfoArray[i].isAddAllowed();
                        if (!bl5 || bl4 || bl6) continue;
                        String string2 = "1";
                        String string3 = ProductInfo.getDisplayableHashValue((String)(string + "ENABLED"));
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("UPDATE PRODUCTS SET ");
                        stringBuffer.append("OPTION1=" + string2 + ",");
                        stringBuffer.append("OPTION2=" + SqlCmd.quote((String)string3) + " ");
                        stringBuffer.append("WHERE (ID=" + string + ");");
                        Trace.logInfo((String)"InstallNewProducts:install", (String)("Execute SQL command=" + stringBuffer.toString()));
                        int n3 = DatabaseSession.executeUpdate((String)stringBuffer.toString());
                        if (n3 != 1) {
                            Trace.logError((String)"InstallNewProducts:install", (String)("Failed to enable Product ID " + string + " to the PRODUCTS table"));
                            throw new ExceptionRequestFailed();
                        }
                        Trace.logInfo((String)"InstallNewProducts:install", (String)("Product ID " + string + " successfully updated in the PRODUCTS table"));
                    }
                    continue;
                }
                catch (ExceptionNoValue exceptionNoValue) {
                    Trace.logInfo((String)"InstallNewProducts:install", (String)("Product ID " + newProductInfoArray[n].m_szID + " does not exist, new Product will be installed"));
                    charSequence = new StringBuffer();
                    ((StringBuffer)charSequence).append("INSERT INTO PRODUCTS ");
                    ((StringBuffer)charSequence).append("( ");
                    ((StringBuffer)charSequence).append("ID, ");
                    ((StringBuffer)charSequence).append("VENDOR, ");
                    ((StringBuffer)charSequence).append("NAME, ");
                    ((StringBuffer)charSequence).append("NMMID, ");
                    ((StringBuffer)charSequence).append("ADD, ");
                    ((StringBuffer)charSequence).append("OPTION1, ");
                    ((StringBuffer)charSequence).append("OPTION2 ");
                    ((StringBuffer)charSequence).append(") ");
                    ((StringBuffer)charSequence).append("VALUES");
                    ((StringBuffer)charSequence).append("( ");
                    ((StringBuffer)charSequence).append(newProductInfoArray[n].m_szID + ", ");
                    ((StringBuffer)charSequence).append(SqlCmd.quote((String)newProductInfoArray[n].m_szVendor) + ", ");
                    ((StringBuffer)charSequence).append(SqlCmd.quote((String)newProductInfoArray[n].m_szName) + ", ");
                    ((StringBuffer)charSequence).append(newProductInfoArray[n].m_szNmmID + ", ");
                    ((StringBuffer)charSequence).append(newProductInfoArray[n].m_szAddAllowed + ", ");
                    ((StringBuffer)charSequence).append(newProductInfoArray[n].m_szEnabled + ", ");
                    ((StringBuffer)charSequence).append(SqlCmd.quote((String)newProductInfoArray[n].m_szHash) + " ");
                    ((StringBuffer)charSequence).append(");");
                    Trace.logInfo((String)"InstallNewProducts:install", (String)("Execute SQL command=" + ((StringBuffer)charSequence).toString()));
                    int n4 = DatabaseSession.executeUpdate((String)((StringBuffer)charSequence).toString());
                    if (n4 != 1) {
                        Trace.logError((String)"InstallNewProducts:install", (String)("Failed to add Product ID " + newProductInfoArray[n].m_szID + " to the PRODUCTS table"));
                        throw new ExceptionRequestFailed();
                    }
                    Trace.logInfo((String)"InstallNewProducts:install", (String)("Product ID " + newProductInfoArray[n].m_szID + " successfully inserted new PRODUCTS"));
                }
            }
        }
        catch (Exception exception) {
            Trace.logError((String)"InstallNewProducts:install", (String)"installation of new products failed", (Throwable)exception);
            throw new ExceptionRequestFailed();
        }
    }

    private static NewNmmInfo[] getNewNmmInformation() throws ExceptionRequestFailed {
        try {
            Object[] objectArray;
            Trace.logInfo((String)"InstallNewProducts:getNewNmmInformation", (String)"Checking for the existence of nmm.dat");
            File file = new File("nmm.dat");
            if (!file.exists()) {
                Trace.logInfo((String)"InstallNewProducts:getNewNmmInformation", (String)"nmm.dat does not exist, nothing to do");
                throw new ExceptionRequestFailed();
            }
            Trace.logInfo((String)"InstallNewProducts:getNewNmmInformation", (String)"nmm.dat exists, reading the file");
            FileInputStream fileInputStream = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
            Trace.logInfo((String)"InstallNewProducts:getNewNmmInformation", (String)"Properties successfully read from nmm.dat");
            Vector<NewNmmInfo> vector = new Vector<NewNmmInfo>();
            Trace.logInfo((String)"InstallNewProducts:getNewNmmInformation", (String)"Evaluating properties read from nmm.dat");
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                objectArray = (Object[])enumeration.nextElement();
                String string = properties.getProperty((String)objectArray);
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                String string2 = stringTokenizer.nextToken().trim();
                String string3 = stringTokenizer.nextToken().trim();
                String string4 = stringTokenizer.nextToken().trim();
                String string5 = stringTokenizer.nextToken().trim();
                Trace.logInfo((String)"InstallNewProducts:getNewNmmInformation", (String)("Found NMM info: ID=" + (String)objectArray + " Name=" + string2 + " JAR=" + string3 + " Class=" + string4 + " Priority=" + string5));
                vector.add(new NewNmmInfo((String)objectArray, string2, string3, string4, string5));
            }
            objectArray = new NewNmmInfo[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (Exception exception) {
            Trace.logError((String)"InstallNewProducts:getNewNmmInformation", (String)"failed to get new NMM information from nmm.dat");
            throw new ExceptionRequestFailed();
        }
    }

    private static NewProductInfo[] getNewProductInformation() throws ExceptionRequestFailed {
        try {
            Object[] objectArray;
            ConfigurationInfo configurationInfo = InstallNewProducts.getConfigurationInformation();
            Trace.logInfo((String)"InstallNewProducts:getNewProductInformation", (String)"Checking for the existence of products.dat");
            File file = new File("products.dat");
            if (!file.exists()) {
                Trace.logInfo((String)"InstallNewProducts:getNewProductInformation", (String)"products.dat does not exist, nothing to do");
                throw new ExceptionRequestFailed();
            }
            Trace.logInfo((String)"InstallNewProducts:getProductInformation", (String)"products.dat exists, reading the file");
            FileInputStream fileInputStream = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
            Trace.logInfo((String)"InstallNewProducts:getNewProductInformation", (String)"Properties successfully read from products.dat");
            Vector<NewProductInfo> vector = new Vector<NewProductInfo>();
            Trace.logInfo((String)"InstallNewProducts:getNewProductInformation", (String)"Evaluating properties read from products.dat");
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string;
                String string2;
                objectArray = (Object[])enumeration.nextElement();
                String string3 = properties.getProperty((String)objectArray);
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                String string4 = stringTokenizer.nextToken().trim();
                String string5 = stringTokenizer.nextToken().trim();
                String string6 = stringTokenizer.nextToken().trim();
                String string7 = configurationInfo.isAddAllowed((String)objectArray) ? "1" : "0";
                if (configurationInfo.isProductEnabled((String)objectArray)) {
                    string2 = "1";
                    string = ProductInfo.getDisplayableHashValue((String)((String)objectArray + "ENABLED"));
                } else {
                    string2 = "0";
                    string = ProductInfo.getDisplayableHashValue((String)((String)objectArray + "DISABLED"));
                }
                NewProductInfo newProductInfo = new NewProductInfo((String)objectArray, string4, string5, string6, string7, string2, string);
                vector.add(newProductInfo);
                Trace.logInfo((String)"InstallNewProducts:getNewProductInformation", (String)("Found " + newProductInfo));
            }
            objectArray = new NewProductInfo[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (Exception exception) {
            Trace.logError((String)"InstallNewProducts:getNewProductInformation", (String)"failed to get the new product information", (Throwable)exception);
            throw new ExceptionRequestFailed();
        }
    }

    private static ConfigurationInfo getConfigurationInformation() throws ExceptionRequestFailed {
        try {
            Trace.logInfo((String)"InstallNewProducts:getConfigurationInformation", (String)"Checking for the existence of config.dat");
            File file = new File("config.dat");
            if (!file.exists()) {
                Trace.logInfo((String)"InstallNewProducts:getConfigurationInformation", (String)"config.dat does not exist, nothing to do");
                throw new ExceptionRequestFailed();
            }
            Trace.logInfo((String)"InstallNewProducts:getConfigurationInformation", (String)"config.dat exists, reading the file");
            FileInputStream fileInputStream = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
            Trace.logInfo((String)"InstallNewProducts:getConfigurationInformation", (String)"Properties successfully read from config.dat");
            Trace.logInfo((String)"InstallNewProducts:getConfigurationInformation", (String)"Evaluating properties read from config.dat");
            String string = properties.getProperty("Add");
            String string2 = properties.getProperty("Enable");
            Vector<String> vector = new Vector<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                vector.add(stringTokenizer.nextToken());
            }
            Vector<String> vector2 = new Vector<String>();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
            while (stringTokenizer2.hasMoreTokens()) {
                vector2.add(stringTokenizer2.nextToken());
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            Object[] objectArray2 = new String[vector2.size()];
            vector2.copyInto(objectArray2);
            ConfigurationInfo configurationInfo = new ConfigurationInfo((String[])objectArray, (String[])objectArray2);
            return configurationInfo;
        }
        catch (Exception exception) {
            Trace.logError((String)"InstallNewProducts:getConfigurationInformation", (String)"failed to get config information from config.dat");
            throw new ExceptionRequestFailed();
        }
    }

    private static class ConfigurationInfo {
        private String[] aszProductIDsToAdd;
        private String[] aszProductIDsToEnable;

        public ConfigurationInfo(String[] stringArray, String[] stringArray2) {
            this.aszProductIDsToAdd = stringArray;
            this.aszProductIDsToEnable = stringArray2;
        }

        public boolean isProductEnabled(String string) {
            for (int i = 0; i < this.aszProductIDsToEnable.length; ++i) {
                if (!this.aszProductIDsToEnable[i].equals(string)) continue;
                return true;
            }
            return false;
        }

        public boolean isAddAllowed(String string) {
            for (int i = 0; i < this.aszProductIDsToAdd.length; ++i) {
                if (!this.aszProductIDsToAdd[i].equals(string)) continue;
                return true;
            }
            return false;
        }
    }

    private static class NewNmmInfo {
        public String m_szID;
        public String m_szName;
        public String m_szJar;
        public String m_szClass;
        public String m_szPriority;

        public NewNmmInfo(String string, String string2, String string3, String string4, String string5) {
            this.m_szID = string;
            this.m_szName = string2;
            this.m_szJar = string3;
            this.m_szClass = string4;
            this.m_szPriority = string5;
        }
    }

    private static class NewProductInfo {
        public String m_szID;
        public String m_szVendor;
        public String m_szName;
        public String m_szNmmID;
        public String m_szAddAllowed;
        public String m_szEnabled;
        public String m_szHash;

        public NewProductInfo(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
            this.m_szID = string;
            this.m_szVendor = string2;
            this.m_szName = string3;
            this.m_szNmmID = string4;
            this.m_szAddAllowed = string5;
            this.m_szEnabled = string6;
            this.m_szHash = string7;
        }

        public String toString() {
            return "Product info: ID=" + this.m_szID + " Vendor=" + this.m_szVendor + " Name=" + this.m_szName + " NmmID=" + this.m_szNmmID + " Add=" + this.m_szAddAllowed + " Enabled=" + this.m_szEnabled + " Hash=" + this.m_szHash;
        }
    }
}

