/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.explorer;

import com.avocent.avworks.services.BrowserHelper;
import com.avocent.avworks.services.ProductInfo;
import com.avocent.avworks.services.ProductsDb;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.components.ButtonPanel;
import com.avocent.lib.gui.dialogs.JDialogCentered;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.Patch;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class JDialogAddLicense
extends JDialogCentered {
    public static final String CNAME = "JDialogAddLicense";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.explorer.Res");
    JPanel panelAddLicense = new JPanel();
    GridBagLayout gridBagLayoutAddLicense = new GridBagLayout();
    JLabel jLabelProductCode = new JLabel();
    JTextField jTextFieldProductCode = new JTextField();
    JLabel jLabelKey = new JLabel();
    JTextField jTextFieldKey = new JTextField();
    JPanel jPanelButton = new JPanel();
    GridBagLayout gridBagLayoutButton = new GridBagLayout();
    JButton jButtonHelp = new JButton();
    JButton jButtonCancel = new JButton();
    JButton jButtonOK = new JButton();
    String m_szProductIds;
    Vector m_vProductIds;
    private String m_szProductHashCode;
    DefaultListModel m_dlm;

    public JDialogAddLicense(Dialog dialog, String string, boolean bl, DefaultListModel defaultListModel) throws ExceptionConstructorFailed {
        super(dialog, string, bl);
        try {
            this.m_dlm = defaultListModel;
            this.jbInit();
            ButtonPanel.equalize((JPanel)this.jPanelButton);
            this.getRootPane().setDefaultButton(this.jButtonOK);
            this.pack();
            this.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        JDialogAddLicense.this.jButtonCancel_actionPerformed();
                    }
                }
            });
            this.jTextFieldProductCode.requestFocus();
        }
        catch (Exception exception) {
            Trace.logError((String)CNAME, (String)("Exception Occurred in Constructor with the following message\n" + exception.getMessage()));
            String string2 = res.getString("JDialogAddLicense_Could_not_display_Add");
            Message.show((Component)((Object)this), (String)string2);
            this.dispose();
        }
        new Patch().fixNonResizableDlg((JDialog)((Object)this));
    }

    void jbInit() throws Exception {
        this.panelAddLicense.setLayout(this.gridBagLayoutAddLicense);
        this.jLabelProductCode.setText(res.getString("JDialogAddLicense_Product_Code_"));
        this.jLabelKey.setText(res.getString("JDialogAddLicense_Key_"));
        this.jPanelButton.setLayout(this.gridBagLayoutButton);
        this.jButtonHelp.setMnemonic(res.getString("JDialogAddLicense_single_char_3").charAt(0));
        this.jButtonHelp.setText(res.getString("JDialogAddLicense_Help"));
        this.jButtonHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogAddLicense.this.jButtonHelp_actionPerformed();
            }
        });
        this.jButtonCancel.setText(res.getString("JDialogAddLicense_Cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogAddLicense.this.jButtonCancel_actionPerformed();
            }
        });
        this.jButtonOK.setText(res.getString("JDialogAddLicense_OK"));
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogAddLicense.this.jButtonOK_actionPerformed();
            }
        });
        this.jTextFieldProductCode.setBackground(UIManager.getColor("TextField.background"));
        this.jTextFieldKey.setBackground(UIManager.getColor("TextField.background"));
        this.setResizable(false);
        this.setTitle(res.getString("JDialogAddLicense_Add_License"));
        this.getContentPane().add(this.panelAddLicense);
        this.panelAddLicense.add((Component)this.jLabelProductCode, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(12, 12, 5, 0), 0, 0));
        this.panelAddLicense.add((Component)this.jTextFieldProductCode, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 17, 2, new Insets(0, 12, 0, 11), 0, 0));
        this.panelAddLicense.add((Component)this.jLabelKey, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 12, 5, 0), 0, 0));
        this.panelAddLicense.add((Component)this.jTextFieldKey, new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 12, 20, 11), 0, 0));
        this.panelAddLicense.add((Component)this.jPanelButton, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelButton.add((Component)this.jButtonHelp, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 11, 11), 0, 0));
        this.jPanelButton.add((Component)this.jButtonCancel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 11, 5), 0, 0));
        this.jPanelButton.add((Component)this.jButtonOK, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 40, 11, 5), 0, 0));
    }

    void jButtonOK_actionPerformed() {
        this.m_szProductIds = this.jTextFieldProductCode.getText();
        if (!this.processProductIds(this.m_szProductIds)) {
            return;
        }
        try {
            this.m_szProductHashCode = ProductInfo.getDisplayableHashValue((String)this.m_szProductIds);
            Trace.logInfo((String)"JDialogAddLicense-jButtonOK_actionPerformed", (String)("HASH=" + this.m_szProductHashCode));
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)"JDialogAddLicense-jButtonOK_actionPerformed", (String)"*** Failed to get hashcode.");
        }
        String string = this.jTextFieldKey.getText();
        if (this.m_szProductHashCode.compareTo(string) != 0) {
            String string2 = res.getString("JDialogAddLicense_The_Key_Code_does_not");
            Message.show((Component)((Object)this), (String)string2);
            return;
        }
        this.updateProducts();
        this.dispose();
    }

    void jButtonCancel_actionPerformed() {
        this.dispose();
    }

    boolean processProductIds(String string) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        this.m_vProductIds = new Vector();
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2++] = stringTokenizer.nextToken();
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                ProductId productId = new ProductId();
                productId.parseProductCode(stringArray[i]);
                this.m_vProductIds.addElement(productId);
            }
            bl = true;
        }
        catch (Exception exception) {
            Trace.logError((String)CNAME, (String)"Exception for product code", (Throwable)exception);
            Message.show((Component)((Object)this), (String)res.getString("JDialogAddLicense_Product_Code_Format_Incorrect"));
            this.jTextFieldProductCode.requestFocus();
        }
        return bl;
    }

    void updateProducts() {
        if (this.m_vProductIds == null) {
            return;
        }
        int n = this.m_vProductIds.size();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            ProductInfo productInfo;
            ProductId productId = (ProductId)this.m_vProductIds.elementAt(i);
            try {
                productInfo = ProductsDb.getProductInfo((int)productId.m_nProductId);
            }
            catch (ExceptionNoValue exceptionNoValue) {
                Trace.logError((String)"JDialogAddLicense.updateProducts", (String)(productId.m_nProductId + " does not exist."));
                continue;
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)"JDialogAddLicense.updateProducts", (String)("Unable to access ProductsDb. See message " + exceptionRequestFailed.getMessage()));
                continue;
            }
            productInfo.setEnabled(productId.m_bSetEnabled);
            productInfo.setAddAllowed(productId.m_bAddable);
            try {
                ProductsDb.modify((ProductInfo)productInfo);
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)"JDialogAddLicense.updateProducts", (String)("Unable to modify ProductsDb record for Product ID " + productId.m_nProductId + " See message " + exceptionRequestFailed.getMessage()));
                continue;
            }
            if (!productId.m_bSetEnabled || !productId.m_bAddable) continue;
            this.m_dlm.addElement(productInfo.getName());
        }
    }

    void jButtonHelp_actionPerformed() {
        ResourceBundle resourceBundle = null;
        try {
            Trace.logInfo((String)"Help", (String)"Loading Help.properties resource bundle");
            resourceBundle = ResourceBundle.getBundle("com.avocent.avworks.explorer.Help");
            Trace.logInfo((String)"Help", (String)"Successfully loaoded Help.properties");
        }
        catch (Exception exception) {
            Trace.logError((String)"Help", (String)"FAILED TO LOAD com.avocent.avworks.explorer.Help");
        }
        BrowserHelper.showHelpPage((JFrame)((JFrame)((JDialog)this.getOwner()).getOwner()), (String)resourceBundle.getString("IDH_ADD_LICENSE"));
    }

    class ProductId {
        int m_nProductId;
        boolean m_bSetEnabled = false;
        boolean m_bAddable = false;

        ProductId() {
        }

        void parseProductCode(String string) throws NumberFormatException, NoSuchElementException {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            while (stringTokenizer.hasMoreTokens()) {
                this.m_nProductId = Integer.parseInt(stringTokenizer.nextToken());
                int n = Integer.parseInt(stringTokenizer.nextToken());
                this.m_bSetEnabled = n == 1;
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                this.m_bAddable = n2 == 1;
            }
        }
    }

    protected class PlainDocumentProductCode
    extends PlainDocument {
        protected PlainDocumentProductCode() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n2 = 0;
            for (int i = 0; i < cArray2.length; ++i) {
                if (Character.isDigit(cArray[i])) {
                    cArray2[n2++] = cArray[i];
                    continue;
                }
                if (cArray[i] == ',') {
                    cArray2[n2++] = cArray[i];
                    continue;
                }
                if (cArray[i] == '.') {
                    cArray2[n2++] = cArray[i];
                    continue;
                }
                Toolkit.getDefaultToolkit().beep();
                String string2 = res.getString("JDialogAddLicense_The_Product_Code");
                Message.show((Component)((Object)JDialogAddLicense.this), (String)string2);
            }
            super.insertString(n, new String(cArray2, 0, n2), attributeSet);
        }
    }
}

