/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.explorer;

import com.avocent.avworks.explorer.JDialogAddLicense;
import com.avocent.avworks.explorer.JFrameExplorer;
import com.avocent.avworks.services.BrowserHelper;
import com.avocent.avworks.services.ProductInfo;
import com.avocent.avworks.services.ProductsDb;
import com.avocent.lib.database.SqlCmd;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.components.ButtonPanel;
import com.avocent.lib.gui.components.JListAvocent;
import com.avocent.lib.gui.dialogs.JDialogCentered;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.Patch;
import com.avocent.lib.util.ResourceManager;
import com.avocent.lib.util.StringUtilities;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JDialogLicenseManager
extends JDialogCentered {
    public static final String CNAME = "JDialogLicenseManager";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.explorer.Res");
    JPanel panelLicenseManager = new JPanel();
    GridBagLayout gridBagLayoutLicenseManager = new GridBagLayout();
    JLabel jLabelLicensedProducts = new JLabel();
    JPanel jPanelButton = new JPanel();
    GridBagLayout gridBagLayoutButton = new GridBagLayout();
    JButton jButtonAdd = new JButton();
    JButton jButtonDelete = new JButton();
    JButton jButtonClose = new JButton();
    JButton jButtonHelp = new JButton();
    JLabel jLabelPad = new JLabel();
    JFrameExplorer m_jfe;
    ProductInfo[] m_apiProducts;
    DefaultListModel m_dlmProducts;
    JScrollPane jScrollPaneLicensedProducts = new JScrollPane();
    JListAvocent jListLicensedProducts = new JListAvocent();

    public JDialogLicenseManager(Frame frame, String string, boolean bl) throws ExceptionConstructorFailed {
        super(frame, string, bl);
        try {
            this.jbInit();
            this.pack();
            this.m_jfe = (JFrameExplorer)frame;
            ButtonPanel.equalize((JPanel)this.jPanelButton);
            this.getRootPane().setDefaultButton(this.jButtonClose);
            this.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        JDialogLicenseManager.this.jButtonClose_actionPerformed();
                    }
                }
            });
            this.jButtonClose.requestFocus();
        }
        catch (Exception exception) {
            Trace.logError((String)CNAME, (String)("Exception Occurred in Constructor with the following message\n" + exception.getMessage()));
            String string2 = res.getString("JDialogLicenseManager_Could_not_display_Lic");
            Message.show((Component)((Object)this), (String)string2);
            throw new ExceptionConstructorFailed();
        }
        new Patch().fixNonResizableDlg((JDialog)((Object)this));
    }

    void jbInit() throws Exception {
        this.panelLicenseManager.setLayout(this.gridBagLayoutLicenseManager);
        this.setModal(true);
        this.setResizable(false);
        this.setTitle(res.getString("JDialogLicenseManager_License_Manager"));
        this.jLabelLicensedProducts.setText(res.getString("JDialogLicenseManager_Licensed_products_"));
        this.jPanelButton.setLayout(this.gridBagLayoutButton);
        this.jButtonAdd.setMnemonic(res.getString("JDialogLicenseManager_single_char_4").charAt(0));
        this.jButtonAdd.setText(res.getString("JDialogLicenseManager_Add"));
        this.jButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogLicenseManager.this.jButtonAdd_actionPerformed(actionEvent);
            }
        });
        this.jButtonDelete.setEnabled(false);
        this.jButtonDelete.setMnemonic(res.getString("JDialogLicenseManager_single_char_D").charAt(0));
        this.jButtonDelete.setText(res.getString("JDialogLicenseManager_Delete"));
        this.jButtonDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogLicenseManager.this.jButtonDelete_actionPerformed(actionEvent);
            }
        });
        this.jButtonClose.setMnemonic(res.getString("JDialogLicenseManager_single_char_C").charAt(0));
        this.jButtonClose.setText(res.getString("JDialogLicenseManager_Close"));
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogLicenseManager.this.jButtonClose_actionPerformed();
            }
        });
        this.jButtonHelp.setMnemonic(res.getString("JDialogLicenseManager_single_char_3").charAt(0));
        this.jButtonHelp.setText(res.getString("JDialogLicenseManager_Help"));
        this.jButtonHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogLicenseManager.this.jButtonHelp_actionPerformed();
            }
        });
        this.m_dlmProducts = new DefaultListModel();
        this.jListLicensedProducts.setModel((ListModel)this.m_dlmProducts);
        this.jListLicensedProducts.setSelectionMode(0);
        this.jListLicensedProducts.setVisibleRowCount(6);
        this.jListLicensedProducts.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JDialogLicenseManager.this.jListLicensedProducts_valueChanged(listSelectionEvent);
            }
        });
        this.jScrollPaneLicensedProducts.setPreferredSize(new Dimension(240, 120));
        this.getContentPane().add((Component)this.panelLicenseManager, "Center");
        this.panelLicenseManager.add((Component)this.jLabelLicensedProducts, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 0, new Insets(12, 12, 5, 0), 0, 0));
        this.panelLicenseManager.add((Component)this.jPanelButton, new GridBagConstraints(2, 0, 1, 6, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelButton.add((Component)this.jButtonClose, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 0, new Insets(-5, 5, -20, 11), 0, 0));
        this.jPanelButton.add((Component)this.jButtonAdd, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(12, 5, -20, 11), 0, 0));
        this.jPanelButton.add((Component)this.jButtonDelete, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(-5, 5, -20, 11), 0, 0));
        this.jPanelButton.add((Component)this.jButtonHelp, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 10, 2, new Insets(-5, 5, 11, 11), 0, 0));
        this.panelLicenseManager.add((Component)this.jLabelPad, new GridBagConstraints(0, 2, 2, 2, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 40));
        this.panelLicenseManager.add((Component)this.jScrollPaneLicensedProducts, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 12, 0, 12), 0, 0));
        this.jScrollPaneLicensedProducts.getViewport().add((Component)this.jListLicensedProducts, null);
        if (!this.loadProductsListFromDb()) {
            throw new Exception("Unable to read from ProductsDb");
        }
    }

    void jButtonClose_actionPerformed() {
        this.dispose();
    }

    void jListLicensedProducts_valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.jListLicensedProducts.getSelectedIndex();
        this.jButtonDelete.setEnabled(n >= 0);
    }

    void jButtonAdd_actionPerformed(ActionEvent actionEvent) {
        try {
            JDialogAddLicense jDialogAddLicense = new JDialogAddLicense((Dialog)((Object)this), "", true, this.m_dlmProducts);
            jDialogAddLicense.setLocationRelativeTo((Component)((Object)this));
            jDialogAddLicense.setVisible(true);
        }
        catch (ExceptionConstructorFailed exceptionConstructorFailed) {
            Trace.logError((String)CNAME, (String)"failed to launch JDialogAddLicense");
        }
    }

    boolean loadProductsListFromDb() {
        boolean bl = true;
        try {
            int n = ProductsDb.getCount();
            this.m_apiProducts = ProductsDb.getProductList();
            for (int i = 0; i < n; ++i) {
                if (!this.m_apiProducts[i].isEnabled() || !this.m_apiProducts[i].isAddAllowed()) continue;
                this.m_dlmProducts.addElement(this.m_apiProducts[i].getName());
            }
        }
        catch (ExceptionNoValue exceptionNoValue) {
            Trace.logError((String)"JDialogLicenseManager.loadProductsListFromDb", (String)"No Values Found when requesting ProductInfo from ProductsDb");
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)"JDialogLicenseManager.loadProductsListFromDb", (String)("Unable to load License Manager JList with contents of Database " + exceptionRequestFailed.getMessage()));
            bl = false;
        }
        return bl;
    }

    void jButtonDelete_actionPerformed(ActionEvent actionEvent) {
        String string = (String)this.jListLicensedProducts.getSelectedValue();
        String string2 = string = string.trim();
        try {
            string2 = StringUtilities.toTwoByteAsciiHex((String)string);
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            // empty catch block
        }
        int n = JOptionPane.showConfirmDialog((Component)((Object)this), res.getString("JDialogLicenseManager_Are_you_sure_") + " " + string + "?", res.getString("JDialogLicenseManager_Confirm_Delete"), 0);
        if (n != 0) {
            return;
        }
        String string3 = "WHERE NAME=" + SqlCmd.quote((String)string2);
        try {
            ProductInfo[] productInfoArray = ProductsDb.getProductList((String)string3);
            if (productInfoArray != null) {
                if (productInfoArray.length > 1) {
                    Trace.logInfo((String)"JDialogLicenseManager.jButtonDelete_actionPerformed", (String)"There was more than one product that matched the search criteria.");
                    return;
                }
                productInfoArray[0].setEnabled(false);
                productInfoArray[0].setAddAllowed(false);
                ProductsDb.modify((ProductInfo)productInfoArray[0]);
                this.m_dlmProducts.removeElement(string);
                this.jListLicensedProducts.clearSelection();
                this.jButtonDelete.setEnabled(false);
            }
        }
        catch (Exception exception) {
            Trace.logError((String)"JDialogLicenseManager.jButtonDelete_actionPerformed", (String)("Unable to delete license " + string + " " + exception.getMessage()));
        }
    }

    void jListLicensedProducts_mousePressed(MouseEvent mouseEvent) {
        this.jButtonDelete.setEnabled(true);
    }

    void jButtonHelp_actionPerformed() {
        ResourceBundle resourceBundle = null;
        try {
            Trace.logInfo((String)"Help", (String)"Loading Help.properties resource bundle");
            resourceBundle = ResourceBundle.getBundle("com.avocent.avworks.explorer.Help");
            Trace.logInfo((String)"Help", (String)"Successfully loaoded Help.properties");
        }
        catch (Exception exception) {
            Trace.logError((String)"Help", (String)"FAILED TO LOAD com.avocent.avworks.explorer.Help");
        }
        BrowserHelper.showHelpPage((JFrame)((JFrame)this.getOwner()), (String)resourceBundle.getString("IDH_LICENSE_MANAGER"));
    }
}

