/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.explorer;

import com.avocent.avworks.services.BrowserHelper;
import com.avocent.avworks.services.CustomFoldersDb;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.dialogs.JDialogCentered;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.Patch;
import com.avocent.lib.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class JDialogNewFolder
extends JDialogCentered {
    public static final String CNAME = "JDialogNewFolder";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.explorer.Res");
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanelButtons = new JPanel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JButton jButtonCancel = new JButton();
    JButton jButtonOK = new JButton();
    JLabel jLabelFolderName = new JLabel();
    JTextField jTextFieldFolderName = new JTextField();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JButton jButtonHelp = new JButton();
    BorderLayout borderLayout1 = new BorderLayout();
    private boolean m_bCanceled = true;
    private String m_szFolderName = "";
    private int m_nFolderID = 0;
    private boolean m_bFolderAdded = false;
    private int m_nParentID = 0;

    public JDialogNewFolder(Frame frame, int n) throws ExceptionConstructorFailed {
        super(frame, res.getString("JDialogNewFolder_New_Custom_Folder"), true);
        this.m_nParentID = n;
        try {
            this.jbInit();
            this.pack();
            this.jTextFieldFolderName.requestFocus();
        }
        catch (Exception exception) {
            throw new ExceptionConstructorFailed();
        }
        new Patch().fixNonResizableDlg((JDialog)((Object)this));
    }

    void jbInit() throws Exception {
        this.jPanelButtons.setLayout(this.gridBagLayout2);
        this.jButtonCancel.setText(res.getString("JDialogNewFolder_Cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogNewFolder.this.jButtonCancel_actionPerformed(actionEvent);
            }
        });
        this.jButtonOK.setText(res.getString("JDialogNewFolder_OK"));
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogNewFolder.this.jButtonOK_actionPerformed(actionEvent);
            }
        });
        this.jPanel1.setLayout(this.gridBagLayout3);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.getContentPane().setLayout(this.borderLayout1);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                JDialogNewFolder.this.this_keyPressed(keyEvent);
            }
        });
        this.jLabelFolderName.setName("");
        this.jLabelFolderName.setText(res.getString("JDialogNewFolder_Name_"));
        this.jPanel1.setMinimumSize(new Dimension(0, 0));
        this.jPanelButtons.setMinimumSize(new Dimension(0, 0));
        this.jButtonHelp.setMnemonic(res.getString("JDialogNewFolder_Help_Button_Mnemonic").charAt(0));
        this.jButtonHelp.setText(res.getString("JDialogNewFolder_Help"));
        this.jButtonHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogNewFolder.this.jButtonHelp_actionPerformed(actionEvent);
            }
        });
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.getContentPane().add((Component)this.jPanelButtons, "South");
        this.jPanelButtons.add((Component)this.jButtonCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(6, 12, 11, 0), 0, 0));
        this.jPanelButtons.add((Component)this.jButtonOK, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 12, 0, new Insets(6, 12, 11, 0), 0, 0));
        this.jPanelButtons.add((Component)this.jButtonHelp, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(6, 12, 11, 11), 0, 0));
        this.jPanel1.add((Component)this.jLabelFolderName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 12, 6, 0), 0, 0));
        this.jPanel1.add((Component)this.jTextFieldFolderName, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 18, 2, new Insets(12, 12, 6, 11), 0, 0));
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    void jButtonOK_actionPerformed(ActionEvent actionEvent) {
        this.showBusyCursor();
        this.disableButtons();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                String string = JDialogNewFolder.this.jTextFieldFolderName.getText().trim();
                if (string.length() == 0 || string.length() > 32) {
                    String string2 = res.getString("JDialogNewFolder_The_Name_field_is_not");
                    Message.show((Component)((Object)JDialogNewFolder.this), (String)string2);
                    JDialogNewFolder.this.showNormalCursor();
                    JDialogNewFolder.this.enableButtons();
                    return;
                }
                try {
                    if (CustomFoldersDb.isNameDefined((int)JDialogNewFolder.this.m_nParentID, (String)string)) {
                        String string3 = res.getString("JDialogNewFolder_The_Name_field_is_not2");
                        Message.show((Component)((Object)JDialogNewFolder.this), (String)string3);
                        JDialogNewFolder.this.showNormalCursor();
                        JDialogNewFolder.this.enableButtons();
                        return;
                    }
                    int n = CustomFoldersDb.add((int)JDialogNewFolder.this.m_nParentID, (String)string);
                    JDialogNewFolder.this.m_szFolderName = string;
                    JDialogNewFolder.this.m_nFolderID = n;
                    JDialogNewFolder.this.m_bFolderAdded = true;
                    JDialogNewFolder.this.m_bCanceled = false;
                    JDialogNewFolder.this.dispose();
                    return;
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    String string4 = res.getString("JDialogNewFolder_Could_not_add_the");
                    Message.show((Component)((Object)JDialogNewFolder.this), (String)string4);
                    JDialogNewFolder.this.dispose();
                    return;
                }
            }
        });
        thread.start();
    }

    void jButtonCancel_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    void this_keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (!(keyEvent.isControlDown() || keyEvent.isAltDown() || keyEvent.isShiftDown() || n != 27)) {
            this.dispose();
        }
    }

    void jButtonHelp_actionPerformed(ActionEvent actionEvent) {
        ResourceBundle resourceBundle = null;
        try {
            Trace.logInfo((String)"Help", (String)"Loading Help.properties resource bundle");
            resourceBundle = ResourceBundle.getBundle("com.avocent.avworks.explorer.Help");
            Trace.logInfo((String)"Help", (String)"Successfully loaoded Help.properties");
        }
        catch (Exception exception) {
            Trace.logError((String)"Help", (String)"FAILED TO LOAD com.avocent.avworks.explorer.Help");
        }
        BrowserHelper.showHelpPage((JFrame)((JFrame)this.getOwner()), (String)resourceBundle.getString("IDH_NEW_FOLDER"));
    }

    public boolean wasCanceled() {
        return this.m_bCanceled;
    }

    public boolean wasNewFolderAdded() {
        return this.m_bFolderAdded;
    }

    public String getNewFolderName() {
        return this.m_szFolderName;
    }

    public int getNewFolderID() {
        return this.m_nFolderID;
    }

    private void showBusyCursor() {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.setCursor(Cursor.getPredefinedCursor(3));
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        JDialogNewFolder.this.setCursor(Cursor.getPredefinedCursor(3));
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showNormalCursor() {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        JDialogNewFolder.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void disableButtons() {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.jButtonOK.setEnabled(false);
                this.jButtonCancel.setEnabled(false);
                this.jButtonHelp.setEnabled(false);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        JDialogNewFolder.this.jButtonOK.setEnabled(false);
                        JDialogNewFolder.this.jButtonCancel.setEnabled(false);
                        JDialogNewFolder.this.jButtonHelp.setEnabled(false);
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void enableButtons() {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.jButtonOK.setEnabled(true);
                this.jButtonCancel.setEnabled(true);
                this.jButtonHelp.setEnabled(true);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        JDialogNewFolder.this.jButtonOK.setEnabled(true);
                        JDialogNewFolder.this.jButtonCancel.setEnabled(true);
                        JDialogNewFolder.this.jButtonHelp.setEnabled(true);
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

