/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.explorer;

import com.avocent.avworks.explorer.BrandingInfo;
import com.avocent.avworks.services.AppliancesDb;
import com.avocent.avworks.services.BrowserHelper;
import com.avocent.avworks.services.CustomFoldersDb;
import com.avocent.avworks.services.ServersDb;
import com.avocent.avworks.services.UnitInfo;
import com.avocent.avworks.services.UnitsDb;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.components.ButtonPanel;
import com.avocent.lib.gui.dialogs.JDialogCentered;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.Patch;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;

public class JDialogRename
extends JDialogCentered {
    public static final String CNAME = "JDialogRename";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.explorer.Res");
    JPanel panelRename = new JPanel();
    GridBagLayout gridBagLayoutRename = new GridBagLayout();
    JLabel jLabelName = new JLabel();
    JTextField jTextFieldRename = new JTextField();
    JPanel jPanelButton = new JPanel();
    GridBagLayout gridBagLayoutButton = new GridBagLayout();
    JButton jButtonHelp = new JButton();
    JButton jButtonCancel = new JButton();
    JButton jButtonOK = new JButton();
    public static int SERVER_TYPE = 1;
    public static int CF1 = 2;
    public static int CF2 = 3;
    public static int FOLDER = 4;
    public static int UNIT = 5;
    int m_nType = 0;
    String m_szOldName;
    String m_szOldNameCF1;
    public String m_szNewName;
    public UnitInfo m_uiUnit;
    public String m_szFolderId;
    public String m_szFolderParentId;
    public boolean m_bOK = false;
    static final int MAXFIELDSIZE = 32;

    public JDialogRename(Frame frame, int n, String string, UnitInfo unitInfo, String string2, String string3) throws ExceptionConstructorFailed {
        super(frame, "", true);
        this.m_nType = n;
        this.m_szOldName = string;
        this.m_uiUnit = unitInfo;
        this.m_szFolderId = string2;
        this.m_szFolderParentId = string3;
        try {
            this.jbInit();
            this.jTextFieldRename.setText(this.m_szOldName);
            ButtonPanel.equalize((JPanel)this.jPanelButton);
            this.getRootPane().setDefaultButton(this.jButtonOK);
            this.pack();
            this.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        JDialogRename.this.jButtonCancel_actionPerformed();
                    }
                }
            });
            this.jTextFieldRename.requestFocus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        new Patch().fixNonResizableDlg((JDialog)((Object)this));
    }

    public JDialogRename(Frame frame, String string, String string2) throws ExceptionConstructorFailed {
        this(frame, CF2, string2, null, null, null);
        this.m_szOldNameCF1 = string;
    }

    void jbInit() throws Exception {
        this.panelRename.setLayout(this.gridBagLayoutRename);
        this.jLabelName.setText(res.getString("JDialogRename_Name_"));
        this.jPanelButton.setLayout(this.gridBagLayoutButton);
        this.jButtonHelp.setMnemonic(res.getString("JDialogRename_single_char_3").charAt(0));
        this.jButtonHelp.setText(res.getString("JDialogRename_Help"));
        this.jButtonHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogRename.this.jButtonHelp_actionPerformed();
            }
        });
        this.jButtonCancel.setText(res.getString("JDialogRename_Cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogRename.this.jButtonCancel_actionPerformed();
            }
        });
        this.jButtonOK.setText(res.getString("JDialogRename_OK"));
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogRename.this.jButtonOK_actionPerformed();
            }
        });
        this.jTextFieldRename.setBackground(UIManager.getColor("TextField.background"));
        this.jTextFieldRename.setDocument(new DefaultStyledDocumentRename(32));
        this.setResizable(false);
        this.setTitle(res.getString("JDialogRename_Rename"));
        this.getContentPane().add(this.panelRename);
        this.panelRename.add((Component)this.jLabelName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 12, 11, 11), 0, 0));
        this.panelRename.add((Component)this.jTextFieldRename, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(12, 0, 11, 11), 0, 0));
        this.panelRename.add((Component)this.jPanelButton, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 12, 11, 11), 0, 0));
        this.jPanelButton.add((Component)this.jButtonHelp, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelButton.add((Component)this.jButtonCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.jPanelButton.add((Component)this.jButtonOK, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
    }

    void jButtonOK_actionPerformed() {
        String string = this.jTextFieldRename.getText().trim();
        if (string.length() == 0) {
            String string2 = res.getString("JDialogRename_The_Rename_Field_is");
            Message.show((Component)((Object)this), (String)string2, (Component)this.jTextFieldRename);
            return;
        }
        this.m_szNewName = string;
        if (this.m_nType == SERVER_TYPE) {
            try {
                UnitInfo[] unitInfoArray = UnitsDb.getServerList((String)this.m_szNewName);
                if (unitInfoArray.length > 0) {
                    String string3 = res.getString("JDialogRename_0_Type_Exists");
                    Object[] objectArray = new Object[]{BrandingInfo.getServerNameSingular(), BrandingInfo.getServerNameSingular()};
                    String string4 = MessageFormat.format(string3, objectArray);
                    Message.show((Component)((Object)this), (String)string4, (Component)this.jTextFieldRename);
                    return;
                }
                UnitsDb.renameServerType((String)this.m_szOldName, (String)this.m_szNewName);
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)"JDialogRename.jButtonOK_actionPerformed", (String)("Unable to rename Server Type. " + exceptionRequestFailed.getMessage()));
                this.dispose();
                return;
            }
        }
        if (this.m_nType == CF1) {
            try {
                String[] stringArray = UnitsDb.getUniqueCustomField1Values();
                boolean bl = false;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equals(this.m_szNewName)) continue;
                    bl = true;
                }
                if (bl) {
                    String string5 = res.getString("JDialogRename_Name_Exists");
                    Message.show((Component)((Object)this), (String)string5, (Component)this.jTextFieldRename);
                    return;
                }
                UnitsDb.renameCustomField1((String)this.m_szOldName, (String)this.m_szNewName);
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)"JDialogRename.jButtonOK_actionPerformed", (String)("Unable to rename Custom Field 1. " + exceptionRequestFailed.getMessage()));
                this.dispose();
                return;
            }
        }
        if (this.m_nType == CF2) {
            try {
                String[] stringArray = UnitsDb.getUniqueCustomField2Values((String)this.m_szOldNameCF1);
                boolean bl = false;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equals(this.m_szNewName)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    String string6 = res.getString("JDialogRename_Name_Exists");
                    Message.show((Component)((Object)this), (String)string6, (Component)this.jTextFieldRename);
                    return;
                }
                UnitsDb.renameCustomField2((String)this.m_szOldNameCF1, (String)this.m_szOldName, (String)this.m_szNewName);
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)"JDialogRename.jButtonOK_actionPerformed", (String)("Unable to rename Custom Field 2. " + exceptionRequestFailed.getMessage()));
                this.dispose();
                return;
            }
        }
        if (this.m_nType == FOLDER) {
            try {
                if (CustomFoldersDb.isNameDefined((int)Integer.parseInt(this.m_szFolderId), (int)Integer.parseInt(this.m_szFolderParentId), (String)this.m_szNewName)) {
                    String string7 = res.getString("JDialogRename_Name_Exists");
                    Message.show((Component)((Object)this), (String)string7, (Component)this.jTextFieldRename);
                    return;
                }
                UnitsDb.renameFolder((String)this.m_szFolderId, (String)this.m_szNewName);
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)"JDialogRename.jButtonOK_actionPerformed", (String)("Unable to rename Folder. " + exceptionRequestFailed.getMessage()));
                this.dispose();
                return;
            }
        }
        if (this.m_nType == UNIT) {
            if (this.m_uiUnit == null) {
                Trace.logError((String)"JDialogRename.jButtonOK_actionPerformed", (String)"Unit does not exist.");
                this.dispose();
                return;
            }
            try {
                if ((AppliancesDb.isNameDefined((String)this.m_szNewName) || ServersDb.isNameDefined((String)this.m_szNewName)) && (this.m_szOldName.equals(this.m_szNewName) || !this.m_szOldName.equalsIgnoreCase(this.m_szNewName))) {
                    String string8 = res.getString("JDialogRename_Name_Exists");
                    Message.show((Component)((Object)this), (String)string8, (Component)this.jTextFieldRename);
                    return;
                }
                if (this.m_uiUnit.isAppliance()) {
                    AppliancesDb.rename((int)this.m_uiUnit.getID(), (String)this.m_szNewName);
                } else {
                    ServersDb.rename((int)this.m_uiUnit.getID(), (String)this.m_szNewName);
                }
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)"JDialogRename.jButtonOK_actionPerformed", (String)("Unable to rename selected unit. " + exceptionRequestFailed.getMessage()));
                this.dispose();
                return;
            }
        }
        this.m_bOK = true;
        this.dispose();
    }

    void jButtonCancel_actionPerformed() {
        this.dispose();
    }

    void jButtonHelp_actionPerformed() {
        ResourceBundle resourceBundle = null;
        try {
            Trace.logInfo((String)"Help", (String)"Loading Help.properties resource bundle");
            resourceBundle = ResourceBundle.getBundle("com.avocent.avworks.explorer.Help");
            Trace.logInfo((String)"Help", (String)"Successfully loaoded Help.properties");
        }
        catch (Exception exception) {
            Trace.logError((String)"Help", (String)"FAILED TO LOAD com.avocent.avworks.explorer.Help");
        }
        BrowserHelper.showHelpPage((JFrame)((JFrame)this.getOwner()), (String)resourceBundle.getString("IDH_RENAME"));
    }

    public class DefaultStyledDocumentRename
    extends DefaultStyledDocument {
        int nMaxCharacters;

        public DefaultStyledDocumentRename(int n) {
            this.nMaxCharacters = n;
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (this.getLength() + string.length() <= this.nMaxCharacters) {
                super.insertString(n, string, attributeSet);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

