/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.explorer;

import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.gui.components.JTextFieldIPAddress;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.gui.wizards.InterfaceWizardPanel;
import com.avocent.lib.gui.wizards.JDialogWizard;
import com.avocent.lib.net.IpAddress;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class JPanelDiscoverWizardAddressRange
extends JPanel
implements InterfaceWizardPanel {
    public static final String CNAME = "JPanelDiscoverWizardAddressRange";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.explorer.Res");
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JDialogWizard m_dialogWizard = null;
    private int m_nID = 2;
    private int m_nNextID = 3;
    private String m_szTitle = "";
    JLabel jLabelPleaseEnter = new JLabel();
    JLabel jLabelFromAddress = new JLabel();
    JLabel jLabel3 = new JLabel();
    int nStyle = 3;
    JTextFieldIPAddress jTextFieldFromAddress = new JTextFieldIPAddress(this.nStyle);
    JTextFieldIPAddress jTextFieldToAddress = new JTextFieldIPAddress(this.nStyle);
    private static boolean m_bDefaultAddressRange = AVWorksBranding.getDefaultAddressRange();

    public JPanelDiscoverWizardAddressRange(JDialogWizard jDialogWizard, int n, String string) {
        this.m_dialogWizard = jDialogWizard;
        this.m_nID = n;
        this.m_szTitle = string;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Trace.logError((String)"DiscoverWizard-AddressRange", (String)"*** constructor Unable to load page.");
            Trace.logError((String)"DiscoverWizard-AddressRange", (String)exception.getMessage());
        }
    }

    void jbInit() throws Exception {
        this.jLabelPleaseEnter.setText(res.getString("JPanelDiscoverWizardAddressRange_Please_enter_the"));
        this.setLayout(this.gridBagLayout1);
        this.jLabelFromAddress.setText(res.getString("JPanelDiscoverWizardAddressRange_From_Address_"));
        this.jLabel3.setText(res.getString("JPanelDiscoverWizardAddressRange_To_Address_"));
        this.add((Component)this.jLabelPleaseEnter, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 11, 11), 0, 0));
        this.add((Component)this.jLabelFromAddress, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 24, 11, 12), 0, 0));
        this.add((Component)this.jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(12, 24, 0, 12), 0, 0));
        this.add((Component)this.jTextFieldFromAddress, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(12, 12, 11, 200), 0, 0));
        this.add((Component)this.jTextFieldToAddress, new GridBagConstraints(1, 2, 2, 1, 1.0, 1.0, 18, 2, new Insets(12, 12, 0, 200), 0, 0));
    }

    public String getTitle() {
        return this.m_szTitle;
    }

    public int getID() {
        return this.m_nID;
    }

    public void onInit() {
    }

    public void onSetActive() {
        block6: {
            try {
                Long l = (Long)this.m_dialogWizard.getValue((Object)"FromAddress");
                if (l != null) {
                    Trace.logInfo((String)"DiscoverWizard-AddressRange", (String)"onSetActive Setting From Address");
                    final long l2 = l;
                    Trace.logInfo((String)"DiscoverWizard-AddressRange", (String)"onSetActive Setting To Address");
                    Long l3 = (Long)this.m_dialogWizard.getValue((Object)"ToAddress");
                    final long l4 = l3;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                JPanelDiscoverWizardAddressRange.this.jTextFieldFromAddress.setText(IpAddress.getString((long)l2));
                                JPanelDiscoverWizardAddressRange.this.jTextFieldToAddress.setText(IpAddress.getString((long)l4));
                            }
                            catch (Exception exception) {
                                Trace.logError((String)"DiscoverWizard-AddressRange", (String)"*** onSetActive Unable to determine local host address");
                                Trace.logError((String)"DiscoverWizard-AddressRange", (String)exception.getMessage());
                            }
                        }
                    });
                    break block6;
                }
                if (m_bDefaultAddressRange) {
                    Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                    block2: while (enumeration.hasMoreElements()) {
                        NetworkInterface networkInterface = enumeration.nextElement();
                        Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                        while (enumeration2.hasMoreElements()) {
                            InetAddress inetAddress = enumeration2.nextElement();
                            byte[] byArray = inetAddress.getAddress();
                            if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0 || byArray[0] == 127) continue;
                            final InetAddress inetAddress2 = inetAddress;
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    try {
                                        byte[] byArray = inetAddress2.getAddress();
                                        byArray[3] = 1;
                                        IpAddress ipAddress = new IpAddress(byArray);
                                        JPanelDiscoverWizardAddressRange.this.jTextFieldFromAddress.setText(ipAddress.getString());
                                        byte[] byArray2 = inetAddress2.getAddress();
                                        byArray2[3] = -2;
                                        IpAddress ipAddress2 = new IpAddress(byArray2);
                                        JPanelDiscoverWizardAddressRange.this.jTextFieldToAddress.setText(ipAddress2.getString());
                                    }
                                    catch (Exception exception) {
                                        Trace.logError((String)"DiscoverWizard-AddressRange", (String)exception.getMessage());
                                    }
                                }
                            });
                            break block2;
                        }
                    }
                    Trace.logInfo((String)"DiscoverWizard-AddressRange", (String)"onSetActive Exiting For addresses ");
                    break block6;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JPanelDiscoverWizardAddressRange.this.jTextFieldFromAddress.setText("");
                        JPanelDiscoverWizardAddressRange.this.jTextFieldToAddress.setText("");
                    }
                });
                Trace.logInfo((String)"DiscoverWizard-AddressRange", (String)"onSetActive Done, set blank addresses.");
            }
            catch (Exception exception) {
                Trace.logError((String)"DiscoverWizard-AddressRange", (String)"*** onSetActive Unable to determine local host address");
                Trace.logError((String)"DiscoverWizard-AddressRange", (String)exception.getMessage());
            }
        }
        Trace.logInfo((String)"DiscoverWizard-AddressRange", (String)"onSetActive Updating Button State");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Trace.logInfo((String)"DiscoverWizard-AddressRange", (String)"onSetActive Setting Wizard Button State");
                JPanelDiscoverWizardAddressRange.this.m_dialogWizard.setWizardButtons(11);
                Trace.logInfo((String)"DiscoverWizard-AddressRange", (String)"onSetActive Setting Wizard Default Button");
                JPanelDiscoverWizardAddressRange.this.m_dialogWizard.setDefaultButton(2);
                JPanelDiscoverWizardAddressRange.this.jTextFieldFromAddress.requestFocusInWindow();
            }
        });
        Trace.logInfo((String)"DiscoverWizard-AddressRange", (String)"onSetActive exiting");
    }

    public int onNext() {
        Trace.logInfo((String)"DiscoverWizard-AddressRange", (String)"onNext");
        long l = 0L;
        long l2 = -1L;
        try {
            if (!this.jTextFieldFromAddress.isDataValid()) {
                Trace.logError((String)"DiscoverWizard-AddressRange", (String)"onNext Invalid From Address");
                return 2;
            }
            l = IpAddress.getLong((String)this.jTextFieldFromAddress.getText().trim());
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            Trace.logError((String)"DiscoverWizard-AddressRange", (String)exceptionInvalidArgument.getMessage(), (Throwable)exceptionInvalidArgument);
            String string = res.getString("JPanelDiscoverWizardAddressRange_The_From_Address_field");
            Message.invokeLater((Component)this, (String)string, (Component)this.jTextFieldToAddress);
            return 2;
        }
        try {
            if (!this.jTextFieldToAddress.isDataValid()) {
                Trace.logError((String)"DiscoverWizard-AddressRange", (String)"onNext Invalid To Address");
                return 2;
            }
            l2 = IpAddress.getLong((String)this.jTextFieldToAddress.getText().trim());
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            Trace.logError((String)"DiscoverWizard-AddressRange", (String)exceptionInvalidArgument.getMessage(), (Throwable)exceptionInvalidArgument);
            String string = res.getString("JPanelDiscoverWizardAddressRange_The_To_Address_field");
            Message.invokeLater((Component)this, (String)string, (Component)this.jTextFieldToAddress);
            return 2;
        }
        if (l2 < l) {
            Trace.logError((String)"DiscoverWizard-AddressRange", (String)"onNext Invalid To Address (From greater than To)");
            String string = res.getString("JPanelDiscoverWizardAddressRange_The_To_Address_field3");
            Message.invokeLater((Component)this, (String)string, (Component)this.jTextFieldToAddress);
            return 2;
        }
        Long l3 = new Long(l);
        Long l4 = new Long(l2);
        this.m_dialogWizard.putValue((Object)"FromAddress", (Object)l3);
        this.m_dialogWizard.putValue((Object)"ToAddress", (Object)l4);
        this.m_dialogWizard.putValue((Object)"Community", (Object)"public");
        return 3;
    }

    public int onBack() {
        this.m_dialogWizard.setWizardButtons(10);
        return this.m_dialogWizard.getPreviousPageID();
    }

    public boolean onFinish() {
        return true;
    }

    public void onDestroy() {
    }
}

