/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.explorer;

import com.avocent.avworks.explorer.BrandingInfo;
import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.avworks.services.ApplianceInfo;
import com.avocent.avworks.services.AppliancesDb;
import com.avocent.avworks.services.InterfaceAVWorksNMM;
import com.avocent.avworks.services.NmmDb;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionNotSupported;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.wizards.InterfaceWizardPanel;
import com.avocent.lib.gui.wizards.JDialogWizard;
import com.avocent.lib.net.IpAddress;
import com.avocent.lib.util.ResourceManager;
import com.avocent.lib.util.ThreadContinuous;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class JPanelDiscoverWizardSearchingNetwork
extends JPanel
implements InterfaceWizardPanel {
    public static final String CNAME = "JPanelDiscoverWizardSearchingNetwork";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.explorer.Res");
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JDialogWizard m_dialogWizard = null;
    private int m_nID = 3;
    private int m_nNextID = 5;
    private String m_szTitle = "";
    JLabel jLabelSearching = new JLabel();
    JProgressBar jProgressBarAdding = new JProgressBar();
    JButton jButtonStop = new JButton();
    JLabel jLabelAddressRange = new JLabel();
    Vector m_vDiscoveredAppliances = new Vector();
    ThreadGroup m_tgDiscoveryThreads = new ThreadGroup("DiscoveryThreads");
    String m_szDiscoveryFormat = res.getString("JPanelDiscoverWizardSearchingNetwork_Discover_Label");
    Object[] m_anDFLabelArgs = new Object[4];
    public static final Integer ONE = new Integer(1);
    int[] m_anActiveThreadCount = new int[]{0};
    boolean m_bDiscoveryStopping = false;
    public static final int DEFAULT_THREAD_MAX_COUNT = 256;
    public static final String THREAD_MAX_COUNT = "MaxDiscoveryThreads";
    public static final int DEFAULT_ADDRESSES_PER_THREAD = 4;
    public static final String ADDRESSES_PER_THREAD = "AddressesPerThread";
    private static boolean m_bDisplaySearchNetworkAddressRange = AVWorksBranding.getDisplaySearchNetworkAddressRange();
    private int m_nThreadMax = 256;
    private int m_nThreadThreshhold = 4;

    public JPanelDiscoverWizardSearchingNetwork(JDialogWizard jDialogWizard, int n, String string) {
        this.m_dialogWizard = jDialogWizard;
        this.m_nID = n;
        this.m_szTitle = string;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Trace.logError((String)"DiscoverWizard-SearchingNetwork", (String)"*** constructor Unable to load page.");
            Trace.logError((String)"DiscoverWizard-SearchingNetwork", (String)exception.getMessage());
        }
        try {
            File file = new File("discovery.properties");
            FileInputStream fileInputStream = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
            this.m_nThreadMax = JPanelDiscoverWizardSearchingNetwork.getIntegerProperty(properties, THREAD_MAX_COUNT, 256);
            this.m_nThreadThreshhold = JPanelDiscoverWizardSearchingNetwork.getIntegerProperty(properties, ADDRESSES_PER_THREAD, 4);
            Trace.logInfo((String)"DiscoverWizard-SearchingNetwork", (String)("configured via discovery.properties: -- maximum threads:" + this.m_nThreadMax + "; addresses/thread:" + this.m_nThreadThreshhold));
        }
        catch (Exception exception) {
            Trace.logInfo((String)"DiscoverWizard-SearchingNetwork", (String)"discovery.properties is corrupt -- Using default values (256 threads,4 addresses per thread)");
            this.m_nThreadMax = 256;
            this.m_nThreadThreshhold = 4;
        }
    }

    private static int getIntegerProperty(Properties properties, String string, int n) {
        String string2 = properties.getProperty(string, String.valueOf(n));
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Trace.logInfo((String)"DiscoverWizard-SearchingNetwork", (String)("discovery.properties is corrupt -- using default value for \"" + string + "\" (" + n + ")"));
            return n;
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.jButtonStop.setSelected(true);
        this.jButtonStop.setText(res.getString("JPanelDiscoverWizardSearchingNetwork_Stop"));
        this.jButtonStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPanelDiscoverWizardSearchingNetwork.this.jButtonStop_actionPerformed(actionEvent);
            }
        });
        if (m_bDisplaySearchNetworkAddressRange) {
            this.add((Component)this.jLabelAddressRange, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 12, 11, 0), 0, 0));
            this.add((Component)this.jLabelSearching, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 12, 11, 11), 0, 0));
            this.add((Component)this.jProgressBarAdding, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 12, 0, 11), 0, 10));
            this.add((Component)this.jButtonStop, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.add((Component)this.jLabelSearching, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, new Insets(12, 12, 11, 11), 0, 0));
            this.add((Component)this.jProgressBarAdding, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 12, 0, 11), 0, 10));
            this.add((Component)this.jButtonStop, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    public String getTitle() {
        return this.m_szTitle;
    }

    public int getID() {
        return this.m_nID;
    }

    public void onInit() {
        Trace.logInfo((String)CNAME, (String)"onInit");
    }

    public void onSetActive() {
        Trace.logInfo((String)CNAME, (String)"onSetActive");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Trace.logInfo((String)"DiscoverWizard-SearchingNetwork", (String)"onSetActive");
                Long l = (Long)JPanelDiscoverWizardSearchingNetwork.this.m_dialogWizard.getValue((Object)"FromAddress");
                long l2 = l;
                Long l3 = (Long)JPanelDiscoverWizardSearchingNetwork.this.m_dialogWizard.getValue((Object)"ToAddress");
                long l4 = l3;
                String string = (String)JPanelDiscoverWizardSearchingNetwork.this.m_dialogWizard.getValue((Object)"Community");
                int n = (int)(l4 - l2 + 1L);
                JPanelDiscoverWizardSearchingNetwork.this.jProgressBarAdding.setMinimum(0);
                JPanelDiscoverWizardSearchingNetwork.this.jProgressBarAdding.setMaximum(n + 1);
                JPanelDiscoverWizardSearchingNetwork.this.jProgressBarAdding.setValue(1);
                JPanelDiscoverWizardSearchingNetwork.this.m_dialogWizard.setWizardButtons(8);
                JPanelDiscoverWizardSearchingNetwork.this.jButtonStop.setEnabled(true);
                JPanelDiscoverWizardSearchingNetwork.this.m_dialogWizard.setDefaultButton(JPanelDiscoverWizardSearchingNetwork.this.jButtonStop);
                JPanelDiscoverWizardSearchingNetwork.this.m_vDiscoveredAppliances.removeAllElements();
                JPanelDiscoverWizardSearchingNetwork.this.m_anDFLabelArgs[0] = new Integer(0);
                JPanelDiscoverWizardSearchingNetwork.this.m_anDFLabelArgs[1] = new Integer(n);
                JPanelDiscoverWizardSearchingNetwork.this.setDiscoverLabel();
                JPanelDiscoverWizardSearchingNetwork.this.setDiscoverAddressRangeLabel(l2, l4);
                JPanelDiscoverWizardSearchingNetwork.this.startDiscoverThreads(l2, l4, string);
                JPanelDiscoverWizardSearchingNetwork.this.jButtonStop.grabFocus();
            }
        });
    }

    public int onNext() {
        Trace.logInfo((String)CNAME, (String)"onNext");
        return 5;
    }

    public int onBack() {
        Trace.logInfo((String)CNAME, (String)"onBack");
        return this.m_dialogWizard.getPreviousPageID();
    }

    public boolean onFinish() {
        Trace.logInfo((String)CNAME, (String)"onFinish");
        return true;
    }

    public void onDestroy() {
        Trace.logInfo((String)CNAME, (String)"onDestroy");
        this.stopDiscoverThreads();
    }

    void jButtonStop_actionPerformed(ActionEvent actionEvent) {
        this.m_bDiscoveryStopping = true;
        JDialogWizard jDialogWizard = this.m_dialogWizard;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (JPanelDiscoverWizardSearchingNetwork.this.m_tgDiscoveryThreads.activeCount() != 0) {
                    JPanelDiscoverWizardSearchingNetwork.this.jButtonStop.setEnabled(false);
                    JPanelDiscoverWizardSearchingNetwork.this.stopDiscoverThreads();
                }
            }
        });
    }

    public void gotoNextPage() {
        if (this.m_vDiscoveredAppliances.size() > 0) {
            this.m_dialogWizard.putValue((Object)"DiscoveredAppliances", (Object)this.m_vDiscoveredAppliances);
            this.m_dialogWizard.showPage(5);
        } else {
            String string = res.getString("JPanelDiscoverWizardSearchingNetwork_No_new_0_were_found");
            Object[] objectArray = new Object[]{BrandingInfo.getApplianceNamePlural()};
            String string2 = MessageFormat.format(string, objectArray);
            this.m_dialogWizard.putValue((Object)"FinishHeader", (Object)res.getString("JPanelDiscoverWizardSearchingNetwork_Discover_Wizard_Unsuccessful"));
            this.m_dialogWizard.putValue((Object)"FinishStatus", (Object)string2);
            this.m_dialogWizard.putValue((Object)"FinishExclamation", (Object)new Boolean(true));
            this.m_dialogWizard.putValue((Object)"FinishClose", (Object)res.getString("JPanelDiscoverWizardSearchingNetwork_Click_Back_to_retry"));
            this.m_dialogWizard.putValue((Object)"FinishButtons", (Object)new Integer(5));
            this.m_dialogWizard.showPage(8);
        }
    }

    public void addressProbed(String string, String string2) {
        Trace.logInfo((String)"DiscoverWizard", (String)(string + " probed; result: " + string2));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (JPanelDiscoverWizardSearchingNetwork.this.m_bDiscoveryStopping) {
                    return;
                }
                int n = (Integer)JPanelDiscoverWizardSearchingNetwork.this.m_anDFLabelArgs[0];
                JPanelDiscoverWizardSearchingNetwork.this.m_anDFLabelArgs[0] = new Integer(++n);
                JPanelDiscoverWizardSearchingNetwork.this.setDiscoverLabel();
                JPanelDiscoverWizardSearchingNetwork.this.jProgressBarAdding.setValue(JPanelDiscoverWizardSearchingNetwork.this.jProgressBarAdding.getValue() + 1);
            }
        });
    }

    private void setDiscoverLabel() {
        this.m_anDFLabelArgs[2] = new Integer(this.m_vDiscoveredAppliances.size());
        this.m_anDFLabelArgs[3] = AVWorksBranding.getApplianceName((boolean)this.m_anDFLabelArgs[2].equals(ONE));
        String string = MessageFormat.format(this.m_szDiscoveryFormat, this.m_anDFLabelArgs);
        this.jLabelSearching.setText(string);
    }

    private void setDiscoverAddressRangeLabel(long l, long l2) {
        try {
            String string = IpAddress.getString((long)l);
            String string2 = IpAddress.getString((long)l2);
            if (m_bDisplaySearchNetworkAddressRange) {
                this.jLabelAddressRange.setText(res.getString("JPanelDiscoverWizardSearchingNetwork_Address_Range") + " : " + string + " - " + string2);
            }
        }
        catch (Exception exception) {
            Trace.logInfo((String)"setDiscoverAddressRangeLabel", (String)" Unable to display Address Range in Discover Wizard");
        }
    }

    public void startDiscoverThreads(long l, long l2, String string) {
        Trace.logInfo((String)"DiscoverWizard", (String)("probe fr " + l + " to " + l2));
        long l3 = l2 - l + 1L;
        int n = Math.round((float)l3 / (float)this.m_nThreadThreshhold + 0.4999999f);
        int n2 = Math.min(n, this.m_nThreadMax);
        int n3 = (int)l3 % n2;
        int n4 = Math.round((float)(l3 - (long)n3) / (float)n2);
        Trace.logInfo((String)"DiscoverWizard", (String)("#Threads to fire up: " + n2));
        Trace.logInfo((String)"DiscoverWizard", (String)("#Address/thread:     " + n4));
        Trace.logInfo((String)"DiscoverWizard", (String)("First " + n3 + " threads will probe an extra address"));
        long l4 = l - 1L;
        this.m_bDiscoveryStopping = false;
        for (int i = 0; i < n2; ++i) {
            long l5 = l4 + 1L;
            long l6 = l5 + (long)n4 - 1L;
            if (i < n3) {
                ++l6;
            }
            try {
                Trace.logInfo((String)"DiscoverWizard", (String)("Thread #" + i + " will probe from " + new IpAddress(l5).getString() + " to " + new IpAddress(l6).getString()));
                ThreadDiscover threadDiscover = new ThreadDiscover(this.m_tgDiscoveryThreads, i, l5, l6, string);
                threadDiscover.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
            l4 = l6;
        }
        PollingThread pollingThread = new PollingThread();
        pollingThread.start();
    }

    public void stopDiscoverThreads() {
        int n = this.m_tgDiscoveryThreads.activeCount();
        Thread[] threadArray = new Thread[n];
        this.m_tgDiscoveryThreads.enumerate(threadArray);
        for (int i = 0; i < n; ++i) {
            if (!(threadArray[i] instanceof ThreadContinuous)) continue;
            ((ThreadContinuous)threadArray[i]).stopThread();
        }
        Trace.logInfo((String)"DiscoverWizard", (String)"All DiscoverThreads stopped: goto next page any second now");
    }

    private class PollingThread
    extends Thread {
        public PollingThread() {
            super("DiscovryManager");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        int[] nArray = JPanelDiscoverWizardSearchingNetwork.this.m_anActiveThreadCount;
                        // MONITORENTER : JPanelDiscoverWizardSearchingNetwork.this.m_anActiveThreadCount
                        JPanelDiscoverWizardSearchingNetwork.this.m_anActiveThreadCount.wait();
                        if (JPanelDiscoverWizardSearchingNetwork.this.m_anActiveThreadCount[0] <= 0) {
                            Trace.logInfo((String)"DiscoverWizard", (String)"Last DiscoverThread finished");
                            JPanelDiscoverWizardSearchingNetwork.this.gotoNextPage();
                            // MONITOREXIT : nArray
                            return;
                        }
                        // MONITOREXIT : nArray
                    }
                }
                catch (InterruptedException interruptedException) {
                    Trace.logError((String)"DiscoverWizard", (String)"PollingThread Interrupted");
                    continue;
                }
                break;
            }
        }
    }

    class ThreadDiscover
    extends ThreadContinuous {
        long m_lFromAddress;
        long m_lToAddress;
        long m_lCurrentAddress;
        String m_szCommunity;

        ThreadDiscover(ThreadGroup threadGroup, int n, long l, long l2, String string) {
            super(threadGroup, "DiscoveryThread_" + n, (long)(10 + n));
            this.m_lFromAddress = 0L;
            this.m_lToAddress = 0L;
            this.m_lCurrentAddress = 0L;
            this.m_szCommunity = "public";
            this.m_lFromAddress = l;
            this.m_lToAddress = l2;
            this.m_szCommunity = string;
            this.m_lCurrentAddress = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void startUp() {
            int[] nArray = JPanelDiscoverWizardSearchingNetwork.this.m_anActiveThreadCount;
            synchronized (JPanelDiscoverWizardSearchingNetwork.this.m_anActiveThreadCount) {
                JPanelDiscoverWizardSearchingNetwork.this.m_anActiveThreadCount[0] = JPanelDiscoverWizardSearchingNetwork.this.m_anActiveThreadCount[0] + 1;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        protected void performTask() {
            block6: {
                if (this.m_lCurrentAddress > this.m_lToAddress) {
                    this.stopThread();
                    return;
                }
                try {
                    String string = IpAddress.getString((long)this.m_lCurrentAddress);
                    Trace.logInfo((String)"DiscoverWizard-SearchingNetwork", (String)("Searching " + string));
                    try {
                        if (AppliancesDb.isAddressDefined((String)string)) {
                            Trace.logError((String)"DiscoverWizard-SearchingNetwork", (String)"Address is already defined in Database");
                            JPanelDiscoverWizardSearchingNetwork.this.addressProbed(string, "already in database");
                            break block6;
                        }
                        this.discoverAddress();
                    }
                    catch (ExceptionRequestFailed exceptionRequestFailed) {
                        Trace.logError((String)"DiscoverWizard-SearchingNetwork", (String)"*** Unable to determine if address is already defined");
                        JPanelDiscoverWizardSearchingNetwork.this.addressProbed(string, "skipped due to error");
                    }
                }
                catch (ExceptionInvalidArgument exceptionInvalidArgument) {
                    exceptionInvalidArgument.printStackTrace();
                    JPanelDiscoverWizardSearchingNetwork.this.addressProbed(String.valueOf(this.m_lCurrentAddress), "skipped due to error");
                }
            }
            ++this.m_lCurrentAddress;
        }

        protected void discoverAddress() {
            IpAddress ipAddress;
            try {
                ipAddress = new IpAddress(this.m_lCurrentAddress);
            }
            catch (Exception exception) {
                Trace.logError((String)"DiscoverWizard-SearchingNetwork", (String)"*** Discover Address Failed");
                Trace.logError((String)"DiscoverWizard-SearchingNetwork", (String)exception.getMessage());
                JPanelDiscoverWizardSearchingNetwork.this.addressProbed(String.valueOf(this.m_lCurrentAddress), "skipped due to program error");
                return;
            }
            Iterator iterator = NmmDb.iterateNmms();
            while (iterator.hasNext()) {
                InterfaceAVWorksNMM interfaceAVWorksNMM = (InterfaceAVWorksNMM)iterator.next();
                try {
                    ApplianceInfo applianceInfo = interfaceAVWorksNMM.discover(ipAddress, this.m_szCommunity);
                    Trace.logInfo((String)"DiscoverWizard-SearchingNetwork", (String)("Found Appliance " + applianceInfo.getName()));
                    JPanelDiscoverWizardSearchingNetwork.this.m_vDiscoveredAppliances.addElement(applianceInfo);
                    JPanelDiscoverWizardSearchingNetwork.this.addressProbed(ipAddress.getString(), "discovered successfully");
                    return;
                }
                catch (ExceptionNoValue exceptionNoValue) {
                }
                catch (ExceptionNotSupported exceptionNotSupported) {
                }
            }
            JPanelDiscoverWizardSearchingNetwork.this.addressProbed(ipAddress.getString(), "no device found");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cleanup() {
            Trace.logError((String)"DiscoverWizard-SearchingNetwork", (String)((Object)((Object)this) + " cleaning up"));
            int[] nArray = JPanelDiscoverWizardSearchingNetwork.this.m_anActiveThreadCount;
            synchronized (JPanelDiscoverWizardSearchingNetwork.this.m_anActiveThreadCount) {
                JPanelDiscoverWizardSearchingNetwork.this.m_anActiveThreadCount[0] = JPanelDiscoverWizardSearchingNetwork.this.m_anActiveThreadCount[0] - 1;
                JPanelDiscoverWizardSearchingNetwork.this.m_anActiveThreadCount.notify();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                Trace.logInfo((String)"DiscoverWizard", (String)("One DiscoverThread down, " + JPanelDiscoverWizardSearchingNetwork.this.m_anActiveThreadCount[0] + " to go"));
                return;
            }
        }
    }
}

