/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.explorer;

import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.avworks.services.InterfaceAVWorksNMM;
import com.avocent.avworks.services.NmmDb;
import com.avocent.avworks.services.ProductInfo;
import com.avocent.avworks.services.ProductsDb;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.gui.wizards.InterfaceWizardPanel;
import com.avocent.lib.gui.wizards.JDialogWizard;
import com.avocent.lib.util.Patch;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JPanelNewWizardProductSel
extends JPanel
implements InterfaceWizardPanel,
ListSelectionListener {
    public static final String CNAME = "JPanelNewWizardProductSel";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.explorer.Res");
    JLabel jLabelPromptSelect = new JLabel();
    JLabel jLabelVendor = new JLabel();
    JLabel jLabelProduct = new JLabel();
    JScrollPane jScrollPaneVendor = new JScrollPane();
    JScrollPane jScrollPaneProduct = new JScrollPane();
    JList jListVendor = new JList();
    JList jListProduct = new JList();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JDialogWizard m_dialogWizard = null;
    private int m_nID = -1;
    private String m_szTitle = "";
    private final JPanelNewWizardProductSel m_panelProductSel = this;
    private ProductInfo[] m_apiFullProductList = null;

    public JPanelNewWizardProductSel(JDialogWizard jDialogWizard, int n, String string) throws ExceptionConstructorFailed {
        this.m_dialogWizard = jDialogWizard;
        this.m_nID = n;
        this.m_szTitle = string;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Trace.logError((String)"NewApplianceWizard", (String)"Unable to initialize panel");
            throw new ExceptionConstructorFailed();
        }
        this.onInit();
        new Patch().fixNonResizableDlg((JDialog)this.m_dialogWizard);
    }

    void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.jLabelPromptSelect.setText(res.getString("JPanelNewWizardProductSel_Select_Product_From_List"));
        this.jLabelVendor.setText(res.getString("JPanelNewWizardProductSel_Vendor_"));
        this.jLabelProduct.setText(res.getString("JPanelNewWizardProductSel_Product_"));
        this.jScrollPaneProduct.setPreferredSize(new Dimension(100, 132));
        this.jScrollPaneVendor.setPreferredSize(new Dimension(100, 132));
        this.add((Component)this.jLabelPromptSelect, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jLabelVendor, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 0, 0, 11), 0, 0));
        this.add((Component)this.jLabelProduct, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 0, 0, 0), 0, 0));
        this.add((Component)this.jScrollPaneVendor, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 11), 0, 0));
        this.jScrollPaneVendor.getViewport().add((Component)this.jListVendor, null);
        this.add((Component)this.jScrollPaneProduct, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jScrollPaneProduct.getViewport().add((Component)this.jListProduct, null);
    }

    public String getTitle() {
        return this.m_szTitle;
    }

    public int getID() {
        return this.m_nID;
    }

    public void onInit() {
        Trace.logInfo((String)"NewApplianceWizard", (String)"onInit setting List models");
        this.jListVendor.setModel(new DefaultListModel());
        this.jListProduct.setModel(new DefaultListModel());
        this.jListProduct.setSelectionMode(0);
        this.jListVendor.addListSelectionListener(this);
    }

    public void onSetActive() {
        if (!this.readProductList()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JPanelNewWizardProductSel.this.m_dialogWizard.setWizardButtons(11);
                JPanelNewWizardProductSel.this.m_dialogWizard.setDefaultButton(2);
                String[] stringArray = JPanelNewWizardProductSel.this.getEnabledVendorList();
                JPanelNewWizardProductSel.this.updateVendorList(stringArray);
                if (stringArray.length > 1) {
                    JPanelNewWizardProductSel.this.jScrollPaneVendor.setVisible(true);
                    JPanelNewWizardProductSel.this.jListVendor.setVisible(true);
                    JPanelNewWizardProductSel.this.jLabelVendor.setVisible(true);
                    JPanelNewWizardProductSel.this.m_panelProductSel.getLayout().layoutContainer(JPanelNewWizardProductSel.this.m_panelProductSel);
                } else if (stringArray.length == 1) {
                    JPanelNewWizardProductSel.this.jScrollPaneVendor.setVisible(false);
                    JPanelNewWizardProductSel.this.jLabelVendor.setVisible(false);
                    JPanelNewWizardProductSel.this.jListVendor.setVisible(false);
                    JPanelNewWizardProductSel.this.m_panelProductSel.getLayout().layoutContainer(JPanelNewWizardProductSel.this.m_panelProductSel);
                    String string = stringArray[0];
                    String[] stringArray2 = JPanelNewWizardProductSel.this.getEnabledProductListForVendor(string);
                    JPanelNewWizardProductSel.this.updateProductsList(stringArray2);
                    if (stringArray2.length == 1) {
                        String string2 = stringArray2[0];
                        if (!JPanelNewWizardProductSel.this.launchNmmNewApplianceWizard(string, string2)) {
                            JPanelNewWizardProductSel.this.m_dialogWizard.showPage(1);
                        } else {
                            Trace.logInfo((String)"NewApplianceWizard", (String)"User did NOT press BACK so close");
                            JPanelNewWizardProductSel.this.m_dialogWizard.closeWizard(true);
                        }
                        return;
                    }
                }
            }
        });
    }

    public int onNext() {
        Object[] objectArray = this.jListVendor.getSelectedValues();
        if (objectArray.length != 1) {
            Message.show((Component)this, (String)res.getString("JPanelNewWizardProductSel_Please_Select_Vendor"), (Component)this.jListVendor);
            return 2;
        }
        Object[] objectArray2 = this.jListProduct.getSelectedValues();
        if (objectArray2.length != 1) {
            Message.show((Component)this, (String)res.getString("JPanelNewWizardProductSel_Please_Select_Product"), (Component)this.jListProduct);
            return 2;
        }
        String string = (String)objectArray[0];
        String string2 = (String)objectArray2[0];
        if (!this.launchNmmNewApplianceWizard(string, string2)) {
            return 2;
        }
        Trace.logInfo((String)"NewApplianceWizard", (String)"User did NOT press BACK so close");
        this.m_dialogWizard.closeWizard(true);
        return -1;
    }

    public int onBack() {
        return this.m_dialogWizard.getPreviousPageID();
    }

    public boolean onFinish() {
        return true;
    }

    public void onDestroy() {
    }

    private boolean readProductList() {
        try {
            Trace.logInfo((String)"NewApplianceWizard", (String)"Reading Product List from DBase");
            this.m_apiFullProductList = ProductsDb.getProductList();
            for (int i = 0; i < this.m_apiFullProductList.length; ++i) {
                boolean bl = this.m_apiFullProductList[i].isEnabled();
                boolean bl2 = this.m_apiFullProductList[i].isAddAllowed();
                Trace.logInfo((String)"NewApplianceWizard", (String)("PRODUCT " + this.m_apiFullProductList[i].getName() + " " + this.m_apiFullProductList[i].getVendor() + (bl ? "=ENABLED" : "=DISABLED") + (bl2 ? " ADD=ENABLED" : " ADD=DISABLED")));
            }
            return true;
        }
        catch (Exception exception) {
            Trace.logError((String)"NewApplianceWizard", (String)"Unable to retrieve list of products", (Throwable)exception);
            Message.show((Component)this, (String)res.getString("JPanelNewWizardProductSel_Unable_To_Retrieve_Vendors"));
            return false;
        }
    }

    private String[] getEnabledVendorList() {
        Trace.logInfo((String)"NewApplianceWizard", (String)"Getting Vendor List");
        Vector<String> vector = new Vector<String>();
        if (this.m_apiFullProductList == null) {
            return new String[0];
        }
        for (int i = 0; i < this.m_apiFullProductList.length; ++i) {
            if (!this.m_apiFullProductList[i].isEnabled() || !this.m_apiFullProductList[i].isAddAllowed() || this.m_apiFullProductList[i].getID() == Integer.MAX_VALUE) continue;
            String string = this.m_apiFullProductList[i].getVendor();
            Enumeration enumeration = vector.elements();
            boolean bl = false;
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                if (!string2.equalsIgnoreCase(string)) continue;
                bl = true;
            }
            if (bl) continue;
            vector.addElement(string);
            Trace.logInfo((String)"NewApplianceWizard", (String)("Found Enabled Vendor " + string));
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private String[] getEnabledProductListForVendor(String string) {
        Trace.logInfo((String)"NewApplianceWizard", (String)("Getting Product List for Vendor " + string));
        Vector<String> vector = new Vector<String>();
        if (this.m_apiFullProductList == null) {
            return new String[0];
        }
        for (int i = 0; i < this.m_apiFullProductList.length; ++i) {
            if (!this.m_apiFullProductList[i].isEnabled() || !this.m_apiFullProductList[i].isAddAllowed() || !string.equalsIgnoreCase(this.m_apiFullProductList[i].getVendor()) && this.m_apiFullProductList[i].getID() != Integer.MAX_VALUE) continue;
            vector.addElement(this.m_apiFullProductList[i].getName());
            Trace.logInfo((String)"NewApplianceWizard", (String)("Found Enabled Product " + this.m_apiFullProductList[i].getName()));
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        Arrays.sort(objectArray);
        return objectArray;
    }

    private void updateVendorList(final String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DefaultListModel defaultListModel = (DefaultListModel)JPanelNewWizardProductSel.this.jListVendor.getModel();
                defaultListModel.removeAllElements();
                for (int i = 0; i < stringArray.length; ++i) {
                    defaultListModel.addElement(stringArray[i]);
                }
                if (stringArray.length == 1) {
                    JPanelNewWizardProductSel.this.jListVendor.setSelectedIndex(0);
                }
            }
        });
    }

    private void updateProductsList(final String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DefaultListModel defaultListModel = (DefaultListModel)JPanelNewWizardProductSel.this.jListProduct.getModel();
                defaultListModel.removeAllElements();
                for (int i = 0; i < stringArray.length; ++i) {
                    defaultListModel.addElement(stringArray[i]);
                }
                if (stringArray.length == 1) {
                    JPanelNewWizardProductSel.this.jListProduct.setSelectedIndex(0);
                }
            }
        });
    }

    public boolean launchNmmNewApplianceWizard(String string, String string2) {
        String string3;
        try {
            string3 = AVWorksBranding.getString((String)"productGenericApplianceName", (String)"Generic Appliance");
            if (string2.equalsIgnoreCase(string3)) {
                string = "All";
            }
            Trace.logInfo((String)"NewApplianceWizard", (String)("Show the NMMs New Appliance Wizard for " + string + " " + string2));
            for (int i = 0; i < this.m_apiFullProductList.length; ++i) {
                if (!string2.equalsIgnoreCase(this.m_apiFullProductList[i].getName()) || !string.equalsIgnoreCase(this.m_apiFullProductList[i].getVendor()) && this.m_apiFullProductList[i].getID() != Integer.MAX_VALUE) continue;
                Trace.logInfo((String)"NewApplianceWizard", (String)"F Add Appliance is hidden");
                int n = this.m_apiFullProductList[i].getID();
                Trace.logInfo((String)"NewApplianceWizard", (String)("Product ID=" + n));
                int n2 = this.m_apiFullProductList[i].getNmmID();
                Trace.logInfo((String)"NewApplianceWizard", (String)("NMM ID=" + n));
                InterfaceAVWorksNMM interfaceAVWorksNMM = NmmDb.getNmm((int)n2);
                Runnable runnable = new Runnable(){

                    public void run() {
                        Trace.logInfo((String)"NewApplianceWizard", (String)"Hiding Main Add Appliance Wizard");
                        JPanelNewWizardProductSel.this.m_dialogWizard.setVisible(false);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeAndWait(runnable);
                }
                Trace.logInfo((String)"NewApplianceWizard", (String)"Main Add Appliance is hidden");
                Trace.logInfo((String)"NewApplianceWizard", (String)"About to invoke NMM newApplianceWizard method");
                boolean bl = interfaceAVWorksNMM.newApplianceWizard(n);
                Trace.logInfo((String)"NewApplianceWizard", (String)"Back from NMM newApplianceWizard method");
                if (bl) {
                    Trace.logInfo((String)"NewApplianceWizard", (String)"NMM newApplianceWizard method returned true");
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Trace.logInfo((String)"NewApplianceWizard", (String)"Re-display Main Add Wizard Page");
                            JPanelNewWizardProductSel.this.m_dialogWizard.setVisible(true);
                            Trace.logInfo((String)"NewApplianceWizard", (String)"Main Wizard is visible again");
                        }
                    });
                    return false;
                }
                Trace.logInfo((String)"NewApplianceWizard", (String)"NMM newApplianceWizard method returned false");
                Trace.logInfo((String)"NewApplianceWizard", (String)"Close new appliance wizard");
                return true;
            }
            Trace.logError((String)"NewApplianceWizard", (String)("Unable to find Product Info for " + string + " " + string2));
        }
        catch (Exception exception) {
            Trace.logError((String)"NewApplianceWizard", (String)"Failed to load NMM newApplianceWizard", (Throwable)exception);
        }
        string3 = AVWorksBranding.getApplianceName((boolean)true);
        Object[] objectArray = new Object[]{string3};
        String string4 = res.getString("JPanelNewWizardProductSel_Unable_Start_New_Appliance_Wizard");
        final String string5 = MessageFormat.format(string4, objectArray);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JPanelNewWizardProductSel.this.m_dialogWizard.closeWizard(true);
                Trace.logError((String)"NewApplianceWizard", (String)string5);
                Message.show(null, (String)string5);
            }
        });
        return false;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object[] objectArray;
        if (this.m_apiFullProductList == null) {
            return;
        }
        Object object = listSelectionEvent.getSource();
        if (object == this.jListVendor && (objectArray = this.jListVendor.getSelectedValues()).length == 1) {
            String string = (String)objectArray[0];
            String[] stringArray = this.getEnabledProductListForVendor(string);
            this.updateProductsList(stringArray);
        }
    }
}

