/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.explorer;

import com.avocent.avworks.explorer.JPanelTelnetWidget;
import com.avocent.avworks.explorer.TelnetInfo;
import com.avocent.avworks.services.BrowserHelper;
import com.avocent.avworks.services.CommonDatabasePropertyKeys;
import com.avocent.avworks.services.OptionsDb;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.gui.propsheet.InterfacePropertySheetPanel;
import com.avocent.lib.gui.propsheet.JDialogPropertySheet;
import com.avocent.lib.util.ResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JPanelOptionsTelnet
extends JPanel
implements InterfacePropertySheetPanel,
CommonDatabasePropertyKeys {
    public static final String CNAME = "JPanelOptionsTelnet";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.explorer.Res");
    private TitledBorder titledBorder1;
    private JPanelTelnetWidget jPanelTelnet = new JPanelTelnetWidget();
    private GridBagLayout gridBagLayout0 = new GridBagLayout();
    private boolean m_bDialogHasChanged = false;
    private JDialogPropertySheet m_jdps;

    public JPanelOptionsTelnet(JDialogPropertySheet jDialogPropertySheet) throws ExceptionConstructorFailed {
        Trace.logInfo((String)"JPanelOptionsTelnet.constructor", (String)"entered");
        if (jDialogPropertySheet == null) {
            Trace.logError((String)"JPanelPropertySheetPageTemplate", (String)"invalid argument");
            throw new ExceptionConstructorFailed();
        }
        this.m_jdps = jDialogPropertySheet;
        this.jbInit();
        this.jPanelTelnet.setPropertySheet(jDialogPropertySheet);
        Trace.logInfo((String)"JPanelOptionsTelnet.constructor", (String)"exited");
    }

    private void jbInit() {
        Trace.logInfo((String)"JPanelOptionsGeneral.jbInit", (String)"entered");
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), res.getString("JPanelOptionsTelnet_Telnet_Application"));
        this.jPanelTelnet.setBorder(this.titledBorder1);
        this.jPanelTelnet.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JPanelOptionsTelnet.this.jPanelTelnet_stateChanged(changeEvent);
            }
        });
        this.setLayout(this.gridBagLayout0);
        this.add((Component)this.jPanelTelnet, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 6, 6), 0, 0));
    }

    public boolean onInit() {
        Trace.logInfo((String)"JPanelOptionsTelnet.onInit", (String)"");
        return true;
    }

    public void onSetActive() {
        block7: {
            Trace.logInfo((String)"JPanelOptionsTelnet.onSetActive", (String)"entered");
            try {
                boolean bl = OptionsDb.getBooleanValue((String)"TELNET_USE_BUILTIN", (boolean)true);
                boolean bl2 = OptionsDb.getBooleanValue((String)"TELNET_SHOW_LOGIN_WINDOW", (boolean)false);
                if (bl) {
                    this.jPanelTelnet.setInfo(new TelnetInfo(bl2));
                    break block7;
                }
                String string = null;
                try {
                    string = OptionsDb.getStringValue((String)"TELNET_APPLICATION", null);
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logInfo((String)"JPanelOptionsTelnet.onSetActive", (String)"DB Request failed: using null by default");
                }
                String string2 = null;
                try {
                    string2 = OptionsDb.getStringValue((String)"TELNET_APPLICATION_ARGS", null);
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logInfo((String)"JPanelOptionsTelnet.onSetActive", (String)"DB Request failed: using null by default");
                }
                boolean bl3 = OptionsDb.getBooleanValue((String)"TELNET_LAUNCH_IN_WINDOW", (boolean)false);
                this.jPanelTelnet.setInfo(new TelnetInfo(string, string2, bl3));
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)"JPanelOptionsTelnet.saveToDatabase", (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
            }
        }
    }

    public boolean onOk() {
        Trace.logInfo((String)"JPanelOptionsTelnet.onOk", (String)"entered");
        if (this.isDialogChanged()) {
            this.saveToDatabase();
        }
        return true;
    }

    public void onDestroy() {
        Trace.logInfo((String)"JPanelOptionsTelnet.onDestroy", (String)"entered");
    }

    public boolean onApply() {
        Trace.logInfo((String)"JPanelOptionsTelnet.onApply", (String)"entered");
        if (this.isDialogChanged()) {
            this.saveToDatabase();
        }
        return true;
    }

    public void onHelp() {
        Trace.logInfo((String)"JPanelOptionsTelnet.onHelp", (String)"entered");
        ResourceBundle resourceBundle = null;
        try {
            Trace.logInfo((String)"Help", (String)"Loading Help.properties resource bundle");
            resourceBundle = ResourceBundle.getBundle("com.avocent.avworks.explorer.Help");
            Trace.logInfo((String)"Help", (String)"Successfully loaoded Help.properties");
        }
        catch (Exception exception) {
            Trace.logError((String)"Help", (String)"FAILED TO LOAD com.avocent.avworks.explorer.Help", (Throwable)exception);
        }
        BrowserHelper.showHelpPage((JFrame)((JFrame)this.m_jdps.getOwner()), (String)resourceBundle.getString("IDH_TOOLS_OPTIONS_TELNET_TAB"));
    }

    public boolean isPageValid() {
        Trace.logInfo((String)"JPanelOptionsTelnet.isPageValid", (String)"entered");
        return this.jPanelTelnet.isDataValid();
    }

    public String getTitle() {
        return res.getString("JPanelOptionsTelnet_Telnet");
    }

    public String getTooltip() {
        return res.getString("JPanelOptionsTelnet_Telnet");
    }

    public ImageIcon getIcon() {
        return null;
    }

    private void jPanelTelnet_stateChanged(ChangeEvent changeEvent) {
        Trace.logInfo((String)"JPanelOptionsTelnet.jPanelTelnet_stateChanged", (String)"entered");
        this.setDialogHasChanged(true);
        this.m_jdps.setApplyButtonEnabled(true);
    }

    private boolean isDialogChanged() {
        Trace.logInfo((String)"JPanelOptionsTelnet.isDialogChanged", (String)"entered");
        return this.m_bDialogHasChanged;
    }

    private void setDialogHasChanged(boolean bl) {
        Trace.logInfo((String)"JPanelOptionsTelnet.setDialogHasChanged", (String)"entered");
        this.m_bDialogHasChanged = bl;
    }

    private boolean saveToDatabase() {
        Trace.logInfo((String)"JPanelOptionsTelnet.saveToDatabase", (String)"entered");
        try {
            TelnetInfo telnetInfo = this.jPanelTelnet.getInfo();
            OptionsDb.setValue((String)"TELNET_USE_BUILTIN", (boolean)telnetInfo.m_bUseBuiltin);
            OptionsDb.setValue((String)"TELNET_SHOW_LOGIN_WINDOW", (boolean)telnetInfo.m_bLoginWindow);
            OptionsDb.setValue((String)"TELNET_APPLICATION", (String)telnetInfo.m_szTelnetPath);
            OptionsDb.setValue((String)"TELNET_APPLICATION_ARGS", (String)telnetInfo.m_szCommandLine);
            OptionsDb.setValue((String)"TELNET_LAUNCH_IN_WINDOW", (boolean)telnetInfo.m_bCommandWindow);
        }
        catch (Exception exception) {
            Trace.logError((String)CNAME, (String)("Exception Occurred in saveToDatabase with the following message\n" + exception.getMessage()), (Throwable)exception);
            String string = res.getString("JPanelOptionsTelnet_Could_not_save1");
            Message.show((Component)this, (String)string);
            return false;
        }
        return true;
    }
}

