/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.explorer;

import com.avocent.avworks.explorer.BrandingInfo;
import com.avocent.avworks.services.BrowserHelper;
import com.avocent.avworks.services.ConnectionPathInfo;
import com.avocent.avworks.services.InterfaceAVWorksNMM;
import com.avocent.avworks.services.NmmDb;
import com.avocent.avworks.services.UnitInfo;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.gui.components.JListAvocent;
import com.avocent.lib.gui.components.JWrappingLabel;
import com.avocent.lib.gui.propsheet.InterfacePropertySheetPanel;
import com.avocent.lib.gui.propsheet.JDialogPropertySheet;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class JPanelPropertiesConnectionsTab
extends JPanel
implements InterfacePropertySheetPanel {
    public static final String CNAME = "JPanelPropertiesConnectionsTab";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.explorer.Res");
    JPanel panelComponents = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JLabel jLabelConnections = new JLabel();
    JWrappingLabel jwLabelResync = new JWrappingLabel();
    JListAvocent jListConnections = new JListAvocent();
    JScrollPane jScrollPaneConnections = new JScrollPane();
    protected JDialogPropertySheet m_jdps;
    private UnitInfo m_ui = null;
    private static final Dimension PREFERRED_VIEW_SIZE = new Dimension(150, 64);

    public JPanelPropertiesConnectionsTab(JDialogPropertySheet jDialogPropertySheet, UnitInfo unitInfo) throws ExceptionConstructorFailed {
        if (jDialogPropertySheet == null || unitInfo == null) {
            Trace.logError((String)CNAME, (String)"invalid argument");
            throw new ExceptionConstructorFailed();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Trace.logError((String)CNAME, (String)"jbInit failed");
            throw new ExceptionConstructorFailed();
        }
        this.m_jdps = jDialogPropertySheet;
        this.m_ui = unitInfo;
    }

    void jbInit() throws Exception {
        this.panelComponents.setLayout(this.gridBagLayout1);
        this.setLayout(this.gridBagLayout2);
        this.jLabelConnections.setText(res.getString("JPanelPropertiesConnectionsTab_Connections_"));
        Object[] objectArray = new Object[]{BrandingInfo.getApplianceNameSingular()};
        this.jwLabelResync.setText(MessageFormat.format(res.getString("JPanelPropertiesConnectionsTab_Resync"), objectArray));
        this.jListConnections.setFont(new Font("Dialog", 0, 11));
        this.jScrollPaneConnections.setViewportView((Component)this.jListConnections);
        this.jScrollPaneConnections.getViewport().setPreferredSize(PREFERRED_VIEW_SIZE);
        this.panelComponents.add((Component)this.jLabelConnections, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(11, 11, 11, 11), 0, 0));
        this.panelComponents.add((Component)this.jwLabelResync, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 16, 1, new Insets(11, 11, 11, 11), 0, 0));
        this.panelComponents.add((Component)this.jScrollPaneConnections, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 11, 0, 12), 0, 0));
        this.add((Component)this.panelComponents, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public boolean onInit() {
        Vector<String> vector = new Vector<String>();
        Iterator iterator = NmmDb.iterateNmms();
        while (iterator.hasNext()) {
            InterfaceAVWorksNMM interfaceAVWorksNMM = (InterfaceAVWorksNMM)iterator.next();
            try {
                ConnectionPathInfo[] connectionPathInfoArray = interfaceAVWorksNMM.getConnectionPaths(this.m_ui.getID());
                for (int i = 0; i < connectionPathInfoArray.length; ++i) {
                    vector.addElement(connectionPathInfoArray[i].getType() + ":" + connectionPathInfoArray[i].getDescription());
                }
            }
            catch (Exception exception) {
                Trace.logInfo((String)"JPanelPropertiesConnectionsTab:onInit", (String)"caught an exception during getConnectionPaths call to an NMM");
            }
        }
        this.jListConnections.setListData(vector);
        return true;
    }

    public void onSetActive() {
    }

    public boolean onOk() {
        return true;
    }

    public void onDestroy() {
    }

    public boolean onApply() {
        return true;
    }

    public void onHelp() {
        ResourceBundle resourceBundle = null;
        try {
            Trace.logInfo((String)"Help", (String)"Loading Help.properties resource bundle");
            resourceBundle = ResourceBundle.getBundle("com.avocent.avworks.explorer.Help");
            Trace.logInfo((String)"Help", (String)"Successfully loaoded Help.properties");
        }
        catch (Exception exception) {
            Trace.logError((String)"Help", (String)"FAILED TO LOAD com.avocent.avworks.explorer.Help");
        }
        BrowserHelper.showHelpPage((JFrame)((JFrame)this.m_jdps.getOwner()), (String)resourceBundle.getString("IDH_VIEW_PROPERTIES_CONNECTIONS_TAB"));
    }

    public boolean isPageValid() {
        return true;
    }

    public String getTitle() {
        return res.getString("JPanelPropertiesConnectionsTab_Connections");
    }

    public String getTooltip() {
        return res.getString("JPanelPropertiesConnectionsTab_Connections1");
    }

    public ImageIcon getIcon() {
        return null;
    }
}

