/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.explorer;

import com.avocent.avworks.services.AVWorksEventBroadcaster;
import com.avocent.avworks.services.BrowserHelper;
import com.avocent.avworks.services.DatabaseSession;
import com.avocent.avworks.services.UnitInfo;
import com.avocent.lib.database.SqlCmd;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.gui.propsheet.InterfacePropertySheetPanel;
import com.avocent.lib.gui.propsheet.JDialogPropertySheet;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JPanelPropertiesInformationTab
extends JPanel
implements InterfacePropertySheetPanel {
    public static final String CNAME = "JPanelPropertiesInformationTab";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.explorer.Res");
    JPanel panelComponents = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JLabel jLabelDescription = new JLabel();
    JScrollPane jScrollPaneDescription = new JScrollPane();
    JTextArea jTextAreaDescription = new JTextArea();
    JLabel jLabelContact = new JLabel();
    JScrollPane jScrollPaneContact = new JScrollPane();
    JTextArea jTextAreaContact = new JTextArea();
    JTextField jTextFieldContactPhone = new JTextField();
    JLabel jLabelPhoneNumber = new JLabel();
    JLabel jLabelComment = new JLabel();
    JScrollPane jScrollPaneComments = new JScrollPane();
    JTextArea jTextAreaComment = new JTextArea();
    protected JDialogPropertySheet m_jdps;
    private UnitInfo m_ui = null;
    private boolean m_bDatabaseModified = false;
    private boolean m_bChangesPending = false;
    private boolean m_bInitialized = false;

    public JPanelPropertiesInformationTab(JDialogPropertySheet jDialogPropertySheet, UnitInfo unitInfo) throws ExceptionConstructorFailed {
        if (jDialogPropertySheet == null || unitInfo == null) {
            Trace.logError((String)CNAME, (String)"invalid argument");
            String string = res.getString("JPanelPropertiesInformationTab_Could_not_execute_the101");
            Message.show((Component)this, (String)string);
            throw new ExceptionConstructorFailed();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Trace.logError((String)CNAME, (String)"jbInit failed");
            throw new ExceptionConstructorFailed();
        }
        this.m_jdps = jDialogPropertySheet;
        this.m_ui = unitInfo;
    }

    void jbInit() throws Exception {
        this.panelComponents.setLayout(this.gridBagLayout1);
        this.setLayout(this.gridBagLayout2);
        this.jLabelDescription.setText(res.getString("JPanelPropertiesInformationTab_Description_"));
        this.jTextAreaDescription.setText("Description");
        this.jTextAreaDescription.setLineWrap(true);
        this.jTextAreaDescription.setWrapStyleWord(true);
        this.jScrollPaneDescription.setPreferredSize(new Dimension(100, 40));
        this.jLabelContact.setText(res.getString("JPanelPropertiesInformationTab_Contact_"));
        this.jTextAreaContact.setText("Contact");
        this.jTextAreaContact.setLineWrap(true);
        this.jTextAreaContact.setWrapStyleWord(true);
        this.jTextFieldContactPhone.setPreferredSize(new Dimension(100, 21));
        this.jTextFieldContactPhone.setText(res.getString("JPanelPropertiesInformationTab_Phone_Number"));
        this.jLabelPhoneNumber.setText(res.getString("JPanelPropertiesInformationTab_Contact_Phone_Number_"));
        this.jLabelComment.setText(res.getString("JPanelPropertiesInformationTab_Comment_"));
        this.jTextAreaComment.setText("Comments");
        this.jTextAreaComment.setLineWrap(true);
        this.jTextAreaComment.setWrapStyleWord(true);
        this.jScrollPaneContact.setPreferredSize(new Dimension(100, 40));
        this.jScrollPaneComments.setPreferredSize(new Dimension(100, 60));
        this.add((Component)this.panelComponents, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panelComponents.add((Component)this.jLabelDescription, new GridBagConstraints(0, 0, 2, 1, 0.5, 0.0, 18, 0, new Insets(12, 11, 6, 11), 0, 0));
        this.panelComponents.add((Component)this.jScrollPaneDescription, new GridBagConstraints(0, 1, 2, 1, 0.5, 0.5, 18, 1, new Insets(0, 11, 12, 11), 0, 0));
        this.jScrollPaneDescription.getViewport().add((Component)this.jTextAreaDescription, null);
        this.panelComponents.add((Component)this.jLabelContact, new GridBagConstraints(0, 2, 2, 1, 0.5, 0.0, 18, 0, new Insets(0, 11, 6, 11), 0, 0));
        this.panelComponents.add((Component)this.jScrollPaneContact, new GridBagConstraints(0, 3, 2, 1, 0.5, 0.5, 18, 1, new Insets(0, 11, 12, 11), 0, 0));
        this.jScrollPaneContact.getViewport().add((Component)this.jTextAreaContact, null);
        this.panelComponents.add((Component)this.jTextFieldContactPhone, new GridBagConstraints(0, 5, 1, 1, 0.5, 0.0, 18, 2, new Insets(0, 11, 12, 11), 0, 0));
        this.panelComponents.add((Component)this.jLabelPhoneNumber, new GridBagConstraints(0, 4, 1, 1, 0.5, 0.0, 18, 0, new Insets(0, 11, 6, 11), 0, 0));
        this.panelComponents.add((Component)this.jLabelComment, new GridBagConstraints(0, 6, 1, 1, 0.5, 0.0, 18, 0, new Insets(0, 11, 6, 11), 0, 0));
        this.panelComponents.add((Component)this.jScrollPaneComments, new GridBagConstraints(0, 7, 1, 1, 0.5, 0.5, 18, 1, new Insets(0, 11, 12, 11), 0, 0));
        this.jScrollPaneComments.getViewport().add((Component)this.jTextAreaComment, null);
    }

    public boolean onInit() {
        Font font = this.jTextFieldContactPhone.getFont();
        this.jTextAreaComment.setFont(font);
        this.jTextAreaContact.setFont(font);
        this.jTextAreaDescription.setFont(font);
        this.jTextAreaDescription.setText(this.m_ui.getDescription());
        this.jTextAreaContact.setText(this.m_ui.getContact());
        this.jTextFieldContactPhone.setText(this.m_ui.getContactPhone());
        this.jTextAreaComment.setText(this.m_ui.getComment());
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!JPanelPropertiesInformationTab.this.m_bChangesPending) {
                    JPanelPropertiesInformationTab.this.m_jdps.setApplyButtonEnabled(true);
                    JPanelPropertiesInformationTab.this.m_bChangesPending = true;
                }
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                if (!JPanelPropertiesInformationTab.this.m_bChangesPending) {
                    JPanelPropertiesInformationTab.this.m_jdps.setApplyButtonEnabled(true);
                    JPanelPropertiesInformationTab.this.m_bChangesPending = true;
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        this.jTextAreaDescription.getDocument().addDocumentListener(documentListener);
        this.jTextAreaContact.getDocument().addDocumentListener(documentListener);
        this.jTextFieldContactPhone.getDocument().addDocumentListener(documentListener);
        this.jTextAreaComment.getDocument().addDocumentListener(documentListener);
        this.m_bInitialized = true;
        return true;
    }

    public void onSetActive() {
    }

    public boolean onOk() {
        return this.applyChanges();
    }

    private boolean applyChanges() {
        try {
            String string;
            String string2;
            String string3;
            if (!this.m_bChangesPending) {
                return true;
            }
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.m_ui.isAppliance()) {
                stringBuffer.append("UPDATE APPLIANCES SET ");
            } else {
                stringBuffer.append("UPDATE SERVERS SET ");
            }
            String string4 = this.jTextAreaDescription.getText().trim();
            if (!string4.equals(this.m_ui.getDescription())) {
                if (bl) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("DESCRIPTION = " + SqlCmd.quote((String)string4));
                bl = true;
            }
            if (!(string3 = this.jTextAreaContact.getText().trim()).equals(this.m_ui.getContact())) {
                if (bl) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("CONTACT = " + SqlCmd.quote((String)string3));
                bl = true;
            }
            if (!(string2 = this.jTextFieldContactPhone.getText().trim()).equals(this.m_ui.getContactPhone())) {
                if (bl) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("CONTACT_PHONE = " + SqlCmd.quote((String)string2));
                bl = true;
            }
            if (!(string = this.jTextAreaComment.getText().trim()).equals(this.m_ui.getComment())) {
                if (bl) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("COMMENT = " + SqlCmd.quote((String)string));
                bl = true;
            }
            if (bl) {
                stringBuffer.append(" WHERE ID = " + this.m_ui.getID());
                stringBuffer.append(";");
                String string5 = stringBuffer.toString();
                Trace.logInfo((String)"JPanelPropertiesInformationTab:onOk", (String)("About to send SQL statement=" + string5));
                DatabaseSession.executeUpdate((String)string5);
                this.m_bDatabaseModified = true;
                this.m_ui.setDescription(string4);
                this.m_ui.setContact(string3);
                this.m_ui.setContactPhone(string2);
                this.m_ui.setComment(string);
                Trace.logInfo((String)"JPanelPropertiesInformationTab:onOk", (String)"SQL command executed successfully");
                this.fireDbaseModifyEvent();
            }
            this.m_bChangesPending = false;
            return true;
        }
        catch (Exception exception) {
            Trace.logError((String)"JPanelPropertiesInformationTab:onOk", (String)"Failed to write the changes", (Throwable)exception);
            String string = res.getString("JPanelPropertiesInformationTab_Not_all_properties101");
            Message.show((Component)this, (String)string);
            return false;
        }
    }

    public void onDestroy() {
        String string = "DBASE Modified Event Sent For Unit " + this.m_ui.getName();
        UnitInfo unitInfo = (UnitInfo)this.m_jdps.getValue((Object)string);
        if (unitInfo == null) {
            this.fireDbaseModifyEvent();
        }
    }

    public boolean onApply() {
        return this.applyChanges();
    }

    public void onHelp() {
        ResourceBundle resourceBundle = null;
        try {
            Trace.logInfo((String)"Help", (String)"Loading Help.properties resource bundle");
            resourceBundle = ResourceBundle.getBundle("com.avocent.avworks.explorer.Help");
            Trace.logInfo((String)"Help", (String)"Successfully loaoded Help.properties");
        }
        catch (Exception exception) {
            Trace.logError((String)"Help", (String)"FAILED TO LOAD com.avocent.avworks.explorer.Help");
        }
        BrowserHelper.showHelpPage((JFrame)((JFrame)this.m_jdps.getOwner()), (String)resourceBundle.getString("IDH_VIEW_PROPERTIES_INFORMATION_TAB"));
    }

    public boolean isPageValid() {
        String string = this.jTextAreaDescription.getText().trim();
        if (!string.equals(this.m_ui.getDescription()) && string.length() > 128) {
            String string2 = res.getString("JPanelPropertiesInformationTab_The_Description_field");
            Message.show((Component)this, (String)string2);
            this.jTextAreaDescription.grabFocus();
            return false;
        }
        String string3 = this.jTextAreaContact.getText().trim();
        if (!string3.equals(this.m_ui.getContact()) && string3.length() > 128) {
            String string4 = res.getString("JPanelPropertiesInformationTab_The_Contact_field_is");
            Message.show((Component)this, (String)string4);
            this.jTextAreaContact.grabFocus();
            return false;
        }
        String string5 = this.jTextFieldContactPhone.getText().trim();
        if (!string5.equals(this.m_ui.getContactPhone()) && string5.length() > 64) {
            String string6 = res.getString("JPanelPropertiesInformationTab_The_Contact_Phone");
            Message.show((Component)this, (String)string6);
            this.jTextFieldContactPhone.grabFocus();
            return false;
        }
        String string7 = this.jTextAreaComment.getText().trim();
        if (!string7.equals(this.m_ui.getComment()) && string7.length() > 256) {
            String string8 = res.getString("JPanelPropertiesInformationTab_The_Comment_field_is");
            Message.show((Component)this, (String)string8);
            this.jTextAreaComment.grabFocus();
            return false;
        }
        return true;
    }

    public String getTitle() {
        return res.getString("JPanelPropertiesInformationTab_Information");
    }

    public String getTooltip() {
        return res.getString("JPanelPropertiesInformationTab_Information1");
    }

    public ImageIcon getIcon() {
        return null;
    }

    private void fireDbaseModifyEvent() {
        String string = "DBASE Modified Event Sent For Unit " + this.m_ui.getName();
        if (this.m_bDatabaseModified) {
            AVWorksEventBroadcaster.fireApplianceOrServerModifiedEvent((UnitInfo)this.m_ui);
            this.m_jdps.putValue((Object)string, (Object)this.m_ui);
            this.m_bDatabaseModified = false;
        }
    }
}

