/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.explorer;

import com.avocent.avworks.services.AVWorksEventBroadcaster;
import com.avocent.avworks.services.ApplianceInfo;
import com.avocent.avworks.services.AppliancesDb;
import com.avocent.avworks.services.BrowserHelper;
import com.avocent.avworks.services.DatabaseSession;
import com.avocent.avworks.services.ServerInfo;
import com.avocent.avworks.services.ServersDb;
import com.avocent.avworks.services.UnitInfo;
import com.avocent.lib.database.SqlCmd;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.components.JTextFieldIPAddress;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.gui.propsheet.InterfacePropertySheetPanel;
import com.avocent.lib.gui.propsheet.JDialogPropertySheet;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JPanelPropertiesNetworkTab
extends JPanel
implements InterfacePropertySheetPanel {
    public static final String CNAME = "JPanelPropertiesNetworkTab";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.explorer.Res");
    private static int TEXT_FIELD_SIZE = 32;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel jLabelAddress = new JLabel();
    JTextFieldIPAddress jTextFieldAddress;
    JLabel jLabelBrowserURL = new JLabel();
    JTextField jTextFieldBrowserURL = new JTextField();
    JLabel jLabelFiller = new JLabel(" ");
    protected JDialogPropertySheet m_jdps;
    private UnitInfo m_ui = null;
    private boolean m_bDatabaseModified = false;
    private boolean m_bChangesPending = false;
    private boolean m_bInitialized = false;
    private boolean m_bBrowserSupported;

    public JPanelPropertiesNetworkTab(JDialogPropertySheet jDialogPropertySheet, UnitInfo unitInfo) throws ExceptionConstructorFailed {
        if (jDialogPropertySheet == null || unitInfo == null) {
            Trace.logError((String)CNAME, (String)"invalid argument");
            throw new ExceptionConstructorFailed();
        }
        this.m_jdps = jDialogPropertySheet;
        this.m_ui = unitInfo;
        this.m_bBrowserSupported = this.m_ui.isPropertySupported("Browser");
        int n = unitInfo.isAppliance() ? 1 : 0;
        this.jTextFieldAddress = new JTextFieldIPAddress(n);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Trace.logError((String)CNAME, (String)"jbInit failed");
            throw new ExceptionConstructorFailed();
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.jLabelBrowserURL.setText(res.getString("JPanelPropertiesNetworkTab_Browser_URL"));
        this.jLabelBrowserURL.setVisible(this.m_bBrowserSupported);
        this.jTextFieldBrowserURL.setColumns(TEXT_FIELD_SIZE);
        this.jTextFieldBrowserURL.setVisible(this.m_bBrowserSupported);
        this.jLabelAddress.setText(res.getString("JPanelPropertiesNetworkTab_Address_"));
        this.jLabelAddress.setVisible(this.m_ui.isAppliance());
        this.jTextFieldAddress.setColumns(TEXT_FIELD_SIZE);
        this.jTextFieldAddress.setVisible(this.m_ui.isAppliance());
        this.add((Component)this.jLabelAddress, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 11, 12, 12), 0, 0));
        this.add((Component)this.jTextFieldAddress, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(12, 0, 11, 11), 0, 0));
        this.add((Component)this.jLabelBrowserURL, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 11, 12, 12), 0, 0));
        this.add((Component)this.jTextFieldBrowserURL, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(12, 0, 11, 11), 0, 0));
        this.add((Component)this.jLabelFiller, new GridBagConstraints(0, 2, 2, 1, 0.0, 1.0, 18, 0, new Insets(12, 11, 12, 12), 0, 0));
    }

    public boolean onInit() {
        if (this.m_bBrowserSupported) {
            this.jTextFieldBrowserURL.setText(this.m_ui.getBrowserURL());
        }
        if (this.m_ui.isAppliance()) {
            this.jTextFieldAddress.setText(this.m_ui.getAddress());
        }
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!JPanelPropertiesNetworkTab.this.m_bChangesPending) {
                    JPanelPropertiesNetworkTab.this.m_jdps.setApplyButtonEnabled(true);
                    JPanelPropertiesNetworkTab.this.m_bChangesPending = true;
                }
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                if (!JPanelPropertiesNetworkTab.this.m_bChangesPending) {
                    JPanelPropertiesNetworkTab.this.m_jdps.setApplyButtonEnabled(true);
                    JPanelPropertiesNetworkTab.this.m_bChangesPending = true;
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        if (this.m_bBrowserSupported) {
            this.jTextFieldBrowserURL.getDocument().addDocumentListener(documentListener);
        }
        if (this.m_ui.isAppliance()) {
            this.jTextFieldAddress.getDocument().addDocumentListener(documentListener);
        }
        this.m_bInitialized = true;
        return true;
    }

    public void onSetActive() {
    }

    public boolean onOk() {
        return this.applyChanges();
    }

    private boolean applyChanges() {
        try {
            String string;
            if (!this.m_bChangesPending) {
                return true;
            }
            if (this.m_bBrowserSupported && !(string = this.jTextFieldBrowserURL.getText().trim()).equals(this.m_ui.getBrowserURL())) {
                this.m_ui.setBrowserURL(string);
                if (this.m_ui.isAppliance()) {
                    AppliancesDb.modify((ApplianceInfo)((ApplianceInfo)this.m_ui));
                } else {
                    ServersDb.modify((ServerInfo)((ServerInfo)this.m_ui));
                }
                this.m_bDatabaseModified = true;
            }
            if (this.m_ui.isAppliance() && !(string = this.jTextFieldAddress.getText().trim()).equals(this.m_ui.getAddress())) {
                String string2 = "UPDATE APPLIANCES SET ADDRESS = " + SqlCmd.quote((String)string) + " " + "WHERE ID = " + this.m_ui.getID() + ";";
                DatabaseSession.executeUpdate((String)string2);
                this.m_bDatabaseModified = true;
                this.m_ui.setAddress(string);
                Trace.logInfo((String)"JPanelPropertiesApplianceNetworkTab:onOk", (String)"SQL command executed successfully");
            }
            this.fireDbaseModifyEvent();
            this.m_bChangesPending = false;
            return true;
        }
        catch (Exception exception) {
            Trace.logError((String)"JPanelPropertiesNetworkTab:onOk", (String)"Failed to write the changes", (Throwable)exception);
            String string = res.getString("JPanelPropertiesNetworkTab_Not_all_properties102");
            Message.show((Component)this, (String)string);
            return false;
        }
    }

    public void onDestroy() {
        String string = "DBASE Modified Event Sent For Unit " + this.m_ui.getName();
        UnitInfo unitInfo = (UnitInfo)this.m_jdps.getValue((Object)string);
        if (unitInfo == null) {
            this.fireDbaseModifyEvent();
        }
    }

    public boolean onApply() {
        return this.applyChanges();
    }

    public void onHelp() {
        ResourceBundle resourceBundle = null;
        try {
            Trace.logInfo((String)"Help", (String)"Loading Help.properties resource bundle");
            resourceBundle = ResourceBundle.getBundle("com.avocent.avworks.explorer.Help");
            Trace.logInfo((String)"Help", (String)"Successfully loaoded Help.properties");
        }
        catch (Exception exception) {
            Trace.logError((String)"Help", (String)"FAILED TO LOAD com.avocent.avworks.explorer.Help");
        }
        BrowserHelper.showHelpPage((JFrame)((JFrame)this.m_jdps.getOwner()), (String)resourceBundle.getString("IDH_VIEW_PROPERTIES_NETWORK_TAB_SERVER"));
    }

    public boolean isPageValid() {
        String string;
        if (this.m_bBrowserSupported && !(string = this.jTextFieldBrowserURL.getText().trim()).equals(this.m_ui.getBrowserURL()) && string.length() > 256) {
            String string2 = res.getString("JPanelPropertiesNetworkTab_The_Browser_URL_field");
            Message.show((Component)this, (String)string2);
            this.jTextFieldBrowserURL.grabFocus();
            return false;
        }
        return !this.m_ui.isAppliance() || this.validateAddress();
    }

    public String getTitle() {
        return res.getString(CNAME + (this.m_ui.isAppliance() ? "_Appliance_Label" : "_Server_Label"));
    }

    public String getTooltip() {
        return res.getString(CNAME + (this.m_ui.isAppliance() ? "_Appliance_Tip" : "_Server_Tip"));
    }

    public ImageIcon getIcon() {
        return null;
    }

    private void fireDbaseModifyEvent() {
        String string = "DBASE Modified Event Sent For Unit " + this.m_ui.getName();
        if (this.m_bDatabaseModified) {
            AVWorksEventBroadcaster.fireApplianceOrServerModifiedEvent((UnitInfo)this.m_ui);
            this.m_jdps.putValue((Object)string, (Object)this.m_ui);
            this.m_bDatabaseModified = false;
        }
    }

    private boolean validateAddress() {
        String string = this.jTextFieldAddress.getText().trim();
        if (string.equalsIgnoreCase(this.m_ui.getAddress())) {
            return true;
        }
        if (!this.jTextFieldAddress.isDataValid()) {
            return false;
        }
        try {
            if (AppliancesDb.isAddressDefined((String)string)) {
                String string2 = res.getString("JPanelPropertiesNetworkTab_The_Address_field_is5");
                Message.show((Component)this, (String)string2);
                this.jTextFieldAddress.requestFocusInWindow();
                return false;
            }
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)"JPanelPropertiesApplianceNetworkTab", (String)"AppliancesDb.isAddressDefined call failed");
            String string3 = res.getString("JPanelPropertiesNetworkTab_Could_not_update_the100");
            Message.show((Component)this, (String)string3);
            this.jTextFieldAddress.requestFocusInWindow();
            return false;
        }
        return true;
    }
}

