/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.explorer;

import com.avocent.avworks.explorer.JPanelTelnetWidget;
import com.avocent.avworks.explorer.TelnetInfo;
import com.avocent.avworks.services.AVWorksEventBroadcaster;
import com.avocent.avworks.services.BrowserHelper;
import com.avocent.avworks.services.UnitInfo;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.gui.components.JTextFieldIPAddress;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.gui.propsheet.InterfacePropertySheetPanel;
import com.avocent.lib.gui.propsheet.JDialogPropertySheet;
import com.avocent.lib.util.Patch;
import com.avocent.lib.util.ResourceManager;
import com.avocent.lib.util.StringUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JPanelPropertiesTelnetTab
extends JPanel
implements InterfacePropertySheetPanel {
    public static final String CNAME = "JPanelPropertiesTelnetTab";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.explorer.Res");
    private static int TEXT_FIELD_SIZE = 32;
    protected JDialogPropertySheet m_jdps;
    private UnitInfo m_ui = null;
    private boolean m_bChangesPending = false;
    private boolean m_bDatabaseModified = false;
    private boolean m_bPortVisible;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel jLabelPort = new JLabel();
    JTextField jTextFieldPort = new JTextField();
    JLabel jLabelAddress = new JLabel();
    JTextFieldIPAddress jTextFieldAddress = new JTextFieldIPAddress();
    JPanel jPanelTelnetApplication = new JPanel();
    TitledBorder titledBorder1;
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JCheckBox jCheckBoxUseDefault = new JCheckBox();
    JPanelTelnetWidget jptwTelnetInfo = new JPanelTelnetWidget();

    public JPanelPropertiesTelnetTab(JDialogPropertySheet jDialogPropertySheet, UnitInfo unitInfo) throws ExceptionConstructorFailed {
        if (jDialogPropertySheet == null || unitInfo == null) {
            Trace.logError((String)CNAME, (String)"invalid argument");
            throw new ExceptionConstructorFailed();
        }
        this.m_jdps = jDialogPropertySheet;
        this.m_ui = unitInfo;
        this.m_bPortVisible = !unitInfo.isPropertySupported("TelnetRemovePort");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Trace.logError((String)CNAME, (String)"jbInit failed", (Throwable)exception);
            throw new ExceptionConstructorFailed();
        }
        new Patch().fixNonResizableDlg((JDialog)this.m_jdps);
        this.jptwTelnetInfo.setPropertySheet(jDialogPropertySheet);
    }

    void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), res.getString("JPanelPropertiesTelnetTab_Telnet_App_to_Launch"));
        this.setLayout(this.gridBagLayout1);
        this.jLabelAddress.setText(res.getString("JPanelPropertiesTelnetTab_IP_Address_"));
        this.jLabelAddress.setVisible(!this.m_ui.isAppliance());
        this.jTextFieldAddress.setColumns(TEXT_FIELD_SIZE);
        this.jTextFieldAddress.setVisible(!this.m_ui.isAppliance());
        this.jLabelPort.setText(res.getString("JPanelPropertiesTelnetTab_Port_"));
        this.jLabelPort.setVisible(this.m_bPortVisible);
        this.jTextFieldPort.setColumns(TEXT_FIELD_SIZE);
        this.jTextFieldPort.setVisible(this.m_bPortVisible);
        if (!this.m_ui.isAppliance() || this.m_bPortVisible) {
            this.jPanelTelnetApplication.setBorder(this.titledBorder1);
        }
        this.jPanelTelnetApplication.setLayout(this.gridBagLayout2);
        this.jCheckBoxUseDefault.setText(res.getString("JPanelPropertiesTelnetTab_Use_Default"));
        this.add((Component)this.jLabelAddress, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 12, 11, 12), 0, 0));
        this.add((Component)this.jTextFieldAddress, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(12, 0, 11, 12), 0, 0));
        this.add((Component)this.jLabelPort, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 12, 11, 12), 0, 0));
        this.add((Component)this.jTextFieldPort, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(12, 0, 11, 12), 0, 0));
        this.add((Component)this.jPanelTelnetApplication, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 6, 6, 6), 0, 0));
        this.jPanelTelnetApplication.add((Component)this.jCheckBoxUseDefault, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(11, 11, 12, 12), 0, 0));
        this.jPanelTelnetApplication.add((Component)this.jptwTelnetInfo, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(11, 11, 12, 12), 0, 0));
    }

    public boolean onInit() {
        Object object;
        int n;
        if (!this.m_ui.isAppliance()) {
            this.jTextFieldAddress.setText(this.m_ui.getAddress());
        }
        if (this.m_bPortVisible) {
            n = this.m_ui.getTelnetPort();
            this.jTextFieldPort.setText(n == 0 ? "" : String.valueOf(n));
        }
        n = this.m_ui.getUseDefaultTelnet() ? 1 : 0;
        this.jCheckBoxUseDefault.setSelected(n != 0);
        boolean bl = this.m_ui.getUseBuiltinTelnet();
        if (bl) {
            object = new TelnetInfo(this.m_ui.getTelnetLoginWindow());
            this.jptwTelnetInfo.setInfo((TelnetInfo)object);
        } else {
            object = new TelnetInfo(this.m_ui.getTelnetApplicationPath(), this.m_ui.getTelnetCommandLineArgs(), this.m_ui.getTelnetLaunchCommandWindow());
            this.jptwTelnetInfo.setInfo((TelnetInfo)object);
        }
        this.jptwTelnetInfo.setEnabled(n == 0);
        this.jCheckBoxUseDefault.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JPanelPropertiesTelnetTab.this.jCheckBoxUseDefault_itemStateChanged(itemEvent);
            }
        });
        this.jptwTelnetInfo.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JPanelPropertiesTelnetTab.this.jptwTelnetInfo_stateChanged(changeEvent);
            }
        });
        object = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!JPanelPropertiesTelnetTab.this.m_bChangesPending) {
                    JPanelPropertiesTelnetTab.this.m_jdps.setApplyButtonEnabled(true);
                    JPanelPropertiesTelnetTab.this.m_bChangesPending = true;
                }
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                if (!JPanelPropertiesTelnetTab.this.m_bChangesPending) {
                    JPanelPropertiesTelnetTab.this.m_jdps.setApplyButtonEnabled(true);
                    JPanelPropertiesTelnetTab.this.m_bChangesPending = true;
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        this.jTextFieldPort.getDocument().addDocumentListener((DocumentListener)object);
        this.jTextFieldAddress.getDocument().addDocumentListener((DocumentListener)object);
        return true;
    }

    public void onSetActive() {
    }

    public boolean onOk() {
        return this.applyChanges();
    }

    private boolean applyChanges() {
        boolean bl = false;
        try {
            if (this.m_bChangesPending && this.isPageValid()) {
                int n;
                String string;
                if (!this.m_ui.isAppliance() && !(string = this.jTextFieldAddress.getText().trim()).equals(this.m_ui.getAddress())) {
                    this.m_ui.setAddress(string);
                    this.m_bDatabaseModified = true;
                }
                if (this.m_bPortVisible) {
                    string = this.jTextFieldPort.getText().trim();
                    n = this.m_ui.getTelnetPort();
                    if (string.length() == 0) {
                        if (n != 0) {
                            this.m_ui.setTelnetPort(0);
                        }
                    } else {
                        int n2 = Integer.parseInt(string);
                        if (n2 != n) {
                            this.m_ui.setTelnetPort(n2);
                        }
                    }
                }
                int n3 = this.m_ui.getUseDefaultTelnet();
                n = this.jCheckBoxUseDefault.isSelected();
                if (n != n3) {
                    this.m_ui.setUseDefaultTelnet(n != 0);
                }
                if (!this.jCheckBoxUseDefault.isSelected()) {
                    TelnetInfo telnetInfo = this.jptwTelnetInfo.getInfo();
                    boolean bl2 = this.m_ui.getUseBuiltinTelnet();
                    if (telnetInfo.m_bUseBuiltin != bl2) {
                        this.m_ui.setUseBuiltinTelnet(telnetInfo.m_bUseBuiltin);
                    }
                    if (telnetInfo.m_bUseBuiltin) {
                        boolean bl3 = this.m_ui.getTelnetLoginWindow();
                        if (telnetInfo.m_bLoginWindow != bl3) {
                            this.m_ui.setTelnetLoginWindow(telnetInfo.m_bLoginWindow);
                        }
                    } else {
                        boolean bl4;
                        boolean bl5;
                        String string2;
                        String string3 = this.m_ui.getTelnetApplicationPath();
                        if (!StringUtilities.stringsEqual((String)telnetInfo.m_szTelnetPath, (String)string3)) {
                            this.m_ui.setTelnetApplicationPath(telnetInfo.m_szTelnetPath);
                        }
                        if (!StringUtilities.stringsEqual((String)telnetInfo.m_szCommandLine, (String)(string2 = this.m_ui.getTelnetCommandLineArgs()))) {
                            this.m_ui.setTelnetCommandLineArgs(telnetInfo.m_szCommandLine);
                        }
                        if ((bl5 = telnetInfo.m_bCommandWindow) != (bl4 = this.m_ui.getTelnetLaunchCommandWindow())) {
                            this.m_ui.setTelnetLaunchCommandWindow(telnetInfo.m_bCommandWindow);
                        }
                    }
                }
                this.fireDbaseModifyEvent();
                this.m_bChangesPending = false;
            }
            bl = true;
        }
        catch (Exception exception) {
            Trace.logError((String)"JPanelPropertiesTelnetTab:onOk", (String)"Failed to write the changes", (Throwable)exception);
            String string = res.getString("JPanelPropertiesTelnetTab_Not_all_properties102");
            Message.show((Component)this, (String)string);
        }
        return bl;
    }

    public void onDestroy() {
    }

    public boolean onApply() {
        return this.applyChanges();
    }

    public void onHelp() {
        ResourceBundle resourceBundle = null;
        try {
            Trace.logInfo((String)"Help", (String)"Loading Help.properties resource bundle");
            resourceBundle = ResourceBundle.getBundle("com.avocent.avworks.explorer.Help");
            Trace.logInfo((String)"Help", (String)"Successfully loaoded Help.properties");
        }
        catch (Exception exception) {
            Trace.logError((String)"Help", (String)"FAILED TO LOAD com.avocent.avworks.explorer.Help");
        }
        BrowserHelper.showHelpPage((JFrame)((JFrame)this.m_jdps.getOwner()), (String)resourceBundle.getString("IDH_VIEW_PROPERTIES_TELNET_TAB_APPLIANCE"));
    }

    public boolean isPageValid() {
        boolean bl = true;
        if (this.m_bPortVisible) {
            try {
                int n;
                String string = this.jTextFieldPort.getText().trim();
                if (string.length() > 0 && ((n = Integer.parseInt(string)) < 23 || n > 65535)) {
                    throw new NumberFormatException("< 23 || > 65535");
                }
            }
            catch (NumberFormatException numberFormatException) {
                String string = res.getString("JPanelPropertiesTelnetTab_Telnet_Port_Invalid");
                Message.show((Component)this, (String)string);
                this.jTextFieldPort.requestFocus();
                bl = false;
            }
        }
        if (!this.m_ui.isAppliance()) {
            bl &= this.validateAddress();
        }
        if (!this.jCheckBoxUseDefault.isSelected()) {
            bl &= this.jptwTelnetInfo.isDataValid();
        }
        return bl;
    }

    public String getTitle() {
        return res.getString("JPanelPropertiesTelnetTab_Telnet");
    }

    public String getTooltip() {
        return res.getString("JPanelPropertiesTelnetTab_Telnet_Tip");
    }

    public ImageIcon getIcon() {
        return null;
    }

    void jCheckBoxUseDefault_itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent != null && itemEvent.getItemSelectable() == this.jCheckBoxUseDefault) {
            this.jptwTelnetInfo.setEnabled(itemEvent.getStateChange() != 1);
            this.m_bChangesPending = true;
            this.m_jdps.setApplyButtonEnabled(true);
        }
    }

    void jptwTelnetInfo_stateChanged(ChangeEvent changeEvent) {
        this.m_bChangesPending = true;
        this.m_jdps.setApplyButtonEnabled(true);
    }

    private boolean validateAddress() {
        String string = this.jTextFieldAddress.getText().trim();
        if (string.equalsIgnoreCase(this.m_ui.getAddress())) {
            return true;
        }
        return this.jTextFieldAddress.isDataValid();
    }

    private void fireDbaseModifyEvent() {
        String string = "DBASE Modified Event Sent For Unit " + this.m_ui.getName();
        if (this.m_bDatabaseModified) {
            AVWorksEventBroadcaster.fireApplianceOrServerModifiedEvent((UnitInfo)this.m_ui);
            this.m_jdps.putValue((Object)string, (Object)this.m_ui);
            this.m_bDatabaseModified = false;
        }
    }
}

