/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.explorer;

import com.avocent.avworks.explorer.TelnetInfo;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.gui.components.JTextFieldAvocent;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.gui.propsheet.JDialogPropertySheet;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class JPanelTelnetWidget
extends JPanel {
    public static final String CNAME = "JPanelTelnetWidget";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.explorer.Res");
    private static int TEXT_FIELD_SIZE = 32;
    private static final char ARROW_DOWN = '\u25bc';
    private static final char ARROW_UP = '\u25b2';
    private boolean bInMacroButtonClick;
    private boolean bButtonUnsetPending;
    ButtonGroup bgLaunchButtons;
    JRadioButton jRadioBuiltin;
    JRadioButton jRadioUser;
    JPanel jPanelCommandLine = new JPanel();
    JCheckBox jCheckBoxLoginWindow;
    JTextFieldAvocent jTextFieldTelnet = new JTextFieldAvocent();
    JButton jButtonBrowse = new JButton();
    JLabel jLabelCommandLine = new JLabel();
    JTextFieldAvocent jTextFieldCommandLine = new JTextFieldAvocent();
    JToggleButton jButtonMacros = new JToggleButton();
    JPopupMenu jPopupMacroValues = new JPopupMenu();
    JCheckBox jCheckBoxCommandWindow;
    GridBagLayout gridBagLayout0 = new GridBagLayout();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    private Map m_mapMacros = new Hashtable();
    private String m_szMacroLabel;
    private DocumentListener m_docListener = new DocumentListener(){

        public void changedUpdate(DocumentEvent documentEvent) {
            JPanelTelnetWidget.this.fireStateChanged();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            JPanelTelnetWidget.this.fireStateChanged();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            JPanelTelnetWidget.this.fireStateChanged();
        }
    };
    private ChangeListener m_listener;
    JDialogPropertySheet m_jdps = null;

    public JPanelTelnetWidget() {
        Trace.logInfo((String)"JPanelTelnetWidget.constructor", (String)"entered");
        this.initializeMacroPopup();
        this.jbInit();
        Trace.logInfo((String)"JPanelTelnetWidget.constructor", (String)"exited");
    }

    public void setPropertySheet(JDialogPropertySheet jDialogPropertySheet) {
        this.m_jdps = jDialogPropertySheet;
    }

    private void initializeMacroPopup() {
        this.jPopupMacroValues.add(this.makeMenuAction("JPanelTelnetWidget_Address", "%I"));
        this.jPopupMacroValues.add(this.makeMenuAction("JPanelTelnetWidget_Port", "%P"));
        this.jPopupMacroValues.add(this.makeMenuAction("JPanelTelnetWidget_Username", "%U"));
        this.jPopupMacroValues.add(this.makeMenuAction("JPanelTelnetWidget_Password", "%W"));
        this.jPopupMacroValues.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                if (JPanelTelnetWidget.this.bInMacroButtonClick) {
                    JPanelTelnetWidget.this.bButtonUnsetPending = true;
                } else {
                    JPanelTelnetWidget.this.jButtonMacros.setSelected(false);
                }
            }

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    private JMenuItem makeMenuAction(String string, String string2) {
        String string3 = res.getString(string);
        this.m_mapMacros.put(string3, string2);
        JMenuItem jMenuItem = new JMenuItem(string3);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPanelTelnetWidget.this.jPopupMacroValues_actionPerformed(actionEvent);
            }
        });
        return jMenuItem;
    }

    private void jbInit() {
        Trace.logInfo((String)"JPanelOptionsGeneral.jbInit", (String)"entered");
        this.jRadioBuiltin = new JRadioButton(res.getString("JPanelTelnetWidget_Built_In_Telnet"), true);
        this.jRadioBuiltin.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JPanelTelnetWidget.this.jRadioBuiltin_itemStateChanged(itemEvent);
            }
        });
        this.jRadioUser = new JRadioButton(res.getString("JPanelTelnetWidget_User_Telnet"), false);
        this.bgLaunchButtons = new ButtonGroup();
        this.bgLaunchButtons.add(this.jRadioBuiltin);
        this.bgLaunchButtons.add(this.jRadioUser);
        this.jCheckBoxLoginWindow = new JCheckBox(res.getString("JPanelTelnetWidget_Open_window_before_login"), false);
        this.jCheckBoxLoginWindow.setAlignmentX(0.0f);
        this.jCheckBoxLoginWindow.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JPanelTelnetWidget.this.fireStateChanged();
            }
        });
        this.jTextFieldTelnet.setText("");
        this.jTextFieldTelnet.setHorizontalAlignment(2);
        this.jTextFieldTelnet.setEditable(false);
        this.jTextFieldTelnet.setEnabled(false);
        this.jTextFieldTelnet.setColumns(TEXT_FIELD_SIZE);
        this.jTextFieldTelnet.getDocument().addDocumentListener(this.m_docListener);
        this.jButtonBrowse.setMnemonic(res.getString("JPanelTelnetWidget_single_char_2").charAt(0));
        this.jButtonBrowse.setText(res.getString("JPanelTelnetWidget_Browser_"));
        this.jButtonBrowse.setEnabled(false);
        this.jButtonBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPanelTelnetWidget.this.jButtonBrowse_actionPerformed(actionEvent);
            }
        });
        this.jLabelCommandLine.setText(res.getString("JPanelTelnetWidget_Command_Line_Args"));
        this.jLabelCommandLine.setEnabled(false);
        this.jTextFieldCommandLine.setText("");
        this.jTextFieldCommandLine.setHorizontalAlignment(2);
        this.jTextFieldCommandLine.setEditable(false);
        this.jTextFieldCommandLine.setEnabled(false);
        this.jTextFieldCommandLine.setColumns(TEXT_FIELD_SIZE);
        this.jTextFieldCommandLine.getDocument().addDocumentListener(this.m_docListener);
        this.jButtonMacros.setText(res.getString("JPanelTelnetWidget_Command_Line_Macros") + '\u25bc');
        this.jButtonMacros.setEnabled(false);
        this.jButtonMacros.addMouseListener(new MouseInputAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                JPanelTelnetWidget.this.bInMacroButtonClick = true;
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                JPanelTelnetWidget.this.bInMacroButtonClick = false;
                if (JPanelTelnetWidget.this.bButtonUnsetPending) {
                    JPanelTelnetWidget.this.jButtonMacros.setSelected(false);
                    JPanelTelnetWidget.this.bButtonUnsetPending = false;
                }
            }
        });
        this.jButtonMacros.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    JPanelTelnetWidget.this.jButtonMacros.setText(res.getString("JPanelTelnetWidget_Command_Line_Macros") + '\u25b2');
                    JPanelTelnetWidget.this.jPopupMacroValues.show(JPanelTelnetWidget.this.jPanelCommandLine, JPanelTelnetWidget.this.jButtonMacros.getX(), JPanelTelnetWidget.this.jButtonMacros.getY() + JPanelTelnetWidget.this.jButtonMacros.getHeight());
                } else {
                    JPanelTelnetWidget.this.jButtonMacros.setText(res.getString("JPanelTelnetWidget_Command_Line_Macros") + '\u25bc');
                }
            }
        });
        this.jButtonMacros.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                if (!JPanelTelnetWidget.this.bInMacroButtonClick) {
                    focusEvent.getOppositeComponent().requestFocusInWindow();
                }
            }
        });
        this.jCheckBoxCommandWindow = new JCheckBox(res.getString("JPanelTelnetWidget_Telnet_In_Window"));
        this.jCheckBoxCommandWindow.setAlignmentX(0.0f);
        this.jCheckBoxCommandWindow.setEnabled(false);
        this.jCheckBoxCommandWindow.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JPanelTelnetWidget.this.fireStateChanged();
            }
        });
        this.jPanelCommandLine.setLayout(this.gridBagLayout1);
        this.jPanelCommandLine.add((Component)this.jTextFieldTelnet, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 4, 6, 5), 0, 0));
        this.jPanelCommandLine.add((Component)this.jButtonBrowse, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 6, 5), 0, 0));
        this.jPanelCommandLine.add((Component)this.jLabelCommandLine, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 4, 6, 5), 0, 0));
        this.jPanelCommandLine.add((Component)this.jTextFieldCommandLine, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 4, 6, 5), 0, 0));
        this.jPanelCommandLine.add((Component)this.jButtonMacros, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 6, 5), 0, 0));
        this.jPanelCommandLine.add((Component)this.jCheckBoxCommandWindow, new GridBagConstraints(0, 3, 2, 1, 0.0, 1.0, 18, 2, new Insets(5, 0, 6, 0), 0, 0));
        this.setLayout(this.gridBagLayout0);
        this.add((Component)this.jRadioBuiltin, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 13, 11, 0), 0, 0));
        this.add((Component)this.jCheckBoxLoginWindow, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 30, 11, 0), 0, 0));
        this.add((Component)this.jRadioUser, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 13, 11, 0), 0, 0));
        this.add((Component)this.jPanelCommandLine, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 30, 0, 0), 0, 0));
    }

    public TelnetInfo getInfo() {
        if (this.jRadioBuiltin.isSelected()) {
            return new TelnetInfo(this.jCheckBoxLoginWindow.isSelected());
        }
        String string = this.jTextFieldTelnet.getText().trim();
        String string2 = this.jTextFieldCommandLine.getText().trim();
        return new TelnetInfo(string, string2, this.jCheckBoxCommandWindow.isSelected());
    }

    public void setInfo(TelnetInfo telnetInfo) {
        if (telnetInfo.m_bUseBuiltin) {
            this.jRadioBuiltin.setSelected(true);
        } else {
            this.jRadioUser.setSelected(true);
        }
        this.jCheckBoxLoginWindow.setSelected(telnetInfo.m_bLoginWindow);
        this.jTextFieldTelnet.setText(telnetInfo.m_szTelnetPath);
        this.jTextFieldCommandLine.setText(telnetInfo.m_szCommandLine);
        this.jCheckBoxCommandWindow.setSelected(telnetInfo.m_bCommandWindow);
    }

    public boolean isDataValid() {
        String string;
        if (!this.jRadioBuiltin.isSelected() && (string = this.jTextFieldTelnet.getText().trim()).length() == 0) {
            String string2 = res.getString("JPanelTelnetWidget_Telnet_App_Path_Invalid");
            Message.show((Component)this, (String)string2);
            this.jTextFieldTelnet.requestFocus();
            return false;
        }
        return true;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.m_listener = changeListener;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (changeListener == this.m_listener) {
            this.m_listener = null;
        }
    }

    public void setEnabled(boolean bl) {
        this.jRadioUser.setEnabled(bl);
        this.jRadioBuiltin.setEnabled(bl);
        this.jCheckBoxLoginWindow.setEnabled(bl && this.jRadioBuiltin.isSelected());
        boolean bl2 = bl && this.jRadioUser.isSelected();
        this.jTextFieldTelnet.setEnabled(bl2);
        this.jButtonBrowse.setEnabled(bl2);
        this.jLabelCommandLine.setEnabled(bl2);
        this.jTextFieldCommandLine.setEnabled(bl2);
        this.jButtonMacros.setEnabled(bl2);
        this.jCheckBoxCommandWindow.setEnabled(bl2);
    }

    private void jRadioBuiltin_itemStateChanged(ItemEvent itemEvent) {
        boolean bl = this.jRadioBuiltin.isSelected();
        this.jCheckBoxLoginWindow.setEnabled(bl);
        this.jTextFieldTelnet.setEnabled(!bl);
        this.jTextFieldTelnet.setEditable(!bl);
        this.jButtonBrowse.setEnabled(!bl);
        this.jLabelCommandLine.setEnabled(!bl);
        this.jTextFieldCommandLine.setEnabled(!bl);
        this.jTextFieldCommandLine.setEditable(!bl);
        this.jButtonMacros.setEnabled(!bl);
        this.jCheckBoxCommandWindow.setEnabled(!bl);
        this.fireStateChanged();
    }

    private void jButtonBrowse_actionPerformed(ActionEvent actionEvent) {
        Trace.logInfo((String)"JPanelTelnetWidget.jButtonBrowse_actionPerformed", (String)"entered");
        final JDialogPropertySheet jDialogPropertySheet = this.m_jdps;
        jDialogPropertySheet.setCursor(Cursor.getPredefinedCursor(3));
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    JFileChooser jFileChooser = new JFileChooser();
                    Dimension dimension = jFileChooser.getLayout().preferredLayoutSize(jFileChooser);
                    jFileChooser.setPreferredSize(dimension);
                    if (jDialogPropertySheet.isVisible()) {
                        int n = jFileChooser.showOpenDialog((Component)jDialogPropertySheet);
                        jDialogPropertySheet.setCursor(Cursor.getPredefinedCursor(0));
                        if (n == 0) {
                            File file = jFileChooser.getSelectedFile();
                            JPanelTelnetWidget.this.jTextFieldTelnet.setText(file.getAbsolutePath());
                        }
                    }
                }
                catch (Exception exception) {
                    Trace.logError((String)"JPanelOptionsGeneral", (String)exception.getMessage(), (Throwable)exception);
                    String string = res.getString("JPanelTelnetWidget_Could_not_Select");
                    Message.show((Component)jDialogPropertySheet, (String)string);
                }
                jDialogPropertySheet.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        thread.start();
    }

    private void jPopupMacroValues_actionPerformed(ActionEvent actionEvent) {
        Trace.logInfo((String)"JPanelTelnetWidget.jComboBoxMacros_itemStateChanged", (String)"entered");
        String string = actionEvent.getActionCommand();
        String string2 = (String)this.m_mapMacros.get(string);
        if (string2 != null) {
            Document document = this.jTextFieldCommandLine.getDocument();
            try {
                int n;
                String string3 = this.jTextFieldCommandLine.getSelectedText();
                if (string3 != null) {
                    n = this.jTextFieldCommandLine.getSelectionStart();
                    int n2 = this.jTextFieldCommandLine.getSelectionEnd();
                    document.remove(n, n2 - n);
                    this.jTextFieldCommandLine.setCaretPosition(n);
                }
                n = this.jTextFieldCommandLine.getCaretPosition();
                document.insertString(n, string2, null);
            }
            catch (BadLocationException badLocationException) {
                Trace.logError((String)"JPanelTelnetWidget.jComboBoxMacros_itemStateChanged", (String)badLocationException.getMessage(), (Throwable)badLocationException);
            }
        }
        this.jTextFieldCommandLine.requestFocusInWindow();
    }

    private void fireStateChanged() {
        if (this.m_listener != null) {
            this.m_listener.stateChanged(new ChangeEvent(this));
        }
    }
}

