/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.explorer;

import com.avocent.avworks.explorer.AbstractTableModelUnitList;
import com.avocent.avworks.services.UnitInfo;
import com.avocent.avworks.services.UnitsDb;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class UnitListFilter {
    public static final String CNAME = "UnitListFilter";
    public static UnitListFilter DEFAULT = UnitListFilter.getDefaultFilter();
    public static UnitListFilter NONE = UnitListFilter.getEmptyFilter();
    private static Comparator folderComp = new AbstractTableModelUnitList.InternalComparator();

    public abstract boolean include(UnitInfo var1);

    private static UnitListFilter getDefaultFilter() {
        return new UnitListFilter(){

            public String toString() {
                return "DefaultFilter";
            }

            public boolean include(UnitInfo unitInfo) {
                return true;
            }
        };
    }

    private static UnitListFilter getEmptyFilter() {
        return new UnitListFilter(){

            public String toString() {
                return "EmptyFilter";
            }

            public boolean include(UnitInfo unitInfo) {
                return false;
            }
        };
    }

    public static UnitListFilter getApplianceFilter() {
        return new UnitListFilter(){

            public String toString() {
                return "ApplianceFilter";
            }

            public boolean include(UnitInfo unitInfo) {
                return unitInfo.isAppliance();
            }
        };
    }

    public static UnitListFilter getServerFilter() {
        return new UnitListFilter(){

            public String toString() {
                return "ServerFilter";
            }

            public boolean include(UnitInfo unitInfo) {
                return !unitInfo.isAppliance();
            }
        };
    }

    public static UnitListFilter getUnitTypeFilter(final String string) {
        return new UnitListFilter(){

            public String toString() {
                return "UnitTypeFilter [" + string + "]";
            }

            public boolean include(UnitInfo unitInfo) {
                return string.equals(unitInfo.getType());
            }
        };
    }

    public static UnitListFilter getCustom1ValueFilter(final String string) {
        return new UnitListFilter(){

            public String toString() {
                return "CustomField1Filter [" + string + "]";
            }

            public boolean include(UnitInfo unitInfo) {
                return string.equals(unitInfo.getCustomField1());
            }
        };
    }

    public static UnitListFilter getCustom2ValueFilter(final String string, final String string2) {
        return new UnitListFilter(){

            public String toString() {
                return "CustomField2Filter [" + string + ":" + string2 + "]";
            }

            public boolean include(UnitInfo unitInfo) {
                return string.equals(unitInfo.getCustomField1()) && string2.equals(unitInfo.getCustomField2());
            }
        };
    }

    public static UnitListFilter getFolderFilter(String string) {
        try {
            final List<UnitInfo> list = Arrays.asList(UnitsDb.getUnitsInFolder((String)string));
            Collections.sort(list, folderComp);
            return new UnitListFilter(){

                public boolean include(UnitInfo unitInfo) {
                    return Collections.binarySearch(list, unitInfo, folderComp) >= 0;
                }
            };
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)CNAME, (String)("Unable to determine which units are in folder \"" + string + "\""), (Throwable)exceptionRequestFailed);
            return NONE;
        }
    }

    public static UnitListFilter getSubstringFilter(final String string) {
        return new UnitListFilter(){

            public String toString() {
                return "SubstringFilter [" + string + "]";
            }

            private boolean matchString(String string2) {
                return string2 != null && string2.length() > 0 && string2.indexOf(string) >= 0;
            }

            public boolean include(UnitInfo unitInfo) {
                return this.matchString(unitInfo.getName()) || this.matchString(unitInfo.getType()) || unitInfo.isAppliance() && this.matchString(unitInfo.getAddress()) || this.matchString(unitInfo.getCustomField1()) || this.matchString(unitInfo.getCustomField2()) || this.matchString(unitInfo.getCustomField3()) || this.matchString(unitInfo.getContact()) || this.matchString(unitInfo.getComment());
            }
        };
    }

    public static UnitListFilter getSearchFilter(String string) {
        if (string == null || string.trim().length() == 0) {
            return DEFAULT;
        }
        String string2 = string.startsWith("^") ? "" : "^.*";
        String string3 = string.endsWith("$") ? "" : ".*$";
        try {
            final Pattern pattern = Pattern.compile(string2 + string + string3, 66);
            return new UnitListFilter(){

                public String toString() {
                    return "SearchFilter [" + pattern + "]";
                }

                private boolean matchString(String string) {
                    return string != null && string.length() > 0 && pattern.matcher(string).matches();
                }

                public boolean include(UnitInfo unitInfo) {
                    return this.matchString(unitInfo.getName()) || this.matchString(unitInfo.getType()) || unitInfo.isAppliance() && this.matchString(unitInfo.getAddress()) || this.matchString(unitInfo.getCustomField1()) || this.matchString(unitInfo.getCustomField2()) || this.matchString(unitInfo.getCustomField3()) || this.matchString(unitInfo.getContact()) || this.matchString(unitInfo.getComment());
                }
            };
        }
        catch (PatternSyntaxException patternSyntaxException) {
            Trace.logError((String)CNAME, (String)("Invalid regular expression \"" + string + "\": falling" + " back to substring search"));
            return UnitListFilter.getSubstringFilter(string);
        }
    }
}

