/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.explorer;

import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.avworks.services.DatabaseSession;
import com.avocent.avworks.services.InterfaceInfo;
import com.avocent.avworks.services.InterfacesDb;
import com.avocent.avworks.services.OptionsDb;
import com.avocent.avworks.services.ServerPropertiesDb;
import com.avocent.lib.database.DBaseRequestQueryResults;
import com.avocent.lib.database.SqlCmd;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.util.StringUtilities;
import java.util.Hashtable;

public class UpgradeDb {
    public static String TRACE_CONTEXT = "UpgradeDb";
    static final Hashtable eng_MAPPING = new Hashtable();
    public static final int KEY_MAKE = 0;
    public static final int KEY_BREAK = 1;
    public static final int KEY_BOTH = 2;
    public static final int USBKEY_NUMPAD_MINUS = 86;
    public static final int USBKEY_NUMPAD_PLUS = 87;
    public static final int USBKEY_SUN_POWER_SLEEP = 102;
    public static final int USBKEY_SUN_EXECUTE = 116;
    public static final int USBKEY_SUN_HELP = 117;
    public static final int USBKEY_SUN_MENU = 118;
    public static final int USBKEY_SUN_FRONT = 119;
    public static final int USBKEY_SUN_STOP = 120;
    public static final int USBKEY_SUN_AGAIN = 121;
    public static final int USBKEY_SUN_UNDO = 122;
    public static final int USBKEY_SUN_CUT = 123;
    public static final int USBKEY_SUN_COPY = 124;
    public static final int USBKEY_SUN_PASTE = 125;
    public static final int USBKEY_SUN_FIND = 126;
    public static final int USBKEY_SUN_MUTE = 127;
    public static final int USBKEY_SUN_VOL_PLUS = 128;
    public static final int USBKEY_SUN_VOL_MINUS = 129;
    public static final int USBKEY_HENKEN = 138;
    public static final int USBKEY_MUHENKAN = 139;
    public static final int USBKEY_HANZEN = 135;
    public static final int USBKEY_YEN = 137;
    public static final int USBKEY_SUN_META = 227;
    public static final int USBKEY_WINDOWS_START_MENU = 227;
    public static final int USBKEY_WINDOWS_APP_MENU = 101;
    public static final int USBKEY_ALT_RIGHT = 230;
    public static final int USBKEY_ALT_LEFT = 226;
    public static final int USBKEY_CTRL_RIGHT = 228;
    public static final int USBKEY_CTRL_LEFT = 224;
    public static final int USBKEY_SHIFT_RIGHT = 229;
    public static final int USBKEY_SHIFT_LEFT = 225;
    public static final int VK_SUN_FRONT = 414852;
    public static final int VK_SUN_OPEN_EXECUTE = 414854;
    public static final int VK_SUN_MUTE = 414864;
    public static final int VK_SUN_POWER_SLEEP = 414865;
    public static final int VK_SUN_VOL_PLUS = 414866;
    public static final int VK_SUN_VOL_MINUS = 414867;
    public static final int VK_SUN_HELP = 414868;
    public static final int VK_HENKEN = 417792;
    public static final int VK_MUHENKAN = 417793;
    public static final int VK_HANZEN = 417794;
    public static final int VK_YEN = 417795;
    public static final int VK_WINDOWS_START_MENU = 417796;
    public static final int VK_WINDOWS_APP_MENU = 417797;
    public static final int VK_ALT_LEFT = 417798;
    public static final int VK_ALT_RIGHT = 417799;
    public static final int VK_CTRL_LEFT = 417800;
    public static final int VK_CTRL_RIGHT = 417801;
    public static final int VK_SHIFT_LEFT = 417802;
    public static final int VK_SHIFT_RIGHT = 417803;
    public static final int VK_KEYPAD_PLUS = 417806;
    public static final int VK_KEYPAD_MINUS = 417807;

    public static void upgrade() throws ExceptionRequestFailed {
        String string = UpgradeDb.getDatabaseVersion();
        if (string.equals("1.0")) {
            UpgradeDb.upgradeToSystemTestOne();
            string = "System Test 1";
        }
        if (string.equals("System Test 1")) {
            UpgradeDb.upgradeToVersionOneDotZero();
            string = "Version 1.0";
        }
        if (string.equals("Version 1.0")) {
            UpgradeDb.upgradeToVersionOneDotOne();
            string = "Version 1.1";
        }
        if (string.equals("Version 1.1")) {
            UpgradeDb.upgradeToVersionOneDotThree();
            string = "Version 1.3";
        }
        if (string.equals("Version 1.3")) {
            UpgradeDb.upgradeToVersionOneDotFour();
            string = "Version 1.4";
        }
        if (string.equals("Version 1.4")) {
            UpgradeDb.upgradeToVersionOneDotFive();
            string = "Version 1.5";
        }
    }

    private static void upgradeToSystemTestOne() throws ExceptionRequestFailed {
        Trace.logInfo((String)"UpgradeDb:upgradeToSystemTestOne", (String)"Upgrading to DATABASE VERSION=System Test 1");
        String string = "AVR1000";
        String string2 = "DSR1000";
        Trace.logInfo((String)"UpgradeDb:upgradeToSystemTestOne", (String)"Upgrading APPLIANCES table");
        String string3 = "UPDATE APPLIANCES SET TYPE = " + SqlCmd.quote((String)string) + " " + "WHERE TYPE = " + SqlCmd.quote((String)string2) + ";";
        int n = DatabaseSession.executeUpdate((String)string3);
        string = "AVR2000";
        string2 = "DSR2000";
        string3 = "UPDATE APPLIANCES SET TYPE = " + SqlCmd.quote((String)string) + " " + "WHERE TYPE = " + SqlCmd.quote((String)string2) + ";";
        n += DatabaseSession.executeUpdate((String)string3);
        string = "AVR4000";
        string2 = "DSR4000";
        string3 = "UPDATE APPLIANCES SET TYPE = " + SqlCmd.quote((String)string) + " " + "WHERE TYPE = " + SqlCmd.quote((String)string2) + ";";
        Trace.logInfo((String)"UpgradeDb:upgradeToSystemTestOne", (String)("Total records updated in APPLIANCES table=" + (n += DatabaseSession.executeUpdate((String)string3))));
        Trace.logInfo((String)"UpgradeDb:upgradeToSystemTestOne", (String)"Upgrading PRODUCTS table");
        String string4 = "";
        String string5 = "";
        try {
            string4 = StringUtilities.toTwoByteAsciiHex((String)"AVR1000");
            string5 = StringUtilities.toTwoByteAsciiHex((String)"DSR1000");
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            // empty catch block
        }
        string3 = "UPDATE PRODUCTS SET NAME = " + SqlCmd.quote((String)string4) + " " + "WHERE NAME = " + SqlCmd.quote((String)string5) + ";";
        n = DatabaseSession.executeUpdate((String)string3);
        try {
            string4 = StringUtilities.toTwoByteAsciiHex((String)"AVR2000");
            string5 = StringUtilities.toTwoByteAsciiHex((String)"DSR2000");
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            // empty catch block
        }
        string3 = "UPDATE PRODUCTS SET NAME = " + SqlCmd.quote((String)string4) + " " + "WHERE NAME = " + SqlCmd.quote((String)string5) + ";";
        n += DatabaseSession.executeUpdate((String)string3);
        try {
            string4 = StringUtilities.toTwoByteAsciiHex((String)"AVR4000");
            string5 = StringUtilities.toTwoByteAsciiHex((String)"DSR4000");
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            // empty catch block
        }
        string3 = "UPDATE PRODUCTS SET NAME = " + SqlCmd.quote((String)string4) + " " + "WHERE NAME = " + SqlCmd.quote((String)string5) + ";";
        Trace.logInfo((String)"UpgradeDb:upgradeToSystemTestOne", (String)("Total records updated in PRODUCTS table=" + (n += DatabaseSession.executeUpdate((String)string3))));
        Trace.logInfo((String)"UpgradeDb:upgradeToSystemTestOne", (String)"Upgrading DBASEVERSION table");
        DatabaseSession.setDatabaseVersion((String)"System Test 1");
        Trace.logInfo((String)"UpgradeDb:upgradeToSystemTestOne", (String)"Successfully upgraded the DATABASE to VERSION=System Test 1");
    }

    private static void upgradeToVersionOneDotZero() throws ExceptionRequestFailed {
        Trace.logInfo((String)"UpgradeDb:upgradeToVersionOneDotZero", (String)"Upgrading to DATABASE VERSION=Version 1.0");
        String string = "A1000R";
        String string2 = "AVR1000";
        Trace.logInfo((String)"UpgradeDb:upgradeToVersionOneDotZero", (String)"Upgrading APPLIANCES table");
        String string3 = "UPDATE APPLIANCES SET TYPE = " + SqlCmd.quote((String)string) + " " + "WHERE TYPE = " + SqlCmd.quote((String)string2) + ";";
        int n = DatabaseSession.executeUpdate((String)string3);
        string = "A2000R";
        string2 = "AVR2000";
        string3 = "UPDATE APPLIANCES SET TYPE = " + SqlCmd.quote((String)string) + " " + "WHERE TYPE = " + SqlCmd.quote((String)string2) + ";";
        n += DatabaseSession.executeUpdate((String)string3);
        string = "A4000R";
        string2 = "AVR4000";
        string3 = "UPDATE APPLIANCES SET TYPE = " + SqlCmd.quote((String)string) + " " + "WHERE TYPE = " + SqlCmd.quote((String)string2) + ";";
        Trace.logInfo((String)"UpgradeDb:upgradeToVersionOneDotZero", (String)("Total records updated in APPLIANCES table=" + (n += DatabaseSession.executeUpdate((String)string3))));
        Trace.logInfo((String)"UpgradeDb:upgradeToVersionOneDotZero", (String)"Upgrading PRODUCTS table");
        String string4 = "";
        String string5 = "";
        try {
            string4 = StringUtilities.toTwoByteAsciiHex((String)"A1000R");
            string5 = StringUtilities.toTwoByteAsciiHex((String)"AVR1000");
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            // empty catch block
        }
        string3 = "UPDATE PRODUCTS SET NAME = " + SqlCmd.quote((String)string4) + " " + "WHERE NAME = " + SqlCmd.quote((String)string5) + ";";
        n = DatabaseSession.executeUpdate((String)string3);
        try {
            string4 = StringUtilities.toTwoByteAsciiHex((String)"A2000R");
            string5 = StringUtilities.toTwoByteAsciiHex((String)"AVR2000");
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            // empty catch block
        }
        string3 = "UPDATE PRODUCTS SET NAME = " + SqlCmd.quote((String)string4) + " " + "WHERE NAME = " + SqlCmd.quote((String)string5) + ";";
        n += DatabaseSession.executeUpdate((String)string3);
        try {
            string4 = StringUtilities.toTwoByteAsciiHex((String)"A4000R");
            string5 = StringUtilities.toTwoByteAsciiHex((String)"AVR4000");
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            // empty catch block
        }
        string3 = "UPDATE PRODUCTS SET NAME = " + SqlCmd.quote((String)string4) + " " + "WHERE NAME = " + SqlCmd.quote((String)string5) + ";";
        Trace.logInfo((String)"UpgradeDb:upgradeToVersionOneDotZero", (String)("Total records updated in PRODUCTS table=" + (n += DatabaseSession.executeUpdate((String)string3))));
        Trace.logInfo((String)"UpgradeDb:upgradeToVersionOneDotZero", (String)"Upgrading DBASEVERSION table");
        DatabaseSession.setDatabaseVersion((String)"Version 1.0");
        Trace.logInfo((String)"UpgradeDb:upgradeToVersionOneDotZero", (String)"Successfully upgraded the DATABASE to VERSION=Version 1.0");
    }

    private static void upgradeToVersionOneDotOne() throws ExceptionRequestFailed {
        Object object;
        Trace.logInfo((String)"UpgradeDb:upgradeToVersionOneDotOne", (String)"Upgrading to DATABASE VERSION=Version 1.1");
        InterfaceInfo[] interfaceInfoArray = null;
        String string = null;
        int n = 0;
        try {
            interfaceInfoArray = InterfacesDb.getInterfaceInfoList(null);
            n = interfaceInfoArray.length;
        }
        catch (ExceptionNoValue exceptionNoValue) {
            // empty catch block
        }
        if (n > 0) {
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                object = interfaceInfoArray[i];
                nArray[i] = object.getID();
            }
            InterfacesDb.delete((int[])nArray);
        }
        try {
            string = "DROP TABLE INTERFACES;";
            DatabaseSession.executeUpdate((String)string);
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)"UpgradeDb", (String)"Failed to delete INTERFACES table");
            return;
        }
        InterfacesDb.createInterfacesTable();
        for (int i = 0; i < n; ++i) {
            InterfaceInfo interfaceInfo = interfaceInfoArray[i];
            object = interfaceInfo.getName();
            String string2 = "CH";
            int n2 = 0;
            boolean bl = ((String)object).startsWith(string2);
            if (bl) {
                int n3 = interfaceInfo.getPortNum();
                String string3 = ((String)object).substring(string2.length());
                n2 = Integer.parseInt(string3);
                interfaceInfo.setPortNum(n2);
            }
            InterfacesDb.add((InterfaceInfo)interfaceInfo);
        }
        DatabaseSession.setDatabaseVersion((String)"Version 1.1");
        Trace.logInfo((String)"UpgradeDb:upgradeToVersionOneDotOne", (String)"Successfully upgraded the DATABASE to VERSION=Version 1.1");
    }

    private static void upgradeToVersionOneDotThree() throws ExceptionRequestFailed {
        Trace.logInfo((String)"UpgradeDb:upgradeToVersionOneDotThree", (String)"Upgrading to DATABASE VERSION=Version 1.3");
        String string = "AVR NMM";
        String string2 = "avctAVWorksAvrNmm.jar";
        String string3 = "com.avocent.avworks.nmm.avr.AvrNmmInterface";
        String string4 = "10";
        String string5 = "UPDATE NMM SET NAME = " + SqlCmd.quote((String)string) + "," + "JAR = " + SqlCmd.quote((String)string2) + "," + "CLASS = " + SqlCmd.quote((String)string3) + "," + "PRIORITY = " + SqlCmd.quote((String)string4) + " " + "WHERE ID = 1;";
        int n = DatabaseSession.executeUpdate((String)string5);
        DatabaseSession.setDatabaseVersion((String)"Version 1.3");
        Trace.logInfo((String)"UpgradeDb:upgradeToVersionOneDotThree", (String)"Successfully upgraded the DATABASE to VERSION=Version 1.3");
    }

    private static void upgradeToVersionOneDotFour() throws ExceptionRequestFailed {
        Trace.logInfo((String)"UpgradeDb:upgradeToVersionOneDotThree", (String)"Upgrading to DATABASE VERSION=Version 1.3");
        DatabaseSession.setDatabaseVersion((String)"Version 1.4");
        Trace.logInfo((String)"UpgradeDb:upgradeToVersionOneDotThree", (String)"Successfully upgraded the DATABASE to VERSION=Version 1.4");
    }

    private static void upgradeToVersionOneDotFive() throws ExceptionRequestFailed {
        String string;
        Trace.logInfo((String)"UpgradeDb:upgradeToVersionOneDotFive", (String)"Upgrading to DATABASE VERSION=Version 1.5");
        try {
            string = "UPDATE SERVERS SET APP_INDEX = (-1);";
            DatabaseSession.executeUpdate((String)string);
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)"UpgradeDb", (String)"Failed to Update the servers table");
            return;
        }
        try {
            string = "insert into GLOBAL_OPTIONS(KEY, VALUE) select KEY, VALUE from OPTIONS;";
            DatabaseSession.executeUpdate((String)string);
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)"UpgradeDb", (String)"Failed to populate the global_options table");
            return;
        }
        try {
            string = "DROP TABLE OPTIONS;";
            DatabaseSession.executeUpdate((String)string);
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)"UpgradeDb", (String)"Failed to delete OPTIONS table");
            return;
        }
        if (!AVWorksBranding.isVideoViewerMacroEditorEnabled()) {
            string = "DELETE FROM GLOBAL_OPTIONS WHERE KEY LIKE 'MACRO_%' OR KEY LIKE 'MACRONAMES%' OR KEY LIKE 'MACROGROUP_%' OR KEY LIKE 'MACROGROUPNAME%'";
            DatabaseSession.executeUpdate((String)string);
            OptionsDb.setValue((String)"MacrosPreviouslySaved", (int)0);
            String string2 = "UPDATE SERVER_PROPERTIES SET VALUE='DEFAULTMACROGROUP' WHERE KEY LIKE 'SelectedMacroGroupName'";
            DatabaseSession.executeQuery((String)string2);
        } else {
            String string3;
            String string4;
            String string5;
            int n;
            DBaseRequestQueryResults dBaseRequestQueryResults;
            int n2;
            string = "SELECT * FROM GLOBAL_OPTIONS;";
            int n3 = DatabaseSession.executeQuery((String)string);
            while ((n2 = (dBaseRequestQueryResults = DatabaseSession.getQueryResults((int)n3, (int)10)).getRowCount()) != 0) {
                for (n = 1; n <= n2; ++n) {
                    dBaseRequestQueryResults.nextRow();
                    String string6 = dBaseRequestQueryResults.getString("KEY");
                    string5 = dBaseRequestQueryResults.getString("VALUE");
                    if (string6.startsWith("MACRO_")) {
                        if ((string5 = UpgradeDb.ConvertMacroOneFive(string6, string5)) == null) continue;
                        OptionsDb.setValue((String)string6, (String)string5);
                        continue;
                    }
                    if (string6.startsWith("MACROGROUP_")) {
                        string4 = UpgradeDb.ConvertMacroGroupKey(string6);
                        string3 = UpgradeDb.ConvertMacroGroupValue(string6, string5);
                        OptionsDb.removeValue((String)string6);
                        OptionsDb.setValue((String)string4, (String)string3);
                        continue;
                    }
                    if (string6.startsWith("MACROGROUPNAMES") || string6.startsWith("MACRONAMES")) {
                        OptionsDb.removeValue((String)string6);
                        continue;
                    }
                    if (!string6.startsWith("MacrosPreviouslySaved")) continue;
                    OptionsDb.setValue((String)string6, (int)1);
                }
                if (dBaseRequestQueryResults.getRowCount() >= 10) continue;
            }
            string = "SELECT * FROM SERVER_PROPERTIES;";
            n3 = DatabaseSession.executeQuery((String)string);
            while ((n2 = (dBaseRequestQueryResults = DatabaseSession.getQueryResults((int)n3, (int)10)).getRowCount()) != 0) {
                for (n = 1; n <= n2; ++n) {
                    dBaseRequestQueryResults.nextRow();
                    int n4 = dBaseRequestQueryResults.getInt("SERVER_ID");
                    string5 = dBaseRequestQueryResults.getString("KEY");
                    string4 = dBaseRequestQueryResults.getString("VALUE");
                    if (!string5.startsWith("SelectedMacroGroupName")) continue;
                    string3 = "GROUP_" + string4;
                    ServerPropertiesDb.removeValue((int)n4, (String)string5);
                    ServerPropertiesDb.setValue((int)n4, (String)"DEFAULTMACROGROUP", (String)string3);
                }
                if (dBaseRequestQueryResults.getRowCount() >= 10) continue;
            }
            DatabaseSession.closeQuery((int)n3);
        }
        DatabaseSession.setDatabaseVersion((String)"Version 1.5");
        Trace.logInfo((String)"UpgradeDb:upgradeToVersionOneDotFive", (String)"Successfully upgraded the DATABASE to VERSION=Version 1.5");
    }

    public static String getDatabaseVersion() throws ExceptionRequestFailed {
        String string = "SELECT VERSION FROM DBASEVERSION;";
        Trace.logInfo((String)"UpgradeDb:getDatabaseVersion", (String)"Reading VERSION from DBASEVERSION table");
        int n = DatabaseSession.executeQuery((String)string);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults((int)n, (int)1);
        DatabaseSession.closeQuery((int)n);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            Trace.logError((String)"UpgradeDb:getDatabaseVersion", (String)"No value returned from DBASEVERSION table");
            throw new ExceptionRequestFailed();
        }
        dBaseRequestQueryResults.nextRow();
        String string2 = dBaseRequestQueryResults.getString(1);
        Trace.logInfo((String)"UpgradeDb:getDatabaseVersion", (String)("DATABASE VERSION=" + string2));
        return string2;
    }

    public static String ConvertMacroGroupKey(String string) {
        String string2 = "GROUP_" + string.replaceFirst("MACROGROUP_", "");
        return string2;
    }

    public static String ConvertMacroGroupValue(String string, String string2) {
        String string3 = string.replaceFirst("MACROGROUP_", "") + ",";
        String[] stringArray = string2.split("\t");
        for (int i = 0; i < stringArray.length; ++i) {
            string3 = string3 + "MACRO_" + stringArray[i] + ",";
        }
        string3 = string3.substring(0, string3.length() - 1);
        return string3;
    }

    private static String ConvertMacroOneFive(String string, String string2) {
        String string3 = "";
        string3 = string.startsWith("MACRO_") ? string.replaceFirst("MACRO_", "") : string;
        String[] stringArray = string2.split(",");
        String string4 = "";
        Hashtable hashtable = eng_MAPPING;
        for (int i = 0; i < stringArray.length - 2; i += 3) {
            int n = 0;
            try {
                n = Integer.parseInt(stringArray[i + 2]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = stringArray[i + 1].compareToIgnoreCase("true") == 0;
            KeyTranslated keyTranslated = UpgradeDb.translateJavaKey(n, bl);
            if (keyTranslated == null) continue;
            if (!keyTranslated.isBothMakeBreak()) {
                string4 = string4 + keyTranslated.getUsbCode() + "," + (stringArray[i].compareToIgnoreCase("true") == 0 ? "0" : "1") + "," + keyTranslated.toString() + ",";
                continue;
            }
            string4 = string4 + keyTranslated.getUsbCode() + "," + "2" + "," + keyTranslated.toString() + ",";
            i += 3;
        }
        if (string4.length() > 0) {
            string4 = string4.substring(0, string4.length() - 1);
        }
        String string5 = string3 + ",en,-1,0," + string4;
        return string5;
    }

    public static KeyTranslated translateJavaKey(int n, boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("translateKeyUnicodeToUSB nVirtualKey:" + n + " " + (bl ? "true" : "false")));
        KeyIdentifier keyIdentifier = new KeyIdentifier(n, 0, 1, bl);
        KeyTranslated keyTranslated = (KeyTranslated)eng_MAPPING.get(keyIdentifier);
        if (keyTranslated == null) {
            keyIdentifier = new KeyIdentifier(n, 0, 1, false);
            keyTranslated = (KeyTranslated)eng_MAPPING.get(keyIdentifier);
        }
        if (keyTranslated == null) {
            switch (n) {
                case 414865: {
                    keyTranslated = new KeyTranslated(102, "Power", true);
                    break;
                }
                case 414854: {
                    keyTranslated = new KeyTranslated(116, "Exec", true);
                    break;
                }
                case 414868: {
                    keyTranslated = new KeyTranslated(117, "Help", true);
                    break;
                }
                case 65482: {
                    keyTranslated = new KeyTranslated(118, "Menu", true);
                    break;
                }
                case 65480: {
                    keyTranslated = new KeyTranslated(120, "Stop", false);
                    break;
                }
                case 414852: {
                    keyTranslated = new KeyTranslated(119, "SEL", true);
                    break;
                }
                case 65481: {
                    keyTranslated = new KeyTranslated(121, "Again", true);
                    break;
                }
                case 65483: {
                    keyTranslated = new KeyTranslated(122, "Undo", true);
                    break;
                }
                case 414864: {
                    keyTranslated = new KeyTranslated(127, "Mute", true);
                    break;
                }
                case 65489: {
                    keyTranslated = new KeyTranslated(123, "Cut", true);
                    break;
                }
                case 65485: {
                    keyTranslated = new KeyTranslated(124, "Copy", true);
                    break;
                }
                case 65487: {
                    keyTranslated = new KeyTranslated(125, "Paste", true);
                    break;
                }
                case 65488: {
                    keyTranslated = new KeyTranslated(126, "Find", true);
                    break;
                }
                case 414866: {
                    keyTranslated = new KeyTranslated(128, "Vol+", true);
                    break;
                }
                case 414867: {
                    keyTranslated = new KeyTranslated(129, "Vol-", true);
                    break;
                }
                case 417792: {
                    keyTranslated = new KeyTranslated(138, "Henken", true);
                    break;
                }
                case 417793: {
                    keyTranslated = new KeyTranslated(139, "Muhenkan", true);
                    break;
                }
                case 417794: {
                    keyTranslated = new KeyTranslated(135, "Hanzen", true);
                    break;
                }
                case 417795: {
                    keyTranslated = new KeyTranslated(137, "Yen", true);
                    break;
                }
                case 417796: {
                    keyTranslated = new KeyTranslated(227, "XXX", true);
                    break;
                }
                case 417797: {
                    keyTranslated = new KeyTranslated(101, "App", true);
                    break;
                }
                case 417799: {
                    keyTranslated = new KeyTranslated(230, "Alt-Right", false);
                    break;
                }
                case 417798: {
                    keyTranslated = new KeyTranslated(226, "Alt-Left", false);
                    break;
                }
                case 417801: {
                    keyTranslated = new KeyTranslated(228, "Ctrl-Right", false);
                    break;
                }
                case 417800: {
                    keyTranslated = new KeyTranslated(224, "Ctrl-Left", false);
                    break;
                }
                case 417803: {
                    keyTranslated = new KeyTranslated(229, "Shift-Right", false);
                    break;
                }
                case 417802: {
                    keyTranslated = new KeyTranslated(225, "Shift-Left", false);
                    break;
                }
                case 417806: {
                    keyTranslated = new KeyTranslated(87, "+", false);
                    break;
                }
                case 417807: {
                    keyTranslated = new KeyTranslated(86, "-", false);
                }
            }
        }
        if (keyTranslated != null) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("translateJavaKey,  nUsbKey:" + keyTranslated.getUsbCode() + " " + keyTranslated.toString()));
        } else {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("translateJavaKey,  nUsbKey:" + n + " NO OBJECT Found"));
        }
        return keyTranslated;
    }

    static {
        eng_MAPPING.put(new KeyIdentifier(65489, 65535, 1, false), new KeyTranslated(123, "Cut", true));
        eng_MAPPING.put(new KeyIdentifier(65488, 65535, 1, false), new KeyTranslated(126, "Find", true));
        eng_MAPPING.put(new KeyIdentifier(65487, 65535, 1, false), new KeyTranslated(125, "Paste", true));
        eng_MAPPING.put(new KeyIdentifier(65485, 65535, 1, false), new KeyTranslated(124, "Copy", true));
        eng_MAPPING.put(new KeyIdentifier(65483, 65535, 1, false), new KeyTranslated(122, "Undo", true));
        eng_MAPPING.put(new KeyIdentifier(65482, 65535, 1, false), new KeyTranslated(118, "Menu", true));
        eng_MAPPING.put(new KeyIdentifier(65481, 65535, 1, false), new KeyTranslated(121, "Again", true));
        eng_MAPPING.put(new KeyIdentifier(65406, 65535, 1, false), new KeyTranslated(230, "Alt-Gr", true));
        eng_MAPPING.put(new KeyIdentifier(65312, 65535, 1, false), new KeyTranslated(101, "XXX", true));
        eng_MAPPING.put(new KeyIdentifier(227, 65535, 4, false), new KeyTranslated(94, "Right Arrow", true));
        eng_MAPPING.put(new KeyIdentifier(226, 65535, 4, false), new KeyTranslated(92, "Left Arrow", true));
        eng_MAPPING.put(new KeyIdentifier(225, 65535, 4, false), new KeyTranslated(90, "Down Arrow", true));
        eng_MAPPING.put(new KeyIdentifier(224, 65535, 4, false), new KeyTranslated(96, "Up Arrow", true));
        eng_MAPPING.put(new KeyIdentifier(222, 39, 1, false), new KeyTranslated(52, "'", true));
        eng_MAPPING.put(new KeyIdentifier(222, 34, 1, true), new KeyTranslated(52, "\"", true));
        eng_MAPPING.put(new KeyIdentifier(192, 126, 1, true), new KeyTranslated(53, "~", true));
        eng_MAPPING.put(new KeyIdentifier(192, 96, 1, false), new KeyTranslated(53, "`", true));
        eng_MAPPING.put(new KeyIdentifier(157, 65535, 3, false), new KeyTranslated(231, "XXX", true));
        eng_MAPPING.put(new KeyIdentifier(157, 65535, 2, false), new KeyTranslated(227, "XXX", true));
        eng_MAPPING.put(new KeyIdentifier(157, 65535, 0, false), new KeyTranslated(227, "XXX", true));
        eng_MAPPING.put(new KeyIdentifier(156, 65535, 1, false), new KeyTranslated(117, "Help", true));
        eng_MAPPING.put(new KeyIdentifier(155, 65535, 4, false), new KeyTranslated(98, "Keypad Insert", true));
        eng_MAPPING.put(new KeyIdentifier(155, 65535, 1, false), new KeyTranslated(73, "Insert", true));
        eng_MAPPING.put(new KeyIdentifier(154, 65535, 1, false), new KeyTranslated(70, "PrtScn", true));
        eng_MAPPING.put(new KeyIdentifier(145, 65535, 1, false), new KeyTranslated(71, "Scroll", true));
        eng_MAPPING.put(new KeyIdentifier(144, 65535, 4, false), new KeyTranslated(83, "Num", false));
        eng_MAPPING.put(new KeyIdentifier(144, 65535, 0, false), new KeyTranslated(83, "Num", false));
        eng_MAPPING.put(new KeyIdentifier(127, 127, 4, false), new KeyTranslated(99, "Keypad Del", true));
        eng_MAPPING.put(new KeyIdentifier(127, 127, 1, false), new KeyTranslated(76, "Del", true));
        eng_MAPPING.put(new KeyIdentifier(123, 65535, 1, false), new KeyTranslated(69, "F12", true));
        eng_MAPPING.put(new KeyIdentifier(122, 65535, 1, false), new KeyTranslated(68, "F11", true));
        eng_MAPPING.put(new KeyIdentifier(121, 65535, 1, false), new KeyTranslated(67, "F10", true));
        eng_MAPPING.put(new KeyIdentifier(120, 65535, 1, false), new KeyTranslated(66, "F9", true));
        eng_MAPPING.put(new KeyIdentifier(119, 65535, 1, false), new KeyTranslated(65, "F8", true));
        eng_MAPPING.put(new KeyIdentifier(118, 65535, 1, false), new KeyTranslated(64, "F7", true));
        eng_MAPPING.put(new KeyIdentifier(117, 65535, 1, false), new KeyTranslated(63, "F6", true));
        eng_MAPPING.put(new KeyIdentifier(116, 65535, 1, false), new KeyTranslated(62, "F5", true));
        eng_MAPPING.put(new KeyIdentifier(115, 65535, 1, false), new KeyTranslated(61, "F4", true));
        eng_MAPPING.put(new KeyIdentifier(114, 65535, 1, false), new KeyTranslated(60, "F3", true));
        eng_MAPPING.put(new KeyIdentifier(113, 65535, 1, false), new KeyTranslated(59, "F2", true));
        eng_MAPPING.put(new KeyIdentifier(112, 65535, 1, false), new KeyTranslated(58, "F1", true));
        eng_MAPPING.put(new KeyIdentifier(111, 47, 4, false), new KeyTranslated(84, "Keypad /", true));
        eng_MAPPING.put(new KeyIdentifier(110, 46, 4, false), new KeyTranslated(99, "Keypad .", true));
        eng_MAPPING.put(new KeyIdentifier(109, 45, 4, false), new KeyTranslated(86, "Keypad -", true));
        eng_MAPPING.put(new KeyIdentifier(107, 43, 4, false), new KeyTranslated(87, "Keypad +", true));
        eng_MAPPING.put(new KeyIdentifier(106, 42, 4, false), new KeyTranslated(85, "Keypad *", true));
        eng_MAPPING.put(new KeyIdentifier(105, 57, 4, false), new KeyTranslated(97, "Keypad 9", true));
        eng_MAPPING.put(new KeyIdentifier(104, 56, 4, false), new KeyTranslated(96, "Keypad 8", true));
        eng_MAPPING.put(new KeyIdentifier(103, 55, 4, false), new KeyTranslated(95, "Keypad 7", true));
        eng_MAPPING.put(new KeyIdentifier(102, 54, 4, false), new KeyTranslated(94, "Keypad 6", true));
        eng_MAPPING.put(new KeyIdentifier(101, 53, 4, false), new KeyTranslated(93, "Keypad 5", true));
        eng_MAPPING.put(new KeyIdentifier(100, 52, 4, false), new KeyTranslated(92, "Keypad 4", true));
        eng_MAPPING.put(new KeyIdentifier(99, 51, 4, false), new KeyTranslated(91, "Keypad 3", true));
        eng_MAPPING.put(new KeyIdentifier(98, 50, 4, false), new KeyTranslated(90, "Keypad 2", true));
        eng_MAPPING.put(new KeyIdentifier(97, 49, 4, false), new KeyTranslated(89, "Keypad 1", true));
        eng_MAPPING.put(new KeyIdentifier(96, 48, 4, false), new KeyTranslated(98, "Keypad 0", true));
        eng_MAPPING.put(new KeyIdentifier(93, 126, 1, false), new KeyTranslated(48, "]", true));
        eng_MAPPING.put(new KeyIdentifier(93, 125, 1, true), new KeyTranslated(48, "}", true));
        eng_MAPPING.put(new KeyIdentifier(93, 93, 1, false), new KeyTranslated(48, "]", true));
        eng_MAPPING.put(new KeyIdentifier(92, 124, 1, true), new KeyTranslated(49, "|", true));
        eng_MAPPING.put(new KeyIdentifier(92, 92, 1, false), new KeyTranslated(49, "\\", true));
        eng_MAPPING.put(new KeyIdentifier(91, 123, 1, true), new KeyTranslated(47, "{", true));
        eng_MAPPING.put(new KeyIdentifier(91, 91, 1, false), new KeyTranslated(47, "[", true));
        eng_MAPPING.put(new KeyIdentifier(90, 122, 1, false), new KeyTranslated(29, "z", true));
        eng_MAPPING.put(new KeyIdentifier(90, 90, 1, true), new KeyTranslated(29, "Z", true));
        eng_MAPPING.put(new KeyIdentifier(89, 121, 1, false), new KeyTranslated(28, "y", true));
        eng_MAPPING.put(new KeyIdentifier(89, 89, 1, true), new KeyTranslated(28, "Y", true));
        eng_MAPPING.put(new KeyIdentifier(88, 120, 1, false), new KeyTranslated(27, "x", true));
        eng_MAPPING.put(new KeyIdentifier(88, 88, 1, true), new KeyTranslated(27, "X", true));
        eng_MAPPING.put(new KeyIdentifier(87, 119, 1, false), new KeyTranslated(26, "w", true));
        eng_MAPPING.put(new KeyIdentifier(87, 87, 1, true), new KeyTranslated(26, "W", true));
        eng_MAPPING.put(new KeyIdentifier(86, 118, 1, false), new KeyTranslated(25, "v", true));
        eng_MAPPING.put(new KeyIdentifier(86, 86, 1, true), new KeyTranslated(25, "V", true));
        eng_MAPPING.put(new KeyIdentifier(85, 117, 1, false), new KeyTranslated(24, "u", true));
        eng_MAPPING.put(new KeyIdentifier(85, 85, 1, true), new KeyTranslated(24, "U", true));
        eng_MAPPING.put(new KeyIdentifier(84, 116, 1, false), new KeyTranslated(23, "t", true));
        eng_MAPPING.put(new KeyIdentifier(84, 84, 1, true), new KeyTranslated(23, "T", true));
        eng_MAPPING.put(new KeyIdentifier(83, 115, 1, false), new KeyTranslated(22, "s", true));
        eng_MAPPING.put(new KeyIdentifier(83, 83, 1, true), new KeyTranslated(22, "S", true));
        eng_MAPPING.put(new KeyIdentifier(82, 114, 1, false), new KeyTranslated(21, "r", true));
        eng_MAPPING.put(new KeyIdentifier(82, 82, 1, true), new KeyTranslated(21, "R", true));
        eng_MAPPING.put(new KeyIdentifier(81, 113, 1, false), new KeyTranslated(20, "q", true));
        eng_MAPPING.put(new KeyIdentifier(81, 81, 1, true), new KeyTranslated(20, "Q", true));
        eng_MAPPING.put(new KeyIdentifier(80, 112, 1, false), new KeyTranslated(19, "p", true));
        eng_MAPPING.put(new KeyIdentifier(80, 80, 1, true), new KeyTranslated(19, "P", true));
        eng_MAPPING.put(new KeyIdentifier(79, 111, 1, false), new KeyTranslated(18, "o", true));
        eng_MAPPING.put(new KeyIdentifier(79, 79, 1, true), new KeyTranslated(18, "O", true));
        eng_MAPPING.put(new KeyIdentifier(78, 110, 1, false), new KeyTranslated(17, "n", true));
        eng_MAPPING.put(new KeyIdentifier(78, 78, 1, true), new KeyTranslated(17, "N", true));
        eng_MAPPING.put(new KeyIdentifier(77, 109, 1, false), new KeyTranslated(16, "m", true));
        eng_MAPPING.put(new KeyIdentifier(77, 77, 1, true), new KeyTranslated(16, "M", true));
        eng_MAPPING.put(new KeyIdentifier(76, 108, 1, false), new KeyTranslated(15, "l", true));
        eng_MAPPING.put(new KeyIdentifier(76, 76, 1, true), new KeyTranslated(15, "L", true));
        eng_MAPPING.put(new KeyIdentifier(75, 107, 1, false), new KeyTranslated(14, "k", true));
        eng_MAPPING.put(new KeyIdentifier(75, 75, 1, true), new KeyTranslated(14, "K", true));
        eng_MAPPING.put(new KeyIdentifier(74, 106, 1, false), new KeyTranslated(13, "j", true));
        eng_MAPPING.put(new KeyIdentifier(74, 74, 1, true), new KeyTranslated(13, "J", true));
        eng_MAPPING.put(new KeyIdentifier(73, 105, 1, false), new KeyTranslated(12, "i", true));
        eng_MAPPING.put(new KeyIdentifier(73, 73, 1, true), new KeyTranslated(12, "I", true));
        eng_MAPPING.put(new KeyIdentifier(72, 104, 1, false), new KeyTranslated(11, "h", true));
        eng_MAPPING.put(new KeyIdentifier(72, 72, 1, true), new KeyTranslated(11, "H", true));
        eng_MAPPING.put(new KeyIdentifier(71, 103, 1, false), new KeyTranslated(10, "g", true));
        eng_MAPPING.put(new KeyIdentifier(71, 71, 1, true), new KeyTranslated(10, "G", true));
        eng_MAPPING.put(new KeyIdentifier(70, 102, 1, false), new KeyTranslated(9, "f", true));
        eng_MAPPING.put(new KeyIdentifier(70, 70, 1, true), new KeyTranslated(9, "F", true));
        eng_MAPPING.put(new KeyIdentifier(69, 164, 1, false), new KeyTranslated(8, "e", true));
        eng_MAPPING.put(new KeyIdentifier(69, 101, 1, false), new KeyTranslated(8, "e", true));
        eng_MAPPING.put(new KeyIdentifier(69, 69, 1, true), new KeyTranslated(8, "E", true));
        eng_MAPPING.put(new KeyIdentifier(68, 100, 1, false), new KeyTranslated(7, "d", true));
        eng_MAPPING.put(new KeyIdentifier(68, 68, 1, true), new KeyTranslated(7, "D", true));
        eng_MAPPING.put(new KeyIdentifier(67, 99, 1, false), new KeyTranslated(6, "c", true));
        eng_MAPPING.put(new KeyIdentifier(67, 67, 1, true), new KeyTranslated(6, "C", true));
        eng_MAPPING.put(new KeyIdentifier(66, 98, 1, false), new KeyTranslated(5, "b", true));
        eng_MAPPING.put(new KeyIdentifier(66, 66, 1, true), new KeyTranslated(5, "B", true));
        eng_MAPPING.put(new KeyIdentifier(65, 97, 1, false), new KeyTranslated(4, "a", true));
        eng_MAPPING.put(new KeyIdentifier(65, 65, 1, true), new KeyTranslated(4, "A", true));
        eng_MAPPING.put(new KeyIdentifier(61, 61, 1, false), new KeyTranslated(46, "=", true));
        eng_MAPPING.put(new KeyIdentifier(61, 45, 4, false), new KeyTranslated(86, "=", true));
        eng_MAPPING.put(new KeyIdentifier(61, 43, 1, true), new KeyTranslated(46, "+", true));
        eng_MAPPING.put(new KeyIdentifier(59, 59, 1, false), new KeyTranslated(51, ";", true));
        eng_MAPPING.put(new KeyIdentifier(59, 58, 1, true), new KeyTranslated(51, ":", true));
        eng_MAPPING.put(new KeyIdentifier(57, 57, 1, false), new KeyTranslated(38, "9", true));
        eng_MAPPING.put(new KeyIdentifier(57, 40, 1, false), new KeyTranslated(38, "(", true));
        eng_MAPPING.put(new KeyIdentifier(56, 56, 1, false), new KeyTranslated(37, "8", true));
        eng_MAPPING.put(new KeyIdentifier(56, 42, 1, true), new KeyTranslated(37, "*", true));
        eng_MAPPING.put(new KeyIdentifier(55, 55, 1, false), new KeyTranslated(36, "7", true));
        eng_MAPPING.put(new KeyIdentifier(55, 38, 1, true), new KeyTranslated(36, "&", true));
        eng_MAPPING.put(new KeyIdentifier(54, 94, 1, true), new KeyTranslated(35, "^", true));
        eng_MAPPING.put(new KeyIdentifier(54, 54, 1, false), new KeyTranslated(35, "6", true));
        eng_MAPPING.put(new KeyIdentifier(53, 53, 1, false), new KeyTranslated(34, "5", true));
        eng_MAPPING.put(new KeyIdentifier(53, 37, 1, true), new KeyTranslated(34, "%", true));
        eng_MAPPING.put(new KeyIdentifier(52, 52, 1, false), new KeyTranslated(33, "4", true));
        eng_MAPPING.put(new KeyIdentifier(52, 36, 1, false), new KeyTranslated(33, "$", true));
        eng_MAPPING.put(new KeyIdentifier(51, 51, 1, false), new KeyTranslated(32, "3", true));
        eng_MAPPING.put(new KeyIdentifier(51, 35, 1, true), new KeyTranslated(32, "#", true));
        eng_MAPPING.put(new KeyIdentifier(50, 64, 1, true), new KeyTranslated(31, "@", true));
        eng_MAPPING.put(new KeyIdentifier(50, 50, 1, false), new KeyTranslated(31, "2", true));
        eng_MAPPING.put(new KeyIdentifier(49, 49, 1, false), new KeyTranslated(30, "1", true));
        eng_MAPPING.put(new KeyIdentifier(49, 33, 1, true), new KeyTranslated(30, "!", true));
        eng_MAPPING.put(new KeyIdentifier(48, 48, 1, false), new KeyTranslated(39, "0", true));
        eng_MAPPING.put(new KeyIdentifier(48, 41, 1, true), new KeyTranslated(39, ")", true));
        eng_MAPPING.put(new KeyIdentifier(47, 63, 1, true), new KeyTranslated(56, "?", true));
        eng_MAPPING.put(new KeyIdentifier(47, 47, 1, false), new KeyTranslated(56, "/", true));
        eng_MAPPING.put(new KeyIdentifier(46, 65312, 1, false), new KeyTranslated(55, ".", true));
        eng_MAPPING.put(new KeyIdentifier(46, 62, 1, true), new KeyTranslated(55, ">", true));
        eng_MAPPING.put(new KeyIdentifier(46, 46, 1, false), new KeyTranslated(55, ".", true));
        eng_MAPPING.put(new KeyIdentifier(45, 95, 1, true), new KeyTranslated(45, "_", true));
        eng_MAPPING.put(new KeyIdentifier(45, 45, 1, false), new KeyTranslated(45, "-", true));
        eng_MAPPING.put(new KeyIdentifier(44, 60, 1, true), new KeyTranslated(54, "<", true));
        eng_MAPPING.put(new KeyIdentifier(44, 44, 1, false), new KeyTranslated(54, ",", true));
        eng_MAPPING.put(new KeyIdentifier(40, 65535, 4, false), new KeyTranslated(90, "Keypad Down Arrow", true));
        eng_MAPPING.put(new KeyIdentifier(40, 65535, 1, false), new KeyTranslated(81, "Down Arrow", true));
        eng_MAPPING.put(new KeyIdentifier(39, 65535, 4, false), new KeyTranslated(94, "Keypad Right Arrow", true));
        eng_MAPPING.put(new KeyIdentifier(39, 65535, 1, false), new KeyTranslated(79, "Right Arrow", true));
        eng_MAPPING.put(new KeyIdentifier(38, 65535, 4, false), new KeyTranslated(96, "Keypad Up Arrow", true));
        eng_MAPPING.put(new KeyIdentifier(38, 65535, 1, false), new KeyTranslated(82, "Up Arrow", true));
        eng_MAPPING.put(new KeyIdentifier(37, 65535, 4, false), new KeyTranslated(92, "Keypad Left Arrow", true));
        eng_MAPPING.put(new KeyIdentifier(37, 65535, 1, false), new KeyTranslated(80, "Left Arrow", true));
        eng_MAPPING.put(new KeyIdentifier(36, 65535, 4, false), new KeyTranslated(95, "Keypad Home", true));
        eng_MAPPING.put(new KeyIdentifier(36, 65535, 1, false), new KeyTranslated(74, "Home", true));
        eng_MAPPING.put(new KeyIdentifier(35, 65535, 4, false), new KeyTranslated(89, "Keypad End", true));
        eng_MAPPING.put(new KeyIdentifier(35, 65535, 1, false), new KeyTranslated(77, "End", true));
        eng_MAPPING.put(new KeyIdentifier(34, 65535, 4, false), new KeyTranslated(91, "Keypad Page Down", true));
        eng_MAPPING.put(new KeyIdentifier(34, 65535, 1, false), new KeyTranslated(78, "Page Down", true));
        eng_MAPPING.put(new KeyIdentifier(33, 65535, 4, false), new KeyTranslated(97, "Keypad Page Up", true));
        eng_MAPPING.put(new KeyIdentifier(33, 65535, 1, false), new KeyTranslated(75, "Page Up", true));
        eng_MAPPING.put(new KeyIdentifier(32, 32, 4, false), new KeyTranslated(93, "Space", true));
        eng_MAPPING.put(new KeyIdentifier(32, 32, 1, false), new KeyTranslated(44, "Space", true));
        eng_MAPPING.put(new KeyIdentifier(27, 27, 1, false), new KeyTranslated(41, "Esc", true));
        eng_MAPPING.put(new KeyIdentifier(20, 65535, 1, false), new KeyTranslated(57, "Caps", true));
        eng_MAPPING.put(new KeyIdentifier(19, 65535, 1, false), new KeyTranslated(72, "Pause", true));
        eng_MAPPING.put(new KeyIdentifier(18, 65535, 2, false), new KeyTranslated(226, "Alt-Left", false));
        eng_MAPPING.put(new KeyIdentifier(18, 65535, 3, false), new KeyTranslated(230, "Alt-Right", false));
        eng_MAPPING.put(new KeyIdentifier(18, 65535, 0, false), new KeyTranslated(226, "Alt-Left", false));
        eng_MAPPING.put(new KeyIdentifier(17, 65535, 2, false), new KeyTranslated(224, "Ctrl-Left", false));
        eng_MAPPING.put(new KeyIdentifier(17, 65535, 3, false), new KeyTranslated(228, "Ctrl-Right", false));
        eng_MAPPING.put(new KeyIdentifier(17, 65535, 0, false), new KeyTranslated(224, "Ctrl-Left", false));
        eng_MAPPING.put(new KeyIdentifier(16, 65535, 3, false), new KeyTranslated(229, "Shift-Right", false));
        eng_MAPPING.put(new KeyIdentifier(16, 65535, 2, false), new KeyTranslated(225, "Shift-Left", false));
        eng_MAPPING.put(new KeyIdentifier(16, 65535, 0, false), new KeyTranslated(225, "Shift-Left", false));
        eng_MAPPING.put(new KeyIdentifier(12, 65535, 4, false), new KeyTranslated(93, "Clear", true));
        eng_MAPPING.put(new KeyIdentifier(10, 10, 4, false), new KeyTranslated(88, "Keypad Enter", true));
        eng_MAPPING.put(new KeyIdentifier(10, 10, 1, false), new KeyTranslated(40, "Enter", true));
        eng_MAPPING.put(new KeyIdentifier(9, 9, 1, false), new KeyTranslated(43, "Tab", true));
        eng_MAPPING.put(new KeyIdentifier(8, 8, 1, false), new KeyTranslated(42, "BackSp", true));
        eng_MAPPING.put(new KeyIdentifier(3, 0, 1, false), new KeyTranslated(120, "Cancel", true));
    }

    public static class KeyTranslated {
        protected int m_nUsbCode;
        protected String m_szRep;
        protected boolean m_bMakeBreak;

        public KeyTranslated(int n, String string, boolean bl) {
            this.m_nUsbCode = n;
            this.m_szRep = string;
            this.m_bMakeBreak = bl;
        }

        public String toString() {
            return this.m_szRep;
        }

        public int getUsbCode() {
            return this.m_nUsbCode;
        }

        public boolean isBothMakeBreak() {
            return this.m_bMakeBreak;
        }
    }

    public static class KeyIdentifier {
        protected int m_nKeyCode;
        protected int m_nKeyChar;
        protected int m_nKeyLocation;
        protected boolean m_bShiftModified;

        public KeyIdentifier(int n, int n2, int n3, boolean bl) {
            this.m_nKeyCode = n;
            this.m_nKeyLocation = n3 == 0 ? 1 : n3;
            this.m_nKeyChar = n2 == 65535 ? 0 : n2;
            this.m_bShiftModified = bl;
        }

        public int hashCode() {
            if (this.m_nKeyCode > 0) {
                return new String("" + this.m_nKeyCode + "-" + this.m_nKeyLocation).hashCode();
            }
            return new Integer(this.m_nKeyChar).hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof KeyIdentifier) {
                KeyIdentifier keyIdentifier = (KeyIdentifier)object;
                if (this.m_nKeyCode > 0) {
                    return this.m_nKeyCode == keyIdentifier.m_nKeyCode && this.m_bShiftModified == keyIdentifier.m_bShiftModified;
                }
                return this.m_nKeyChar == keyIdentifier.m_nKeyChar;
            }
            return false;
        }

        public String toString() {
            if (this.m_nKeyCode > 0) {
                return "" + this.m_nKeyCode + "-" + this.m_nKeyLocation;
            }
            return "" + this.m_nKeyChar + "(" + (char)this.m_nKeyChar + ")";
        }

        public int getKeyCode() {
            return this.m_nKeyCode;
        }

        public int getKeyChar() {
            return this.m_nKeyChar;
        }

        public boolean isShiftModified() {
            return this.m_bShiftModified;
        }
    }
}

