/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.database;

import com.avocent.lib.database.DBaseRequest;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;

public class DBaseRequestQueryResults
extends DBaseRequest {
    int m_nQueryHandle = 0;
    int m_nMaxRows = 0;
    int m_nCurrentRow = 0;
    Vector m_vRowColumnData = new Vector();
    Vector m_vColumnInfo = new Vector();

    public DBaseRequestQueryResults(int n, int n2) {
        super(2);
        this.m_nQueryHandle = n;
        this.m_nMaxRows = n2;
    }

    public int getQueryHandle() {
        return this.m_nQueryHandle;
    }

    public int getMaxRows() {
        return this.m_nMaxRows;
    }

    public void setColumnInfo(ResultSetMetaData resultSetMetaData) {
        try {
            int n = resultSetMetaData.getColumnCount();
            int n2 = 1;
            while (n2 <= n) {
                String string = resultSetMetaData.getColumnLabel(n2);
                String string2 = resultSetMetaData.getColumnTypeName(n2);
                int n3 = resultSetMetaData.getColumnType(n2);
                ColumnInfo columnInfo = new ColumnInfo(n2, n3, string2, string);
                this.m_vColumnInfo.add(columnInfo);
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            Trace.logError((String)"DBase", (String)("SQLException: " + sQLException.getMessage()));
            this.setErrorStatus(2);
        }
    }

    public void addRow(Vector vector) {
        this.m_vRowColumnData.add(vector);
    }

    public int getColumnCount() {
        return this.m_vColumnInfo.size();
    }

    public int getRowCount() {
        return this.m_vRowColumnData.size();
    }

    public String getColumnLabel(int n) throws ExceptionRequestFailed {
        int n2 = 0;
        while (n2 < this.m_vColumnInfo.size()) {
            ColumnInfo columnInfo = (ColumnInfo)this.m_vColumnInfo.elementAt(n2);
            if (columnInfo.getColumnIndex() == n) {
                return columnInfo.getColumnLabel();
            }
            ++n2;
        }
        Trace.logError((String)"DBase", (String)"Column was not found");
        throw new ExceptionRequestFailed();
    }

    public int getColumnIndex(String string) throws ExceptionRequestFailed {
        int n = 0;
        while (n < this.m_vColumnInfo.size()) {
            ColumnInfo columnInfo = (ColumnInfo)this.m_vColumnInfo.elementAt(n);
            if (string.equalsIgnoreCase(columnInfo.getColumnLabel())) {
                return columnInfo.getColumnIndex();
            }
            ++n;
        }
        Trace.logError((String)"DBase", (String)"Column was not found");
        throw new ExceptionRequestFailed();
    }

    public String getColumnType(int n) throws ExceptionRequestFailed {
        int n2 = 0;
        while (n2 < this.m_vColumnInfo.size()) {
            ColumnInfo columnInfo = (ColumnInfo)this.m_vColumnInfo.elementAt(n2);
            if (columnInfo.getColumnIndex() == n) {
                return columnInfo.getColumnTypeName();
            }
            ++n2;
        }
        Trace.logError((String)"DBase", (String)"Column was not found");
        throw new ExceptionRequestFailed();
    }

    public String getColumnType(String string) throws ExceptionRequestFailed {
        int n = 0;
        while (n < this.m_vColumnInfo.size()) {
            ColumnInfo columnInfo = (ColumnInfo)this.m_vColumnInfo.elementAt(n);
            if (string.equalsIgnoreCase(columnInfo.getColumnLabel())) {
                return columnInfo.getColumnTypeName();
            }
            ++n;
        }
        Trace.logError((String)"DBase", (String)"Column was not found");
        throw new ExceptionRequestFailed();
    }

    public boolean nextRow() {
        if (this.m_vRowColumnData.size() == 0) {
            return false;
        }
        if (this.m_nCurrentRow >= this.m_vRowColumnData.size()) {
            return false;
        }
        ++this.m_nCurrentRow;
        return true;
    }

    public String getString(int n) throws ExceptionRequestFailed {
        Vector vector = (Vector)this.m_vRowColumnData.elementAt(this.m_nCurrentRow - 1);
        Object e = vector.elementAt(n - 1);
        if (e == null) {
            throw new ExceptionRequestFailed("Database column contains a NULL value.");
        }
        return e.toString();
    }

    public String getString(int n, String string) throws ExceptionRequestFailed {
        try {
            Vector vector = (Vector)this.m_vRowColumnData.elementAt(this.m_nCurrentRow - 1);
            Object e = vector.elementAt(n - 1);
            return e == null ? string : e.toString();
        }
        catch (Exception exception) {
            Trace.logError((String)"DBase", (String)exception.getMessage());
            throw new ExceptionRequestFailed();
        }
    }

    public String getString(String string) throws ExceptionRequestFailed {
        int n = this.getColumnIndex(string);
        return this.getString(n);
    }

    public String getString(String string, String string2) throws ExceptionRequestFailed {
        int n = this.getColumnIndex(string);
        return this.getString(n, string2);
    }

    public int getInt(int n) throws ExceptionRequestFailed {
        Integer n2 = this.getInteger(n);
        return n2 == null ? 0 : n2;
    }

    public int getInt(String string) throws ExceptionRequestFailed {
        int n = this.getColumnIndex(string);
        return this.getInt(n);
    }

    public Integer getInteger(int n) throws ExceptionRequestFailed {
        try {
            Vector vector = (Vector)this.m_vRowColumnData.elementAt(this.m_nCurrentRow - 1);
            Integer n2 = (Integer)vector.elementAt(n - 1);
            return n2;
        }
        catch (Exception exception) {
            Trace.logError((String)"DBase", (String)exception.getMessage(), (Throwable)exception);
            throw new ExceptionRequestFailed((Throwable)exception);
        }
    }

    public Integer getInteger(String string) throws ExceptionRequestFailed {
        int n = this.getColumnIndex(string);
        return this.getInteger(n);
    }

    class ColumnInfo {
        int m_nColumnIndex;
        int m_nColumnType;
        String m_szColumnTypeName;
        String m_szColumnLabel;

        ColumnInfo(int n, int n2, String string, String string2) {
            this.m_nColumnIndex = n;
            this.m_nColumnType = n2;
            this.m_szColumnTypeName = string;
            this.m_szColumnLabel = string2;
        }

        public int getColumnIndex() {
            return this.m_nColumnIndex;
        }

        public String getColumnLabel() {
            return this.m_szColumnLabel;
        }

        public int getColumnType() {
            return this.m_nColumnType;
        }

        public String getColumnTypeName() {
            return this.m_szColumnTypeName;
        }
    }
}

