/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.database;

import com.avocent.lib.database.TableDefinition;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;

public class DatabaseUtilities {
    public static final int NO_ACTION = 0;
    public static final int TABLE_ADDED = 1;
    public static final int COLUMN_ADDED = 1;
    public static final int ERROR = 99;
    static String DBUTILITIES = "DBUtilities";

    public static int verifyTableDefinition(Connection connection, TableDefinition tableDefinition) throws ExceptionRequestFailed {
        try {
            int n = 0;
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(null, "", tableDefinition.getTableName(), null);
            if (!resultSet.next()) {
                Trace.logInfo((String)DBUTILITIES, (String)("  Table (" + tableDefinition.getTableName() + ") does not exists."));
                DatabaseUtilities.createTable(tableDefinition, connection);
                n = 1;
            } else {
                int n2 = 0;
                while (n2 < tableDefinition.getColumnCount()) {
                    ResultSet resultSet2 = databaseMetaData.getColumns(null, "", tableDefinition.getTableName(), tableDefinition.getColumnNameAt(n2));
                    if (!resultSet2.next()) {
                        DatabaseUtilities.createColumn(tableDefinition, n2, connection);
                        n = 1;
                    } else {
                        String string = resultSet2.getString(6);
                        if (!tableDefinition.getColumnTypeAt(n2).equalsIgnoreCase(string)) {
                            Trace.logInfo((String)DBUTILITIES, (String)(" Type mismatch in column (" + tableDefinition.getColumnNameAt(n2) + ") - expected (" + tableDefinition.getColumnTypeAt(n2) + ") - found(" + string + ")."));
                            return 99;
                        }
                    }
                    ++n2;
                }
            }
            return n;
        }
        catch (Exception exception) {
            throw new ExceptionRequestFailed("Failed to verify table definition.", (Throwable)exception);
        }
    }

    public static void createTable(TableDefinition tableDefinition, Connection connection) throws ExceptionRequestFailed {
        try {
            Object object;
            String string = tableDefinition.getTableName();
            int n = tableDefinition.getPrimaryKeyColumn();
            StringBuffer stringBuffer = new StringBuffer("CREATE TABLE ");
            stringBuffer.append(string);
            stringBuffer.append("( ");
            int n2 = 0;
            while (n2 < tableDefinition.getColumnCount()) {
                object = tableDefinition.getColumnNameAt(n2);
                String string2 = tableDefinition.getColumnTypeAt(n2);
                Object object2 = tableDefinition.getColumnDefaultValueAt(n2);
                if (n2 != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append((String)object).append(" ").append(string2);
                if (n == n2) {
                    stringBuffer.append(" ").append(tableDefinition.getPrimaryKeyString()).append(" ");
                }
                if (object2 != null) {
                    stringBuffer.append(" DEFAULT ").append(tableDefinition.getFormattedDefaultValueAt(n2));
                }
                ++n2;
            }
            stringBuffer.append(")");
            object = connection.createStatement();
            Trace.logInfo((String)DBUTILITIES, (String)("  Creating table with: " + stringBuffer.toString()));
            object.executeUpdate(stringBuffer.toString());
            object.close();
            Trace.logInfo((String)DBUTILITIES, (String)"  Table creation done.");
        }
        catch (Exception exception) {
            Trace.logError((String)DBUTILITIES, (String)"Failed to create table.", (Throwable)exception);
        }
    }

    public static void createColumn(TableDefinition tableDefinition, int n, Connection connection) throws Exception {
        StringBuffer stringBuffer = new StringBuffer("ALTER TABLE ");
        String string = tableDefinition.getColumnNameAt(n);
        String string2 = tableDefinition.getColumnTypeAt(n);
        Object object = tableDefinition.getColumnDefaultValueAt(n);
        int n2 = tableDefinition.getPrimaryKeyColumn();
        stringBuffer.append(tableDefinition.getTableName());
        stringBuffer.append(" ADD COLUMN ").append(string).append(" ").append(string2);
        if (object != null) {
            stringBuffer.append(" DEFAULT ").append(tableDefinition.getFormattedDefaultValueAt(n));
        }
        Statement statement = connection.createStatement();
        Trace.logInfo((String)DBUTILITIES, (String)("  Creating table with: " + stringBuffer.toString()));
        statement.executeUpdate(stringBuffer.toString());
        statement.close();
        Trace.logInfo((String)DBUTILITIES, (String)"  Table creation done.");
    }

    public static void insert(Connection connection, String string, String[] stringArray, String[] stringArray2) throws ExceptionRequestFailed {
        try {
            StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
            stringBuffer.append(string).append("(");
            int n = 0;
            while (n < stringArray.length) {
                if (n != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(stringArray[n]);
                ++n;
            }
            stringBuffer.append(") VALUES (");
            int n2 = 0;
            while (n2 < stringArray2.length) {
                if (n2 != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(stringArray2[n2]);
                ++n2;
            }
            stringBuffer.append(")");
            Statement statement = connection.createStatement();
            if (statement.executeUpdate(stringBuffer.toString()) == 0) {
                throw new ExceptionRequestFailed("Failed perform database INSERT.");
            }
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            throw exceptionRequestFailed;
        }
        catch (Exception exception) {
            throw new ExceptionRequestFailed("Failed perform database INSERT.", (Throwable)exception);
        }
    }
}

