/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.database;

import com.avocent.lib.database.DBaseActiveQuery;
import com.avocent.lib.database.DBaseRequest;
import com.avocent.lib.database.DBaseRequestCloseQuery;
import com.avocent.lib.database.DBaseRequestExecuteQuery;
import com.avocent.lib.database.DBaseRequestExecuteUpdate;
import com.avocent.lib.database.DBaseRequestQueryResults;
import com.avocent.lib.debug.Assert;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.util.BlockingQueue;
import com.avocent.lib.util.ThreadContinuous;
import java.awt.Font;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class ThreadDBaseService
extends ThreadContinuous {
    public static final int SLEEP_INTERVAL = 0;
    public static final int QUEUE_WAIT_TIME = 1000;
    public static final int REQUEST_WAIT_TIME = 10;
    BlockingQueue m_queueRequests;
    Connection m_conn = null;
    Vector m_vActiveQueries = new Vector();
    private static int m_nQueryHandle = 0;

    public ThreadDBaseService(String string, String string2, String string3, String string4) throws ClassNotFoundException, SQLException {
        super(0L);
        Trace.logInfo((String)"DBase", (String)("Loading Driver " + string + "..."));
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Trace.logError((String)"DBase", (String)"Failed to load database driver");
            Trace.logError((String)"DBase", (String)classNotFoundException.getMessage());
            throw classNotFoundException;
        }
        Trace.logInfo((String)"DBase", (String)"Database driver loaded successfully");
        Trace.logInfo((String)"DBase", (String)("Connecting to database " + string2 + "..."));
        this.m_conn = DriverManager.getConnection(string2, string3, string4);
        Trace.logInfo((String)"DBase", (String)"Successfully connected to database");
        this.m_queueRequests = new BlockingQueue();
    }

    protected void performTask() {
        try {
            Assert.isNotEventDispatchThread();
            DBaseRequest dBaseRequest = (DBaseRequest)this.m_queueRequests.remove(1000L);
            int n = dBaseRequest.getRequestType();
            switch (n) {
                case 1: {
                    this.executeQuery((DBaseRequestExecuteQuery)dBaseRequest);
                    break;
                }
                case 2: {
                    this.getQueryResults((DBaseRequestQueryResults)dBaseRequest);
                    break;
                }
                case 3: {
                    this.closeQuery((DBaseRequestCloseQuery)dBaseRequest);
                    break;
                }
                case 4: {
                    this.executeUpdate((DBaseRequestExecuteUpdate)dBaseRequest);
                }
            }
        }
        catch (ExceptionNoValue exceptionNoValue) {
        }
        catch (Exception exception) {
            Trace.logError((String)"DBase", (String)("Error processing database request - Exception:" + exception.getMessage()), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean request(DBaseRequest dBaseRequest) {
        try {
            DBaseRequest dBaseRequest2 = dBaseRequest;
            synchronized (dBaseRequest2) {
                Assert.isNotEventDispatchThread();
                this.m_queueRequests.add((Object)dBaseRequest);
                Trace.logInfo((String)"DBase", (String)("Waiting for DBase request " + dBaseRequest.getRequestId()));
                dBaseRequest.wait(10000L);
                this.m_queueRequests.removeElement((Object)dBaseRequest);
                if (dBaseRequest.isCompleted()) {
                    Trace.logInfo((String)"DBase", (String)("DBase Request " + dBaseRequest.getRequestId() + " completed successfully"));
                    return true;
                }
                Trace.logError((String)"DBase", (String)("Database request " + dBaseRequest.getRequestId() + " failed after " + 10 + " sec time."));
                return false;
            }
        }
        catch (InterruptedException interruptedException) {
            Trace.logError((String)"DBase", (String)"Database request error - InterruptedException", (Throwable)interruptedException);
            dBaseRequest.setErrorStatus(4);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupQueries(String string) {
        Vector vector = this.m_vActiveQueries;
        synchronized (vector) {
            int n = 0;
            while (n < this.m_vActiveQueries.size()) {
                DBaseActiveQuery dBaseActiveQuery = (DBaseActiveQuery)this.m_vActiveQueries.elementAt(n);
                if (string.equalsIgnoreCase(dBaseActiveQuery.getRequestorAddress())) {
                    try {
                        int n2 = dBaseActiveQuery.getQueryHandle();
                        Trace.logInfo((String)"DBase", (String)("Closing DBase ResultSet for Query Handle " + Integer.toString(n2) + " (" + string + ")"));
                        ResultSet resultSet = dBaseActiveQuery.getResultSet();
                        resultSet.close();
                        Trace.logInfo((String)"DBase", (String)("DBase ResultSet Closed for Query Handle " + Integer.toString(n2) + " (" + string + ")"));
                        Trace.logInfo((String)"DBase", (String)("Closing Statement for Query Handle " + Integer.toString(n2) + " (" + string + ")"));
                        Statement statement = dBaseActiveQuery.getStatement();
                        statement.close();
                        Trace.logInfo((String)"DBase", (String)("DBase Statement closed for Query Handle " + Integer.toString(n2) + " (" + string + ")"));
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    this.m_vActiveQueries.removeElementAt(n);
                    n = 0;
                }
                ++n;
            }
        }
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeQuery(DBaseRequestExecuteQuery dBaseRequestExecuteQuery) {
        Object object;
        Assert.isNotEventDispatchThread();
        String string = dBaseRequestExecuteQuery.getQuery();
        int n = ThreadDBaseService.getNextQueryHandle();
        Trace.logInfo((String)"DBase", (String)("EXECUTE_QUERY: request " + dBaseRequestExecuteQuery.getRequestId() + " assigned Query Handle " + Integer.toString(n)));
        Trace.logInfo((String)"DBase", (String)("EXECUTE_QUERY:Query " + Integer.toString(n) + " Query = " + string));
        Trace.logInfo((String)"DBase", (String)"EXECUTE_QUERY:Executing Request");
        try {
            object = this.m_conn.createStatement();
            ResultSet resultSet = object.executeQuery(string);
            Trace.logInfo((String)"DBase", (String)"EXECUTE_QUERY:Request Executed");
            Trace.logInfo((String)"DBase", (String)("EXECUTE_QUERY:Saving ResultSet for Query Handle " + Integer.toString(n)));
            DBaseActiveQuery dBaseActiveQuery = new DBaseActiveQuery(n, string, (Statement)object, resultSet, dBaseRequestExecuteQuery.getRequestorAddress());
            this.m_vActiveQueries.addElement(dBaseActiveQuery);
            Trace.logInfo((String)"DBase", (String)("EXECUTE_QUERY:Returning Query Handle " + Integer.toString(n)));
            dBaseRequestExecuteQuery.setQueryHandle(n);
            dBaseRequestExecuteQuery.setCompleted(true);
        }
        catch (SQLException sQLException) {
            Trace.logError((String)"DBase", (String)"EXECUTE_QUERY:SQL Exception");
            Trace.logError((String)"DBase", (String)("EXECUTE_QUERY:" + sQLException.getMessage()), (Throwable)sQLException);
            dBaseRequestExecuteQuery.setErrorStatus(2);
        }
        Trace.logInfo((String)"DBase", (String)"EXECUTE_QUERY:Notify requestor that we have finished");
        object = dBaseRequestExecuteQuery;
        synchronized (object) {
            dBaseRequestExecuteQuery.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getQueryResults(DBaseRequestQueryResults dBaseRequestQueryResults) {
        int n = dBaseRequestQueryResults.getMaxRows();
        int n2 = dBaseRequestQueryResults.getQueryHandle();
        Trace.logInfo((String)"DBase", (String)("GET_QUERY:Query Handle=" + Integer.toString(n2) + " Max Rows=" + Integer.toString(n)));
        Trace.logInfo((String)"DBase", (String)("GET_QUERY:Query Handle=" + Integer.toString(n2) + " Searching for Handle in Active Query List"));
        ResultSet resultSet = null;
        Vector vector = this.m_vActiveQueries;
        synchronized (vector) {
            int n3 = 0;
            while (n3 < this.m_vActiveQueries.size()) {
                DBaseActiveQuery dBaseActiveQuery = (DBaseActiveQuery)this.m_vActiveQueries.elementAt(n3);
                if (n2 == dBaseActiveQuery.getQueryHandle()) {
                    resultSet = dBaseActiveQuery.getResultSet();
                    Trace.logInfo((String)"DBase", (String)("GET_QUERY:Query Handle=" + Integer.toString(n2) + " Found ResultSet"));
                }
                ++n3;
            }
        }
        if (resultSet == null) {
            Trace.logError((String)"DBase", (String)("GET_QUERY:Query Handle=" + Integer.toString(n2) + " Unable to locate active query"));
            dBaseRequestQueryResults.setErrorStatus(1);
        } else {
            try {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n4 = resultSetMetaData.getColumnCount();
                dBaseRequestQueryResults.setColumnInfo(resultSetMetaData);
                int n5 = 1;
                while (n5 <= n) {
                    if (!resultSet.next()) break;
                    Vector<Object> vector2 = new Vector<Object>();
                    int n6 = 1;
                    while (n6 <= n4) {
                        Object object = resultSet.getObject(n6);
                        if (resultSet.wasNull()) {
                            vector2.add(null);
                        } else {
                            vector2.add(resultSet.getObject(n6));
                        }
                        ++n6;
                    }
                    dBaseRequestQueryResults.addRow(vector2);
                    ++n5;
                }
                dBaseRequestQueryResults.setCompleted(true);
            }
            catch (SQLException sQLException) {
                Trace.logError((String)"DBase", (String)"GET_QUERY:SQL Exception");
                Trace.logError((String)"DBase", (String)("GET_QUERY:" + sQLException.getMessage()), (Throwable)sQLException);
                dBaseRequestQueryResults.setErrorStatus(2);
            }
        }
        Trace.logInfo((String)"DBase", (String)"GET_QUERY:Notify requestor that we have finished");
        DBaseRequestQueryResults dBaseRequestQueryResults2 = dBaseRequestQueryResults;
        synchronized (dBaseRequestQueryResults2) {
            dBaseRequestQueryResults.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeQuery(DBaseRequestCloseQuery dBaseRequestCloseQuery) {
        int n = dBaseRequestCloseQuery.getQueryHandle();
        Vector vector = this.m_vActiveQueries;
        synchronized (vector) {
            int n2 = 0;
            while (n2 < this.m_vActiveQueries.size()) {
                DBaseActiveQuery dBaseActiveQuery = (DBaseActiveQuery)this.m_vActiveQueries.elementAt(n2);
                if (n == dBaseActiveQuery.getQueryHandle()) {
                    try {
                        Trace.logInfo((String)"DBase", (String)("Closing ResultSet for Query Handle " + Integer.toString(n)));
                        ResultSet resultSet = dBaseActiveQuery.getResultSet();
                        resultSet.close();
                        Trace.logInfo((String)"DBase", (String)("ResultSet Closed for Query Handle " + Integer.toString(n)));
                        Trace.logInfo((String)"DBase", (String)("Closing Statement for Query Handle " + Integer.toString(n)));
                        Statement statement = dBaseActiveQuery.getStatement();
                        statement.close();
                        Trace.logInfo((String)"DBase", (String)("Statement Closed for Query Handle " + Integer.toString(n)));
                        this.m_vActiveQueries.removeElementAt(n2);
                        dBaseRequestCloseQuery.setCompleted(true);
                    }
                    catch (SQLException sQLException) {
                        Trace.logError((String)"DBase", (String)("CLOSE_QUERY:SQL Exception - " + sQLException.getMessage()), (Throwable)sQLException);
                        dBaseRequestCloseQuery.setErrorStatus(2);
                    }
                    break;
                }
                ++n2;
            }
        }
        Trace.logInfo((String)"DBase", (String)"CLOSE_QUERY:Notify requestor that we have finished");
        DBaseRequestCloseQuery dBaseRequestCloseQuery2 = dBaseRequestCloseQuery;
        synchronized (dBaseRequestCloseQuery2) {
            dBaseRequestCloseQuery.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeUpdate(DBaseRequestExecuteUpdate dBaseRequestExecuteUpdate) {
        Object object;
        Assert.isNotEventDispatchThread();
        String string = dBaseRequestExecuteUpdate.getSqlCommand();
        Trace.logInfo((String)"DBase", (String)("EXECUTE_UPDATE:Command = " + string));
        Trace.logInfo((String)"DBase", (String)"EXECUTE_UPDATE:Executing Request");
        try {
            object = this.m_conn.createStatement();
            int n = object.executeUpdate(string);
            Trace.logInfo((String)"DBase", (String)"EXECUTE_UPDATE:Request Executed.");
            Trace.logInfo((String)"DBase", (String)("EXECUTE_UPDATE:Returning Updated Row Count " + Integer.toString(n)));
            dBaseRequestExecuteUpdate.setRowsUpdated(n);
            dBaseRequestExecuteUpdate.setCompleted(true);
        }
        catch (SQLException sQLException) {
            Trace.logError((String)"DBase", (String)("EXECUTE_UPDATE:SQL Exception - " + sQLException.getMessage()), (Throwable)sQLException);
            dBaseRequestExecuteUpdate.setErrorStatus(2);
        }
        Trace.logInfo((String)"DBase", (String)"EXECUTE_UPDATE:Notify requestor that we have finished");
        object = dBaseRequestExecuteUpdate;
        synchronized (object) {
            dBaseRequestExecuteUpdate.notify();
        }
    }

    protected void cleanup() {
        try {
            Trace.logInfo((String)"DBase", (String)"DBase cleanup is commiting JDBC changes");
            this.m_conn.commit();
            Trace.logInfo((String)"DBase", (String)"DBase cleanup is closing JDBC connection");
            this.m_conn.close();
        }
        catch (Exception exception) {}
    }

    private static synchronized int getNextQueryHandle() {
        return m_nQueryHandle++;
    }

    public Connection getConnection() {
        return this.m_conn;
    }

    public static void main(String[] stringArray) {
        Properties properties = new Properties();
        properties.setProperty("LogToConsole", "true");
        properties.setProperty("LogInfo", "true");
        properties.setProperty("LogError", "true");
        Trace.startLogging(null);
        JFrame jFrame = new JFrame();
        JLabel jLabel = new JLabel();
        jLabel.setFont(new Font("DialogInput", 1, 72));
        jFrame.getContentPane().add(jLabel);
        jFrame.setVisible(true);
        Trace.logError((String)"DBase", (String)"Test Error Message");
        try {
            String string = "org.hsql.jdbcDriver";
            String string2 = "jdbc:HypersonicSQL:test";
            String string3 = "sa";
            String string4 = "";
            ThreadDBaseService threadDBaseService = new ThreadDBaseService(string, string2, string3, string4);
            threadDBaseService.start();
            String string5 = "'\u2730TEST VALUE\u2730\ufebe\u0e04'";
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("UPDATE NODEPROPERTIES SET ");
            stringBuffer.append("KEY='Telnet Security',");
            stringBuffer.append("VALUE=" + string5 + " ");
            stringBuffer.append(" WHERE ID=1;");
            DBaseRequestExecuteUpdate dBaseRequestExecuteUpdate = new DBaseRequestExecuteUpdate("", stringBuffer.toString());
            if (!threadDBaseService.request(dBaseRequestExecuteUpdate)) {
                Trace.logError((String)"DBase", (String)"DBase request error");
                return;
            }
            String string6 = "SELECT * FROM NODEPROPERTIES;";
            DBaseRequestExecuteQuery dBaseRequestExecuteQuery = new DBaseRequestExecuteQuery("", string6);
            if (!threadDBaseService.request(dBaseRequestExecuteQuery)) {
                Trace.logError((String)"DBase", (String)"DBase request error");
                return;
            }
            int n = dBaseRequestExecuteQuery.getQueryHandle();
            boolean bl = true;
            block5: while (true) {
                DBaseRequestQueryResults dBaseRequestQueryResults;
                if (!threadDBaseService.request(dBaseRequestQueryResults = new DBaseRequestQueryResults(n, 10))) {
                    Trace.logError((String)"DBase", (String)"DBase request error");
                    return;
                }
                int n2 = dBaseRequestQueryResults.getRowCount();
                if (n2 == 0) break;
                int n3 = 1;
                while (true) {
                    if (n3 >= n2) continue block5;
                    dBaseRequestQueryResults.nextRow();
                    String string7 = dBaseRequestQueryResults.getString(0);
                    Trace.logInfo((String)"DBase", (String)string7);
                    String string8 = dBaseRequestQueryResults.getString(1);
                    Trace.logInfo((String)"DBase", (String)string8);
                    String string9 = dBaseRequestQueryResults.getString(2);
                    Trace.logInfo((String)"DBase", (String)string9);
                    if (bl) {
                        String string10 = dBaseRequestQueryResults.getString(3);
                        Trace.logInfo((String)"DBase", (String)string10);
                        jLabel.setText(string10);
                        bl = false;
                    }
                    ++n3;
                }
                break;
            }
            threadDBaseService.stopThreadAndWait(30L);
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            Trace.logError((String)"DBase", (String)("DBASE request error - ExceptionInvalidArgument:" + exceptionInvalidArgument.getMessage()));
            return;
        }
        catch (SQLException sQLException) {
            Trace.logError((String)"DBase", (String)("DBASE request error - SQLException:" + sQLException.getMessage()));
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Trace.logError((String)"DBase", (String)("DBASE request error - ClassNotFoundException:" + classNotFoundException.getMessage()));
            return;
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)"DBase", (String)("DBASE request error - RequestFailed:" + exceptionRequestFailed.getMessage()));
            return;
        }
    }
}

