/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.gui;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionFileNotFound;
import com.avocent.lib.exceptions.ExceptionFileNotReadable;
import com.avocent.lib.exceptions.ExceptionNotAFile;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.ExecuteCmd;
import com.avocent.lib.util.ResourceManager;
import com.avocent.lib.win32.Win32Library;
import java.io.File;

public class LaunchBrowser {
    public static final String CNAME = "LaunchBrowser";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.lib.util.Res");
    private static String m_szOsName = System.getProperty("os.name");
    public static final String BROWSER_SYSTEM_PROPERTY = "avct.browser.path";
    private static final String[] SUN_BROWSERS = new String[]{"netscape", "hotjava"};
    private static final String[] LINUX_BROWSERS = new String[]{"firefox", "mozilla", "konqueror", "netscape"};
    private static final String[] UNIX_BROWSERS = new String[]{"netscape"};

    private static String getDefaultErrorMessage(String string) {
        String string2 = res.getString("LaunchBrowser_Could_not_display");
        String string3 = res.getString("LaunchBrowser_Reason1");
        return string2 + string + string3;
    }

    public static void launchDefaultBrowser(String string) throws ExceptionRequestFailed, ExceptionFileNotFound, ExceptionNotAFile, ExceptionFileNotReadable {
        LaunchBrowser.launchDefaultBrowser(string, LaunchBrowser.getDefaultErrorMessage(string));
    }

    public static void launchDefaultBrowser(String string, String string2) throws ExceptionRequestFailed, ExceptionFileNotFound, ExceptionNotAFile, ExceptionFileNotReadable {
        if (string == null || string.length() == 0) {
            throw new ExceptionRequestFailed("Invalid URL argument");
        }
        String string3 = System.getProperty(BROWSER_SYSTEM_PROPERTY);
        if (string3 != null && string3.length() > 0) {
            LaunchBrowser.launchBrowser(string, string3);
        } else if (m_szOsName.startsWith("Windows")) {
            LaunchBrowser.launchDefaultBrowserOnWindows(string, string2);
        } else {
            LaunchBrowser.launchDefaultBrowserOnUnix(string, string2);
        }
    }

    private static void launchDefaultBrowserOnWindows(String string, String string2) throws ExceptionRequestFailed, ExceptionFileNotFound, ExceptionNotAFile, ExceptionFileNotReadable {
        Object object;
        String string3 = "";
        try {
            object = new Win32Library();
            string3 = object.getDefaultBrowser();
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)"LaunchBrowser:Win32", (String)("Unable to read the win32DefaultBrowserPath preference " + exceptionRequestFailed.getMessage()));
        }
        object = "";
        if (string3.length() != 0) {
            if (string.charAt(0) != '\"') {
                string = '\"' + string + '\"';
            }
            object = string3;
        } else {
            object = "rundll32 url.dll,FileProtocolHandler";
        }
        Trace.logInfo((String)"LaunchBrowser:Win32", (String)("About to exec the following command[" + (String)object + "] URL[" + string + "]"));
        LaunchBrowser.launchBrowser(string, (String)object, string2);
    }

    private static void launchDefaultBrowserOnUnix(String string, String string2) throws ExceptionRequestFailed, ExceptionFileNotFound, ExceptionNotAFile, ExceptionFileNotReadable {
        String[] stringArray = m_szOsName.startsWith("Sun") ? SUN_BROWSERS : (m_szOsName.startsWith("Linux") ? LINUX_BROWSERS : UNIX_BROWSERS);
        Trace.logInfo((String)CNAME, (String)string);
        string = string.replaceAll(" ", "%20");
        Trace.logInfo((String)CNAME, (String)string);
        LaunchBrowser.launchBrowserImpl(string, stringArray, string2);
    }

    public static void launchBrowser(String string, String string2) throws ExceptionRequestFailed, ExceptionFileNotFound, ExceptionNotAFile, ExceptionFileNotReadable {
        LaunchBrowser.launchBrowserImpl(string, new String[]{string2}, LaunchBrowser.getDefaultErrorMessage(string));
    }

    public static void launchBrowser(String string, String string2, String string3) throws ExceptionRequestFailed, ExceptionFileNotFound, ExceptionNotAFile, ExceptionFileNotReadable {
        LaunchBrowser.launchBrowserImpl(string, new String[]{string2}, string3);
    }

    private static void launchBrowserImpl(final String string, final String[] stringArray, final String string2) throws ExceptionRequestFailed, ExceptionFileNotFound, ExceptionNotAFile, ExceptionFileNotReadable {
        if (stringArray == null || stringArray.length <= 0) {
            throw new ExceptionFileNotFound("Invalid Browser Path Argument", new File(""));
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                Exception exception = null;
                int n = 0;
                while (n < stringArray.length) {
                    try {
                        if (stringArray[n] != null && stringArray[n].length() > 0) {
                            Trace.logInfo((String)"LaunchBrowser:Path", (String)("Attempting to launch browser \"" + stringArray[n] + "\""));
                            ExecuteCmd.verify((String)stringArray[n]);
                            boolean bl = stringArray[n].indexOf("netscape") >= 0;
                            int n2 = ExecuteCmd.execute((String)stringArray[n], (String)string, (boolean)false, (boolean)true);
                            if (n2 == 0 || bl && n2 == 1) {
                                Trace.logInfo((String)"LaunchBrowser:Path", (String)("Successfully launched browser " + stringArray[n]));
                                return;
                            }
                        }
                    }
                    catch (Exception exception2) {
                        exception = exception2;
                    }
                    ++n;
                }
                Trace.logInfo((String)"LaunchBrowser.launchBrowserImpl()", (String)("Failed to launch browser for URL " + string + " " + (exception != null ? exception.getMessage() : "")));
                Message.show(null, string2);
            }
        }, CNAME);
        thread.start();
    }
}

