/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.gui;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.gui.LaunchBrowser;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.ResourceManager;
import java.io.File;
import java.util.Locale;

public class LaunchBrowserHelp {
    public static final String CNAME = "LaunchBrowserHelp";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.lib.util.Res");

    public static String pageToURLStr(String string) {
        String string2;
        if (string == null || string.length() == 0) {
            Trace.logInfo((String)"LaunchBrowserHelp.pageToURLStr()", (String)("The help page parameter is invalid. Bad value=" + string));
            String string3 = res.getString("LaunchBrowserHelp_Could_not_display_Invalid");
            String string4 = res.getString("LaunchBrowserHelp_Reason3");
            String string5 = string3 + string4;
            Message.show(null, string5);
            return null;
        }
        Trace.logInfo((String)"LaunchBrowserHelp.pageToURLStr()", (String)("About to launch the browser for relative URL=" + string));
        File file = new File(string);
        if (!file.exists()) {
            string2 = Locale.getDefault().getLanguage();
            if (string2.equals("en")) {
                Trace.logInfo((String)"LaunchBrowserHelp.pageToURLStr()", (String)("Cannot find help file " + file));
                LaunchBrowserHelp.displayPageNotFound(file);
                return null;
            }
            Trace.logInfo((String)"LaunchBrowserHelp.pageToURLStr()", (String)("Cannot find help file " + file + ": Falling back to an english version"));
            File file2 = file;
            file = new File(string.replaceAll("/" + string2 + "/", "/en/"));
            if (!file.exists()) {
                Trace.logInfo((String)"LaunchBrowserHelp.pageToURLStr()", (String)("Cannot find help file " + file));
                LaunchBrowserHelp.displayPageNotFound(file2);
                return null;
            }
        }
        string2 = file.getAbsolutePath();
        if ((string2 = string2.replace(File.separatorChar, '/')).charAt(0) == '/') {
            return "file://" + string2;
        }
        return "\"file:///" + string2 + "\"";
    }

    private static void displayPageNotFound(File file) {
        Trace.logInfo((String)"LaunchBrowserHelp.pageToURLStr()", (String)("Cannot find help file " + file));
        String string = res.getString("LaunchBrowserHelp_Could_not_display");
        String string2 = res.getString("LaunchBrowserHelp_Reason2");
        String string3 = string + file.getAbsolutePath() + string2;
        Message.show(null, string3);
    }

    public static void showPage(String string) {
        String string2 = LaunchBrowserHelp.pageToURLStr(string);
        if (string2 == null) {
            return;
        }
        Trace.logInfo((String)"LaunchBrowserHelp.showPage()", (String)("About to launch the browser for absolute URL=" + string2));
        try {
            LaunchBrowser.launchDefaultBrowser(string2);
        }
        catch (Exception exception) {
            Trace.logInfo((String)"LaunchBrowserHelp.showPage()", (String)("Failed to launch the browser for absolute URL=" + string2 + " " + exception.getMessage()));
            String string3 = res.getString("LaunchBrowserHelp_Could_not_display");
            String string4 = res.getString("LaunchBrowserHelp_Reason1");
            String string5 = string3 + new File(string).getAbsolutePath() + string4;
            Message.show(null, string5);
        }
    }
}

